/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AuditEventAPI {
    private static final Logger EVENTLOGGER = Logger.getLogger("EventLogger");
    private static AuditEventAPI eventAPI = null;
    private static HashMap eventParserMap = null;
    private HashMap eventIdStatusMap = null;
    private static HashMap<String, ArrayList<String>> serviceAccountMap = null;
    private static String[] eventParserClasses = new String[]{"DefaultEventParser", "DSAEventParser", "AccountMgmtParser", "AccountMgmt2k8Parser", "DSChangeParser", "OAEventParser", "DSA2k8EventParser", "AdfsEventParser"};
    private static HashMap<Integer, ArrayList<Long>> eventCategoryMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditEventAPI getInstance() {
        if (eventAPI != null) return eventAPI;
        Class<AuditEventAPI> clazz = AuditEventAPI.class;
        synchronized (AuditEventAPI.class) {
            if (eventAPI != null) return eventAPI;
            eventAPI = new AuditEventAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return eventAPI;
        }
    }

    private AuditEventAPI() {
        AuditEventAPI.getAuditEventParserMap();
        AuditEventAPI.getServiceAccountDetails();
        AuditEventAPI.buildEventCategoryMap();
    }

    public static void getAuditEventParserMap() {
        try {
            eventParserMap = new HashMap();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEventID", (Row)null);
            for (int i = 0; i < eventParserClasses.length; ++i) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDEventID", (String)"EVENT_PARSER"), (Object)eventParserClasses[i], 11);
                EventParser parserClass = null;
                Iterator iterator = dataObject.getRows("AUDEventID", criteria);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long eventNumber = (Long)row.get("EVENT_NUMBER");
                    String parserClassName = (String)row.get("EVENT_PARSER");
                    if (parserClass == null) {
                        Class<?> classToInvoke = Class.forName(parserClassName.trim());
                        parserClass = (EventParser)classToInvoke.newInstance();
                    }
                    eventParserMap.put(eventNumber.intValue(), parserClass);
                }
            }
            EVENTLOGGER.log(Level.FINE, "Parser Map : " + eventParserMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] getAuditEvents(String[] version, int machineType) {
        int[] eventIds = null;
        EVENTLOGGER.log(Level.INFO, "Windows version is :" + version);
        boolean is2k12 = false;
        try {
            if (version[0].equals("6.2")) {
                is2k12 = true;
                version[0] = "6";
            }
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDEventID", (String)"OS_VERSION"), (Object)version, 8);
            Integer[] eventTypes = new Integer[]{1, 2, 5, 8};
            if (machineType == 1) {
                eventTypes = new Integer[]{1, 5};
                EVENTLOGGER.log(Level.INFO, "The server is DC and call from DC Scheduler");
            } else if ((machineType & 1) == 1 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
                eventTypes = new Integer[]{2, 8};
                EVENTLOGGER.log(Level.INFO, "The server is DC and (FS or Cluster) and call is from file server or cluster");
            } else if ((machineType & 0x10) == 16 && (machineType & 4) != 4 && (machineType & 0x40) != 64) {
                eventTypes = version[0].equals("5") ? new Integer[]{1, 2, 5, 8, 16} : new Integer[]{1, 5, 16};
                EVENTLOGGER.log(Level.INFO, "The server is MS(e) and FS or cluster(d)");
            } else if ((machineType & 0x10) == 16 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
                eventTypes = new Integer[]{1, 2, 5, 8, 16};
                EVENTLOGGER.log(Level.INFO, "The server is MS(e) and FS or cluster(e)");
            } else if ((machineType & 0x10) != 16 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
                eventTypes = new Integer[]{2, 8};
                EVENTLOGGER.log(Level.INFO, "The server is MS(d) and FS or cluster(e)");
            } else if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072) {
                eventTypes = new Integer[]{2, 6, 8};
                EVENTLOGGER.log(Level.INFO, "The server is NetApp Server OR EMC Server");
            } else if ((machineType & 0x80000) == 524288) {
                eventTypes = new Integer[]{2, 8};
                EVENTLOGGER.log(Level.INFO, "The server is NetApp VServer");
            } else if ((machineType & 0x400) == 1024 || (machineType & 0x1000) == 4096) {
                eventTypes = new Integer[]{5};
                EVENTLOGGER.log(Level.INFO, "The server is Event Collector/Work station");
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDEventID", (String)"CATEGORY"), (Object)new String[]{"Logon/Logoff", "Object Access"}, 8));
            } else if ((machineType & 0x200000) == 0x200000) {
                eventTypes = new Integer[]{7};
            }
            if ((machineType & 0x4000) == 16384) {
                eventTypes = new Integer[]{1, 2, 5, 8, 16};
                EVENTLOGGER.log(Level.INFO, "FIM Enabled");
            }
            if (is2k12) {
                EVENTLOGGER.log(Level.INFO, "Add Audit Removable Storage Events for 2k12");
                Integer[] temp = new Integer[eventTypes.length + 1];
                for (int i = 0; i < eventTypes.length; ++i) {
                    temp[i] = eventTypes[i];
                }
                temp[eventTypes.length] = 8;
                eventTypes = temp;
            }
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDEventID", (String)"EVENT_TYPE"), (Object)eventTypes, 8));
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDEventID", (String)"EVENT_NUMBER"), (Object)4648, 1));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEventID", criteria);
            int size = dataObject.size("AUDEventID");
            EVENTLOGGER.log(Level.INFO, "Size of Event IDs is :" + size);
            eventIds = new int[size];
            int i = 0;
            Iterator iterator = dataObject.getRows("AUDEventID");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long eventNumber = (Long)row.get("EVENT_NUMBER");
                EVENTLOGGER.log(Level.FINE, "Event ID is :" + eventNumber.intValue());
                eventIds[i] = eventNumber.intValue();
                ++i;
            }
            if (machineType == 1) {
                for (int j = 0; j < size; ++j) {
                    if (eventIds[j] != 4719) continue;
                    eventIds[j] = 4768;
                }
            }
            if ((machineType & 0x20000) == 131072) {
                for (int j = 0; j < size; ++j) {
                    if (eventIds[j] != 563) continue;
                    eventIds[j] = 560;
                }
            }
            if (!(version[0].startsWith("5") || (machineType & 4) != 4 && (machineType & 0x40) != 64)) {
                boolean ev5140Present = false;
                int[] evIds = new int[size + 1];
                for (int j = 0; j < size; ++j) {
                    evIds[j] = eventIds[j];
                    if (eventIds[j] != 5140) continue;
                    ev5140Present = true;
                }
                if (!ev5140Present) {
                    evIds[size] = 5140;
                    eventIds = evIds;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return eventIds;
    }

    private EventParser getEventParser(Integer eventNumber) {
        if (eventParserMap == null) {
            AuditEventAPI.getAuditEventParserMap();
        }
        return (EventParser)eventParserMap.get(eventNumber);
    }

    public Hashtable<String, Object> parseEvent(Hashtable<String, Object> data) throws Exception {
        Integer eventNumber = (Integer)data.get("EventCode");
        EventParser eventParser = this.getEventParser(eventNumber);
        return eventParser.parseEvent(eventNumber, data);
    }

    public static void getServiceAccountDetails() {
        EVENTLOGGER.log(Level.FINE, "AM HERE");
        try {
            serviceAccountMap = new HashMap();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDServiceAccountFilter"));
            Join userJoin = new Join("AUDServiceAccountFilter", "ADSMUserGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(userJoin);
            query.addSelectColumn(Column.getColumn((String)"AUDServiceAccountFilter", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dObj.isEmpty()) {
                ArrayList<Object> usersList = new ArrayList();
                Iterator iter = dObj.getRows("AUDServiceAccountFilter");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    Object name = row.get("USER_NAME");
                    String domainName = (String)row.get("DOMAIN_NAME");
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), (Object)((String)row.get("OBJECT_GUID")), 0);
                    Row userRow = dObj.getRow("ADSMUserGeneralDetails", crit);
                    usersList = serviceAccountMap.get(domainName) == null ? new ArrayList() : serviceAccountMap.get(domainName);
                    Object logonName = userRow.get("LOGON_NAME");
                    Object samAccountName = userRow.get("SAM_ACCOUNT_NAME");
                    usersList.add(name.toString());
                    usersList.add(logonName.toString());
                    usersList.add(samAccountName.toString());
                    serviceAccountMap.put(domainName, usersList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<String> getUsersList(String domainName) {
        if (!serviceAccountMap.isEmpty() && serviceAccountMap.get(domainName) == null) {
            AuditEventAPI.getServiceAccountDetails();
            if (serviceAccountMap.get(domainName) == null) {
                serviceAccountMap.put(domainName, new ArrayList());
            }
        }
        return serviceAccountMap.get(domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildEventCategoryMap() {
        eventCategoryMap = new HashMap();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = "SELECT EVENT_ID, CATEGORY_ID FROM AUDEvtVarActionMapping GROUP BY EVENT_ID, CATEGORY_ID";
            resultSet = QueryUtil.executeQuery("Grouping Category Based Events", statement, query);
            while (resultSet.next()) {
                Integer eventId = Long.valueOf(resultSet.getLong("EVENT_ID")).intValue();
                ArrayList<Long> categoryList = eventCategoryMap.get(eventId);
                if (categoryList == null) {
                    categoryList = new ArrayList();
                }
                categoryList.add(resultSet.getLong("CATEGORY_ID"));
                eventCategoryMap.put(eventId, categoryList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EVENTLOGGER.log(Level.INFO, "Event Category Map:" + eventCategoryMap);
    }

    public static void buildEventCategoryMapDO() {
        eventCategoryMap = new HashMap();
        try {
            String tableName = "AUDEvtVarActionMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"EVENT_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"CATEGORY_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"MAP_ID"));
            ArrayList<String> groupByColumns = new ArrayList<String>();
            groupByColumns.add("EVENT_ID");
            groupByColumns.add("CATEGORY_ID");
            GroupByClause groupByClause = new GroupByClause(groupByColumns);
            query.setGroupByClause(groupByClause);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"EVENT_ID"), null, 1);
            query.setCriteria(criteria);
            EVENTLOGGER.log(Level.INFO, "Query is " + query);
            RelationalAPI.getInstance().getSelectSQL((Query)query);
            EVENTLOGGER.log(Level.INFO, "Select SQL is " + query);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            EVENTLOGGER.log(Level.INFO, "Event Category Map DO is " + dataObject);
            Iterator rowIterator = dataObject.getRows(tableName);
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                Integer eventId = ((Long)row.get("EVENT_ID")).intValue();
                ArrayList<Long> categoryList = eventCategoryMap.get(eventId);
                if (categoryList == null) {
                    categoryList = new ArrayList();
                }
                categoryList.add((Long)row.get("CATEGORY_ID"));
                eventCategoryMap.put(eventId, categoryList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<Integer, ArrayList<Long>> getEventCategoryMap() {
        return eventCategoryMap;
    }

    public static ArrayList<Long> getCategoriesForEventId(Integer eventId) {
        return eventCategoryMap.get(eventId);
    }

    public static boolean addNTLMEventsForAudit() {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row4776 = ReportUtil.formRow("AUDEventID", new String[]{"EVENT_ID", "SOURCE", "CATEGORY", "EVENT_NUMBER", "Description", "EVENT_PARSER", "OS_VERSION", "EVENT_TYPE"}, new Object[]{298L, "Security", "Account Logon", 4776L, "CREDENTIAL VALIDATION", "com.adventnet.sym.adsm.auditing.server.parsing.DefaultEventParser", 6, 5});
            Row row680 = ReportUtil.formRow("AUDEventID", new String[]{"EVENT_ID", "SOURCE", "CATEGORY", "EVENT_NUMBER", "Description", "EVENT_PARSER", "OS_VERSION", "EVENT_TYPE"}, new Object[]{299L, "Security", "Account Logon", 680L, "CREDENTIAL VALIDATION", "com.adventnet.sym.adsm.auditing.server.parsing.DefaultEventParser", 5, 5});
            dataObject.addRow(row4776);
            dataObject.addRow(row680);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            Long[] ids = DBObjectUtil.getUVHValues("AUDExcludeRules", new String[]{"AUDExcludeRules:RULE_ID:12", "AUDExcludeRules:RULE_ID:13"});
            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"RULE_ID"), (Object)ids, 8));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        AuditEventAPI.getAuditEventParserMap();
        return true;
    }

    public static boolean deleteNTLMEventsForAudit() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEventID", (String)"EVENT_NUMBER"), (Object)new Long[]{4776L, 680L}, 8);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            Row row4624 = ReportUtil.formRow("AUDExcludeRules", new String[]{"RULE_ID", "EVENT_NUMBER", "VARIABLE_NAME", "VALUE", "OPERATOR", "OS_VERSION", "MACHINE_TYPE"}, new Object[]{DBObjectUtil.getUVHValues("AUDExcludeRules", "AUDExcludeRules:RULE_ID:12"), 4624, "adap.AUDRuleVariables.variable_name.Logon_Type", "3", 1, 6, 17});
            Row row4625 = ReportUtil.formRow("AUDExcludeRules", new String[]{"RULE_ID", "EVENT_NUMBER", "VARIABLE_NAME", "VALUE", "OPERATOR", "OS_VERSION", "MACHINE_TYPE"}, new Object[]{DBObjectUtil.getUVHValues("AUDExcludeRules", "AUDExcludeRules:RULE_ID:13"), 4625, "adap.AUDRuleVariables.variable_name.Logon_Type", "3", 1, 6, 17});
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            dataObject.addRow(row4624);
            dataObject.addRow(row4625);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        AuditEventAPI.getAuditEventParserMap();
        return true;
    }

    public static boolean isNTLMEnabled() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEventID", (String)"EVENT_NUMBER"), (Object)new Long[]{4776L, 680L}, 8);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDEventID", crit);
            if (dObj.isEmpty()) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

