/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;

public final class BufferedQueue {
    private Vector<Hashtable<String, Object>> inQ;
    private Vector<Hashtable<String, Object>> outQ;
    private int qSize;
    private int dataFilesStartCount = 0;
    private int dataFilesEndCount = 0;
    private String fileName;
    private File directory;
    private boolean freezeQ = false;
    private static final int DEFAULT_SIZE = 500;
    private final Object outQLock = new Object();

    public BufferedQueue(String strDir, String fileName, int qSize) {
        this.inQ = new Vector(qSize);
        this.qSize = qSize > 0 ? qSize : 500;
        this.directory = new File(strDir + File.separator);
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.exists()) {
            throw new IllegalArgumentException(strDir + " temp directory does not exist");
        }
        this.fileName = fileName;
        this.resetFileCounts();
        File memFile = this.getMemFile();
        if (memFile.exists()) {
            this.outQ = this.loadFromFile(memFile);
        }
        while (this.outQ == null && this.dataFilesEndCount > this.dataFilesStartCount) {
            this.outQ = this.loadFromFile(this.getNextReadFile());
            ++this.dataFilesStartCount;
        }
        if (this.outQ == null) {
            this.outQ = new Vector(qSize);
        }
    }

    public synchronized boolean add(Hashtable<String, Object> obj) {
        if (this.freezeQ) {
            return false;
        }
        if (this.inQ.size() >= this.qSize) {
            int tryCount;
            for (tryCount = 0; !this.saveToFile(this.inQ, this.getNextWriteFile()) && tryCount < 10; ++tryCount) {
                ++this.dataFilesEndCount;
            }
            ++this.dataFilesEndCount;
            if (tryCount == 10) {
                return false;
            }
            this.inQ.removeAllElements();
        }
        this.inQ.add(obj);
        return true;
    }

    public synchronized Vector<Hashtable<String, Object>> getOutQ() {
        this.outQ = this.inQ;
        this.inQ = new Vector(this.qSize);
        return this.outQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> get() {
        Object object = this.outQLock;
        synchronized (object) {
            if (this.isEmpty()) {
                return null;
            }
            if (this.freezeQ) {
                return null;
            }
            if (this.outQ.size() == 0) {
                if (this.dataFilesEndCount > this.dataFilesStartCount) {
                    this.outQ = this.loadFromFile(this.getNextReadFile());
                    ++this.dataFilesStartCount;
                    while (this.outQ == null && this.dataFilesEndCount > this.dataFilesStartCount) {
                        this.outQ = this.loadFromFile(this.getNextReadFile());
                        ++this.dataFilesStartCount;
                    }
                    if (this.outQ == null) {
                        this.outQ = this.getOutQ();
                        if (this.outQ.size() == 0) {
                            return null;
                        }
                    }
                } else {
                    this.outQ = this.getOutQ();
                    if (this.outQ.size() == 0) {
                        return null;
                    }
                }
            }
            return this.outQ.remove(0);
        }
    }

    public Vector<Hashtable<String, Object>> getNextBatch() {
        throw new UnsupportedOperationException("Allowed only for Buffers of type BATCH");
    }

    public synchronized void close() {
        this.freezeQ = true;
        if (this.inQ.size() > 0) {
            this.saveToFile(this.inQ, this.getNextWriteFile());
            ++this.dataFilesEndCount;
        }
        if (this.outQ.size() > 0) {
            this.saveToFile(this.outQ, this.getMemFile());
        }
        this.inQ.removeAllElements();
        this.outQ.removeAllElements();
    }

    public boolean isEmpty() {
        if (this.freezeQ) {
            return true;
        }
        return this.inQ.size() <= 0 && this.outQ.size() <= 0 && this.dataFilesEndCount <= this.dataFilesStartCount;
    }

    private File getNextWriteFile() {
        File file = new File(this.directory, this.fileName + this.dataFilesEndCount + ".dmp");
        return file;
    }

    private File getNextReadFile() {
        File file = new File(this.directory, this.fileName + this.dataFilesStartCount + ".dmp");
        return file;
    }

    private File getMemFile() {
        File file = new File(this.directory, "MEMORY.dmp");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveToFile(Vector<Hashtable<String, Object>> persistV, File file) {
        FileOutputStream fout = null;
        ObjectOutputStream out = null;
        RandomAccessFile raf = null;
        FilterOutputStream bout = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            fout = new FileOutputStream(raf.getFD());
            bout = new BufferedOutputStream(fout);
            out = new ObjectOutputStream(bout);
            out.writeObject(persistV);
            out.flush();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
                if (fout != null) {
                    fout.close();
                }
                if (out != null) {
                    out.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        out = null;
        fout = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Hashtable<String, Object>> loadFromFile(File file) {
        FileInputStream fin = null;
        ObjectInputStream oin = null;
        Vector persistV = null;
        RandomAccessFile raf = null;
        BufferedInputStream bin = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            fin = new FileInputStream(raf.getFD());
            bin = new BufferedInputStream(fin);
            oin = new ObjectInputStream(bin);
            persistV = (Vector)oin.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (oin != null) {
                    oin.close();
                }
                if (bin != null) {
                    bin.close();
                }
                if (fin != null) {
                    fin.close();
                }
                if (raf != null) {
                    raf.close();
                }
                this.deleteFile(file);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return persistV;
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    private void resetFileCounts() {
        int min = -1;
        int max = -1;
        File[] fileList = this.directory.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            String currFile = fileList[i].getName();
            if (!currFile.startsWith(this.fileName)) continue;
            String baseName = currFile.substring(this.fileName.length(), currFile.length() - 4);
            int currVal = Integer.parseInt(baseName);
            if (currVal <= min || min == -1) {
                min = currVal;
            }
            if (currVal < max && max != -1) continue;
            max = currVal + 1;
        }
        if (min != -1) {
            this.dataFilesStartCount = min;
        }
        if (max != -1) {
            this.dataFilesEndCount = max;
        }
    }
}

