/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DNSResolver {
    private static volatile DNSResolver dnsResolver = null;
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}?(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
    private static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static volatile Hashtable<String, ArrayList<String>> ipAddressList = null;
    private static Hashtable<String, ArrayList<String>> ipAddressStringsList = null;
    private static Executor executor = Executors.newFixedThreadPool(15);
    private static Executor cachedExecutor = Executors.newCachedThreadPool();
    private static Long timeout = 50L;
    private static String executorType = "1";
    private static String resolverType = "1";

    private DNSResolver() {
        ipAddressList = new Hashtable();
        ipAddressStringsList = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DNSResolver getInstance() {
        if (dnsResolver != null) return dnsResolver;
        Class<DNSResolver> clazz = DNSResolver.class;
        synchronized (DNSResolver.class) {
            String rType;
            String eType;
            if (dnsResolver != null) return dnsResolver;
            String tout = CommonUtil.getSysParams("DNS_TIMEOUT");
            if (tout != null) {
                timeout = Long.parseLong(tout);
            }
            if ((eType = CommonUtil.getSysParams("DNS_EXECUTOR_TYPE")) != null) {
                executorType = eType;
            }
            if ((rType = CommonUtil.getSysParams("DNS_RESOLVER_TYPE")) != null) {
                resolverType = rType;
            }
            dnsResolver = new DNSResolver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dnsResolver;
        }
    }

    public static void clearCache() {
        ipAddressList.clear();
        ipAddressStringsList.clear();
    }

    public ArrayList<String> getHostName(String ipAddress2) throws UnknownHostException {
        final String ipAddress = ipAddress2.replaceAll("::ffff:", "");
        ArrayList<String> hostName = ipAddressList.get(ipAddress);
        FutureTask<ArrayList<String>> ipResolver = new FutureTask<ArrayList<String>>(new Callable<ArrayList<String>>(){

            @Override
            public ArrayList<String> call() throws Exception {
                ArrayList hostName = new ArrayList();
                try {
                    if (!resolverType.equals("1") && ipAddress.contains(".") && !ipAddress.contains(":")) {
                        String res = ADHandler.getHostName(ipAddress);
                        hostName.add(0, (String)res);
                        hostName.add(1, (String)ipAddress);
                        if (ipAddressList.containsKey(ipAddress) && Character.isDigit(res.charAt(0))) {
                            hostName = (ArrayList)ipAddressList.get(ipAddress);
                        } else {
                            ipAddressList.put(ipAddress, hostName);
                        }
                    } else {
                        InetAddress inetAdd = null;
                        Matcher matcher = IPV4_PATTERN.matcher(ipAddress);
                        if (matcher.find()) {
                            inetAdd = InetAddress.getByName(matcher.group());
                        } else {
                            inetAdd = InetAddress.getByName(ipAddress);
                            if (ipAddress.startsWith("2002:")) {
                                byte[] address = inetAdd.getAddress();
                                byte[] ipv4Address = new byte[4];
                                for (int i = 0; i < 4; ++i) {
                                    ipv4Address[i] = address[i + 2];
                                }
                                inetAdd = InetAddress.getByAddress(ipv4Address);
                            }
                        }
                        hostName.add(0, (String)inetAdd.getHostName());
                        hostName.add(1, (String)inetAdd.getHostAddress());
                        ipAddressList.put(ipAddress, hostName);
                    }
                }
                catch (Exception e) {
                    hostName = null;
                    e.printStackTrace();
                }
                return hostName;
            }
        });
        try {
            if (hostName == null) {
                if (!executorType.equals("1")) {
                    cachedExecutor.execute(ipResolver);
                } else {
                    executor.execute(ipResolver);
                }
                hostName = ipResolver.get(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException toe) {
            ipResolver.cancel(true);
            REPORT_LOGGER.log(Level.WARNING, "TimeOutException while fetching IPAddress -> " + ipAddress);
        }
        catch (ExecutionException e) {
            REPORT_LOGGER.log(Level.WARNING, "ExecutionException while fetching IPAddress -> " + ipAddress);
        }
        catch (InterruptedException e) {
            REPORT_LOGGER.log(Level.WARNING, "InterruptedException while fetching IPAddress -> " + ipAddress);
        }
        if (hostName == null) {
            hostName = new ArrayList();
            hostName.add(0, ipAddress);
            hostName.add(1, ipAddress);
            ipAddressList.put(ipAddress, hostName);
        }
        return hostName;
    }
}

