/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.BufferedQueue;
import com.adventnet.sym.adsm.auditing.server.ProcessMonitor;
import com.adventnet.sym.adsm.auditing.server.archive.DataArchiver;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventController;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.EventCollectorHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventDataAdapter {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("EventLogger");
    private static EventQueue eventQueue;
    private static boolean needToArchive;
    private static int workerThreads;

    public static boolean initialize() {
        logger.info("Event Fetching initialized.");
        return true;
    }

    public static void updateRecordNumber(long timeGenerated, long recordNumber, String dcName, String domainName) {
        try {
            logger.log(Level.INFO, "Finished Data Collection for domainController [{0}] of domain [{1}]: ", new Object[]{dcName, domainName});
            logger.log(Level.INFO, "Record Number is [{0}] and event time is [{1}]", new Object[]{recordNumber, timeGenerated});
            EventDataUtil.updateRecordNumber(timeGenerated, recordNumber, dcName, domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Error while updating recordnumber from native for domain controller [{0}] of domain [{1}]", new Object[]{dcName, domainName});
        }
    }

    public static void updateStringSD(Object data) {
        try {
            AuditDelegationUtil.updateSaclStatusForShare(data);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.toString());
            ex.printStackTrace();
        }
    }

    public static void bookMarkEvents(Object collectorData) {
        try {
            Hashtable data = (Hashtable)collectorData;
            EventCollectorHandler.updateRecordNumber(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void notify(Object data) {
        try {
            eventQueue.add((Hashtable)data);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Unable to send event :" + data);
            ex.printStackTrace();
        }
    }

    public static void wmiNotify(Object data) {
        try {
            Hashtable hashtable = (Hashtable)data;
            String type = (String)hashtable.get("Type");
            Integer eventType = 0;
            if (type.equalsIgnoreCase(rb.getString("adap.EventDataAdapter.Audit_Success"))) {
                eventType = 8;
            } else if (type.equalsIgnoreCase(rb.getString("adap.EventDataAdapter.Audit_Failure"))) {
                eventType = 16;
            }
            hashtable.put("EventType", eventType);
            hashtable.put("TimeGenerated", TimeUtil.getEventTime((String)hashtable.get("TimeGenerated")));
            eventQueue.add(hashtable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.INFO, "Unable to send event :" + data);
        }
    }

    public static void audit(String desc) {
        if (desc == null) {
            return;
        }
        Hashtable<String, String> data = new Hashtable<String, String>();
        data.put("TIME", "" + System.currentTimeMillis());
        data.put("CATEGORY", "Fos");
        data.put("DESCRIPTION", desc);
        EventDataAdapter.notify(data);
    }

    public static boolean useLocalMessageDLL() {
        boolean useLocalMsgDll = false;
        try {
            useLocalMsgDll = EventCollectionUtil.useLocalMessageDLL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return useLocalMsgDll;
    }

    public static boolean getDCStatus(Object uniqueId) {
        boolean b = false;
        try {
            RealTimeEventController.getInstance();
            b = RealTimeEventController.getDCStatus(new Long(uniqueId.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static boolean resetRetryCount(Object uniqueId) {
        boolean b = false;
        try {
            RealTimeEventController.getInstance();
            b = RealTimeEventController.resetRetryCount(new Long(uniqueId.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static boolean updateDCMessage(Object uniqueId) {
        boolean b = false;
        try {
            RealTimeEventController.getInstance();
            b = RealTimeEventController.updateDCMessage(new Long(uniqueId.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static void bookmarkNetAppEvtFileTime(String filerGuid, String evtFileTime) {
        try {
            logger.log(Level.INFO, "In bookmarkNetAppEvtFileTime:" + evtFileTime);
            logger.log(Level.INFO, "objectGuid:" + filerGuid);
            NetAppHandler.updateLastReadEvtFileTime(filerGuid, evtFileTime);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, ex.toString());
            ex.printStackTrace();
        }
    }

    static {
        needToArchive = false;
        workerThreads = 1;
        needToArchive = DataArchiver.getInstance().isNeedToArchive();
        eventQueue = new EventQueue();
        workerThreads = EventCollectionUtil.getWorkerThreads();
        logger.info("Worker Threads Count : " + workerThreads);
        for (int i = 0; i < workerThreads; ++i) {
            new EventDispatcher(eventQueue, "EvTempProcessing" + i).start();
        }
    }

    static class EventDispatcher
    extends Thread {
        private EventQueue queue;

        public EventDispatcher(EventQueue queue) {
            this.queue = queue;
        }

        public EventDispatcher(EventQueue queue, String name) {
            super(name);
            this.queue = queue;
        }

        @Override
        public void run() {
            while (true) {
                Hashtable<String, Object> data = this.queue.remove();
                try {
                    Hashtable<String, Object> modData = null;
                    logger.log(Level.FINE, "DBG:: Event Data b4 modification -> " + data);
                    if (data == null) continue;
                    modData = AuditEventAPI.getInstance().parseEvent(data);
                    logger.log(Level.FINE, "Parsed Event Data -> " + modData);
                    if (needToArchive) {
                        DataArchiver.getInstance().archiveEvent(modData);
                    }
                    ProcessMonitor.process(modData);
                    continue;
                }
                catch (Exception exp) {
                    logger.info("Unable to send event : " + data);
                    exp.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static class EventQueue {
        private String storingDir = System.getProperty("server.dir") + File.separator + "ev_temp";
        private BufferedQueue bq = new BufferedQueue(this.storingDir, "ev", 5000);
        private Object lock = new Object();
        private int waitingThreads = 0;

        EventQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Hashtable<String, Object> obj) {
            this.bq.add(obj);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hashtable<String, Object> remove() {
            Hashtable<String, Object> obj = this.bq.get();
            if (obj == null) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ++this.waitingThreads;
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    --this.waitingThreads;
                }
            }
            if (obj == null) {
                obj = this.bq.get();
            }
            return obj;
        }
    }
}

