/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventFetchThreadPool;
import com.adventnet.sym.adsm.auditing.server.eventcollection.FetchEventData;
import com.adventnet.sym.adsm.auditing.server.eventcollection.FetchEventDataWMI;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventController;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterMonitorCriteria;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.Monitor;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.util.WindowsDirUtil;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EventDataHandler {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static EventDataHandler eventDataHandler = null;
    public Hashtable domainsConfigured = null;
    public Hashtable<String, Integer> dcStatusP = null;
    public Hashtable<Long, Long> dcEventReadTime = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static final FileIntegrityManager FILE_INTEGRITY_MANAGER = FileIntegrityManager.getInstance();
    private static final ClusterMonitorCriteria CLUSTER_MONITOR_CRITERIA = ClusterMonitorCriteria.getInstance();
    static HashMap<String, Date> dates = new HashMap();

    private EventDataHandler() {
        try {
            this.domainsConfigured = DomainHandler.getConfiguredDomains();
        }
        catch (Exception ex) {
            EVENT_LOGGER.log(Level.SEVERE, "Error while fetching domains");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventDataHandler getInstance() {
        if (eventDataHandler != null) return eventDataHandler;
        Class<EventDataHandler> clazz = EventDataHandler.class;
        synchronized (EventDataHandler.class) {
            if (eventDataHandler != null) return eventDataHandler;
            eventDataHandler = new EventDataHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return eventDataHandler;
        }
    }

    public void getEventDataFromDC(String domainName, String computerName, int machineType, String guid) throws Exception {
        Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
        this.getEventDataFromDC(domainDetails, computerName, machineType, guid);
    }

    private void clearServerTable(String domainName, String compName, int machineType) {
        Date newDate = new Date();
        long hours = 0L;
        String Domain_Computer = domainName + "_" + compName;
        Date oldDate = dates.get(Domain_Computer);
        hours = oldDate == null ? 0L : (newDate.getTime() - oldDate.getTime()) / 3600000L;
        if (hours >= 5L) {
            HashMap<String, HashMap<String, HashMap<String, Object>>> domainTable = MonitorManager.sanDriveTable.get(domainName);
            if (domainTable != null) {
                HashMap<String, HashMap<String, Object>> serverTable;
                ArrayList<Properties> capList;
                if (machineType != 1 && (machineType & 0x40) == 64 && (capList = CLUSTER_MONITOR_CRITERIA.getClusterCaps(domainName, compName)) != null && capList.size() > 0) {
                    for (int i = 0; i < capList.size(); ++i) {
                        Properties capProps = capList.get(i);
                        String capName = ((String)capProps.get("CLUSTER_CAP_NAME")).toLowerCase();
                        HashMap<String, HashMap<String, Object>> serverTable2 = domainTable.get(capName);
                        if (serverTable2 == null) continue;
                        domainTable.remove(capName);
                    }
                }
                if ((serverTable = domainTable.get(compName)) != null) {
                    domainTable.remove(compName);
                }
            }
            dates.put(Domain_Computer, newDate);
        }
    }

    public void getEventDataFromDC(Properties domainDetails, String computerName, int machineType, String guid) throws Exception {
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        String compName = computerName.toLowerCase();
        try {
            this.clearServerTable(domainName, compName, machineType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Integer eventFetchMode = EventDataUtil.getEventFetchMode(computerName, domainName);
        if (eventFetchMode == 3) {
            this.realTimeEventCollection(domainDetails, computerName, machineType, guid);
        } else {
            this.readEventFromDC(domainDetails, computerName, machineType, guid);
        }
    }

    public void realTimeEventCollection(Properties domainDetails, String computerName, int machineType, String guid) throws Exception {
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        String osVersion = EventDataUtil.getComputerOsVersion(computerName, domainName);
        if (osVersion == null || osVersion.equals("")) {
            osVersion = DirectoryObjectAPI.getInstance().getComputerOsVersion(domainName, guid, computerName, "computer");
        }
        if (osVersion != null && osVersion.startsWith("6.") && !osVersion.startsWith("5.0")) {
            EVENT_LOGGER.log(Level.INFO, "RealTimeEventController with local dll");
            RealTimeEventController.getInstance().start(domainDetails, null, computerName, 1);
        }
    }

    public void readEventFromDC(Properties domainDetails, String computerName, int machineType, String guid) throws Exception {
        if (this.dcStatusP == null) {
            this.dcStatusP = new Hashtable();
            EVENT_LOGGER.log(Level.INFO, "Initializing for DC -> " + computerName);
            this.dcStatusP.put(computerName, 1);
        } else if (this.dcStatusP.get(computerName) == null) {
            this.dcStatusP.put(computerName, 1);
        } else {
            Integer state = this.dcStatusP.get(computerName);
            if (state == 1) {
                EVENT_LOGGER.log(Level.INFO, "Event fetching is already on for " + computerName);
                throw new Exception(rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{computerName}));
            }
        }
        this.dcStatusP.put(computerName, 1);
        try {
            Integer isFIMEnabled;
            EVENT_LOGGER.log(Level.INFO, "Going to fetch the event for the machine " + computerName);
            String domainName = (String)domainDetails.get("DOMAIN_NAME");
            Long recordNumber = EventDataUtil.getRecordNumber(computerName, domainName);
            Long timeGenerated = EventDataUtil.getEventTime(computerName, domainName);
            String osVersion = EventDataUtil.getComputerOsVersion(computerName, domainName);
            Integer eventFetchMode = EventDataUtil.getEventFetchMode(computerName, domainName);
            if (eventFetchMode == 4) {
                eventFetchMode = 1;
            }
            if ((isFIMEnabled = EventDataUtil.isFIMEnabled(computerName, domainName)) == 1 && FILE_INTEGRITY_MANAGER.isFIMEnabledInDomain(domainName) && FILE_INTEGRITY_MANAGER.isFIMEnabledForMachineType(domainName, machineType)) {
                machineType += 16384;
                EVENT_LOGGER.log(Level.INFO, "FIM Enabled for:" + computerName);
            }
            if ((machineType & 0x20000) == 131072) {
                osVersion = "5.2";
            }
            boolean isLocalDll = EventCollectionUtil.useLocalMessageDLL();
            EventDataUtil.updateEventLogMessage(rb.getString("adap.common.text.status_msg.event_collection_scheduled"), computerName, domainName);
            EVENT_LOGGER.log(Level.INFO, "OS Version:" + osVersion);
            EVENT_LOGGER.log(Level.INFO, "Event FetchMode:" + eventFetchMode);
            EVENT_LOGGER.log(Level.INFO, "LocalDll:" + isLocalDll);
            if (osVersion == null || osVersion.equals("")) {
                osVersion = DirectoryObjectAPI.getInstance().getComputerOsVersion(domainName, guid, computerName, "computer");
            }
            if (osVersion != null && !osVersion.startsWith("5.0") && eventFetchMode != null && eventFetchMode == 1 && isLocalDll) {
                EventFetchThreadPool eventFetchThreadPool = EventFetchThreadPool.getInstance(1);
                FetchEventData fetchEventData = new FetchEventData(domainDetails, computerName, recordNumber, timeGenerated, null, machineType, osVersion, guid, isLocalDll, 1);
                EVENT_LOGGER.log(Level.INFO, "Native mode with local dll");
                eventFetchThreadPool.runTask(fetchEventData);
            } else if (osVersion != null && osVersion.startsWith("6.") && !osVersion.startsWith("5.0") && eventFetchMode != null && eventFetchMode == 2 && isLocalDll) {
                EventFetchThreadPool eventFetchThreadPool = EventFetchThreadPool.getInstance(1);
                FetchEventData fetchEventData2k8 = new FetchEventData(domainDetails, computerName, recordNumber, timeGenerated, null, machineType, osVersion, guid, isLocalDll, 2);
                EVENT_LOGGER.log(Level.INFO, "evt query with local dll");
                eventFetchThreadPool.runTask(fetchEventData2k8);
            } else if (osVersion != null && osVersion.startsWith("5.") && !osVersion.startsWith("5.0") && isLocalDll) {
                EventFetchThreadPool eventFetchThreadPool = EventFetchThreadPool.getInstance(1);
                FetchEventData fetchEventData = new FetchEventData(domainDetails, computerName, recordNumber, timeGenerated, null, machineType, osVersion, guid, isLocalDll, 1);
                EVENT_LOGGER.log(Level.INFO, "native mode for os version 6 and above with local dll");
                eventFetchThreadPool.runTask(fetchEventData);
            } else {
                Properties windowsProps = WindowsDirUtil.getWindowsDirectory(computerName, domainDetails);
                osVersion = windowsProps.getProperty("Version");
                eventFetchMode = Integer.parseInt(windowsProps.getProperty("EventFetchMode"));
                if (osVersion.startsWith("5.0")) {
                    isLocalDll = false;
                }
                if (osVersion.startsWith("6.0") && !isLocalDll) {
                    EventFetchThreadPool eventFetchThreadPool2K8 = EventFetchThreadPool.getInstance(2);
                    FetchEventDataWMI fetchEventDataWmi = new FetchEventDataWMI(domainDetails, computerName, recordNumber, timeGenerated, windowsProps, machineType, osVersion, guid, isLocalDll);
                    EVENT_LOGGER.log(Level.INFO, "going to wmi for osversion 6.0");
                    eventFetchThreadPool2K8.runTask(fetchEventDataWmi);
                } else if (osVersion.startsWith("6.") && eventFetchMode == 0) {
                    EventFetchThreadPool eventFetchThreadPool2K8 = EventFetchThreadPool.getInstance(2);
                    FetchEventDataWMI fetchEventDataWmi = new FetchEventDataWMI(domainDetails, computerName, recordNumber, timeGenerated, windowsProps, machineType, osVersion, guid, isLocalDll);
                    EVENT_LOGGER.log(Level.INFO, "wmi without local dll");
                    eventFetchThreadPool2K8.runTask(fetchEventDataWmi);
                } else if (osVersion.startsWith("6.") && eventFetchMode == 2) {
                    EventFetchThreadPool eventFetchThreadPool = EventFetchThreadPool.getInstance(1);
                    FetchEventData fetchEventData2k8 = new FetchEventData(domainDetails, computerName, recordNumber, timeGenerated, windowsProps, machineType, osVersion, guid, isLocalDll, 2);
                    EVENT_LOGGER.log(Level.INFO, "evt query without local dll");
                    eventFetchThreadPool.runTask(fetchEventData2k8);
                } else {
                    EventFetchThreadPool eventFetchThreadPool = EventFetchThreadPool.getInstance(1);
                    FetchEventData fetchEventData = new FetchEventData(domainDetails, computerName, recordNumber, timeGenerated, windowsProps, machineType, osVersion, guid, isLocalDll, 1);
                    EVENT_LOGGER.log(Level.INFO, "all conditions unsatisfied. Therefore going to native");
                    eventFetchThreadPool.runTask(fetchEventData);
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                EVENT_LOGGER.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{computerName, e.getMessage()});
            } else {
                e.printStackTrace();
            }
            if ((machineType & 0x1000) != 4096) {
                EventErrorAlert.sendMail((String)domainDetails.get("DOMAIN_NAME"), computerName, e.getMessage(), machineType);
            }
            EventDataHandler.getInstance().dcStatusP.put(computerName, 0);
            EventDataUtil.updateEventLogMessage(e.getMessage(), computerName, (String)domainDetails.get("DOMAIN_NAME"));
            throw new Exception(e.getMessage());
        }
    }

    public void fillEventData(String domainName) throws DataAccessException, Exception {
        EVENT_LOGGER.log(Level.INFO, "FillEventData called for domain :  " + domainName);
        ArrayList<Object> l = new ArrayList<Object>();
        DataObject eventIDDO = CommonUtil.getPersistence(new boolean[0]).get("AUDEventID", (Criteria)null);
        if (eventIDDO.isEmpty()) {
            return;
        }
        Iterator it = eventIDDO.getRows("AUDEventID");
        while (it.hasNext()) {
            Row r = (Row)it.next();
            l.add(r.get("EVENT_NUMBER"));
        }
        EVENT_LOGGER.log(Level.FINE, "DBG:: E -> " + l.toString());
        int[] EventIDList = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            Long itn = (Long)l.get(i);
            EventIDList[i] = itn.intValue();
        }
        EVENT_LOGGER.log(Level.FINE, "DBG:: Domain Process Object -> " + DomainProcess.getInstance().toString());
        EVENT_LOGGER.log(Level.FINE, "DBG:: EventIDList -> " + EventIDList);
        EVENT_LOGGER.log(Level.FINE, "DBG:: Domain Name -> " + domainName);
        Properties p = DomainHandler.getConfiguredValues(domainName, 1L);
        EVENT_LOGGER.log(Level.INFO, "its from FillEventData(domainName)");
        this.checkDomainMonitorCount(domainName);
        ConcurrentHashMap<String, HashMap<Long, HashMap<Long, Monitor>>> monitorMap = MonitorManager.getInstance().getMonitorMap();
        if (!monitorMap.isEmpty()) {
            this.getEventData(p);
        } else {
            EVENT_LOGGER.log(Level.INFO, "Monitor is empty, not processing events.");
        }
    }

    public void fillEventData(String domainName, String computerName, Long scheduleid, int machineType, String guid) throws DataAccessException, Exception {
        String status = SchedulerUtil.getStatus(scheduleid);
        if (status != null && status.equalsIgnoreCase("Enabled")) {
            EVENT_LOGGER.log(Level.INFO, "its from FillEventData(domainName,computerName,scheduleid,machineType,guid)");
            this.checkDomainMonitorCount(domainName);
            EVENT_LOGGER.log(Level.INFO, "DBG:: Domain Process Object -> " + DomainProcess.getInstance().toString());
            EVENT_LOGGER.log(Level.INFO, "DBG:: Domain Name -> " + domainName);
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            ConcurrentHashMap<String, HashMap<Long, HashMap<Long, Monitor>>> monitorMap = MonitorManager.getInstance().getMonitorMap();
            if (!monitorMap.isEmpty()) {
                this.getEventDataFromDC(domainDetails, computerName, machineType, guid);
            } else {
                EVENT_LOGGER.log(Level.INFO, "Monitor is empty, not processing events.");
            }
        }
    }

    private void getEventData(Properties domainDetails) throws Exception {
        int noOfDCs = ((ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST")).size();
        for (int i = 0; i < noOfDCs; ++i) {
            String domainName;
            String dcName = (String)((ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST")).get(i);
            String status = EventSchedulerUtil.getDCSchedulerStatus(dcName, domainName = (String)domainDetails.get("DOMAIN_NAME"));
            if (status == null || !status.equalsIgnoreCase("Enabled")) continue;
            this.getEventDataFromDC(domainDetails, dcName, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDomainMonitorCount(String domainName) throws Exception {
        EventDataHandler eventDataHandler = this;
        synchronized (eventDataHandler) {
            int monitorsCount = AuditMonitorAPI.getInstance().getMonitorsCountForDomain(domainName);
            if (monitorsCount < 1) {
                Properties domainProperties = DomainAction.getDomainGeneralDetails(domainName);
                AuditMonitorHandler.getInstance().createDefaultMonitors(domainProperties);
            }
        }
    }
}

