/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import java.util.HashMap;
import java.util.Iterator;

public class EventFormatMessageAPI {
    private static volatile EventFormatMessageAPI eventFormatMessageAPI = null;
    private HashMap<String, HashMap<Integer, String>> formatMap = null;
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final EventFormatMessageAPI getInstance() {
        if (eventFormatMessageAPI != null) return eventFormatMessageAPI;
        Class<EventFormatMessageAPI> clazz = EventFormatMessageAPI.class;
        synchronized (EventFormatMessageAPI.class) {
            if (eventFormatMessageAPI != null) return eventFormatMessageAPI;
            eventFormatMessageAPI = new EventFormatMessageAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return eventFormatMessageAPI;
        }
    }

    private EventFormatMessageAPI() {
        this.getMessageFormats();
    }

    private final void getMessageFormats() {
        try {
            this.formatMap = new HashMap();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEvtFormatMessage", (Row)null);
            Iterator iterator = dataObject.getRows("AUDEvtFormatMessage");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String objectClass = (String)row.get("OBJECT_CLASS");
                HashMap<Integer, String> objectClassMap = this.formatMap.get(objectClass);
                if (objectClassMap == null) {
                    objectClassMap = new HashMap();
                }
                objectClassMap.put((Integer)row.get("EVENT_NUMBER"), RB.getString((String)row.get("FORMAT")));
                this.formatMap.put(objectClass, objectClassMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final String getFormatMessage(Row eventRow, Integer eventNumber, String objectClass) {
        String format = this.getFormat(eventNumber, objectClass);
        String message = "-";
        if (format != null) {
            message = FormatUtil.getFormatMessage(eventRow, format);
        }
        return message;
    }

    public final String getFormat(Integer eventNumber, String objectClass) {
        String format = "";
        if (this.formatMap == null) {
            this.getMessageFormats();
        }
        HashMap<Integer, String> objectClassMap = this.formatMap.get(objectClass);
        format = objectClassMap.get(eventNumber);
        return format;
    }
}

