/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.RuleVariable;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class EventVariablesAPI {
    private static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static EventVariablesAPI eventAPI = null;
    private static HashMap eventVarMapping = null;
    private static HashMap ruleVariablesMap = null;
    private static HashMap kerberosErrorCodeMap = null;
    private static HashMap logonTypeMap = null;
    private static HashMap userRightsMap = null;
    private static HashMap<String, Long> categoryIdMap = null;
    public static final String[] RULE_VARIABLE_COLUMNS = new String[]{"VARIABLE_ID", "VARIABLE_DATATYPE", "VARIABLE_NAME", "VARIABLE_DISPLAY_NAME", "INPUT_TYPE", "IS_MULTI_VALUED"};
    public static HashMap<Integer, HashMap<String, String>> evtSIDMapping = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventVariablesAPI getInstance() {
        if (eventAPI != null) return eventAPI;
        Class<EventVariablesAPI> clazz = EventVariablesAPI.class;
        synchronized (EventVariablesAPI.class) {
            if (eventAPI != null) return eventAPI;
            eventAPI = new EventVariablesAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return eventAPI;
        }
    }

    private EventVariablesAPI() {
        this.getEventVarMapping();
        this.getRuleVariables();
        this.getKerberosErrorCodes();
        this.getEvtVarSIDMapping();
        this.getLogonTypeCodes();
        this.getUserRights();
        this.getCategoryId();
    }

    private void getEventVarMapping() {
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDEvtVarActionMapping");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDEvtVarActionMapping", (String)"EVENT_ID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, criteria);
            if (dataObject.size("AUDEvtVarActionMapping") > 0) {
                eventVarMapping = new HashMap();
                Iterator iterator = dataObject.getRows("AUDEvtVarActionMapping");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Object evtId = row.get("EVENT_ID");
                    Object objClass = row.get("OBJECT_CLASS");
                    HashMap<String, Object> idObjClassMap = new HashMap<String, Object>();
                    idObjClassMap.put("EVENT_ID", evtId.toString());
                    idObjClassMap.put("CATEGORY_ID", (Long)row.get("CATEGORY_ID"));
                    HashMap valueMap = null;
                    valueMap = eventVarMapping.get(idObjClassMap) == null ? new HashMap() : (HashMap)eventVarMapping.get(idObjClassMap);
                    String columnName = (String)row.get("COLUMN_NAME");
                    String tableName = (String)row.get("TABLE_NAME");
                    ArrayList tableColumnList = null;
                    tableColumnList = valueMap.get(tableName) == null ? new ArrayList() : (ArrayList)valueMap.get(tableName);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("COLUMN_NAME", columnName);
                    hashMap.put("VARIABLE_ID", row.get("VARIABLE_ID"));
                    tableColumnList.add(hashMap);
                    valueMap.put(tableName, tableColumnList);
                    eventVarMapping.put(idObjClassMap, valueMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getEventVarMapping(Integer eventID, Long categoryId) {
        HashMap eventIdVarMap = null;
        try {
            if (eventVarMapping == null) {
                this.getEventVarMapping();
            }
            HashMap<String, Object> idObjectClassMap = new HashMap<String, Object>();
            idObjectClassMap.put("EVENT_ID", eventID.toString());
            idObjectClassMap.put("CATEGORY_ID", categoryId);
            eventIdVarMap = (HashMap)eventVarMapping.get(idObjectClassMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return eventIdVarMap;
    }

    private void getRuleVariables() {
        try {
            DataObject ruleVariablesDO = CommonUtil.getPersistence(new boolean[0]).get("AUDRuleVariables", (Row)null);
            ruleVariablesMap = new HashMap();
            Iterator iterator = ruleVariablesDO.getRows("AUDRuleVariables");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long ruleVariableId = (Long)row.get("VARIABLE_ID");
                RuleVariable ruleVariable = new RuleVariable(row);
                ruleVariablesMap.put(ruleVariableId, ruleVariable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RuleVariable getVariable(Long varID) {
        RuleVariable variable = null;
        try {
            if (ruleVariablesMap == null) {
                this.getRuleVariables();
            }
            variable = (RuleVariable)ruleVariablesMap.get(varID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return variable;
    }

    private void getKerberosErrorCodes() {
        try {
            DataObject kerberosErrorCodeDO = CommonUtil.getPersistence(new boolean[0]).get("AUDKerberosErrorCodes", (Criteria)null);
            kerberosErrorCodeMap = new HashMap();
            Iterator iterator = kerberosErrorCodeDO.getRows("AUDKerberosErrorCodes");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String errorCode = ((String)row.get("ERROR_CODE")).toLowerCase();
                String errorCodeText = rb.getString((String)row.get("ERROR_CODE_TEXT"));
                kerberosErrorCodeMap.put(errorCode, errorCodeText);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getLogonTypeCodes() {
        try {
            DataObject logonTypeDO = CommonUtil.getPersistence(new boolean[0]).get("AUDLogonCodes", (Criteria)null);
            logonTypeMap = new HashMap();
            Iterator iterator = logonTypeDO.getRows("AUDLogonCodes");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String logonTypeText = rb.getString((String)row.get("LOGON_TYPE_TEXT"));
                logonTypeMap.put(row.get("LOGON_TYPE"), logonTypeText);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getUserRights() {
        try {
            DataObject userRightsDO = CommonUtil.getPersistence(new boolean[0]).get("AUDUserRights", (Criteria)null);
            userRightsMap = new HashMap();
            Iterator iterator = userRightsDO.getRows("AUDUserRights");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                userRightsMap.put(row.get("USER_RIGHTS"), rb.getString((String)row.get("USER_RIGHTS_VALUE")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getKerberosErrorCodeText(String errorCode) {
        String errorCodeText = "-";
        try {
            Object value;
            if (kerberosErrorCodeMap == null) {
                this.getKerberosErrorCodes();
            }
            errorCodeText = (value = kerberosErrorCodeMap.get(errorCode.toLowerCase())) != null ? (String)value : errorCode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorCodeText;
    }

    public String getLogonTypeCodeText(String logonType) {
        String logonTypeText = "-";
        try {
            Object value;
            if (logonTypeMap == null) {
                this.getLogonTypeCodes();
            }
            if ((value = logonTypeMap.get(logonType)) != null) {
                logonTypeText = (String)value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logonTypeText;
    }

    public String getUserRightsValue(Object userRights) {
        String userRightsValue = (String)userRights;
        try {
            Object value;
            if (userRightsMap == null) {
                this.getUserRights();
            }
            if ((value = userRightsMap.get(userRights)) != null) {
                userRightsValue = (String)value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userRightsValue;
    }

    private void getEvtVarSIDMapping() {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEvtVarSID", (Row)null);
            if (!dataObject.isEmpty()) {
                evtSIDMapping = new HashMap();
                Iterator iterator = dataObject.getRows("AUDEvtVarSID");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Integer eventId = ((Long)row.get("EVENT_ID")).intValue();
                    HashMap<Object, Object> sidMap = null;
                    sidMap = evtSIDMapping.get(eventId) == null ? new HashMap() : evtSIDMapping.get(eventId);
                    Long variableId = (Long)row.get("VARIABLE_ID");
                    sidMap.put(row.get("VARIABLE_TYPE").toString(), rb.getString(this.getVariable(variableId).getName()));
                    evtSIDMapping.put(eventId, sidMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, String> getEvtVarSID(Integer eventId) {
        if (evtSIDMapping == null) {
            this.getEvtVarSIDMapping();
        }
        return evtSIDMapping.get(eventId);
    }

    private void getCategoryId() {
        String[] uvhStr = new String[]{"AUDCategories:category_id:1", "AUDCategories:category_id:2", "AUDCategories:category_id:3", "AUDCategories:category_id:4", "AUDCategories:category_id:5", "AUDCategories:category_id:6", "AUDCategories:category_id:7", "AUDCategories:category_id:8", "AUDCategories:category_id:9", "AUDCategories:category_id:20", "AUDCategories:category_id:30", "AUDCategories:category_id:31", "AUDCategories:category_id:32", "AUDCategories:category_id:33"};
        categoryIdMap = new HashMap();
        for (int count = 0; count < uvhStr.length; ++count) {
            categoryIdMap.put(uvhStr[count], DBObjectUtil.getUVHValues("AUDCategories", uvhStr[count]));
        }
    }

    public Long getCategoryId(String cateStr) {
        if (categoryIdMap == null) {
            this.getCategoryId();
        }
        return categoryIdMap.get(cateStr);
    }
}

