/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class LastLogonUpdateQueue {
    private static volatile LastLogonUpdateQueue queue = null;
    private static Vector<Row> addQ = new Vector();
    private static Hashtable<String, Row> updateQueue = new Hashtable();
    private boolean isProcessCompleted = true;
    private Criteria criteria = null;
    private static final String AUDUSER_LASTLOGON_INFO = "AUDUserLastLogonInfo";
    private static final String USER_SID = "USER_SID";
    private HashMap<String, Long> sidMap = null;
    private Object object = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LastLogonUpdateQueue getInstance() {
        Class<LastLogonUpdateQueue> clazz = LastLogonUpdateQueue.class;
        synchronized (LastLogonUpdateQueue.class) {
            if (queue == null) {
                queue = new LastLogonUpdateQueue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return queue;
        }
    }

    private LastLogonUpdateQueue() {
        this.setSIDMap();
        new Action().start();
    }

    private void setSIDMap() {
        this.sidMap = new HashMap();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)AUDUSER_LASTLOGON_INFO));
            query.addSelectColumn(Column.getColumn((String)AUDUSER_LASTLOGON_INFO, (String)USER_SID));
            query.addSelectColumn(Column.getColumn((String)AUDUSER_LASTLOGON_INFO, (String)"TIME_GENERATED"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dObj.isEmpty()) {
                Iterator iterator = dObj.getRows(AUDUSER_LASTLOGON_INFO);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String userSid = (String)row.get(USER_SID);
                    Long timeGen = (Long)row.get("TIME_GENERATED");
                    this.sidMap.put(userSid, timeGen);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Vector<Row> addQCopy = null;
        Vector<Row> vector = addQ;
        synchronized (vector) {
            addQCopy = addQ;
            addQ = new Vector();
            try {
                if (addQCopy.size() > 0) {
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    for (Row row : addQCopy) {
                        Row lastLogonRow = new Row(AUDUSER_LASTLOGON_INFO);
                        for (Object object : lastLogonRow.getColumns()) {
                            lastLogonRow.set((String)object, row.get((String)object));
                        }
                        dataObject.addRow(lastLogonRow);
                    }
                    CommonUtil.getPersistence(new boolean[0]).add(dataObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Hashtable<String, Row> updateQueueCopy = null;
        Hashtable<String, Row> hashtable = updateQueue;
        synchronized (hashtable) {
            updateQueueCopy = updateQueue;
            updateQueue = new Hashtable();
            try {
                if (updateQueueCopy.size() > 0) {
                    String[] criteriaSIDs = new String[updateQueueCopy.size()];
                    int i = 0;
                    Enumeration<String> enumeration = updateQueueCopy.keys();
                    while (enumeration.hasMoreElements()) {
                        criteriaSIDs[i] = enumeration.nextElement();
                        ++i;
                    }
                    this.criteria = new Criteria(Column.getColumn((String)AUDUSER_LASTLOGON_INFO, (String)USER_SID), (Object)criteriaSIDs, 8);
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUDUSER_LASTLOGON_INFO, this.criteria);
                    Iterator rowIterator = dataObject.getRows(AUDUSER_LASTLOGON_INFO);
                    while (rowIterator.hasNext()) {
                        Row lastLognInforow = (Row)rowIterator.next();
                        String userSID = (String)lastLognInforow.get(USER_SID);
                        Row logonInfoRow = updateQueueCopy.get(userSID);
                        for (Object object : lastLognInforow.getColumns()) {
                            lastLognInforow.set((String)object, logonInfoRow.get((String)object));
                        }
                        dataObject.updateRow(lastLognInforow);
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isProcessCompleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateRow(Row logoninfoRow) {
        Object object = this.object;
        synchronized (object) {
            String userSid = (String)logoninfoRow.get(USER_SID);
            long timeFromEvent = (Long)logoninfoRow.get("TIME_GENERATED");
            if (this.sidMap.get(userSid) == null) {
                addQ.addElement(logoninfoRow);
                this.sidMap.put(userSid, timeFromEvent);
            } else if (timeFromEvent > this.sidMap.get(userSid)) {
                updateQueue.put(userSid, logoninfoRow);
                this.sidMap.put(userSid, timeFromEvent);
            }
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        @Override
        public void run() {
            try {
                while (!this.shutDown) {
                    this.checkAndProcess();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void checkAndProcess() {
            this.waitForUpdate(300L);
            if (LastLogonUpdateQueue.this.isProcessCompleted) {
                LastLogonUpdateQueue.this.process();
            }
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

