/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server;

import com.adventnet.db.persistence.SequenceGenerator;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.SequenceGeneratorRepository;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.EventManager;
import com.adventnet.sym.adsm.auditing.server.category.EventCategoryListener;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.auditing.server.monitor.Monitor;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.util.FileAuditIpResolverUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessMonitor {
    private static final Logger EVENTLOGGER = Logger.getLogger("EventLogger");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final Long DEFAULT_USER_MGMT_CATEGORY_ID = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:3");
    private static final Long DEFAULT_COMPUTER_MGMT_CATEGORY_ID = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:4");
    private static final Long DEFAULT_GROUP_MGMT_CATEGORY_ID = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:5");

    public static void process(Hashtable<String, Object> eventTable) throws Exception {
        String domainName;
        HashMap<Long, HashMap<Long, Monitor>> domainMap;
        String shareName;
        ConcurrentHashMap<String, HashMap<Long, HashMap<Long, Monitor>>> monitorMap = MonitorManager.getInstance().getMonitorMap();
        Integer eventId = (Integer)eventTable.get("EventCode");
        ArrayList<Object> categoryList = new ArrayList();
        if (eventId == 685 || eventId == 4781) {
            String objClass;
            String SID = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Target_Account_ID"));
            if (SID == null) {
                SID = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Security_ID"));
            }
            String domainName2 = (String)eventTable.get("DomainName");
            if (SID.startsWith("%{")) {
                SID = SID.substring(2, SID.length() - 1);
            }
            if ((objClass = ADAPObjectCacheAPI.getInstance().getObjectClassFromSIDGC(domainName2, SID)).equalsIgnoreCase("user")) {
                categoryList.add(DEFAULT_USER_MGMT_CATEGORY_ID);
            } else if (objClass.equalsIgnoreCase("computer")) {
                categoryList.add(DEFAULT_COMPUTER_MGMT_CATEGORY_ID);
            } else if (objClass.equalsIgnoreCase("group")) {
                categoryList.add(DEFAULT_GROUP_MGMT_CATEGORY_ID);
            }
        } else {
            categoryList = AuditEventAPI.getCategoriesForEventId(eventId);
        }
        if (eventId == 5140 && !(shareName = (String)eventTable.get("Share Name")).contains("IPC$")) {
            FileAuditIpResolverUtil.getInstance().insertOrUpdateIp(eventTable);
        }
        if (!monitorMap.isEmpty() && (domainMap = monitorMap.get(domainName = (String)eventTable.get("DomainName"))) != null) {
            for (Long l : categoryList) {
                HashMap<Long, Monitor> categoryMap = domainMap.get(l);
                if (categoryMap == null) continue;
                Set<Long> categorySet = categoryMap.keySet();
                for (Long monitorId : categorySet) {
                    Monitor monitor = categoryMap.get(monitorId);
                    Hashtable<String, Object> procesedEventTable = monitor.evaluate(eventTable, monitor);
                    if (procesedEventTable == null) continue;
                    procesedEventTable.put("CategoryId", l);
                    procesedEventTable.put("MonitorId", monitorId);
                    procesedEventTable.put("monitorDomainName", domainName);
                    ProcessMonitor.addEventRows(procesedEventTable);
                    EVENTLOGGER.log(Level.FINE, "monitor {0} evaluated succesfully : ", new Object[]{monitorId});
                }
            }
        }
    }

    public static void addEventRows(Hashtable<String, Object> procesedEventTable) {
        block6: {
            try {
                if (procesedEventTable == null) break block6;
                Long catgId = 0L;
                Long processMonitorId = 0L;
                String domainName = null;
                if (procesedEventTable.get("CategoryId") != null) {
                    catgId = (Long)procesedEventTable.get("CategoryId");
                    processMonitorId = (Long)procesedEventTable.get("MonitorId");
                    domainName = (String)procesedEventTable.get("monitorDomainName");
                }
                Category category = AuditCatgoryAPI.getInstance().getCategoryObject(catgId);
                EventCategoryListener eventCategoryListener = category.getCategoryListener();
                ObjectClass objectClass = category.getResultObjectClass();
                ArrayList<Row> rowList = null;
                try {
                    rowList = eventCategoryListener.getEventRowList(domainName, procesedEventTable, processMonitorId, objectClass.getObjectClass(), catgId);
                }
                catch (Exception exception) {
                    EVENTLOGGER.warning("Exception in getting ColumnValue for: " + procesedEventTable);
                    exception.printStackTrace();
                }
                if (rowList != null) {
                    Boolean isEvtCollector = ((Integer)procesedEventTable.get("MachineType") & 0x400) == 1024;
                    EventManager.getInstance().addEventRows(rowList, domainName, isEvtCollector);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static SequenceGenerator getSequenceGenerator(String generatorName, String tableName) throws Exception {
        SequenceGenerator gen = SequenceGeneratorRepository.get((String)generatorName);
        if (gen != null) {
            return gen;
        }
        return ProcessMonitor.getSequenceGenerator(generatorName, MetaDataUtil.getTableDefinitionByName((String)tableName));
    }

    public static SequenceGenerator getSequenceGenerator(String generatorName, TableDefinition td) throws DataAccessException {
        SequenceGenerator gen = SequenceGeneratorRepository.get((String)generatorName);
        if (gen == null) {
            try {
                SequenceGeneratorRepository.initGeneratorValues((TableDefinition)td);
                gen = SequenceGeneratorRepository.get((String)generatorName);
            }
            catch (Exception e) {
                throw new DataAccessException("Problem in initializing the SequenceGenerator for the tableName : " + td.getTableName(), (Throwable)e);
            }
        }
        return gen;
    }

    public static void loadDataToDB(String filename, String tableName, int linesToIgnore, List colNames) throws Exception {
        StringBuilder query = new StringBuilder("LOAD DATA LOCAL INFILE '");
        query.append(filename.replaceAll("\\\\", "\\\\\\\\")).append("' INTO TABLE ").append(tableName).append(" FIELDS TERMINATED BY ','  ENCLOSED BY '\"' IGNORE ").append(linesToIgnore).append(" LINES");
        if (colNames != null) {
            query.append(" (");
            int j = colNames.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    query.append(',');
                }
                query.append(colNames.get(i));
            }
            query.append(')');
        }
    }

    private Long getMonitorGenID(Row monitorRow) throws DataAccessException {
        Long monitorGenID = 0L;
        String tblName = "AUDMonitorGenDetails";
        Long monitorID = (Long)monitorRow.get("MONITOR_ID");
        EVENTLOGGER.log(Level.FINE, "DBG:: Monitor ID -> " + monitorID);
        SelectQueryImpl q = new SelectQueryImpl(Table.getTable((String)tblName));
        Criteria c = new Criteria(Column.getColumn((String)tblName, (String)"MONITOR_ID"), (Object)monitorID, 0);
        q.addSelectColumn(Column.getColumn((String)tblName, (String)"*"));
        q.setCriteria(c);
        DataObject genDO = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)q);
        EVENTLOGGER.log(Level.FINE, "DBG:: MonitorGenDO -> " + genDO);
        monitorGenID = (Long)genDO.getFirstValue(tblName, "MONITOR_GEN_ID");
        return monitorGenID;
    }

    private DataObject getVariableListFromEventID(Integer eventID) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDEvtVarActionMapping"));
        Criteria c = new Criteria(Column.getColumn((String)"AUDEvtVarActionMapping", (String)"EVENT_ID"), (Object)eventID, 0);
        query.addSelectColumn(Column.getColumn((String)"AUDEvtVarActionMapping", (String)"*"));
        query.setCriteria(c);
        DataObject varDO = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        EVENTLOGGER.log(Level.FINE, "DBG:: Var DO -> " + varDO);
        return varDO;
    }
}

