/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.ProcessMonitor;
import com.adventnet.sym.adsm.auditing.server.accountLockout.IISHandler;
import com.adventnet.sym.adsm.auditing.server.accountLockout.LogCopyThread;
import com.adventnet.sym.adsm.auditing.server.accountLockout.LogUtil;
import com.adventnet.sym.adsm.auditing.server.accountLockout.OWALogTask;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AccountLockoutHistory {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    static String[] properties = new String[]{"Category", "ComputerName", "EventCode", "Message", "RecordNumber", "SourceName", "TimeGenerated", "EventType", "Type", "User"};
    private static AccountLockoutHistory accountLockoutHistory = null;
    public static Queue<Hashtable<String, Object>> queue = null;
    static Long categoryId = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:9");
    public static ProcessThread processThread = null;
    public static HashMap<String, String> ruleMap = null;
    public static HashMap<String, Integer> workstationStatus = null;
    public static HashMap<String, Integer> activeSyncStatus = null;
    public static HashMap<String, String> errorMessage = null;
    public static HashMap<String, String> activeSyncErrorMessage = null;
    public static HashMap<String, Boolean> iisConfigure = null;
    private static final Logger logger = Logger.getLogger("EventLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccountLockoutHistory getInstance() {
        if (accountLockoutHistory != null) return accountLockoutHistory;
        Class<AccountLockoutHistory> clazz = AccountLockoutHistory.class;
        synchronized (AccountLockoutHistory.class) {
            accountLockoutHistory = new AccountLockoutHistory();
            queue = new LinkedList<Hashtable<String, Object>>();
            workstationStatus = new HashMap();
            activeSyncStatus = new HashMap();
            processThread = new ProcessThread();
            ruleMap = new HashMap();
            errorMessage = new HashMap();
            activeSyncErrorMessage = new HashMap();
            iisConfigure = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return accountLockoutHistory;
        }
    }

    public static void wmiNotify(Object data) {
        try {
            Hashtable table = (Hashtable)data;
            if (table != null) {
                Hashtable<String, Object> modData = AuditEventAPI.getInstance().parseEvent(table);
                queue.add(modData);
                if (!processThread.isAlive()) {
                    processThread = new ProcessThread();
                    processThread.start();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fetchOwaActiveSyncHistory(HashMap<String, String> map) {
        block3: {
            String server;
            block2: {
                server = map.get("workstation");
                AccountLockoutHistory.getInstance();
                if (activeSyncStatus.get(server) == null) break block2;
                AccountLockoutHistory.getInstance();
                if (activeSyncStatus.get(server) != 0) break block3;
            }
            AccountLockoutHistory.getInstance();
            activeSyncStatus.put(server, 1);
        }
        EventFetchThread eventFetchThread = new EventFetchThread(map, false);
        eventFetchThread.start();
    }

    public static String formatLogDirPath(String serverLogDirPath, String gatheringServerName) throws Exception {
        String serverLogDirPathPrefix = "\\\\?\\UNC\\";
        if (serverLogDirPath != null) {
            if (serverLogDirPath.contains(":")) {
                serverLogDirPath = serverLogDirPathPrefix + gatheringServerName + File.separator + serverLogDirPath.replace(":", "$") + File.separator;
            } else if (serverLogDirPath.startsWith("\\")) {
                serverLogDirPath = serverLogDirPath + File.separator;
            }
        }
        return serverLogDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getOwaActiveSyncEventData(HashMap<String, String> map) {
        try {
            String server = map.get("workstation");
            String accountName = map.get("accountName");
            String domainName = map.get("domainName");
            String timeGenerated = map.get("timeGenerated");
            String uniqueId = map.get("uniqueId");
            IISHandler.checkAndGetIISDetails(map);
            if (!map.containsKey("serverDirPath")) {
                AccountLockoutHistory.getInstance();
                activeSyncErrorMessage.put(server, map.get("err"));
                if (map.containsKey("toBeConfigured")) {
                    AccountLockoutHistory.getInstance();
                    iisConfigure.put(server, true);
                }
                AccountLockoutHistory.getInstance();
                activeSyncStatus.put(server, 0);
                return;
            }
            AccountLockoutHistory.getInstance();
            iisConfigure.put(server, false);
            String serverLogDirPath = map.get("serverDirPath");
            serverLogDirPath = AccountLockoutHistory.formatLogDirPath(serverLogDirPath, server);
            String currentWorkDir = System.getProperty("server.dir");
            String localLogDirPath = new String(currentWorkDir + File.separator + "data" + File.separator + server + File.separator);
            File tempDir = new File(currentWorkDir + File.separator + "data" + File.separator);
            if (!tempDir.exists()) {
                logger.log(Level.CONFIG, Thread.currentThread() + " '" + currentWorkDir + "\\Data' Directory Does Not Exists. Creating The Directory...");
                tempDir.mkdir();
            } else {
                logger.log(Level.CONFIG, Thread.currentThread() + " '" + currentWorkDir + "\\Data' Directory Exists.");
            }
            File tempFile = new File(localLogDirPath);
            if (!tempFile.exists()) {
                logger.log(Level.CONFIG, Thread.currentThread() + " " + localLogDirPath + " Does Not Exists. Creating The Directory...");
                tempFile.mkdir();
            } else {
                logger.log(Level.CONFIG, Thread.currentThread() + " " + localLogDirPath + " Exists.");
            }
            String owaSearchPattern = "\\*.log";
            Properties domainCredentials = DomainHandler.getConfiguredValues(domainName, 1L);
            Long startTime = Long.parseLong(timeGenerated) - 900L;
            Long to = Long.parseLong(timeGenerated) + 300L;
            Criteria criteria = new Criteria(Column.getColumn((String)"OWA_ACTIVESYNC", (String)"USERNAME"), (Object)accountName, 0);
            criteria.and(new Criteria(Column.getColumn((String)"OWA_ACTIVESYNC", (String)"TIME_GENERATED"), (Object)to, 6));
            DataObject d = CommonUtil.getPersistence(new boolean[0]).get("OWA_ACTIVESYNC", criteria);
            if (!d.isEmpty()) {
                SortColumn sortCol = new SortColumn("OWA_ACTIVESYNC", "TIME_GENERATED", false);
                d.sortRows("OWA_ACTIVESYNC", new SortColumn[]{sortCol});
                Row r = d.getFirstRow("OWA_ACTIVESYNC");
                Long time = (Long)r.get("TIME_GENERATED");
                if (time >= startTime) {
                    startTime = time + 1L;
                }
            }
            LogCopyThread logCopyThread = new LogCopyThread(server, (String)domainCredentials.get("USER_NAME"), (String)domainCredentials.get("PASSWORD"), domainName, serverLogDirPath, localLogDirPath, owaSearchPattern, timeGenerated, startTime, true, "OWA", map.get("period"), Boolean.parseBoolean(map.get("utf")));
            new Thread(logCopyThread).start();
            while (!logCopyThread.getAllLogFilesCopiedFlag() || logCopyThread.getCopiedLogFilesListSize() > 0) {
                logger.log(Level.CONFIG, Thread.currentThread() + " Checking If Any Files Are Available For Parsing..");
                logCopyThread.checkCopiedLogFilesListSize();
                if (logCopyThread.getCopiedLogFilesListSize() <= 0) continue;
                String logFile = "";
                String parentFolder = "";
                try {
                    HashMap<Object, Object> fileDetails = logCopyThread.getCopiedLogFilesListDetails(0);
                    logFile = (String)fileDetails.get("fileName");
                    parentFolder = (String)fileDetails.get("parentFolder");
                    if (!logFile.toLowerCase().startsWith("fr")) {
                        logger.log(Level.INFO, Thread.currentThread() + " parsing file logFile : " + logFile + " | parentFolder: " + parentFolder);
                        OWALogTask task = new OWALogTask(server, logFile, parentFolder, accountName, timeGenerated, startTime);
                        task.process();
                        LogUtil.setLogFileProcessedStatus(server, logFile, parentFolder, 3);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogUtil.setLogFileProcessedStatus(server, logFile, parentFolder, 1);
                    AccountLockoutHistory.getInstance();
                    activeSyncErrorMessage.put(server, e.getMessage());
                }
                finally {
                    String fileToBeDeleted = "";
                    fileToBeDeleted = parentFolder != null && !parentFolder.equals("") ? new String(System.getProperty("server.dir") + File.separator + "data" + File.separator + server + File.separator + parentFolder + File.separator + logFile) : new String(System.getProperty("server.dir") + File.separator + "data" + File.separator + server + File.separator + logFile);
                    new File(fileToBeDeleted).delete();
                }
                logCopyThread.removeCopiedLogFilesListElement(0);
            }
            if (logCopyThread.getErrorMessage() != null) {
                AccountLockoutHistory.getInstance();
                activeSyncErrorMessage.put(server, logCopyThread.getErrorMessage());
            }
            AccountLockoutHistory.getInstance();
            activeSyncStatus.put(server, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fetchEventData(HashMap<String, String> map) {
        try {
            block5: {
                String workstation;
                block4: {
                    workstation = map.get("workstation");
                    AccountLockoutHistory.getInstance();
                    if (workstationStatus.get(workstation) == null) break block4;
                    AccountLockoutHistory.getInstance();
                    if (workstationStatus.get(workstation) != 0) break block5;
                }
                AccountLockoutHistory.getInstance();
                workstationStatus.put(workstation, 1);
            }
            EventFetchThread eventFetchThread = new EventFetchThread(map, true);
            eventFetchThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean checkIfMachineConfigured(String domainName, String machineName, HashMap result) throws Exception {
        boolean flag = false;
        HashMap prop = EventDataUtil.getComputerProperties(domainName, machineName);
        if (prop == null) {
            prop = EventDataUtil.getComputerProperties(domainName, machineName.toLowerCase());
        }
        Long computer_id = -1L;
        String objectGuid = null;
        if (prop != null) {
            if (prop.containsKey("OBJECT_GUID")) {
                objectGuid = (String)prop.get("OBJECT_GUID");
                result.put("objectGuid", objectGuid);
            }
            computer_id = (Long)prop.get("COMPUTER_ID");
        }
        Integer machineType = -1;
        Integer adminStatus = -1;
        Long scheduleId = -1L;
        if (objectGuid != null) {
            Row r;
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)computer_id, 0));
            if (!obj.isEmpty() && (r = obj.getFirstRow("AUDComputerEventRead")) != null) {
                machineType = (Integer)r.get("MACHINE_TYPE");
                result.put("machineType", machineType);
                if ((machineType & 0x10) == 16 || (machineType & 0x1000) == 4096) {
                    flag = true;
                }
            }
        } else {
            Row r;
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AUDDCEventRead"));
            Join join = new Join(Table.getTable((String)"AUDDCEventRead"), Table.getTable((String)"Scheduled_Task"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), (Object)computer_id, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty() && (r = dataObj.getFirstRow("Scheduled_Task")) != null) {
                adminStatus = (Integer)r.get("ADMIN_STATUS");
                scheduleId = (Long)r.get("SCHEDULE_ID");
                result.put("scheduleId", scheduleId);
                if (adminStatus == 3) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getEventData(HashMap<String, String> map) {
        String machineName = map.get("workstation");
        boolean flag = false;
        boolean isDC = false;
        try {
            String accountName = map.get("accountName");
            String domainName = map.get("domainName");
            String timeGenerated = map.get("timeGenerated");
            ruleMap.put("userName", accountName);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"), (Object)accountName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMUserGeneralDetails", criteria);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("ADSMUserGeneralDetails");
                ruleMap.put("logonName", (String)r.get("LOGON_NAME"));
            }
            ruleMap.put("domainName", domainName);
            HashMap result = new HashMap();
            flag = AccountLockoutHistory.checkIfMachineConfigured(domainName, machineName, result);
            if (flag) {
                if (errorMessage.containsKey(machineName)) {
                    errorMessage.remove(machineName);
                }
                if (result.containsKey("objectGuid") && result.get("objectGuid") != null) {
                    try {
                        EventDataHandler.getInstance().getEventDataFromDC(domainName, machineName, (int)((Integer)result.get("machineType")), (String)result.get("objectGuid"));
                    }
                    catch (Exception e) {
                        errorMessage.put(machineName, rb.getString("adap.routine_event_fetch_in_progress_wait_retry"));
                    }
                } else {
                    isDC = true;
                    try {
                        EventDataHandler.getInstance().fillEventData(domainName, machineName.toLowerCase(), (Long)result.get("scheduleId"), 1, null);
                    }
                    catch (Exception e) {
                        errorMessage.put(machineName, rb.getString("adap.routine_event_fetch_in_progress_wait_retry"));
                    }
                }
            } else {
                Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
                String windowsVersion = DirectoryObjectAPI.getInstance().getObjectOsVersion(domainName, null, machineName, "computer");
                String osVersion = null;
                HashMap resultMap = new HashMap();
                if (windowsVersion != null) {
                    osVersion = CommonUtil.getOSVersion(windowsVersion);
                    int[] eventIDList = AccountLockoutHistory.getEventNumber(windowsVersion);
                    resultMap = ADHandler.getLockoutEventData(domainDetails, machineName, new Long(timeGenerated) - 900L, new Long(timeGenerated) + 240L, eventIDList, 0, osVersion);
                } else {
                    resultMap.put("errorMessage", rb.getString("adap.AccountLockoutHistory.text.cant_osversion"));
                }
                if (resultMap.get("errorMessage") != null) {
                    errorMessage.put(machineName, (String)resultMap.get("errorMessage"));
                } else if (errorMessage.containsKey(machineName)) {
                    errorMessage.remove(machineName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (flag) {
                if (isDC) {
                    while (EventDataHandler.getInstance().dcStatusP != null && EventDataHandler.getInstance().dcStatusP.get(machineName.toLowerCase()) != null && EventDataHandler.getInstance().dcStatusP.get(machineName.toLowerCase()) != 0) {
                    }
                } else {
                    while (EventDataHandler.getInstance().dcStatusP != null && EventDataHandler.getInstance().dcStatusP.get(machineName) != null && EventDataHandler.getInstance().dcStatusP.get(machineName) != 0) {
                    }
                }
            }
            AccountLockoutHistory.getInstance();
            workstationStatus.put(machineName, 0);
        }
    }

    public static void process(Hashtable<String, Object> table) {
        try {
            boolean b = AccountLockoutHistory.evaluate(table);
            if (b) {
                table.put("CategoryId", categoryId);
                table.put("MonitorId", 0L);
                table.put("monitorDomainName", ruleMap.get("domainName"));
                ProcessMonitor.addEventRows(table);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int[] getEventNumber(String windowsVersion) {
        int[] eventIDList = new int[]{4625, 4625, 4648};
        try {
            if (windowsVersion != null && windowsVersion.startsWith("5.")) {
                eventIDList = new int[]{529, 530, 531, 532, 533, 534, 535, 536, 537, 539, 528};
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return eventIDList;
    }

    public static Boolean evaluate(Hashtable<String, Object> table) {
        boolean b = false;
        try {
            String name = "";
            Integer eventCode = (Integer)table.get("EventCode");
            name = eventCode == 4625 || eventCode == 4648 ? table.get("Account Name").toString() : table.get("User Name").toString();
            if (name != null && (name.equalsIgnoreCase(ruleMap.get("userName")) || name.equalsIgnoreCase(ruleMap.get("logonName")))) {
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static String getOSVersionString(String sourceName) {
        String osVersion = "2k3";
        try {
            String windowsVersion;
            String localWinVer = System.getProperty("os.version");
            if (localWinVer.startsWith("6.")) {
                osVersion = "2k8r2";
            }
            if ((windowsVersion = DirectoryObjectAPI.getInstance().getObjectOsVersion(null, null, sourceName, "computer")) != null) {
                osVersion = CommonUtil.getOSVersion(windowsVersion);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return osVersion;
    }

    public static String getDomainName(String sourceName) {
        String domainName = "";
        try {
            Row row = DirectoryObjectAPI.getInstance().getComputerObjectRow("computer", null, sourceName, null);
            domainName = (String)row.get("DOMAIN_NAME");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainName;
    }

    static class EventFetchThread
    extends Thread {
        private boolean shutDown = false;
        private HashMap<String, String> map;
        private boolean flag;

        EventFetchThread(HashMap<String, String> workstationMap, boolean flag) {
            this.map = workstationMap;
            this.flag = flag;
        }

        @Override
        public void run() {
            try {
                if (this.flag) {
                    AccountLockoutHistory.getEventData(this.map);
                } else {
                    AccountLockoutHistory.getOwaActiveSyncEventData(this.map);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }
    }

    static class ProcessThread
    extends Thread {
        private boolean shutDown = false;

        ProcessThread() {
        }

        @Override
        public void run() {
            try {
                while (queue.size() > 0) {
                    for (int i = 0; i < queue.size(); ++i) {
                        Hashtable<String, Object> table = queue.remove();
                        AccountLockoutHistory.process(table);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void checkAndProcess() {
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

