/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutThread;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutUtil;
import com.adventnet.sym.adsm.auditing.server.accountLockout.ServerThreadPool;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Queue;

public class AccountLockoutListener {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    protected PrintWriter out = null;
    private ArrayList updateList = new ArrayList();
    public boolean isCompleted = true;

    public void startThread(String domainName, String workstation, String accountName, Queue<String> analyzeQueue, String sessionId, String uniqueId) {
        try {
            this.isCompleted = false;
            ServerThreadPool serverPool = ServerThreadPool.getInstance();
            serverPool.addSessionId(sessionId);
            AccountLockoutThread examineRunnable = new AccountLockoutThread(domainName, workstation, accountName, analyzeQueue, sessionId, uniqueId);
            serverPool.runTask(sessionId, examineRunnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void updateUI(String str, int len, int flag, int status) {
        if (this.out != null) {
            this.updateOutList();
            this.out.write("<script>updateUI(" + str + ", " + len + ", " + flag + ", " + status + ")</script>");
            this.out.flush();
        } else {
            this.updateList.add("<script>updateUI(" + str + ", " + len + ", " + flag + "," + status + ")</script>");
        }
    }

    public void controlUI(PrintWriter o) {
        this.out = o;
        while (!this.isCompleted) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.out = null;
    }

    protected synchronized void updateOutList() {
        if (this.updateList.size() > 0) {
            for (int i = 0; i < this.updateList.size(); ++i) {
                this.out.write((String)this.updateList.get(i));
                this.out.flush();
            }
            this.updateList.clear();
        }
    }

    public void clearList() {
        if (this.updateList.size() > 0) {
            this.updateList.clear();
        }
    }

    public void process(String domainName, String accountName, String workstation, String analyzeName, String sessionId) {
        try {
            HashMap resultMap = ADHandler.getComponentList(domainName, accountName, workstation, analyzeName);
            int component = (Integer)resultMap.get("component");
            AccountLockoutUtil.getInstance();
            HashMap map = AccountLockoutUtil.getUIString(domainName, resultMap, analyzeName);
            int len = (Integer)map.get("length");
            int status = (Integer)map.get("status");
            String resultString = (String)map.get("resultString");
            map.put("flag", component);
            this.updateUI(resultString, len, component, status);
            ArrayList preSelectedlist = AccountLockoutUtil.getInstance().preSelectedMap.get(sessionId);
            if (preSelectedlist == null) {
                preSelectedlist = new ArrayList();
            }
            preSelectedlist.add(map);
            AccountLockoutUtil.getInstance().preSelectedMap.put(sessionId, preSelectedlist);
            if (!resultMap.containsKey("errorMessage")) {
                resultMap.put("component", component);
                ArrayList list = AccountLockoutUtil.getInstance().dbMap.get(sessionId);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(resultMap);
                AccountLockoutUtil.getInstance().dbMap.put(sessionId, list);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

