/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutUtil;
import com.adventnet.sym.adsm.auditing.server.accountLockout.ServerThreadPool;
import java.util.Queue;

public class AccountLockoutThread
implements Runnable {
    private boolean shutDown = false;
    private boolean retShutDown = false;
    private String uniqueId = "";
    private String sessionId = "";
    private String domainName = "";
    private String workstation = "";
    private String accountName = "";
    private Queue<String> analyzeQueue = null;

    public AccountLockoutThread(String domainName, String workstation, String accountName, Queue<String> analyzeQueue, String sessionId, String uniqueId) {
        this.domainName = domainName;
        this.workstation = workstation;
        this.accountName = accountName;
        this.analyzeQueue = analyzeQueue;
        this.uniqueId = uniqueId;
        this.sessionId = sessionId;
    }

    @Override
    public void run() {
        try {
            for (int j = this.analyzeQueue.size(); j > 0; --j) {
                if (this.shutDown) {
                    AccountLockoutUtil.getInstance().getFromMap((String)this.sessionId).isCompleted = true;
                    AccountLockoutUtil.getInstance().getFromMap(this.sessionId).controlUI(null);
                    AccountLockoutUtil.getInstance().getFromMap(this.sessionId).clearList();
                    this.retShutDown = true;
                    break;
                }
                String analyzeName = this.analyzeQueue.remove();
                AccountLockoutUtil.getInstance().getFromMap(this.sessionId).process(this.domainName, this.accountName, this.workstation, analyzeName, this.sessionId);
            }
            if (!this.shutDown) {
                AccountLockoutUtil.getInstance().addInDB(this.domainName, this.sessionId, this.uniqueId);
            }
            AccountLockoutUtil.getInstance().getFromMap((String)this.sessionId).isCompleted = true;
            AccountLockoutUtil.getInstance().removeFromMap(this.sessionId);
            AccountLockoutUtil.getInstance().removeFromPreSelectedMap(this.sessionId);
            ServerThreadPool tPool = ServerThreadPool.getInstance();
            tPool.removeSessionId(this.sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutDown() {
        this.shutDown = true;
        while (!this.retShutDown) {
            this.waitForUpdate(1000L);
        }
    }

    public synchronized void waitForUpdate(long t) {
        try {
            super.wait(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

