/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutListener;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public final class AccountLockoutUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static AccountLockoutUtil accountLockoutUtil = null;
    public HashMap<String, AccountLockoutListener> listenerMap = null;
    public HashMap<String, ArrayList<HashMap>> dbMap = null;
    public HashMap<String, ArrayList<HashMap>> preSelectedMap = null;
    private static final String AUD_LOCKOUT_EXAMINER_TABLE = "AudLockoutExaminer";
    private static final String AUD_EXAMINER_DETAILS = "AudExaminerDetails";
    public static final Long[] COMPONENT_ID = new Long[]{DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:1"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:2"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:3"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:4"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:5"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:6"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:7"), DBObjectUtil.getUVHValues("AudLockoutExaminer", "AudLockoutExaminer:examiner_id:8")};
    public static final String[] COMPONENT_NAME = new String[]{"adap.audLockoutExaminer.windows_services", "adap.audLockoutExaminer.scheduled_tasks", "adap.audLockoutExaminer.network_drive_mappings", "adap.audLockoutExaminer.logon_sessions", "adap.audLockoutExaminer.com_objects", "adap.audLockoutExaminer.owa", "adap.audLockoutExaminer.active_sync", "adap.audLockoutExaminer.process_list"};

    private AccountLockoutUtil() {
        try {
            this.listenerMap = new HashMap();
            this.dbMap = new HashMap();
            this.preSelectedMap = new HashMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccountLockoutUtil getInstance() {
        if (accountLockoutUtil != null) return accountLockoutUtil;
        Class<AccountLockoutUtil> clazz = AccountLockoutUtil.class;
        synchronized (AccountLockoutUtil.class) {
            accountLockoutUtil = new AccountLockoutUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return accountLockoutUtil;
        }
    }

    public static HashMap getUIString(String domainName, HashMap map, String examineName) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        StringBuffer buff = null;
        try {
            int len = 1;
            if (!map.containsKey("errorMessage")) {
                ArrayList list = (ArrayList)map.get("result");
                if (!list.isEmpty()) {
                    len = list.size();
                    if (examineName.equalsIgnoreCase("logonSession") || examineName.equalsIgnoreCase("comObject")) {
                        buff = AccountLockoutUtil.getCOMLogonBufferString(list);
                    } else if (examineName.equalsIgnoreCase("networkMap")) {
                        map = AccountLockoutUtil.getMappedDriveUIMap(domainName, list, len);
                        buff = (StringBuffer)map.get("buff");
                        len = (Integer)map.get("len");
                    } else {
                        buff = AccountLockoutUtil.otherComponentBufferString(list);
                    }
                    buff.append("]");
                    retMap.put("status", 2);
                } else {
                    buff = AccountLockoutUtil.nothingBufferString();
                    retMap.put("status", 1);
                }
            } else {
                buff = AccountLockoutUtil.errorBufferString(map);
                retMap.put("status", 0);
            }
            retMap.put("length", len);
            retMap.put("resultString", buff.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retMap;
    }

    private static StringBuffer errorBufferString(HashMap map) {
        StringBuffer buff = new StringBuffer();
        try {
            String error = (String)map.get("errorMessage");
            error = error.toString().replaceAll("[^A-Za-z0-9- -:]", "");
            buff.append("['");
            buff.append(error);
            buff.append("']");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static StringBuffer nothingBufferString() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append("['");
            buff.append(rb.getString("adap.AccountLockoutUtil.Nothing_found"));
            buff.append("']");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static StringBuffer otherComponentBufferString(ArrayList list) {
        StringBuffer buff = null;
        try {
            for (Object val : list) {
                if (buff == null) {
                    buff = new StringBuffer();
                    buff.append("[");
                } else {
                    buff.append(",");
                }
                buff.append("'");
                buff.append(val.toString());
                buff.append("'");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static StringBuffer getCOMLogonBufferString(ArrayList list) {
        StringBuffer buff = null;
        try {
            for (Object tableObject : list) {
                Hashtable tableVal = (Hashtable)tableObject;
                if (buff == null) {
                    buff = new StringBuffer();
                    buff.append("[");
                } else {
                    buff.append(",");
                }
                buff.append("'");
                if (tableVal.containsKey("Caption")) {
                    String val = (String)tableVal.get("Caption");
                    buff.append(val);
                } else {
                    String clientName = (String)tableVal.get("ClientName");
                    String sessionType = (String)tableVal.get("SessionType");
                    buff.append(rb.getString("adap.AccountLockoutUtil.Logon_from"));
                    buff.append(":");
                    buff.append(sessionType);
                    buff.append(".");
                    if (clientName != null && !clientName.equalsIgnoreCase("")) {
                        buff.append(rb.getString("adap.AccountLockoutUtil.HostName"));
                        buff.append(" ");
                        buff.append(clientName);
                        buff.append(".");
                    }
                }
                buff.append("'");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static HashMap getMappedDriveUIMap(String domainName, ArrayList list, int len) {
        HashMap<String, Comparable<StringBuffer>> map = new HashMap<String, Comparable<StringBuffer>>();
        try {
            StringBuffer buff = null;
            for (Object tableObject : list) {
                Hashtable networkTable = (Hashtable)tableObject;
                ArrayList networkList = (ArrayList)networkTable.get("List");
                String objectGuid = (String)networkTable.get("ObjectGuid");
                Row objectRow = null;
                len = buff == null ? networkList.size() : (len += networkList.size());
                for (Hashtable hashTable : networkList) {
                    if (buff == null) {
                        buff = new StringBuffer();
                        buff.append("[");
                    } else {
                        buff.append(",");
                    }
                    String driveName = (String)hashTable.get("driveName");
                    String userName = (String)hashTable.get("userName");
                    if (objectRow == null && objectGuid != null && !objectGuid.equalsIgnoreCase("") && (objectRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, objectGuid, "SID_STRING", "user")) != null) {
                        objectGuid = (String)objectRow.get("SAM_ACCOUNT_NAME");
                    }
                    if (userName == null || userName.equalsIgnoreCase("")) {
                        userName = "-";
                    }
                    buff.append("'");
                    buff.append(driveName);
                    buff.append(":");
                    buff.append(";;;;");
                    buff.append(userName);
                    buff.append(";;;;");
                    buff.append(objectGuid);
                    buff.append("'");
                }
            }
            map.put("buff", buff);
            map.put("len", Integer.valueOf(len));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static String getWMIQuery(String domainName, String accountName) {
        StringBuffer buff = new StringBuffer();
        try {
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            domainName = (String)domainDetails.get("DOMAIN_NAME");
            String domainFlatName = (String)domainDetails.get("DOMAIN_FLAT_NAME");
            CommonUtil.appendString(new String[]{"Select * from Win32_DCOMApplicationSetting where RunAsUser ='", accountName, "' or ", " RunAsUser = '", domainName, "\\\\", accountName, "' or ", " RunAsUser = '", domainFlatName, "\\\\", accountName, "' or ", " RunAsUser = '", accountName, "@", domainName, "' or ", " RunAsUser = '", accountName, "@", domainFlatName, "'"}, buff);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toString();
    }

    public void addInMap(String sessionId, AccountLockoutListener listener) {
        try {
            this.listenerMap.put(sessionId, listener);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AccountLockoutListener getFromMap(String sessionId) {
        AccountLockoutListener listener = null;
        try {
            if (this.listenerMap.containsKey(sessionId)) {
                listener = this.listenerMap.get(sessionId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return listener;
    }

    public void removeFromMap(String sessionId) {
        try {
            if (this.listenerMap.containsKey(sessionId)) {
                this.listenerMap.remove(sessionId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void addInDB(String domainName, String sessionId, String uniqueId) {
        try {
            ArrayList<HashMap> list = this.dbMap.get(sessionId);
            if (list != null) {
                for (HashMap object : list) {
                    boolean add = true;
                    HashMap map = object;
                    int component = (Integer)map.get("component");
                    ArrayList listVal = (ArrayList)map.get("result");
                    Criteria criteria = new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"COMPONENT_ID"), (Object)COMPONENT_ID[component], 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"UNIQUE_ID"), (Object)Long.valueOf(uniqueId), 0));
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUD_EXAMINER_DETAILS, criteria);
                    if (!dataObject.isEmpty()) {
                        CommonUtil.getPersistence(new boolean[0]).delete(criteria);
                    }
                    for (Object listObject : listVal) {
                        HashMap<String, Object> rowMap = new HashMap<String, Object>();
                        rowMap.put("COMPONENT_ID", COMPONENT_ID[component]);
                        rowMap.put("UNIQUE_ID", Long.valueOf(uniqueId));
                        if (component == 3 || component == 4) {
                            this.setCOMLogonValues(rowMap, dataObject, listObject);
                            continue;
                        }
                        if (component == 2) {
                            this.setMapNetworkValues(rowMap, listObject, dataObject, domainName);
                            continue;
                        }
                        rowMap.put("RESULT", listObject.toString());
                        this.setRowValues(rowMap, dataObject);
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                }
            }
            this.dbMap.remove(sessionId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setCOMLogonValues(HashMap<String, Object> rowMap, DataObject dataObject, Object listObject) {
        try {
            Hashtable resultTable = (Hashtable)listObject;
            String val = null;
            if (resultTable.containsKey("Caption")) {
                val = (String)resultTable.get("Caption");
            } else {
                val = (String)resultTable.get("SessionType");
                String clientName = (String)resultTable.get("ClientName");
                if (clientName != null && !clientName.equalsIgnoreCase("")) {
                    rowMap.put("HOSTNAME", clientName);
                }
            }
            rowMap.put("RESULT", val);
            this.setRowValues(rowMap, dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMapNetworkValues(HashMap<String, Object> rowMap, Object listObject, DataObject dataObject, String domainName) {
        try {
            Hashtable networkTable = (Hashtable)listObject;
            ArrayList networkList = (ArrayList)networkTable.get("List");
            String objectGuid = (String)networkTable.get("ObjectGuid");
            Row objectRow = null;
            for (Hashtable hashTable : networkList) {
                String driveName = (String)hashTable.get("driveName");
                String userName = (String)hashTable.get("userName");
                if (userName != null && !userName.equalsIgnoreCase("")) {
                    rowMap.put("LOCKOUT_USER_NAME", userName);
                }
                if (objectRow == null && objectGuid != null && !objectGuid.equalsIgnoreCase("") && (objectRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, objectGuid, "SID_STRING", "user")) != null) {
                    objectGuid = (String)objectRow.get("SAM_ACCOUNT_NAME");
                }
                rowMap.put("ACCOUNT_NAME", objectGuid);
                rowMap.put("RESULT", driveName);
                this.setRowValues(rowMap, dataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setRowValues(HashMap<String, Object> map, DataObject dataObject) {
        try {
            Row row = new Row(AUD_EXAMINER_DETAILS);
            Set<String> keySet = map.keySet();
            for (String object : keySet) {
                row.set(object, map.get(object));
            }
            dataObject.addRow(row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap getFromDB(String uniqueId) {
        HashMap map = new HashMap();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)AUD_EXAMINER_DETAILS));
            Criteria criteria = new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"UNIQUE_ID"), (Object)Long.valueOf(uniqueId), 0);
            selectQuery.addSelectColumn(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"*"));
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            int i = 0;
            if (!dataObject.isEmpty()) {
                for (Long componentId : COMPONENT_ID) {
                    criteria = new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"COMPONENT_ID"), (Object)componentId, 0);
                    ArrayList<String> list = new ArrayList<String>();
                    Iterator detailsItr = dataObject.getRows(AUD_EXAMINER_DETAILS, criteria);
                    while (detailsItr.hasNext()) {
                        Row detailsRow = (Row)detailsItr.next();
                        String result = detailsRow.get("RESULT").toString();
                        StringBuffer buff = new StringBuffer();
                        if (componentId.equals(COMPONENT_ID[2])) {
                            String userName = (String)detailsRow.get("LOCKOUT_USER_NAME");
                            String accountName = (String)detailsRow.get("ACCOUNT_NAME");
                            if (userName == null) {
                                userName = "-";
                            }
                            if (accountName == null) {
                                accountName = "-";
                            }
                            buff.append("<td>");
                            buff.append(result);
                            buff.append(":");
                            buff.append("</td>");
                            buff.append("<td>");
                            buff.append(userName);
                            buff.append("</td>");
                            buff.append("<td>");
                            buff.append(accountName);
                            buff.append("</td>");
                        } else if (componentId.equals(COMPONENT_ID[3])) {
                            buff.append(rb.getString("adap.AccountLockoutUtil.Logon_from"));
                            buff.append(":");
                            buff.append(result);
                            buff.append(".");
                            String clientName = (String)detailsRow.get("HOSTNAME");
                            if (clientName != null && !clientName.equalsIgnoreCase("")) {
                                buff.append(rb.getString("adap.AccountLockoutUtil.HostName"));
                                buff.append(" ");
                                buff.append(clientName);
                                buff.append(".");
                            }
                        } else {
                            buff.append(result);
                        }
                        list.add(buff.toString());
                    }
                    map.put(COMPONENT_NAME[i], list);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public void removeFromPreSelectedMap(String sessionId) {
        try {
            if (this.preSelectedMap.containsKey(sessionId)) {
                this.preSelectedMap.remove(sessionId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<HashMap> getPreSelectedList(String sessionId) {
        ArrayList<HashMap> list = null;
        try {
            if (this.preSelectedMap.containsKey(sessionId)) {
                list = this.preSelectedMap.get(sessionId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public HashMap<String, String> getFromDBEmber(String uniqueId) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)AUD_EXAMINER_DETAILS));
            Criteria criteria = new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"UNIQUE_ID"), (Object)Long.valueOf(uniqueId), 0);
            selectQuery.addSelectColumn(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"*"));
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            int i = 0;
            if (!dataObject.isEmpty()) {
                for (Long componentId : COMPONENT_ID) {
                    criteria = new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"COMPONENT_ID"), (Object)componentId, 0);
                    ArrayList<String> list = new ArrayList<String>();
                    String columnValue = "";
                    StringBuffer buff = new StringBuffer();
                    Iterator detailsItr = dataObject.getRows(AUD_EXAMINER_DETAILS, criteria);
                    while (detailsItr.hasNext()) {
                        Row detailsRow = (Row)detailsItr.next();
                        String result = detailsRow.get("RESULT").toString();
                        if (componentId.equals(COMPONENT_ID[2])) {
                            if (buff.length() == 0) {
                                buff.append("<div class=\"mini-well\">");
                                buff.append("<table class=\"mini-table\">");
                                buff.append("<thead>");
                                buff.append("<th>Mapped Drive</th>");
                                buff.append("<th>Mapped Using Credential</th>");
                                buff.append("<th>Under User Profile</th>");
                                buff.append("</thead>");
                                buff.append("<tbody>");
                            }
                            String userName = (String)detailsRow.get("LOCKOUT_USER_NAME");
                            String accountName = (String)detailsRow.get("ACCOUNT_NAME");
                            if (userName == null) {
                                userName = "-";
                            }
                            if (accountName == null) {
                                accountName = "-";
                            }
                            buff.append("<tr>");
                            buff.append("<td>");
                            buff.append(result);
                            buff.append(":");
                            buff.append("</td>");
                            buff.append("<td>");
                            buff.append(userName);
                            buff.append("</td>");
                            buff.append("<td>");
                            buff.append(accountName);
                            buff.append("</td>");
                            buff.append("<tr>");
                        } else if (componentId.equals(COMPONENT_ID[3])) {
                            if (buff.length() == 0) {
                                buff.append("<div class=\"well-default\">");
                                buff.append("<table>");
                            }
                            buff.append("<tr>");
                            buff.append("<td>");
                            buff.append("<span class=\"label label-default\"><span class=\"text-default\">");
                            buff.append(rb.getString("adap.AccountLockoutUtil.Logon_from"));
                            buff.append(":");
                            buff.append(result);
                            buff.append(".");
                            String clientName = (String)detailsRow.get("HOSTNAME");
                            if (clientName != null && !clientName.equalsIgnoreCase("")) {
                                buff.append(rb.getString("adap.AccountLockoutUtil.HostName"));
                                buff.append(" ");
                                buff.append(clientName);
                                buff.append(".");
                            }
                            buff.append("</span></span>");
                            buff.append("</td>");
                            buff.append("</tr>");
                        } else {
                            if (buff.length() == 0) {
                                buff.append("<div class=\"well-default\">");
                                buff.append("<table>");
                            }
                            buff.append("<tr>");
                            buff.append("<td>");
                            buff.append("<span class=\"label label-default\"><span class=\"text-default\">");
                            buff.append(result);
                            buff.append("</span></span>");
                            buff.append("</td>");
                            buff.append("</tr>");
                        }
                        list.add(buff.toString());
                    }
                    if (list.isEmpty()) {
                        columnValue = "<span class=\"label label-default\"><span class=\"text-success\">Nothing found...</span></span>";
                        map.put(COMPONENT_NAME[i], columnValue);
                    } else {
                        if (componentId.equals(COMPONENT_ID[3])) {
                            if (buff.length() > 0) {
                                buff.append("</table>");
                                buff.append("</div>");
                            }
                        } else if (componentId.equals(COMPONENT_ID[2])) {
                            if (buff.length() > 0) {
                                buff.append("</tbody>");
                                buff.append("</table>");
                                buff.append("</div>");
                            }
                        } else if (buff.length() > 0) {
                            buff.append("</tbody>");
                            buff.append("</table>");
                            buff.append("</div>");
                        }
                        map.put(COMPONENT_NAME[i], buff.toString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public void addInDBEmber(HashMap map, String domainName, String uniqueId) {
        try {
            boolean add = true;
            int component = (Integer)map.get("component");
            ArrayList listVal = (ArrayList)map.get("result");
            Criteria criteria = new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"COMPONENT_ID"), (Object)COMPONENT_ID[component], 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)AUD_EXAMINER_DETAILS, (String)"UNIQUE_ID"), (Object)Long.valueOf(uniqueId), 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUD_EXAMINER_DETAILS, criteria);
            if (!dataObject.isEmpty()) {
                CommonUtil.getPersistence(new boolean[0]).delete(criteria);
            }
            for (Object listObject : listVal) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("COMPONENT_ID", COMPONENT_ID[component]);
                rowMap.put("UNIQUE_ID", Long.valueOf(uniqueId));
                if (component == 3 || component == 4) {
                    this.setCOMLogonValues(rowMap, dataObject, listObject);
                    continue;
                }
                if (component == 2) {
                    this.setMapNetworkValues(rowMap, listObject, dataObject, domainName);
                    continue;
                }
                rowMap.put("RESULT", listObject.toString().replaceAll("=", " : "));
                this.setRowValues(rowMap, dataObject);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap getUIStringEmber(String domainName, HashMap map, String examineName) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        StringBuffer buff = null;
        try {
            int len = 1;
            if (!map.containsKey("errorMessage")) {
                ArrayList list = (ArrayList)map.get("result");
                if (!list.isEmpty()) {
                    len = list.size();
                    if (examineName.equalsIgnoreCase("logonSession") || examineName.equalsIgnoreCase("comObject")) {
                        buff = AccountLockoutUtil.getCOMLogonBufferStringEmber(list);
                    } else if (examineName.equalsIgnoreCase("networkMap")) {
                        map = AccountLockoutUtil.getMappedDriveUIMapEmber(domainName, list, len);
                        buff = (StringBuffer)map.get("buff");
                        len = (Integer)map.get("len");
                    } else {
                        buff = AccountLockoutUtil.otherComponentBufferStringEmber(list);
                    }
                    retMap.put("status", 2);
                } else {
                    buff = AccountLockoutUtil.nothingBufferStringEmber();
                    retMap.put("status", 1);
                }
            } else {
                buff = AccountLockoutUtil.errorBufferStringEmber(map);
                retMap.put("status", 0);
            }
            retMap.put("length", len);
            retMap.put("resultString", buff.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retMap;
    }

    private static HashMap getMappedDriveUIMapEmber(String domainName, ArrayList list, int len) {
        HashMap<String, Comparable<StringBuffer>> map = new HashMap<String, Comparable<StringBuffer>>();
        try {
            StringBuffer buff = null;
            for (Object tableObject : list) {
                Hashtable networkTable = (Hashtable)tableObject;
                ArrayList networkList = (ArrayList)networkTable.get("List");
                String objectGuid = (String)networkTable.get("ObjectGuid");
                Row objectRow = null;
                len = buff == null ? networkList.size() : (len += networkList.size());
                for (Hashtable hashTable : networkList) {
                    if (buff == null) {
                        buff = new StringBuffer();
                        buff.append("<div class=\"mini-well\">");
                        buff.append("<table class=\"mini-table\">");
                        buff.append("<thead>");
                        buff.append("<th>Mapped Drive</th>");
                        buff.append("<th>Mapped Using Credential</th>");
                        buff.append("<th>Under User Profile</th>");
                        buff.append("</thead>");
                        buff.append("<tbody>");
                    }
                    String driveName = (String)hashTable.get("driveName");
                    String userName = (String)hashTable.get("userName");
                    if (objectRow == null && objectGuid != null && !objectGuid.equalsIgnoreCase("") && (objectRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, objectGuid, "SID_STRING", "user")) != null) {
                        objectGuid = (String)objectRow.get("SAM_ACCOUNT_NAME");
                    }
                    if (userName == null || userName.equalsIgnoreCase("")) {
                        userName = "-";
                    }
                    buff.append("<tr>");
                    buff.append("<td>");
                    buff.append(driveName);
                    buff.append(":");
                    buff.append("</td>");
                    buff.append("<td>");
                    buff.append(userName);
                    buff.append("</td>");
                    buff.append("<td>");
                    buff.append(objectGuid);
                    buff.append("</td>");
                    buff.append("</tr>");
                }
            }
            if (buff.length() > 0) {
                buff.append("</tbody>");
                buff.append("</table>");
                buff.append("</div>");
            }
            map.put("buff", buff);
            map.put("len", Integer.valueOf(len));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    private static StringBuffer getCOMLogonBufferStringEmber(ArrayList list) {
        StringBuffer buff = null;
        try {
            for (Object tableObject : list) {
                Hashtable tableVal = (Hashtable)tableObject;
                if (buff == null) {
                    buff = new StringBuffer();
                    buff.append("<div class=\"well-default\">");
                    buff.append("<table>");
                }
                buff.append("<tr>");
                buff.append("<td>");
                buff.append("<span class=\"label label-default\"><span class=\"text-default\">");
                if (tableVal.containsKey("Caption")) {
                    String val = (String)tableVal.get("Caption");
                    buff.append(val);
                } else {
                    String clientName = (String)tableVal.get("ClientName");
                    String sessionType = (String)tableVal.get("SessionType");
                    buff.append(rb.getString("adap.AccountLockoutUtil.Logon_from"));
                    buff.append(":");
                    buff.append(sessionType);
                    buff.append(".");
                    if (clientName != null && !clientName.equalsIgnoreCase("")) {
                        buff.append(rb.getString("adap.AccountLockoutUtil.HostName"));
                        buff.append(" ");
                        buff.append(clientName);
                        buff.append(".");
                    }
                }
                buff.append("</span></span>");
                buff.append("</td>");
                buff.append("</tr>");
            }
            if (buff.length() > 0) {
                buff.append("</table>");
                buff.append("</div>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static StringBuffer otherComponentBufferStringEmber(ArrayList list) {
        StringBuffer buff = null;
        try {
            for (Object val : list) {
                if (buff == null) {
                    buff = new StringBuffer();
                    buff.append("<div class=\"well-default\">");
                    buff.append("<table>");
                }
                buff.append("<tr>");
                buff.append("<td>");
                buff.append("<span class=\"label label-default\"><span class=\"text-default\">");
                buff.append(val.toString().replaceAll("=", " : "));
                buff.append("</span></span>");
                buff.append("</td>");
                buff.append("</tr>");
            }
            if (buff.length() > 0) {
                buff.append("</tbody>");
                buff.append("</table>");
                buff.append("</div>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static StringBuffer nothingBufferStringEmber() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append("<span class=\"label label-default\"><span class=\"text-success\">Nothing found...</span></span>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }

    private static StringBuffer errorBufferStringEmber(HashMap map) {
        StringBuffer buff = new StringBuffer();
        try {
            String error = (String)map.get("errorMessage");
            error = error.toString().replaceAll("[^A-Za-z0-9- -:]", "");
            buff.append("<span class=\"label label-default\"><span class=\"text-danger\">");
            buff.append(error);
            buff.append("</span></span>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff;
    }
}

