/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IISHandler {
    private static Logger logger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static HashMap defaultIISConfig = new HashMap();

    private static void setDefaultIISConfig() {
        Criteria c = null;
        try {
            DataObject iisDefault = CommonUtil.getPersistence(new boolean[0]).get("IISDefaultConfiguration", c);
            HashMap defaultConfig = new HashMap();
            Iterator iterator = iisDefault.getRows("IISDefaultConfiguration");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                defaultIISConfig.put(row.get("FIELD_NAME"), row.get("FIELD_VALUE"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static void checkAndGetIISDetails(HashMap<String, String> map) throws Exception {
        String serverName = map.get("workstation");
        String domainName = map.get("domainName");
        Boolean isConfigured = false;
        String iisLogPath = null;
        String period = null;
        String utf = null;
        Criteria crit = new Criteria(Column.getColumn((String)"IISServer", (String)"SERVER_NAME"), (Object)serverName, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"IISServer", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DataObject iisDO = CommonUtil.getPersistence(new boolean[0]).get("IISServer", crit);
        if (!iisDO.isEmpty()) {
            Row iisRow = iisDO.getRow("IISServer");
            isConfigured = (Boolean)iisRow.get("IS_CONFIGURED");
            iisLogPath = (String)iisRow.get("UPDATED_IIS_LOG_PATH");
            period = ((Integer)iisRow.get("PERIOD")).toString();
            if (iisRow.get("LOG_IN_UTF8") != null) {
                utf = ((Integer)iisRow.get("LOG_IN_UTF8")).toString();
            }
        }
        if (iisDO.isEmpty() || map.containsKey("sync")) {
            Properties loggingProps = IISHandler.getIISDetails(serverName, domainName, false);
            if (loggingProps.containsKey("errorMessage")) {
                map.put("err", (String)loggingProps.get("errorMessage"));
                map.put("errorConfigure", "true");
                map.put("toBeConfigured", "true");
                return;
            }
            isConfigured = (Boolean)loggingProps.get("isConfigured");
            IISHandler.AddorUpdateIISRow(loggingProps, domainName, serverName);
            if (isConfigured.booleanValue()) {
                iisLogPath = (String)loggingProps.get("logPath");
                period = (String)loggingProps.get("LogFilePeriod");
                utf = (String)loggingProps.get("LogInUTF8");
            }
        }
        if (isConfigured.booleanValue()) {
            map.put("serverDirPath", iisLogPath);
            if (period != null) {
                map.put("period", period);
            } else {
                map.put("period", "1");
            }
            if (utf != null && utf != "0") {
                map.put("utf", "false");
            } else {
                map.put("utf", "true");
            }
        } else {
            map.put("err", rb.getString("adap.errorMessage.Required_IIS_Configuration_not_set"));
            map.put("toBeConfigured", "true");
        }
    }

    public static void AddorUpdateIISRow(Properties loggingProps, String domainName, String serverName) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"IISServer", (String)"SERVER_NAME"), (Object)serverName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"IISServer", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject iisDO = CommonUtil.getPersistence(new boolean[0]).get("IISServer", crit);
            Row iisRow = iisDO.getRow("IISServer");
            boolean newRow = false;
            if (iisRow == null) {
                newRow = true;
                iisRow = new Row("IISServer");
                iisRow.set("SERVER_NAME", (Object)serverName);
                iisRow.set("DOMAIN_NAME", (Object)domainName);
            }
            iisRow.set("LOG_TYPE", (Object)Long.parseLong(loggingProps.get("LogType").toString()));
            iisRow.set("DONT_LOG", (Object)Long.parseLong(loggingProps.get("dontLog").toString()));
            iisRow.set("LOG_FIELD_FLAG", (Object)Long.parseLong(loggingProps.get("LogExtFileFlags").toString()));
            iisRow.set("IS_CONFIGURED", (Object)Boolean.parseBoolean(loggingProps.get("isConfigured").toString()));
            iisRow.set("FILE_PER_SITE", (Object)Boolean.parseBoolean(loggingProps.get("file_per_site").toString()));
            iisRow.set("LOG_PLUGIN_CLSID", (Object)loggingProps.get("LogPluginClsid").toString());
            if (loggingProps.containsKey("LogInUTF8")) {
                iisRow.set("LOG_IN_UTF8", loggingProps.get("LogInUTF8"));
            }
            if (loggingProps.containsKey("LogFilePeriod")) {
                iisRow.set("PERIOD", (Object)((String)loggingProps.get("LogFilePeriod")));
            }
            if (loggingProps.containsKey("LogFileLocaltimeRollover")) {
                iisRow.set("ROLLOVER_TIME", (Object)((String)loggingProps.get("LogFileLocaltimeRollover")));
            }
            if (loggingProps.get("LogFileDirectory") != null) {
                String virtualDirectoryMetaBasePath = (String)loggingProps.get("virtualMetabasePath");
                String directory = loggingProps.get("LogFileDirectory") + "\\W3SVC";
                directory = directory + loggingProps.get("directoryNumber");
                iisRow.set("UPDATED_IIS_LOG_PATH", (Object)directory);
                loggingProps.put("logPath", directory);
            }
            iisRow.set("VIRTUAL_METABASE_PATH", (Object)((String)loggingProps.get("virtualMetabasePath")));
            iisRow.set("METABASE_PATH", (Object)((String)loggingProps.get("metabasePath")));
            if (newRow) {
                iisDO.addRow(iisRow);
            } else {
                iisDO.updateRow(iisRow);
            }
            CommonUtil.getPersistence(new boolean[0]).update(iisDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void configureIIS(String server, String domainName, HashMap map) throws Exception {
        String defaultLogFormat;
        String logFormat;
        int rollOverTime;
        int logFlags;
        int dontLog;
        Integer value;
        Criteria crit = new Criteria(Column.getColumn((String)"IISServer", (String)"SERVER_NAME"), (Object)server, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"IISServer", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DataObject iisDO = CommonUtil.getPersistence(new boolean[0]).get("IISServer", crit);
        Row iisRow = iisDO.getRow("IISServer");
        Properties domainCredentials = DomainHandler.getConfiguredValues(domainName, 1L);
        boolean flag = true;
        NativeError ne = new NativeError();
        String err = null;
        int logType = (Integer)iisRow.get("LOG_TYPE");
        if ((logType & (value = Integer.valueOf(Integer.parseInt((String)defaultIISConfig.get("LogType"))))) != value) {
            flag = false;
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("LogType");
            ADHandler.setLogProperty((String)iisRow.get("VIRTUAL_METABASE_PATH"), domainCredentials, attributeList, value.toString(), ne);
            if (ne.getErrorMessage(domainName) != null) {
                map.put("errorConfigure", true);
                err = ne.getErrorMessage(domainName);
                logger.log(Level.INFO, ne.getErrorMessage(domainName));
            } else {
                iisRow.set("LOG_TYPE", (Object)value);
                flag = true;
            }
        }
        if ((dontLog = ((Integer)iisRow.get("DONT_LOG")).intValue()) != (value = Integer.valueOf(Integer.parseInt((String)defaultIISConfig.get("dontLog"))))) {
            flag = false;
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("dontLog");
            ADHandler.setLogProperty((String)iisRow.get("VIRTUAL_METABASE_PATH"), domainCredentials, attributeList, value.toString(), ne);
            if (ne.getErrorMessage(domainName) != null) {
                map.put("errorConfigure", true);
                err = ne.getErrorMessage(domainName);
                logger.log(Level.INFO, ne.getErrorMessage(domainName));
            } else {
                iisRow.set("DONT_LOG", (Object)value);
                flag = true;
            }
        }
        if (((logFlags = ((Integer)iisRow.get("LOG_FIELD_FLAG")).intValue()) & (value = Integer.valueOf(Integer.parseInt(((String)defaultIISConfig.get("LogExtFileFlags")).substring(2), 16)))) != value) {
            flag = false;
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("LogExtFileFlags");
            ADHandler.setLogProperty((String)iisRow.get("VIRTUAL_METABASE_PATH"), domainCredentials, attributeList, value.toString(), ne);
            if (ne.getErrorMessage(domainName) != null) {
                err = ne.getErrorMessage(domainName);
                map.put("errorConfigure", true);
                logger.log(Level.INFO, ne.getErrorMessage(domainName));
            } else {
                iisRow.set("LOG_FIELD_FLAG", (Object)value);
                flag = true;
            }
        }
        if (iisRow.get("ROLLOVER_TIME") != null && (rollOverTime = ((Integer)iisRow.get("ROLLOVER_TIME")).intValue()) != (value = Integer.valueOf(Integer.parseInt((String)defaultIISConfig.get("LogFileLocaltimeRollover"))))) {
            flag = false;
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("LogFileLocaltimeRollover");
            ADHandler.setLogProperty((String)iisRow.get("VIRTUAL_METABASE_PATH"), domainCredentials, attributeList, value.toString(), ne);
            if (ne.getErrorMessage(domainName) != null) {
                map.put("errorConfigure", true);
                err = ne.getErrorMessage(domainName);
                logger.log(Level.INFO, ne.getErrorMessage(domainName));
            } else {
                iisRow.set("ROLLOVER_TIME", (Object)value);
                flag = true;
            }
        }
        if (!(logFormat = (String)iisRow.get("LOG_PLUGIN_CLSID")).equalsIgnoreCase(defaultLogFormat = (String)defaultIISConfig.get("LogModuleId"))) {
            flag = false;
            if (err == null) {
                err = rb.getString("adap.errorMessage.Set_log_format_manually");
                map.put("manualConfigure", "true");
            }
        }
        if (!((Boolean)iisRow.get("FILE_PER_SITE")).booleanValue()) {
            flag = false;
            if (err == null) {
                err = rb.getString("adap.errorMessage.Set_Create_log_file_per_site_manually");
                map.put("manualConfigure", "true");
            } else if (map.containsKey("manualConfigure")) {
                err = err + " , " + rb.getString("adap.errorMessage.Set_Create_log_file_per_site_manually");
            }
        }
        if (flag) {
            iisRow.set("IS_CONFIGURED", (Object)flag);
        }
        iisDO.updateRow(iisRow);
        CommonUtil.getPersistence(new boolean[0]).update(iisDO);
        map.put("errorMessage", err);
        map.put("toBeConfigured", !flag);
    }

    private static void checkLoggingProps(Properties loggingProps, String domainName, Properties domainCredentials) {
        int rollOverTime;
        int logFlags;
        String logPluginClsid;
        int dontLog;
        int value;
        boolean flag = true;
        NativeError ne = new NativeError();
        int logType = Integer.parseInt(loggingProps.get("LogType").toString());
        if ((logType & (value = Integer.parseInt((String)defaultIISConfig.get("LogType")))) != value) {
            flag = false;
        }
        if ((dontLog = Integer.parseInt(loggingProps.get("dontLog").toString())) != (value = Integer.parseInt((String)defaultIISConfig.get("dontLog")))) {
            flag = false;
        }
        if (!(logPluginClsid = (String)loggingProps.get("LogPluginClsid")).equalsIgnoreCase(loggingProps.get("logModuleId").toString())) {
            flag = false;
        }
        if (((logFlags = Integer.parseInt(loggingProps.get("LogExtFileFlags").toString())) & (value = Integer.parseInt(((String)defaultIISConfig.get("LogExtFileFlags")).substring(2), 16))) != value) {
            flag = false;
        }
        if (loggingProps.containsKey("LogFileLocaltimeRollover") && (rollOverTime = Integer.parseInt(loggingProps.get("LogFileLocaltimeRollover").toString())) != (value = Integer.parseInt((String)defaultIISConfig.get("LogFileLocaltimeRollover")))) {
            flag = false;
        }
        loggingProps.put("isConfigured", (Object)flag);
    }

    private static HashMap<String, String> getServerProps(String serverName, String domainName) throws DataAccessException {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMExchangeServerDetails", (String)"NAME"), (Object)serverName, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"ADSMExchangeServerDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMExchangeServerDetails", crit);
        Row r = obj.getRow("ADSMExchangeServerDetails");
        HashMap<String, String> serverProps = new HashMap<String, String>();
        serverProps.put("SERVER_NAME", (String)r.get("NAME"));
        serverProps.put("SERVER_DN", (String)r.get("DISTINGUISHED_NAME"));
        String version = (String)r.get("SERIAL_NUMBER");
        if (version.lastIndexOf("(Build") != -1) {
            version = version.substring(0, version.lastIndexOf("(Build"));
        }
        version = version.replaceAll("[^\\d.]", "");
        serverProps.put("SERVER_VERSION", version);
        return serverProps;
    }

    public static Properties getIISDetails(String serverName, String domainName, boolean mod) throws Exception {
        logger.log(Level.INFO, "Entering getIISDetails");
        Properties loggingProps = new Properties();
        String logModuleId = null;
        try {
            Properties domainCredentials = DomainHandler.getConfiguredValues(domainName, 1L);
            ArrayList<String> attributeList = new ArrayList<String>();
            HashMap<Object, Object> serverProps = new HashMap();
            serverProps = IISHandler.getServerProps(serverName, domainName);
            Properties pathProps = IISHandler.getIISMetabasePath((String)serverProps.get("SERVER_VERSION"), (String)serverProps.get("SERVER_DN"), (String)serverProps.get("SERVER_NAME"), domainCredentials);
            if (pathProps.containsKey("errorMessage")) {
                loggingProps.put("errorMessage", pathProps.get("errorMessage"));
                return loggingProps;
            }
            String virtualMetabasePath = (String)pathProps.get("virtualMetabasePath");
            logModuleId = (String)defaultIISConfig.get("LogModuleId");
            if (logModuleId.equalsIgnoreCase("0") || mod) {
                attributeList.add("LogModuleId");
                loggingProps = IISHandler.getIISLoggingProps(virtualMetabasePath.substring(0, virtualMetabasePath.lastIndexOf("/W3SVC")) + "/Logging/W3C Extended Log File Format", domainCredentials, attributeList);
                if (loggingProps.containsKey("errorMessage")) {
                    return loggingProps;
                }
                if (loggingProps.containsKey("LogModuleId")) {
                    logModuleId = (String)loggingProps.get("LogModuleId");
                    Criteria c = new Criteria(Column.getColumn((String)"IISDefaultConfiguration", (String)"FIELD_NAME"), (Object)"LogModuleId", 0);
                    DataObject d = CommonUtil.getPersistence(new boolean[0]).get("IISDefaultConfiguration", c);
                    Row r = d.getFirstRow("IISDefaultConfiguration");
                    r.set("FIELD_VALUE", (Object)logModuleId);
                    d.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(d);
                    defaultIISConfig.put("LogModuleId", logModuleId);
                }
            }
            boolean filePerSite = false;
            attributeList = new ArrayList<String>(Arrays.asList("CentralW3CLoggingEnabled", "CentralBinaryLoggingEnabled"));
            loggingProps = IISHandler.getIISLoggingProps((String)pathProps.get("CentralMetabasePath"), domainCredentials, attributeList);
            if (loggingProps.containsKey("errorMessage")) {
                return loggingProps;
            }
            int w3c = Integer.parseInt((String)defaultIISConfig.get("CentralW3CLoggingEnabled"));
            int binary = Integer.parseInt((String)defaultIISConfig.get("CentralBinaryLoggingEnabled"));
            if (!(loggingProps.containsKey("CentralW3CLoggingEnabled") && Integer.parseInt((String)loggingProps.get("CentralW3CLoggingEnabled")) != w3c || loggingProps.containsKey("CentralBinaryLoggingEnabled") && Integer.parseInt((String)loggingProps.get("CentralBinaryLoggingEnabled")) != binary)) {
                filePerSite = true;
            }
            attributeList = new ArrayList<String>(Arrays.asList("LogFileDirectory", "LogExtFileFlags", "LogType", "dontLog", "LogFileLocaltimeRollover", "LogFilePeriod", "centralLogFileMode", "LogInUTF8", "LogPluginClsid"));
            loggingProps = IISHandler.getIISLoggingProps((String)pathProps.get("virtualMetabasePath"), domainCredentials, attributeList);
            if (loggingProps.containsKey("errorMessage")) {
                return loggingProps;
            }
            loggingProps.put("logModuleId", logModuleId);
            IISHandler.checkLoggingProps(loggingProps, domainName, domainCredentials);
            loggingProps.put("file_per_site", (Object)filePerSite);
            loggingProps.put("virtualMetabasePath", (String)pathProps.get("virtualMetabasePath"));
            loggingProps.put("metabasePath", (String)pathProps.get("metabasePath"));
            loggingProps.put("directoryNumber", (String)pathProps.get("virtualDirectoryNo"));
            if (!filePerSite) {
                loggingProps.put("isConfigured", (Object)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        logger.log(Level.INFO, "Leaving getIISDetails");
        return loggingProps;
    }

    public static Properties getIISMetabasePath(String serverVersion, String serverDN, String serverName, Properties domainCredentials) throws Exception {
        String domainName;
        String searchString;
        NativeError ne = new NativeError();
        String metabasePath = null;
        String virtualDirectoryMetaBasePath = null;
        Properties pathProps = new Properties();
        if (serverVersion.startsWith("8.") || serverVersion.startsWith("14.")) {
            searchString = "(&(objectClass=msExchOWAVirtualDirectory)(cn=owa*))";
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("msExchMetabasePath");
            metabasePath = ADHandler.getOWAMetabasePath(serverDN, domainCredentials, attributes, searchString, ne);
            if (metabasePath != null) {
                virtualDirectoryMetaBasePath = metabasePath.substring(0, metabasePath.indexOf(serverName) + serverName.length()) + metabasePath.substring(metabasePath.indexOf("/W3SVC/"));
                virtualDirectoryMetaBasePath = virtualDirectoryMetaBasePath.substring(0, virtualDirectoryMetaBasePath.toLowerCase().lastIndexOf("/root"));
            }
        } else if (serverVersion.startsWith("15.")) {
            searchString = "(&(objectClass=msExchOWAVirtualDirectory)(cn=owa (Default Web Site)))";
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("msExchMetabasePath");
            metabasePath = ADHandler.getOWAMetabasePath(serverDN, domainCredentials, attributes, searchString, ne);
            if (metabasePath != null) {
                virtualDirectoryMetaBasePath = metabasePath.substring(0, metabasePath.indexOf(serverName) + serverName.length()) + metabasePath.substring(metabasePath.indexOf("/W3SVC/"));
                virtualDirectoryMetaBasePath = virtualDirectoryMetaBasePath.substring(0, virtualDirectoryMetaBasePath.toLowerCase().lastIndexOf("/root"));
            }
        } else {
            searchString = "(&(objectClass=msExchProtocolCfgHTTPVirtualDirectory)(cn=Exchange))";
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("distinguishedName");
            String directoryDN = ADHandler.getOWAMetabasePath(serverDN, domainCredentials, attributes, searchString, ne);
            if (directoryDN != null) {
                virtualDirectoryMetaBasePath = IISHandler.convertDNToVirtualMetabasePath(directoryDN, serverName);
                metabasePath = IISHandler.convertToMetabasePath(virtualDirectoryMetaBasePath);
            }
        }
        if (virtualDirectoryMetaBasePath != null) {
            pathProps.put("metabasePath", metabasePath);
            pathProps.put("virtualMetabasePath", virtualDirectoryMetaBasePath);
            String centralMetabasePath = virtualDirectoryMetaBasePath.substring(0, virtualDirectoryMetaBasePath.lastIndexOf("W3SVC/") + 5);
            pathProps.put("CentralMetabasePath", centralMetabasePath);
            pathProps.put("virtualDirectoryNo", virtualDirectoryMetaBasePath.substring(virtualDirectoryMetaBasePath.lastIndexOf("W3SVC/") + 6));
        }
        if (ne.getErrorMessage(domainName = (String)domainCredentials.get("DOMAIN_NAME")) != null) {
            pathProps.put("errorMessage", ne.getErrorMessage(domainName));
        }
        return pathProps;
    }

    private static String convertDNToVirtualMetabasePath(String directoryDN, String serverName) {
        String subDN = directoryDN.substring(0, directoryDN.indexOf(",CN=HTTP"));
        String virtualDirectoryNo = subDN.substring(subDN.lastIndexOf("=") + 1, subDN.length());
        String virtualDirectoryMetaBasePath = "IIS://" + serverName + "/w3svc/" + virtualDirectoryNo;
        return virtualDirectoryMetaBasePath;
    }

    private static String convertToMetabasePath(String virtualDirectoryMetaBasePath) {
        String metaBasePath = virtualDirectoryMetaBasePath + "/root/Exchange";
        return metaBasePath;
    }

    public static Properties getIISLoggingProps(String virtualDirectoryMetaBasePath, Properties domainCredentials, ArrayList attributeList) throws Exception {
        logger.log(Level.INFO, "Entering getIISLoggingProps");
        NativeError ne = new NativeError();
        Properties loggingProps = ADHandler.getOWALoggingInfo(virtualDirectoryMetaBasePath, domainCredentials, attributeList, ne);
        String domainName = (String)domainCredentials.get("DOMAIN_NAME");
        if (ne.getErrorMessage(domainName) != null) {
            loggingProps.put("errorMessage", ne.getErrorMessage(domainName));
        }
        logger.log(Level.INFO, "Leaving getIISLoggingProps");
        return loggingProps;
    }

    static {
        IISHandler.setDefaultIISConfig();
    }
}

