/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.sym.adsm.auditing.server.accountLockout.LogUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCopyThread
implements Runnable {
    private static Logger logger = Logger.getLogger("ReportLogger");
    public ArrayList<HashMap<Object, Object>> copiedLogFiles;
    private String timestamp;
    private String userName;
    private String password;
    private String domainName;
    private String logDirectoryPath;
    private String tempDirectoryPath;
    private String searchPattern;
    private static ResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private String errorMessage = null;
    private String server = null;
    private NativeError ne;
    private boolean allLogFiledCopiedFlag = false;
    private boolean needFileDetails = false;
    private String period = null;
    private boolean utf = true;
    private Long startTime;
    public HashMap<Object, Object> fileDetailsSize = null;
    public int seqNum = -1;

    public LogCopyThread(String server, String userName, String password, String domainName, String logDirectoryPath, String tempDirectoryPath, String searchPattern, String timestamp, Long startTime, boolean needFileDetails, String task, String period, boolean utf) {
        this.userName = userName;
        this.password = password;
        this.domainName = domainName;
        this.server = server;
        this.logDirectoryPath = logDirectoryPath;
        this.tempDirectoryPath = tempDirectoryPath;
        this.searchPattern = searchPattern;
        this.timestamp = timestamp;
        this.startTime = startTime;
        this.copiedLogFiles = new ArrayList();
        this.needFileDetails = needFileDetails;
        this.period = period;
        this.utf = utf;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<HashMap<Object, Object>> filteredFilesList = new ArrayList<HashMap<Object, Object>>();
        ArrayList<Object> logFileDetailList = new ArrayList();
        try {
            HashMap fileDetails;
            int i;
            logger.log(Level.INFO, Thread.currentThread() + "LogCopyThread - run() method begins... ");
            logger.log(Level.INFO, Thread.currentThread() + "LogCopyThread : run() - getLogFileNamesNative() native call started ");
            this.ne = new NativeError();
            logFileDetailList = ADHandler.getLogFileNamesNative(this.userName, this.password, this.domainName, this.logDirectoryPath, this.tempDirectoryPath, this.searchPattern, this.needFileDetails, this.ne);
            logger.log(Level.INFO, Thread.currentThread() + "LogCopyThread : run() - getLogFileNamesNative() native call completed ");
            for (i = 0; i < logFileDetailList.size(); ++i) {
                fileDetails = (HashMap)logFileDetailList.get(i);
                if (!LogUtil.matchLogFileFilterCriteria(fileDetails, this.server, this.startTime, this.timestamp, this.period, this.utf, this)) continue;
                filteredFilesList.add(fileDetails);
            }
            if (this.seqNum != -1) {
                filteredFilesList.add(this.fileDetailsSize);
                this.seqNum = -1;
            }
            logger.log(Level.INFO, Thread.currentThread() + " Log Files : " + filteredFilesList.toString());
            this.allLogFiledCopiedFlag = false;
            for (i = 0; i < filteredFilesList.size(); ++i) {
                fileDetails = (HashMap)filteredFilesList.get(i);
                String logFileName = (String)fileDetails.get("fileName");
                String parentFolder = (String)fileDetails.get("parentFolder");
                int logFileProcessedStatus = LogUtil.getLogFileProcessedStatus(this.server, logFileName, parentFolder);
                logger.log(Level.CONFIG, Thread.currentThread() + " logFileName = " + logFileName + " | " + parentFolder + " | logFileProcessedStatus: " + logFileProcessedStatus);
                if (logFileProcessedStatus != 1 && logFileProcessedStatus != 3) continue;
                boolean isSet = false;
                isSet = LogUtil.setLogFileProcessedStatus(this.server, logFileName, parentFolder, 2);
                if (!isSet) continue;
                String filePath = this.logDirectoryPath;
                String localFilePath = this.tempDirectoryPath;
                if (parentFolder != null && !parentFolder.equals("")) {
                    filePath = filePath.endsWith(File.separator) ? filePath : filePath + File.separator;
                    filePath = filePath + parentFolder + File.separator;
                    localFilePath = localFilePath.endsWith(File.separator) ? localFilePath : localFilePath + File.separator;
                    File tempFile = new File(localFilePath = localFilePath + parentFolder + File.separator);
                    if (!tempFile.exists()) {
                        logger.log(Level.CONFIG, Thread.currentThread() + " " + localFilePath + " Does Not Exists. Creating The Directory...");
                        tempFile.mkdir();
                    }
                }
                ADHandler.copyLogFileNative(logFileName, this.userName, this.password, this.domainName, filePath, localFilePath, this.ne);
                logger.log(Level.CONFIG, Thread.currentThread() + " Message Tracking Log File Copied Successfully..");
                logger.log(Level.CONFIG, Thread.currentThread() + " Adding The Message Tracking Log File To The Copied Files List..");
                this.addCopiedLogFileToList(fileDetails);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.log(Level.SEVERE, Thread.currentThread() + " - " + message);
            e.printStackTrace();
            this.errorMessage = message;
        }
        finally {
            this.allLogFiledCopiedFlag = true;
            this.notifyParserThread();
        }
        logger.log(Level.INFO, Thread.currentThread() + "LogCopyThread - run() method ends... ");
    }

    private synchronized void addCopiedLogFileToList(HashMap<Object, Object> fileDetails) {
        this.copiedLogFiles.add(fileDetails);
        logger.log(Level.CONFIG, Thread.currentThread() + " File Added To The Copied Files List..");
        this.notifyParserThread();
    }

    public synchronized void removeCopiedLogFilesListElement(int i) {
        if (this.copiedLogFiles.size() > 0) {
            this.copiedLogFiles.remove(i);
        }
    }

    public static void log(int level, String logMessage) throws Exception {
        if (level == 1) {
            logger.log(Level.INFO, "Thread ID : " + Thread.currentThread().getId() + " - " + logMessage);
        } else if (level == 2) {
            logger.log(Level.CONFIG, "Thread ID : " + Thread.currentThread().getId() + " - " + logMessage);
        } else if (level == 3) {
            logger.log(Level.SEVERE, "Thread ID : " + Thread.currentThread().getId() + " - " + logMessage);
            throw new Exception(rb.getString(logMessage));
        }
    }

    public boolean getAllLogFilesCopiedFlag() {
        return this.allLogFiledCopiedFlag;
    }

    public synchronized HashMap<Object, Object> getCopiedLogFilesListDetails(int i) {
        if (this.copiedLogFiles.size() > 0) {
            return this.copiedLogFiles.get(i);
        }
        return null;
    }

    public synchronized int getCopiedLogFilesListSize() {
        return this.copiedLogFiles.size();
    }

    public void setAllLogFiledCopiedFlag(boolean allLogFiledCopiedFlag) {
        this.allLogFiledCopiedFlag = allLogFiledCopiedFlag;
    }

    public synchronized void checkCopiedLogFilesListSize() throws Exception {
        if (this.copiedLogFiles.size() == 0 && !this.allLogFiledCopiedFlag) {
            logger.log(Level.CONFIG, Thread.currentThread() + " There Are No Files To Parse. Going To Wait State..");
            this.wait();
            logger.log(Level.CONFIG, Thread.currentThread() + " Returned From Wait State..");
        }
    }

    public synchronized void notifyParserThread() {
        logger.log(Level.CONFIG, Thread.currentThread() + " Notifying The Parsing Thread..");
        this.notify();
        logger.log(Level.CONFIG, Thread.currentThread() + " Parser Thread Notified");
    }
}

