/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.accountLockout.LogCopyThread;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class LogUtil {
    private static Logger logger = Logger.getLogger("EventLogger");
    private static HashMap fileProcessedState = new HashMap();

    public static synchronized int getLogFileProcessedStatus(String server, String fileName, String parentFolder) throws Exception {
        int logFileProcessedStatus = 1;
        HashMap processMap = (HashMap)fileProcessedState.get(server);
        if (processMap != null) {
            if (parentFolder != null && !parentFolder.trim().equals("")) {
                HashMap map = (HashMap)processMap.get(parentFolder.trim());
                if (map != null && map.get(fileName) != null) {
                    logFileProcessedStatus = (Integer)map.get(fileName);
                }
            } else if (processMap.get(fileName) != null) {
                logFileProcessedStatus = (Integer)processMap.get(fileName);
            }
        }
        return logFileProcessedStatus;
    }

    private static boolean setStatus(HashMap processMap, String fileName, int logFileProcessedStatus) {
        boolean isSet = false;
        if (processMap.get(fileName) == null) {
            logger.log(Level.CONFIG, Thread.currentThread() + " setLogFileProcessedStatus - The Log File Does Not Exist, Creating A New Entry");
            processMap.put(fileName, logFileProcessedStatus);
            isSet = true;
        } else {
            int logFileStatus = (Integer)processMap.get(fileName);
            if (logFileStatus == 1 || logFileStatus == 3) {
                if (logFileProcessedStatus == 2) {
                    logger.log(Level.CONFIG, Thread.currentThread() + " setLogFileProcessedStatus - The Log File Exists, Updating The Entry");
                    processMap.put(fileName, logFileProcessedStatus);
                    isSet = true;
                }
            } else if (logFileStatus == 2 && (logFileProcessedStatus == 1 || logFileProcessedStatus == 3)) {
                logger.log(Level.CONFIG, Thread.currentThread() + " setLogFileProcessedStatus - The Log File Exists, Updating The Entry");
                processMap.put(fileName, logFileProcessedStatus);
                isSet = true;
            }
        }
        return isSet;
    }

    public static synchronized boolean setLogFileProcessedStatus(String server, String fileName, String parentFolder, int logFileProcessedStatus) throws Exception {
        boolean isSet = false;
        HashMap processMap = (HashMap)fileProcessedState.get(server);
        if (processMap == null) {
            processMap = new HashMap();
            fileProcessedState.put(server, processMap);
        }
        if (parentFolder != null && !parentFolder.trim().equals("")) {
            HashMap map = (HashMap)processMap.get(parentFolder.trim());
            if (map == null) {
                map = new HashMap();
                processMap.put(parentFolder.trim(), map);
            }
            isSet = LogUtil.setStatus(map, fileName, logFileProcessedStatus);
        } else {
            isSet = LogUtil.setStatus(processMap, fileName, logFileProcessedStatus);
        }
        return isSet;
    }

    public static boolean matchLogFileFilterCriteria(HashMap<Object, Object> fileDetails, String server, Long startTime, String timeGenerated, String period, boolean utf, LogCopyThread logCopyThread) throws Exception {
        String fileName = (String)fileDetails.get("fileName");
        String parentFolder = (String)fileDetails.get("parentFolder");
        String creationTime = (String)fileDetails.get("creationTime");
        Calendar calendar = Calendar.getInstance();
        Calendar c = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        c.setTimeInMillis(startTime * 1000L);
        String time = format.format(c.getTime());
        Date fromDate = format.parse(time);
        c.setTimeInMillis((Long.parseLong(timeGenerated) + 300L) * 1000L);
        time = format.format(c.getTime());
        Date toDate = format.parse(time);
        boolean retValue = false;
        boolean isPatternMatches = false;
        if (fromDate == null || toDate == null) {
            return true;
        }
        if (utf && fileName.startsWith("u_ex") || !utf && fileName.startsWith("ex")) {
            int month;
            int year;
            String tempFileName;
            String logFileDate = null;
            String tempLogFromDate = null;
            String tempLogToDate = null;
            if (period.equalsIgnoreCase("1") && Pattern.matches("(?i)ex[0-9]{6}.log|u_ex[0-9]{6}.log|", fileName)) {
                isPatternMatches = true;
                tempFileName = fileName.substring(0, fileName.indexOf(".log"));
                logFileDate = "20" + tempFileName.substring(tempFileName.length() - 6, tempFileName.length());
                tempLogFromDate = logFileDate.substring(0, 4) + "-" + logFileDate.substring(4, 6) + "-" + logFileDate.substring(6, 8) + " 00:00:00";
                tempLogToDate = logFileDate.substring(0, 4) + "-" + logFileDate.substring(4, 6) + "-" + logFileDate.substring(6, 8) + " 23:59:59";
            } else if (period.equalsIgnoreCase("2") && Pattern.matches("(?i)ex[0-9]{6}.log|u_ex[0-9]{6}.log|", fileName)) {
                isPatternMatches = true;
                tempFileName = fileName.substring(0, fileName.indexOf(".log"));
                logFileDate = "20" + tempFileName.substring(tempFileName.length() - 6, tempFileName.length());
                year = Integer.parseInt(logFileDate.substring(0, 4));
                month = Integer.parseInt(logFileDate.substring(4, 6));
                int weekOfMonth = Integer.parseInt(logFileDate.substring(6, 8));
                Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
                cal.set(2, month - 1);
                cal.set(1, year);
                cal.set(4, weekOfMonth);
                cal.set(7, 1);
                format = new SimpleDateFormat("yyyy-MM-dd");
                tempLogFromDate = format.format(cal.getTime()) + " 00:00:00";
                cal.set(7, 7);
                tempLogToDate = format.format(cal.getTime()) + " 23:59:59";
            } else if (period.equalsIgnoreCase("3") && Pattern.matches("(?i)ex[0-9]{4}.log|u_ex[0-9]{4}.log|", fileName)) {
                isPatternMatches = true;
                tempFileName = fileName.substring(0, fileName.indexOf(".log"));
                logFileDate = "20" + tempFileName.substring(tempFileName.length() - 4, tempFileName.length());
                year = Integer.parseInt(logFileDate.substring(0, 4));
                month = Integer.parseInt(logFileDate.substring(4, 6));
                Calendar cal = Calendar.getInstance();
                cal.set(2, month - 1);
                cal.set(1, year);
                cal.set(5, 1);
                format = new SimpleDateFormat("yyyy-MM-dd");
                tempLogFromDate = format.format(cal.getTime()) + " 00:00:00";
                cal.set(5, cal.getActualMaximum(5));
                tempLogToDate = format.format(cal.getTime()) + " 23:59:59";
            } else if (period.equalsIgnoreCase("4") && Pattern.matches("(?i)ex[0-9]{8}.log|u_ex[0-9]{8}.log|", fileName)) {
                isPatternMatches = true;
                tempFileName = fileName.substring(0, fileName.indexOf(".log"));
                logFileDate = "20" + tempFileName.substring(tempFileName.length() - 8, tempFileName.length());
                tempLogFromDate = logFileDate.substring(0, 4) + "-" + logFileDate.substring(4, 6) + "-" + logFileDate.substring(6, 8) + " " + logFileDate.substring(8, 10) + ":00:00";
                tempLogToDate = logFileDate.substring(0, 4) + "-" + logFileDate.substring(4, 6) + "-" + logFileDate.substring(6, 8) + " " + logFileDate.substring(8, 10) + ":59:59";
            }
            if (!period.equalsIgnoreCase("0") && isPatternMatches) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                format.setTimeZone(new SimpleTimeZone(0, "GMT"));
                Date logFromDate = format.parse(tempLogFromDate);
                Date logToDate = format.parse(tempLogToDate);
                if (logToDate.compareTo(fromDate) >= 0 && logFromDate.compareTo(toDate) <= 0) {
                    retValue = true;
                }
            } else if (period.equalsIgnoreCase("0") && Pattern.matches("(?i)extend[0-9]{2}.log|u_extend[0-9]{2}.log|extend[0-9]{1}.log|u_extend[0-9]{1}.log|", fileName)) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                format.setTimeZone(new SimpleTimeZone(0, "GMT"));
                Date creationDate = format.parse(creationTime);
                if (creationDate.compareTo(fromDate) >= 0 && creationDate.compareTo(toDate) <= 0) {
                    retValue = true;
                } else {
                    int seqNum = -1;
                    String tempFileName2 = fileName.substring(0, fileName.indexOf(".log"));
                    if (utf && fileName.startsWith("u_extend")) {
                        seqNum = Integer.parseInt(tempFileName2.substring(8));
                    } else if (!utf && fileName.startsWith("extend")) {
                        seqNum = Integer.parseInt(tempFileName2.substring(6));
                    }
                    if (creationDate.compareTo(fromDate) < 0 && logCopyThread.seqNum < seqNum) {
                        logCopyThread.seqNum = seqNum;
                        logCopyThread.fileDetailsSize = fileDetails;
                        retValue = false;
                    }
                }
            }
        } else {
            logger.log(Level.INFO, "IIS log file not in required type.So skipping it");
        }
        return retValue;
    }

    public static void updateAllLogFilesStatus() throws Exception {
        Persistence persistence = CommonUtil.getPersistence(new boolean[0]);
        DataObject gatheredLogFilesDataObject = persistence.get("GatheredIISLogFile", (Criteria)null);
        Iterator gatheredLogFilesIterator = gatheredLogFilesDataObject.getRows("GatheredIISLogFile");
        while (gatheredLogFilesIterator.hasNext()) {
            Row gatheredLogFilesRow = (Row)gatheredLogFilesIterator.next();
            int logFileProcessedStatus = (Integer)gatheredLogFilesRow.get("LOG_FILE_PROCESSED_STATUS");
            if (logFileProcessedStatus != 2) continue;
            logger.log(Level.CONFIG, Thread.currentThread() + " updateAllLogFilesStatus - The Log File " + gatheredLogFilesRow.get("FILENAME") + " In Server " + gatheredLogFilesRow.get("SERVER_ID") + " Has Status 1, Updating The Status To 2...");
            gatheredLogFilesRow.set("LOG_FILE_PROCESSED_STATUS", (Object)new Integer(1));
            gatheredLogFilesDataObject.updateRow(gatheredLogFilesRow);
        }
        persistence.update(gatheredLogFilesDataObject);
    }
}

