/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutHistory;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.LogFormat;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.ParserRulesPopulator;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.RecordParser;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.sql.FileWriterObject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OWALogTask {
    private static Logger logger = Logger.getLogger("ReportLogger");
    private String owaLogFileName = null;
    private String serverName = null;
    private String parentFolder = null;
    static int recordCount = 0;
    private Long fromDate = null;
    private Long toDate = null;
    private String userName = null;
    private HashMap win32MessageString = new HashMap();

    public OWALogTask(String serverName, String owaLogFileName, String parentFolder, String userName, String timeGenerated, Long startTime) {
        this.serverName = serverName;
        this.owaLogFileName = owaLogFileName;
        this.parentFolder = parentFolder;
        this.userName = userName;
        this.fromDate = startTime;
        this.toDate = Long.parseLong(timeGenerated) + 240L;
        logger.log(Level.INFO, this.serverName);
        logger.log(Level.INFO, this.owaLogFileName);
        logger.log(Level.INFO, this.parentFolder);
    }

    public void process() throws Exception {
        BufferedReader reader = null;
        boolean first = true;
        ArrayList<Object> rowList = new ArrayList<Row>();
        String domainName = "";
        try {
            String data;
            String fileName = "";
            fileName = this.parentFolder != null && !this.parentFolder.equals("") ? System.getProperty("server.dir") + "\\" + "data" + "\\" + this.serverName + "\\" + this.parentFolder + "\\" + this.owaLogFileName : System.getProperty("server.dir") + "\\" + "data" + "\\" + this.serverName + "\\" + this.owaLogFileName;
            reader = new BufferedReader(new FileReader(fileName));
            LogFormat format = ParserRulesPopulator.get_instance().getParserRules();
            RecordParser parser = new RecordParser(format);
            Integer i = 0;
            while ((data = reader.readLine()) != null) {
                Hashtable result;
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
                if (data.matches("^\\s*$")) continue;
                if (data.startsWith("#Fields:")) {
                    first = true;
                }
                if ((result = parser.parseRecord(data)).size() == 0) continue;
                result.put("lineNumber", i.toString());
                if (first) {
                    first = false;
                    if (result.size() >= 10) {
                        if (result.get("date") == null || result.get("time") == null || result.get("cs_username") == null || result.get("c_ip") == null || result.get("browser_name") == null || result.get("browser_version") == null || result.get("cs_uri_query") == null || result.get("s_ip") == null || result.get("cs_uri_stem") == null || result.get("sc_status") == null || result.get("sc_win32_status") == null) {
                            logger.log(Level.INFO, "Required fields not selected");
                            first = true;
                            continue;
                        }
                    } else {
                        logger.log(Level.INFO, "Required fields not selected");
                        first = true;
                        continue;
                    }
                    domainName = (String)result.get("cs_domainName");
                }
                AccountLockoutHistory.getInstance();
                AccountLockoutHistory.activeSyncErrorMessage.put(this.serverName, null);
                if (!this.checkOwaActiveSyncRecords(result, rowList)) continue;
                ++recordCount;
            }
            FileWriterObject.getInstance().addRows(rowList, domainName, true);
            rowList = new ArrayList();
            recordCount = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "unable to close Import reader handle");
                }
            }
        }
    }

    private boolean checkOwaActiveSyncRecords(Hashtable result, ArrayList rowList) throws Exception {
        String username;
        String url = "";
        String[] columns = new String[]{"DOMAIN_NAME", "SERVER", "DATE", "TIME_GENERATED", "SERVER_IP_ADDRESS", "METHOD", "PROCESS", "QUERY", "SERVER_PORT", "USERNAME", "CLIENT_IP_ADDRESS", "USER_AGENT", "STATUS", "LINE_NUMBER", "STATUS_MESSAGE", "WIN32_STATUS", "WIN32_STATUS_MESSAGE"};
        String[] resultColumns = new String[]{"cs_domainName", "server", "date", "timeGenerated", "s_ip", "cs_method", "cs_uri_stem", "cs_uri_query", "s_port", "cs_username", "c_ip", "cs(User_Agent)", "sc_status", "lineNumber", "statusMessage", "sc_win32_status", "win32StatusMessage"};
        String date = (String)result.get("date");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        Date date1 = dateFormat.parse(date + " " + (String)result.get("time"));
        long timeGenerated = date1.getTime();
        if ((timeGenerated /= 1000L) <= this.fromDate || timeGenerated >= this.toDate) {
            return false;
        }
        if (result.get("cs_uri_stem") != null) {
            url = (String)result.get("cs_uri_stem");
        }
        if ((username = (String)result.get("cs_username")).equalsIgnoreCase(this.userName) && url != null && (url.startsWith("/Microsoft-Server-ActiveSync") || url.toLowerCase().contains("/owa/"))) {
            String tridentVersion;
            if (result.containsKey("trident_version") && (tridentVersion = (String)result.get("trident_version")) != null && tridentVersion != "") {
                if (tridentVersion.equalsIgnoreCase("4.0")) {
                    result.put("browser_version", "8.0");
                } else if (tridentVersion.equalsIgnoreCase("5.0")) {
                    result.put("browser_version", "9.0");
                } else if (tridentVersion.equalsIgnoreCase("6.0")) {
                    result.put("browser_version", "10.0");
                } else if (tridentVersion.equalsIgnoreCase("7.0")) {
                    result.put("browserVersion", "11.0");
                }
            }
            this.putStatusMessage(result);
            if (url.toLowerCase().contains("/owa/")) {
                result.put("cs(User_Agent)", result.get("browser_name") + " " + result.get("browser_version"));
            }
            if (result.containsKey("active_deviceId")) {
                result.put("cs(User_Agent)", result.get("cs(User_Agent)") + " " + result.get("active_deviceId"));
            }
            Row r = new Row("Owa_Activesync");
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].equalsIgnoreCase("Time_Generated")) {
                    r.set(columns[i], (Object)timeGenerated);
                    continue;
                }
                if (columns[i].equalsIgnoreCase("Cmd")) {
                    if (result.containsKey("active_cmd")) {
                        r.set(columns[i], result.get("active_cmd"));
                        continue;
                    }
                    r.set(columns[i], (Object)"-");
                    continue;
                }
                if (columns[i].equalsIgnoreCase("server")) {
                    r.set(columns[i], (Object)this.serverName);
                    continue;
                }
                r.set(columns[i], (Object)((String)result.get(resultColumns[i])));
            }
            rowList.add(r);
            return true;
        }
        return false;
    }

    private void putStatusMessage(Hashtable result) {
        result.put("status_message", result.get("sc_status"));
        if (result.get("sc_win32_status") != null) {
            String win32Status = (String)result.get("sc_win32_status");
            if (!this.win32MessageString.containsKey("win32Status")) {
                if (win32Status.equalsIgnoreCase("") || win32Status.equalsIgnoreCase("-")) {
                    this.win32MessageString.put(win32Status, win32Status);
                } else {
                    String message = ADHandler.getErrorMessage(Integer.parseInt(win32Status));
                    this.win32MessageString.put(win32Status, message);
                }
            }
            result.put("win32StatusMessage", this.win32MessageString.get(win32Status));
        }
    }
}

