/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout;

import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutThread;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServerThreadPool {
    private int maxPoolSize = 50;
    private ThreadPoolExecutor tpExec = null;
    private Hashtable sessionIds = new Hashtable();
    private static ServerThreadPool instance = null;
    private LinkedBlockingQueue queue = new LinkedBlockingQueue();

    public static synchronized ServerThreadPool getInstance() {
        if (instance == null) {
            instance = new ServerThreadPool();
        }
        return instance;
    }

    public ServerThreadPool() {
        this.tpExec = new ThreadPoolExecutor(this.maxPoolSize / 3, this.maxPoolSize, 50000L, TimeUnit.MILLISECONDS, this.queue);
    }

    public synchronized void runTask(String sessionId, AccountLockoutThread task) {
        ArrayList list = (ArrayList)this.sessionIds.get(sessionId);
        list.add(task);
        this.sessionIds.put(sessionId, list);
        this.tpExec.execute(task);
    }

    public void addSessionId(String sessionId) {
        this.sessionIds.put(sessionId, new ArrayList());
    }

    public void removeSessionId(String sessionId) {
        this.sessionIds.remove(sessionId);
    }

    public boolean isRunning(String sessionId) {
        return this.sessionIds.containsKey(sessionId);
    }

    public synchronized void stopSessionTasks(String sessionId) {
        if (this.sessionIds.containsKey(sessionId)) {
            ArrayList runnableList = (ArrayList)this.sessionIds.get(sessionId);
            for (int i = 0; i < runnableList.size(); ++i) {
                this.queue.remove(runnableList.get(i));
            }
        }
    }

    public void shutDown() {
        this.tpExec.shutdown();
    }

    public AccountLockoutThread getRunningThread(String sessionId) {
        AccountLockoutThread runnable = null;
        try {
            if (this.sessionIds.containsKey(sessionId)) {
                ArrayList list = (ArrayList)this.sessionIds.get(sessionId);
                runnable = (AccountLockoutThread)list.get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return runnable;
    }
}

