/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout.parser;

import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.ParserRule;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class LogFormat {
    private Vector keyRules = new Vector(4);
    private Vector preParserRules = new Vector(4);
    private Vector parserRules = new Vector();
    private Hashtable parserRuleMap = new Hashtable();
    private ArrayList dbFields = new ArrayList(10);
    private boolean keyRulePresent = false;
    private boolean containsLongReport = false;
    private int numLines = 1;

    public int getNumLines() {
        return this.numLines;
    }

    public void setNumLines(int numLines) {
        this.numLines = numLines;
    }

    public ArrayList getDbFields() {
        return this.dbFields;
    }

    public Vector getKeyRules() {
        return this.keyRules;
    }

    public List getParserRule(String key) {
        return (List)this.parserRuleMap.get(key);
    }

    public Vector getParserRules() {
        return this.parserRules;
    }

    public Vector getPreParserRules() {
        return this.preParserRules;
    }

    public boolean isContainsLongReport() {
        return this.containsLongReport;
    }

    public boolean isKeyRulePresent() {
        return this.keyRulePresent;
    }

    private boolean isNumericRange(String key) {
        return key.matches("\\d+-\\d+");
    }

    public void setDbFields(ArrayList dbFields) {
        this.dbFields = dbFields;
    }

    public void setKeyRulePresent(boolean keyRulePresent) {
        this.keyRulePresent = keyRulePresent;
    }

    public void setKeyRules(Vector keyRules) {
        this.keyRules.addAll(keyRules);
    }

    public void setParserRules(Vector parserRules) {
        this.parserRules.addAll(parserRules);
        for (ParserRule rule : parserRules) {
            String[] keys = rule.getName().split(",");
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.isNumericRange(key)) {
                    int end;
                    String[] keyRange = key.split("-");
                    int start = Integer.parseInt(keyRange[0]);
                    if (start > (end = Integer.parseInt(keyRange[1]))) continue;
                    int size1 = keyRange[0].length();
                    int size2 = keyRange[1].length();
                    NumberFormat format = NumberFormat.getInstance();
                    format.setMaximumIntegerDigits(Math.max(size1, size2));
                    format.setMinimumIntegerDigits(Math.min(size1, size2));
                    for (int j = start; j <= end; ++j) {
                        String string = format.format(new Integer(j));
                        ArrayList<ParserRule> list = (ArrayList<ParserRule>)this.parserRuleMap.get(string);
                        if (list == null) {
                            list = new ArrayList<ParserRule>(4);
                            this.parserRuleMap.put(string, list);
                        }
                        list.add(rule);
                    }
                    continue;
                }
                ArrayList<ParserRule> list = (ArrayList<ParserRule>)this.parserRuleMap.get(key);
                if (list == null) {
                    list = new ArrayList<ParserRule>(4);
                    this.parserRuleMap.put(key, list);
                }
                list.add(rule);
            }
        }
    }

    public void setPreParserRules(Vector preParserRules) {
        this.preParserRules.addAll(preParserRules);
    }
}

