/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout.parser;

import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.Attribute;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.LogFormat;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.ParsedAttributeRule;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.ParsedAttributes;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.ParserRule;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParserRulesPopulator {
    private static String parserRuleFileName = new String(System.getProperty("server.dir") + "\\" + "conf" + "\\" + "adap" + "\\" + "owa-parser-rules.xml");
    private static ParserRulesPopulator instance = null;
    private LogFormat format;

    public static synchronized ParserRulesPopulator get_instance() {
        if (instance == null) {
            instance = new ParserRulesPopulator();
        }
        return instance;
    }

    private ParserRulesPopulator() {
    }

    private LogFormat getLogFormat(Element element, LogFormat format) {
        Element nodeElement;
        int i;
        NodeList nodes = element.getElementsByTagName("Key-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setKeyRules(this.getRuleSet(nodeElement, "Key-Rule"));
            format.setKeyRulePresent(true);
        }
        nodes = element.getElementsByTagName("Parser-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setParserRules(this.getRuleSet(nodeElement, "Parser-Rule"));
        }
        return format;
    }

    private ParserRule getParserRule(Element element, String tagName) {
        Element nodeElement;
        int i;
        ParserRule pRule = new ParserRule();
        NamedNodeMap attrs = element.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (attr.getName().equals("name")) {
                pRule.setName(attr.getValue());
                continue;
            }
            if (!attr.getName().equals("type")) continue;
            if (attr.getValue().equals("SEPARATOR")) {
                pRule.setParserType((byte)2);
                continue;
            }
            if (!attr.getValue().equals("DYN_SEPARATOR")) continue;
            pRule.setParserType((byte)4);
        }
        NodeList nodes = element.getElementsByTagName("regex");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            pRule.setRegex(this.getregex(nodeElement));
        }
        nodes = element.getElementsByTagName("Attribute");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String key = null;
            String groupNumber = null;
            String open = null;
            String derived = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                Attr attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("groupNumber")) {
                    groupNumber = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("key")) {
                    key = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("open")) {
                    open = attr.getValue();
                    continue;
                }
                if (!attr.getName().equals("derived")) continue;
                derived = attr.getValue();
            }
            if (derived != null && derived.equals("true")) {
                pRule.addDerivedAttribute(key, groupNumber);
                continue;
            }
            if (open != null && open.equals("true")) {
                pRule.addOpenAttribute(key, groupNumber);
                continue;
            }
            try {
                pRule.addAttribute(new Attribute(Integer.valueOf(groupNumber), key));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        nodes = element.getElementsByTagName("Parsed-Attributes");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            pRule.addParsedAttributes(this.getParsedAttribute(nodeElement, "Parsed-Attributes"));
        }
        return pRule;
    }

    private ParsedAttributes getParsedAttribute(Element element, String tagName) {
        Element nodeElement;
        int i;
        ParsedAttributes pAttr = new ParsedAttributes();
        NamedNodeMap attrs = element.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (!attr.getName().equals("key")) continue;
            pAttr.setKey(attr.getValue());
        }
        NodeList nodes = element.getElementsByTagName("regex");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            pAttr.setRegex(this.getregex(nodeElement));
        }
        nodes = element.getElementsByTagName("Attribute");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String key = null;
            String groupNumber = null;
            String open = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                Attr attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("groupNumber")) {
                    groupNumber = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("key")) {
                    key = attr.getValue();
                    continue;
                }
                if (!attr.getName().equals("open")) continue;
                open = attr.getValue();
            }
            if (open != null && open.equals("true")) {
                pAttr.addOpenAttribute(key, groupNumber);
                continue;
            }
            try {
                pAttr.addAttribute(new Attribute(Integer.valueOf(groupNumber), key));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        nodes = element.getElementsByTagName("Browser-Name");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            pAttr.addBrowserName(this.getParsedAttributeRule(nodeElement, "Browser-Name"));
        }
        nodes = element.getElementsByTagName("Domain-Name");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            pAttr.addDomainComponents(this.getParsedAttributeRule(nodeElement, "Domain-Name"));
        }
        nodes = element.getElementsByTagName("Active-Name");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            pAttr.addActiveComponents(this.getParsedAttributeRule(nodeElement, "Active-Name"));
        }
        return pAttr;
    }

    private ParsedAttributeRule getParsedAttributeRule(Element element, String tagName) {
        Element nodeElement;
        int i;
        ParsedAttributeRule rule = new ParsedAttributeRule();
        NamedNodeMap attrs = element.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (!attr.getName().equals("key")) continue;
            rule.setKey(attr.getValue());
        }
        NodeList nodes = element.getElementsByTagName("regex");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            rule.setRegex(this.getregex(nodeElement));
        }
        nodes = element.getElementsByTagName("Attribute");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String key = null;
            String groupNumber = null;
            String open = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                Attr attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("groupNumber")) {
                    groupNumber = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("key")) {
                    key = attr.getValue();
                    continue;
                }
                if (!attr.getName().equals("open")) continue;
                open = attr.getValue();
            }
            if (open != null && open.equals("true")) {
                rule.addOpenAttribute(key, groupNumber);
                continue;
            }
            try {
                rule.addAttribute(new Attribute(Integer.valueOf(groupNumber), key));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return rule;
    }

    public synchronized LogFormat getParserRules() {
        if (this.format == null) {
            this.format = new LogFormat();
            File file = new File(parserRuleFileName);
            try {
                DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuild = dBuildFac.newDocumentBuilder();
                Document doc = dBuild.parse(file);
                Element rootNode = doc.getDocumentElement();
                this.format = this.getLogFormat(rootNode, this.format);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.format;
    }

    private String getregex(Element element) {
        String regex = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 4) continue;
            regex = ((CDATASection)node).getData().trim();
        }
        return regex;
    }

    private Vector getRuleSet(Element element, String tagName) {
        Vector<ParserRule> rules = new Vector<ParserRule>();
        NodeList nodes = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            rules.add(this.getParserRule(nodeElement, tagName));
        }
        return rules;
    }
}

