/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.accountLockout.parser;

import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.Attribute;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.DynSeparatorParser;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.LogFormat;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.Parser;
import com.adventnet.sym.adsm.auditing.server.accountLockout.parser.ParserRule;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class RecordParser {
    private Parser parser = null;
    private LogFormat logFormat = null;
    public boolean containsLongReport = false;
    public boolean multiline_match = false;
    public String header_record = null;

    public RecordParser(LogFormat format) {
        this.logFormat = format;
    }

    private boolean applyKeyBasedParsing(String record, Hashtable paramMap) {
        ParserRule pRule;
        String key = null;
        Iterator iterator = this.logFormat.getKeyRules().iterator();
        while (iterator.hasNext() && (key = this.executeKeyRule(record, pRule = (ParserRule)iterator.next())) == null) {
        }
        List ruleList = null;
        if (key != null) {
            ruleList = this.logFormat.getParserRule(key);
        }
        if (ruleList == null) {
            ruleList = this.logFormat.getParserRule("All");
        }
        return this.applyParserRules(record, paramMap, ruleList);
    }

    private boolean applyParserRules(String record, Hashtable paramMap, List ruleList) {
        if (ruleList == null) {
            return false;
        }
        boolean result = false;
        for (ParserRule rule : ruleList) {
            boolean lastExp;
            if (this.parser == null) {
                this.setParser(rule.getParserType());
            }
            if ((lastExp = this.executeParserRule(record, rule, paramMap)) && rule.getName().startsWith("MULTI_LINE")) {
                this.multiline_match = true;
            }
            result = result || lastExp;
        }
        return result;
    }

    private boolean executeParserRule(String record, ParserRule rule, Hashtable paramMap) {
        boolean result = this.parser.getParams(record, rule, paramMap);
        if (result) {
            result = this.parser.getParsedAttributes(rule.getParsedAttributes(), paramMap);
        }
        return result;
    }

    private String executeKeyRule(String record, ParserRule rule) {
        Matcher m = rule.getPattern().matcher(record);
        if (!m.find()) {
            return null;
        }
        ArrayList attrs = rule.getAttributes();
        if (!attrs.isEmpty()) {
            String key = null;
            for (Attribute attr : attrs) {
                key = m.group(attr.getGroupNumber());
                if (key == null) continue;
                return key;
            }
        } else {
            Hashtable openAttributes = rule.getOpenAttributes();
            if (openAttributes != null && openAttributes.containsKey("PARSER_KEY")) {
                return (String)openAttributes.get("PARSER_KEY");
            }
        }
        return null;
    }

    private int getParamBitSet(Hashtable paramMap, Hashtable params) {
        int retVal = 0;
        for (Map.Entry entry : params.entrySet()) {
            if (!paramMap.containsKey(entry.getKey())) continue;
            retVal |= ((Integer)entry.getValue()).intValue();
        }
        return retVal;
    }

    public Hashtable parseRecord(String data) {
        this.multiline_match = false;
        boolean result = false;
        Hashtable paramMap = new Hashtable();
        String host = "";
        result = this.logFormat.isKeyRulePresent() ? this.applyKeyBasedParsing(data, paramMap) : this.applyParserRules(data, paramMap, this.logFormat.getParserRules());
        return paramMap;
    }

    private void setParser(byte parserType) {
        switch (parserType) {
            case 4: {
                this.parser = new DynSeparatorParser();
            }
        }
    }
}

