/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Monitor;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class AlertAPI {
    private static AlertAPI alertAPI = null;
    public ArrayList columnList = null;
    private static HashMap<String, ArrayList<String>> timeFilterMap = null;
    private static ArrayList printerAlertProfileIdList = null;
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertAPI getInstance() {
        if (alertAPI != null) return alertAPI;
        Class<AlertAPI> clazz = AlertAPI.class;
        synchronized (AlertAPI.class) {
            if (alertAPI != null) return alertAPI;
            alertAPI = new AlertAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return alertAPI;
        }
    }

    protected AlertAPI() {
        this.getTimeFilterValues();
        this.getPrinterAlertProfile();
    }

    public ArrayList<HashMap<String, Object>> getALertProfileList() {
        ArrayList<HashMap<String, Object>> alertProfileList = new ArrayList<HashMap<String, Object>>();
        try {
            String tableName = "AUDAlertProfile";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"MODIFICATION_TIME"), false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
                List columnList = row.getColumns();
                for (String columnName : columnList) {
                    alertProfileMap.put(columnName, row.get(columnName));
                }
                alertProfileList.add(alertProfileMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertProfileList;
    }

    public ArrayList getAlertRows(String searchCriteria, HashMap inputParamsMap, String sortColumn, String sortOrder, int startIndex, int noOfObjects, String severityid, Integer count) {
        String uvhString = "AUDCVConfig:cv_id:10001";
        Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", uvhString);
        ArrayList reportRowsList = new ArrayList();
        try {
            Boolean visible = true;
            HashMap<String, Object> addionalSQLPropsMap = new HashMap<String, Object>();
            addionalSQLPropsMap.put("sortColumn", sortColumn);
            addionalSQLPropsMap.put("sortOrder", sortOrder);
            addionalSQLPropsMap.put("startIndex", startIndex);
            addionalSQLPropsMap.put("noOfObjects", noOfObjects);
            String sqlString = "";
            if ((String)inputParamsMap.get("MONITOR_ID") == null && (String)inputParamsMap.get("ALERT_PROFILE_ID") == null) {
                sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, count);
                sqlString = ((String)inputParamsMap.get("allPeriod")).equalsIgnoreCase("allPeriod") ? sqlString.replace("AND MONITOR_ID=${MONITOR_ID} AND CREATION_TIME BETWEEN ${FROM} AND ${TO}", "") : sqlString.replace("AND MONITOR_ID=${MONITOR_ID} ", "");
            } else {
                if (((String)inputParamsMap.get("allPeriod")).equals("allPeriod")) {
                    sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, count);
                    sqlString = sqlString.replace("AND CREATION_TIME BETWEEN ${FROM} AND ${TO}", "");
                } else {
                    sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, count);
                    if (((String)inputParamsMap.get("TO")).trim().equals("0")) {
                        sqlString = sqlString.replace("AND CREATION_TIME BETWEEN 0 AND 0", "");
                    }
                }
                sqlString = sqlString.replace("MONITOR_ID=${MONITOR_ID}", "ALERT_PROFILE_ID=" + inputParamsMap.get("ALERT_PROFILE_ID"));
            }
            sqlString = sqlString.replace("AND SEVERITY=${SEVERITYID}", "");
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            reportRowsList = QueryUtil.getRows(sqlString, columnList, new HashMap(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportRowsList;
    }

    public ArrayList getRowList(Long alertId, String tableName) {
        ArrayList profileDetails = null;
        ArrayList<Long> UniqueIdTemp = new ArrayList<Long>();
        Long cvId = null;
        ArrayList rowListTemp = null;
        ArrayList rowList = null;
        try {
            Criteria criteria1 = new Criteria(Column.getColumn((String)"AUDAlertThresholdMap", (String)"ALERT_ID"), (Object)alertId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertThresholdMap", criteria1);
            Iterator iterator = dataObject.getRows("AUDAlertThresholdMap");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                profileDetails = new ArrayList();
                Long monitorId = (Long)row.get("MONITOR_ID");
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDMonitorReportMap", (String)"MONITOR_ID"), (Object)monitorId, 0);
                DataObject dataObject2 = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitorReportMap", criteria2);
                Row row2 = dataObject2.getRow("AUDMonitorReportMap");
                Long reportId = (Long)row2.get("AUDIT_REPORT_ID");
                Criteria criteria3 = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
                DataObject dataObject3 = CommonUtil.getPersistence(new boolean[0]).get("AUDReportCVMapping", criteria3);
                Row row3 = dataObject3.getRow("AUDReportCVMapping");
                cvId = (Long)row3.get("CV_ID");
                this.columnList = AuditReportAPI.getInstance().getVisibleColumnList(cvId);
                UniqueIdTemp.add((Long)row.get("UNIQUE_ID"));
            }
            Long[] uniqueId = UniqueIdTemp.toArray(new Long[UniqueIdTemp.size()]);
            if (UniqueIdTemp.size() > 0) {
                rowList = new ArrayList();
            }
            for (int i = 0; i < uniqueId.length; ++i) {
                String queryString = "SELECT * FROM " + tableName + " WHERE UNIQUE_ID =" + uniqueId[i];
                rowListTemp = QueryUtil.getRows(queryString, this.columnList, new HashMap(), false);
                ArrayList tempList = (ArrayList)rowListTemp.get(0);
                HashMap tempMap = (HashMap)tempList.get(0);
                tempMap.put("tableName", tableName);
                tempMap.put("UNIQUE_ID", uniqueId[i]);
                rowList.add(rowListTemp.get(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowList;
    }

    public HashMap<Long, Integer> getThresholdCountMap(Long alert_id) {
        ArrayList<Long> alertIdList = new ArrayList<Long>();
        alertIdList.add(alert_id);
        return this.getalertCountMap(alertIdList);
    }

    public HashMap<Long, Integer> getThresholdCountMap(ArrayList alertList) {
        ArrayList<Long> alertIdList = new ArrayList<Long>();
        try {
            block2: for (int i = 0; i < alertList.size(); ++i) {
                ArrayList list2 = (ArrayList)alertList.get(i);
                for (Object obj : list2) {
                    HashMap valueMap = (HashMap)obj;
                    String columnName = (String)valueMap.get("COLUMNALIAS");
                    Object columnValue = valueMap.get("COLUMN_VALUE");
                    if (!columnName.equals("ALERT_ID")) continue;
                    Long alertId = (Long)columnValue;
                    alertIdList.add(alertId);
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.getalertCountMap(alertIdList);
    }

    public HashMap<Long, Integer> getalertCountMap(ArrayList<Long> alertList) {
        HashMap<Long, Integer> alertMap = new HashMap<Long, Integer>();
        try {
            for (Long alert_id : alertList) {
                Object[] alertArray = new Object[]{alert_id};
                int count = this.getTableColumnsearchCount("ALERT_ID", "AUDAlertThresholdMap", alertArray);
                if (count <= 0) continue;
                alertMap.put(alert_id, count);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertMap;
    }

    public Integer getTableColumnsearchCount(String searchColumn, String tableName, Object[] searchValue) {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)searchColumn), (Object)searchValue, 8);
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            return dataObject.size(tableName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public String getAlertsCount(String searchCriteria, HashMap inputParamsMap) {
        String countSqlString = "";
        try {
            String uvhString = "AUDCVConfig:cv_id:10001";
            Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", uvhString);
            if ((String)inputParamsMap.get("MONITOR_ID") == null && (String)inputParamsMap.get("ALERT_PROFILE_ID") == null) {
                countSqlString = ((String)inputParamsMap.get("allPeriod")).equalsIgnoreCase("allPeriod") ? ADAPSQLQueryAPI.getInstance().getSQLCountString("SELECT COUNT(*) FROM ${TABLE:AUDAlert} WHERE SEVERITY NOT IN ('${SEVERITY}') AND SEVERITY=${SEVERITYID} AND ${SCRITERIA}", searchCriteria, inputParamsMap) : ADAPSQLQueryAPI.getInstance().getSQLCountString("SELECT COUNT(*) FROM ${TABLE:AUDAlert} WHERE SEVERITY NOT IN ('${SEVERITY}') AND SEVERITY=${SEVERITYID} AND ${SCRITERIA} AND ( CREATION_TIME BETWEEN ${FROM} AND ${TO})", searchCriteria, inputParamsMap);
            } else {
                if (((String)inputParamsMap.get("allPeriod")).equals("allPeriod")) {
                    countSqlString = ADAPSQLQueryAPI.getInstance().getSQLCountString(cvId, searchCriteria, inputParamsMap);
                    countSqlString = countSqlString.replace("AND CREATION_TIME BETWEEN ${FROM} AND ${TO}", "");
                } else {
                    countSqlString = ADAPSQLQueryAPI.getInstance().getSQLCountString(cvId, searchCriteria, inputParamsMap);
                    if (((String)inputParamsMap.get("TO")).trim().equals("0")) {
                        countSqlString = countSqlString.replace("AND CREATION_TIME BETWEEN 0 AND 0", "");
                    }
                }
                countSqlString = countSqlString.replace("MONITOR_ID=${MONITOR_ID}", "ALERT_PROFILE_ID=" + inputParamsMap.get("ALERT_PROFILE_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return countSqlString;
    }

    public void getTimeFilterValues() {
        try {
            String uvhString = "AudElement:element_id:10001";
            Long elementId = DBObjectUtil.getUVHValues("AudElement", uvhString);
            String tableName = "AudSelectElementAttr";
            Table table = Table.getTable((String)tableName);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"ELEMENT_ID"), (Object)elementId, 0);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)tableName, (String)"PRIORITY_ID"), true);
            query.setCriteria(criteria);
            query.addSortColumn(sortColumn);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            ArrayList<String> serverValues = new ArrayList<String>();
            ArrayList<String> clientValues = new ArrayList<String>();
            Iterator iterator = dataObject.getRows("AudSelectElementAttr");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                serverValues.add((String)row.get("SERVER_VALUE"));
                clientValues.add(RB.getString((String)row.get("CLIENT_VALUE")));
            }
            timeFilterMap = new HashMap();
            timeFilterMap.put("serverValues", serverValues);
            timeFilterMap.put("clientValues", clientValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, ArrayList<String>> getTimeFilterMap() {
        return timeFilterMap;
    }

    public JSONArray getTimeFilterMap2() {
        JSONArray periodValues = new JSONArray();
        ArrayList<String> clientValues = timeFilterMap.get("clientValues");
        ArrayList<String> serverValues = timeFilterMap.get("serverValues");
        try {
            for (int i = 1; i < clientValues.size() - 1; ++i) {
                JSONObject jo = new JSONObject();
                jo.put("name", (Object)clientValues.get(i));
                jo.put("serverValue", (Object)serverValues.get(i));
                HashMap<String, Object> periodMap = TimeUtil.getTimePeriod(serverValues.get(i));
                jo.put("start", (Object)periodMap.get("FROM").toString());
                jo.put("end", (Object)periodMap.get("TO").toString());
                periodValues.put((Object)jo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return periodValues;
    }

    public Boolean clearAlerts(Long[] alertId, String action) {
        Boolean retAction = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlert", (String)"ALERT_ID"), (Object)alertId, 8);
            if (action.equals("clear")) {
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("AUDAlert");
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn("SEVERITY", (Object)0);
                updateQuery.setUpdateColumn("MODIFIED_TIME", (Object)(System.currentTimeMillis() / 1000L));
                CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)updateQuery);
            } else {
                CommonUtil.getPersistenceLite().delete(criteria);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            retAction = false;
        }
        return retAction;
    }

    public HashMap<String, Comparable> showAlertDetails(Long alert_id) {
        HashMap<String, Comparable> detailsMap = new HashMap<String, Comparable>();
        try {
            String tableName;
            Long reportID = 0L;
            Criteria crit = new Criteria(Column.getColumn((String)"AUDAlert", (String)"ALERT_ID"), (Object)alert_id, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlert", crit);
            Row alertRow = dataObject.getRow("AUDAlert");
            Long uniqueId = (Long)alertRow.get("UNIQUE_ID");
            Long monitorId = (Long)alertRow.get("MONITOR_ID");
            String string = tableName = printerAlertProfileIdList.contains(alertRow.get("ALERT_PROFILE_ID")) ? "AUDPrintjobsinqueue" : "AudGPOAuditInfo";
            if (monitorId > 0L) {
                Monitor monitor = MonitorManager.getInstance().getMonitor(monitorId);
                if (monitor != null) {
                    tableName = AuditCatgoryAPI.getInstance().getCategoryObject(monitor.getCategoryId()).getTableName();
                    reportID = monitor.getAuditReportId();
                } else {
                    tableName = "";
                }
            }
            tableName = this.getTableName(uniqueId, tableName);
            detailsMap.put("tableName", (Comparable)((Object)tableName));
            detailsMap.put("reportID", reportID);
            detailsMap.put("uniqueId", uniqueId);
            detailsMap.put("monitorId", monitorId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return detailsMap;
    }

    public String getTableName(Long unique_id, String tableName) {
        String strName = tableName;
        try {
            SelectQueryImpl stquery = new SelectQueryImpl(Table.getTable((String)"AUDMetaTable"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_INDEX"), (Object)unique_id, 6);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_INDEX"), (Object)unique_id, 4));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)tableName, 0));
            stquery.setCriteria(crit);
            stquery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)stquery);
            if (!dataObject.isEmpty()) {
                Iterator Itr2 = dataObject.getRows("AUDMetaTable");
                while (Itr2.hasNext()) {
                    Row row = (Row)Itr2.next();
                    strName = (String)row.get("LOOKUP_TABLENAME");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return strName;
    }

    public static HashMap<String, ArrayList<HashMap<String, Object>>> getALertProfileList(String domainName) {
        HashMap<String, ArrayList<HashMap<String, Object>>> alertProfileMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        try {
            String tableName = "AUDAlertProfile";
            Table table = Table.getTable((String)tableName);
            Table alertMonitorMapTable = Table.getTable((String)"AUDAlertMonitorMap");
            Table monitorTable = Table.getTable((String)"AUDMonitor");
            Table alertCriteriaTable = Table.getTable((String)"AUDAlertCriteria");
            Table printCriteriaTable = Table.getTable((String)"AUDPrinterAlertCriteria");
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Join alertmonitorMapJoin = new Join(table, alertMonitorMapTable, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 1);
            Join mapMonitorJoin = new Join(alertMonitorMapTable, monitorTable, new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 1);
            Join alertCriteriaAlertProfileJoin = new Join(table, alertCriteriaTable, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 1);
            Join alertPrintCriteriaAlertProfileJoin = new Join(table, printCriteriaTable, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 1);
            if (domainName != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName.split(","), 8);
                crit = crit.or(new Criteria(Column.getColumn((String)"AUDAlertCriteria", (String)"DOMAIN_NAME"), (Object)domainName.split(","), 8));
                crit = crit.or(new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"DOMAIN_NAME"), (Object)domainName.split(","), 8));
                selectQuery.setCriteria(crit);
            }
            selectQuery.addJoin(alertmonitorMapJoin);
            selectQuery.addJoin(mapMonitorJoin);
            selectQuery.addJoin(alertCriteriaAlertProfileJoin);
            selectQuery.addJoin(alertPrintCriteriaAlertProfileJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertMonitorMap", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertCriteria", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"MODIFICATION_TIME"), false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            ArrayList<HashMap<String, Object>> alertProfileList = null;
            Iterator iterator = dataObject.getRows("AUDAlertProfile");
            while (iterator.hasNext()) {
                Criteria crit1;
                Row printCritRow;
                Row row = (Row)iterator.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                List columnList = row.getColumns();
                for (String columnName : columnList) {
                    if (columnName.equalsIgnoreCase("ALERT_PROFILE_NAME") || columnName.equalsIgnoreCase("ALERT_PROFILE_DESCRIPTION")) {
                        map.put(columnName, RB.getString((String)row.get(columnName)));
                        continue;
                    }
                    map.put(columnName, row.get(columnName));
                }
                String profileDomainName = "";
                Criteria mapCrit = new Criteria(Column.getColumn((String)"AUDAlertMonitorMap", (String)"ALERT_PROFILE_ID"), row.get("ALERT_PROFILE_ID"), 0);
                Iterator mapItr = dataObject.getRows("AUDAlertMonitorMap", mapCrit);
                while (mapItr.hasNext()) {
                    Row mapRow = (Row)mapItr.next();
                    Criteria monitorCrit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), mapRow.get("MONITOR_ID"), 0);
                    Row monitorRow = dataObject.getRow("AUDMonitor", monitorCrit);
                    profileDomainName = (String)monitorRow.get("DOMAIN_NAME");
                    alertProfileList = alertProfileMap.get(profileDomainName);
                    if (alertProfileList == null) {
                        alertProfileList = new ArrayList();
                    }
                    if (!alertProfileList.contains(map)) {
                        alertProfileList.add(map);
                    }
                    alertProfileMap.put(profileDomainName, alertProfileList);
                }
                Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertCriteria", (String)"ALERT_PROFILE_ID"), row.get("ALERT_PROFILE_ID"), 0);
                Row critRow = dataObject.getRow("AUDAlertCriteria", crit);
                if (critRow != null) {
                    profileDomainName = (String)critRow.get("DOMAIN_NAME");
                    alertProfileList = alertProfileMap.get(profileDomainName);
                    if (alertProfileList == null) {
                        alertProfileList = new ArrayList();
                    }
                    if (!alertProfileList.contains(map)) {
                        alertProfileList.add(map);
                    }
                    alertProfileMap.put(profileDomainName, alertProfileList);
                }
                if ((printCritRow = dataObject.getRow("AUDPrinterAlertCriteria", crit1 = new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"ALERT_PROFILE_ID"), row.get("ALERT_PROFILE_ID"), 0))) == null) continue;
                profileDomainName = (String)printCritRow.get("DOMAIN_NAME");
                alertProfileList = alertProfileMap.get(profileDomainName);
                if (alertProfileList == null) {
                    alertProfileList = new ArrayList();
                }
                if (!alertProfileList.contains(map)) {
                    alertProfileList.add(map);
                }
                alertProfileMap.put(profileDomainName, alertProfileList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertProfileMap;
    }

    public void deleteGPOAlertProfile(String domainName) throws Exception {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getPrinterAlertProfile() {
        try {
            printerAlertProfileIdList = new ArrayList();
            Criteria crit = new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"ALERT_PROFILE_ID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDPrinterAlertCriteria", crit);
            Iterator iterator = dataObject.getRows("AUDPrinterAlertCriteria");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (row == null) continue;
                printerAlertProfileIdList.add(row.get("ALERT_PROFILE_ID"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

