/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfile;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;

public final class AlertProfileAPI {
    private static AlertProfileAPI alertProfileAPI = null;
    private static HashMap<Long, AlertProfile> alertProfilesMap = null;
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static Hashtable<String, HashMap> columnMap = new Hashtable();

    private AlertProfileAPI() {
        try {
            if (alertProfilesMap == null) {
                this.getAlertProfiles();
                AlertProfileAPI.setAddnMailMap();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertProfileAPI getInstance() {
        if (alertProfileAPI != null) return alertProfileAPI;
        Class<AlertProfileAPI> clazz = AlertProfileAPI.class;
        synchronized (AlertProfileAPI.class) {
            if (alertProfileAPI != null) return alertProfileAPI;
            alertProfileAPI = new AlertProfileAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return alertProfileAPI;
        }
    }

    public void getAlertProfiles() throws DataAccessException {
        ArrayList<Long> notificationIdList = null;
        Table alertProfileTable = Table.getTable((String)"AUDAlertProfile");
        Table alertNotificationMapTable = Table.getTable((String)"AUDAlertNotificationMap");
        SelectQueryImpl sq = new SelectQueryImpl(alertProfileTable);
        Join alertProNotificatinMapJoin = new Join(alertProfileTable, alertNotificationMapTable, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERTPROFILE_ID"}, 1);
        sq.addJoin(alertProNotificatinMapJoin);
        sq.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"));
        sq.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_NAME"));
        sq.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_MESSAGE"));
        sq.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"CRITERIA_PATTERN"));
        sq.addSelectColumn(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"));
        sq.addSelectColumn(Column.getColumn((String)"AUDAlertNotificationMap", (String)"NOTIFICATION_ID"));
        DataObject alertProfileDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        Iterator alertProfileIterator = alertProfileDataObject.getRows("AUDAlertProfile");
        while (alertProfileIterator.hasNext()) {
            AlertProfile alertProfile = new AlertProfile();
            Row alertProfileRow = (Row)alertProfileIterator.next();
            Long alertProfileId = (Long)alertProfileRow.get("ALERT_PROFILE_ID");
            alertProfile.setId(alertProfileId);
            alertProfile.setName(RB.getString((String)alertProfileRow.get("ALERT_PROFILE_NAME")));
            alertProfile.setIsBusinessHourEnabled(this.getBusinessHourValue((Long)alertProfileRow.get("ALERT_PROFILE_ID")));
            alertProfile.setCallerUserNameValue(this.getCallerUserName((Long)alertProfileRow.get("ALERT_PROFILE_ID")));
            alertProfile.setFilterDetails(this.getFilterDetails((Long)alertProfileRow.get("ALERT_PROFILE_ID")));
            alertProfile.setFilterPattern(alertProfileRow.get("CRITERIA_PATTERN") != null ? (String)alertProfileRow.get("CRITERIA_PATTERN") : "-");
            HashMap<String, Integer> thresoldMap = this.fillThresHoldValues((Long)alertProfileRow.get("ALERT_PROFILE_ID"));
            if (thresoldMap.size() > 0) {
                alertProfile.setThresholdValues(thresoldMap);
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            Iterator notificationMapIterator = alertProfileDataObject.getRows("AUDAlertNotificationMap", crit);
            notificationIdList = new ArrayList<Long>();
            if (notificationMapIterator != null) {
                if (notificationMapIterator.hasNext()) {
                    while (notificationMapIterator.hasNext()) {
                        Row notificationMapRow = (Row)notificationMapIterator.next();
                        Long notificationId = (Long)notificationMapRow.get("NOTIFICATION_ID");
                        Table alertNotificationTable = Table.getTable((String)"AUDNotification");
                        SelectQueryImpl sq1 = new SelectQueryImpl(alertNotificationTable);
                        sq1.addSelectColumn(Column.getColumn((String)"AUDNotification", (String)"NOTIFICATIONID"));
                        sq1.addSelectColumn(Column.getColumn((String)"AUDNotification", (String)"NOTIFICATION_TYPE"));
                        DataObject alertNotificationDO = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq1);
                        Row alertNotificationRow = alertNotificationDO.getRow("AUDNotification");
                        String notificationType = (String)alertNotificationRow.get("NOTIFICATION_TYPE");
                        if (notificationType != null) {
                            alertProfile.setIsMailEnabled(notificationType.equals("E-Mail"));
                        }
                        notificationIdList.add(notificationId);
                    }
                } else {
                    alertProfile.setIsMailEnabled(false);
                }
                alertProfile.setNotificationIdList(notificationIdList);
            }
            if (alertProfilesMap == null) {
                alertProfilesMap = new HashMap();
            }
            alertProfilesMap.put(alertProfileId, alertProfile);
        }
    }

    public AlertProfile getAlertProfile(Long alertProfileId) throws DataAccessException, NullPointerException {
        if (alertProfilesMap == null) {
            this.getAlertProfiles();
        }
        return alertProfilesMap.get(alertProfileId);
    }

    public void addAlertProfileRowInMap(Row alertProfileRow) {
        try {
            if (alertProfilesMap != null) {
                AlertProfile alertProfile = new AlertProfile();
                Long alertProfileId = (Long)alertProfileRow.get("ALERT_PROFILE_ID");
                alertProfile.setId(alertProfileId);
                alertProfile.setName((String)alertProfileRow.get("ALERT_PROFILE_NAME"));
                ArrayList<Long> notificationIdList = this.getNotificationIdList(alertProfileId);
                alertProfile.setNotificationIdList(notificationIdList);
                alertProfile.setIsBusinessHourEnabled(this.getBusinessHourValue((Long)alertProfileRow.get("ALERT_PROFILE_ID")));
                alertProfile.setCallerUserNameValue(this.getCallerUserName((Long)alertProfileRow.get("ALERT_PROFILE_ID")));
                HashMap<String, Integer> thresoldMap = this.fillThresHoldValues((Long)alertProfileRow.get("ALERT_PROFILE_ID"));
                if (thresoldMap.size() > 0) {
                    alertProfile.setThresholdValues(thresoldMap);
                }
                if (AlertProfileAPI.isMailEnabled(alertProfileId)) {
                    alertProfile.setIsMailEnabled(true);
                } else {
                    alertProfile.setIsMailEnabled(false);
                }
                LinkedHashMap<Integer, HashMap<String, Object>> filterDetails = this.getFilterDetails(alertProfileId);
                if (filterDetails.size() > 0) {
                    alertProfile.setFilterDetails(filterDetails);
                }
                alertProfilesMap.put(alertProfileId, alertProfile);
                alertProfile.setFilterPattern((String)alertProfileRow.get("CRITERIA_PATTERN"));
                MonitorManager.getInstance().updateAlertProfileInMonitorMap(new Long[]{alertProfileId});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<Long> getNotificationIdList(Long alertProfileId) {
        ArrayList<Long> notificationIdList = new ArrayList<Long>();
        try {
            Table alertNotificationMapTable = Table.getTable((String)"AUDAlertNotificationMap");
            SelectQueryImpl sq = new SelectQueryImpl(alertNotificationMapTable);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertNotificationMap", (String)"*"));
            DataObject notificationMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator notificationMapIterator = notificationMapDataObject.getRows("AUDAlertNotificationMap");
            while (notificationMapIterator.hasNext()) {
                Row notificationMapRow = (Row)notificationMapIterator.next();
                Long notificationId = (Long)notificationMapRow.get("NOTIFICATION_ID");
                notificationIdList.add(notificationId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notificationIdList;
    }

    public void deleteAlertProfileRowInMap(Long alertProfileId) {
        try {
            if (alertProfilesMap != null) {
                alertProfilesMap.remove(alertProfileId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAlertProfileRowInMap(Long alertProfileId, HashMap<String, Object> propsMap) throws DataAccessException, NullPointerException {
        try {
            if (alertProfilesMap != null) {
                AlertProfile alertProfile = new AlertProfile();
                alertProfile.setId(alertProfileId);
                alertProfile.setName((String)propsMap.get("ALERT_PROFILE_NAME"));
                alertProfile.setFilterPattern((String)propsMap.get("CRITERIA_PATTERN"));
                alertProfile.setFilterDetails((LinkedHashMap)propsMap.get("filterDetails"));
                ArrayList<Long> notificationIdList = this.getNotificationIdList(alertProfileId);
                alertProfile.setNotificationIdList(notificationIdList);
                if (AlertProfileAPI.isMailEnabled(alertProfileId)) {
                    alertProfile.setIsMailEnabled(true);
                } else {
                    alertProfile.setIsMailEnabled(false);
                }
                alertProfile.setIsBusinessHourEnabled(this.getBusinessHourValue(alertProfileId));
                alertProfile.setCallerUserNameValue(this.getCallerUserName(alertProfileId));
                HashMap<String, Integer> thresoldMap = this.fillThresHoldValues(alertProfileId);
                if (thresoldMap.size() > 0) {
                    alertProfile.setThresholdValues(thresoldMap);
                }
                alertProfilesMap.put(alertProfileId, alertProfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isMailEnabled(Long alertProfileId) {
        boolean isMailEnabled = true;
        try {
            Table alertNotificationMapTable = Table.getTable((String)"AUDAlertNotificationMap");
            SelectQueryImpl sq = new SelectQueryImpl(alertNotificationMapTable);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertNotificationMap", (String)"*"));
            DataObject notificationMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            isMailEnabled = notificationMapDataObject.isEmpty();
            isMailEnabled = !isMailEnabled;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMailEnabled;
    }

    public boolean enableDisableAlertProfile(Long[] alertProfileId, String action) {
        boolean b = true;
        try {
            if (action != null) {
                String tableName = "AUDAlertProfile";
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 8);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                Iterator itr = dataObject.getRows(tableName);
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    if (action.equals("Enable")) {
                        row.set("IS_ENABLED", (Object)true);
                    } else {
                        row.set("IS_ENABLED", (Object)false);
                    }
                    dataObject.updateRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        return b;
    }

    public int getBusinessHourValue(Long alertProfileId) {
        int businessHrValue = 0;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertProfile", criteria);
            if (dataObject != null) {
                Row row = dataObject.getRow("AUDAlertProfile");
                businessHrValue = row.get("IS_BUSINESS_HOUR_ENABLED") == null ? 0 : (Integer)row.get("IS_BUSINESS_HOUR_ENABLED");
            }
        }
        catch (Exception e) {
            businessHrValue = 0;
            e.printStackTrace();
        }
        return businessHrValue;
    }

    public HashMap<String, String> fillBusinessHourValues() {
        HashMap<String, String> businessAlertValues = new HashMap<String, String>();
        try {
            int i = 0;
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)new String[]{"FromTime", "ToTime", "Days"}, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            String[] businessHourValues = new String[3];
            Iterator iterator = dataObject.getRows("SystemParams");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                businessHourValues[i++] = (String)row.get("PARAM_VALUE");
            }
            businessAlertValues.put("fromTime", businessHourValues[0]);
            businessAlertValues.put("toTime", businessHourValues[1]);
            businessAlertValues.put("dayOfWeek", businessHourValues[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return businessAlertValues;
    }

    public ArrayList<String> getCallerUserName(Long alertProfileId) {
        ArrayList<String> callerUserName = new ArrayList<String>();
        try {
            Table table = Table.getTable((String)"AUDAlertUserCriteria");
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertUserCriteria", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            Join join = new Join("AUDAlertUserCriteria", "AUDCallerUserNameMap", new String[]{"USERNAME_ID"}, new String[]{"USERNAME_ID"}, 2);
            selectQuery.addJoin(join);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertUserCriteria", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDCallerUserNameMap", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("AUDCallerUserNameMap");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                callerUserName.add(((String)row.get("CRITERIA_OBJECT")).toLowerCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return callerUserName;
    }

    public LinkedHashMap<Integer, HashMap<String, Object>> getFilterDetails(Long alertProfileId) {
        LinkedHashMap<Integer, HashMap<String, Object>> filterDetails = new LinkedHashMap<Integer, HashMap<String, Object>>();
        try {
            Table table = Table.getTable((String)"AUDAlertProfileFilterMapping");
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"PRIORITY_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            filterDetails = this.getFilterDetails(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return filterDetails;
    }

    public LinkedHashMap<Integer, HashMap<String, Object>> getFilterDetails(DataObject dataObject) {
        LinkedHashMap<Integer, HashMap<String, Object>> filterDetails = new LinkedHashMap<Integer, HashMap<String, Object>>();
        try {
            if (dataObject.size("AUDAlertProfileFilterMapping") > 0) {
                HashMap columnMap = AuditCategoryHandler.getInstance().getColumnsMap();
                Iterator iterator = dataObject.getRows("AUDAlertProfileFilterMapping");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    HashMap columnDetails = (HashMap)columnMap.get((Long)row.get("COLUMN_ID"));
                    HashMap<String, Object> filterMap = new HashMap<String, Object>();
                    filterMap.put("COLUMN_NAME", columnDetails.get("COLUMN_NAME"));
                    filterMap.put("RELATIONAL_OPERATOR", row.get("RELATIONAL_OPERATOR"));
                    filterMap.put("LOGICAL_OPERATOR", row.get("LOGICAL_OPERATOR"));
                    filterMap.put("COLUMN_DATA_TYPE", columnDetails.get("COLUMN_DATA_TYPE"));
                    String[] value = ((String)row.get("VALUE")).split(";;;");
                    if (value.length > 1) {
                        String objectClass = value[0];
                        HashMap<String, Object> inputParams = ReportUtil.formMap(new String[]{"objectClass", "object_guid"}, new Object[]{value[0], new ArrayList<String>(Arrays.asList(value[1].split(",")))});
                        HashMap inputParamsMap = new HashMap();
                        AuditReportParamsAPI.getObjectValues(0L, inputParams, inputParamsMap);
                        inputParamsMap = ReportSchedulerUtil.formInputParamsMap((String)columnDetails.get("EXPECTED_OBJECT_CLASS"), inputParams, inputParamsMap);
                        String[] inputValues = ((String)columnDetails.get("INPUT_VALUE")).split(",");
                        String value1 = "";
                        value1 = inputValues.length == 2 ? (String)inputParamsMap.get(inputValues[0]) + "," + (String)inputParamsMap.get(inputValues[1]) : (String)inputParamsMap.get(inputValues[0]);
                        filterMap.put("VALUE", ReportUtil.removeQuotes(value1));
                    } else {
                        filterMap.put("VALUE", value[0]);
                    }
                    filterDetails.put((Integer)row.get("PRIORITY_ID"), filterMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return filterDetails;
    }

    public HashMap<String, Integer> fillThresHoldValues(Long alertProfileId) {
        HashMap<String, Integer> thresHoldValues = new HashMap<String, Integer>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertThresold", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertThresold", criteria);
            Iterator iterator = dataObject.getRows("AUDAlertThresold");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                thresHoldValues.put("Count", (Integer)row.get("THRES_COUNT"));
                thresHoldValues.put("TimeInterval", (Integer)row.get("TIME_INTERVAL"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thresHoldValues;
    }

    public HashMap<String, ArrayList> getMessageContentType(HttpServletRequest request) {
        HashMap<String, ArrayList> messageContType = new HashMap<String, ArrayList>();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String[] clientValues = new String[]{rb.getString("adap.AlertProfileAPI.MessageContentText.Subject_Alone"), rb.getString("adap.AlertProfileAPI.MessageContentText.Alert_Msg_As_Subject"), rb.getString("adap.AlertProfileAPI.MessageContentText.Alert_Msg_only_in_Content")};
            String[] serverValues = new String[]{"subjectAlone", "messageAsSubject", "msgOnlyInContent"};
            ArrayList<String> clientList = new ArrayList<String>();
            ArrayList<String> serverList = new ArrayList<String>();
            for (int i = 0; i < clientValues.length; ++i) {
                clientList.add(clientValues[i]);
                serverList.add(serverValues[i]);
            }
            messageContType.put("CLIENT_VALUES", clientList);
            messageContType.put("SERVER_VALUES", serverList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return messageContType;
    }

    private static HashMap getAddnMailMap(String tableName) {
        return columnMap.get(tableName);
    }

    public static String getMailIdsFromName(String columnName, Row row) {
        String mailAddress = null;
        try {
            HashMap tableMap = AlertProfileAPI.getAddnMailMap(row.getTableName());
            if (tableMap == null) {
                return null;
            }
            Hashtable columnTable = (Hashtable)tableMap.get(columnName);
            if (columnTable == null) {
                return null;
            }
            String[] equlColumn = ((String)columnTable.get("EQUALENT_COLUMN_NAME")).split(",");
            String[] userColumn = ((String)columnTable.get("USER_COLUMN_NAME")).split(",");
            Criteria crit = null;
            for (int i = 0; i < equlColumn.length; ++i) {
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)userColumn[i]), (Object)((String)row.get(equlColumn[i])).replace("%{", "").replace("}", ""), 0);
                crit = crit == null ? criteria : crit.and(criteria);
            }
            Row userDetails = ReportUtil.getFirstRow(crit, "ADSMUserGeneralDetails");
            if (userDetails != null) {
                mailAddress = (String)userDetails.get("EMAIL_ADDRESS");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mailAddress;
    }

    private static void setAddnMailMap() {
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDAddnMailNameColumnDetails", (Criteria)null);
            Iterator iter = dObj.getRows("AUDAddnMailNameColumnDetails");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String tableName = (String)row.get("TABLE_NAME");
                HashMap tableMap = columnMap.get(tableName) != null ? columnMap.get(tableName) : new HashMap();
                String columnName = (String)row.get("COLUMN_NAME");
                Hashtable columnTable = tableMap.get(columnName) != null ? (Hashtable)tableMap.get(columnName) : new Hashtable();
                String equalentColName = (String)row.get("EQUALENT_COLUMN_NAME");
                String userTableColumnNames = (String)row.get("USER_COLUMN_NAME");
                columnTable.put("EQUALENT_COLUMN_NAME", equalentColName);
                columnTable.put("USER_COLUMN_NAME", userTableColumnNames);
                tableMap.put(columnName, columnTable);
                columnMap.put(tableName, tableMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList<String> getAlertMailToAddress(String mailIdStr, Row eventRow) {
        ArrayList<String> list = new ArrayList<String>();
        String[] mailIds = mailIdStr.split(",");
        for (int i = 0; i < mailIds.length; ++i) {
            String tempId = mailIds[i];
            if (tempId.indexOf("%") == 0) {
                String columnName = tempId.split("@")[0];
                if (eventRow.get(columnName.replace("%", "")) == null) continue;
                list.add(tempId.replace(columnName, (String)eventRow.get(columnName.replace("%", ""))));
                continue;
            }
            list.add(tempId);
        }
        return list;
    }
}

