/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.PrintAlertProfileHandler;
import com.adventnet.sym.adsm.auditing.server.alert.notification.NotificationAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlertProfileHandler {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("QueryLogger");
    private static Row notificationTableRow = null;

    public static final boolean saveAlertProfile(HashMap<String, HashMap> map, ArrayList<Long> monitorIdList) {
        boolean status = false;
        try {
            HashMap thresholdMap;
            HashMap propsMap = map.get("AlertProfileDetails");
            DataObject alertProfileDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("AUDAlertProfile");
            Set keySet = propsMap.keySet();
            for (String string : keySet) {
                row.set(string, propsMap.get(string));
            }
            UniqueValueHolder uniqueValueHolder = (UniqueValueHolder)row.get("ALERT_PROFILE_ID");
            alertProfileDO.addRow(row);
            AlertProfileHandler.addAlertMonitorMap(uniqueValueHolder, monitorIdList, alertProfileDO);
            HashMap propsMap1 = map.get("NotificationProfileDetails");
            if (Boolean.valueOf(propsMap1.get("IS_MAIL_NOTIFICATION").toString()).booleanValue()) {
                Row row1 = new Row("AUDAlertNotificationMap");
                row1.set("ALERTPROFILE_ID", (Object)uniqueValueHolder);
                alertProfileDO.addRow(row1);
                UniqueValueHolder notificationUniqueValueHolder = (UniqueValueHolder)row1.get("NOTIFICATION_ID");
                HashMap<String, Object> notificationMap = AlertProfileHandler.getNotification(notificationUniqueValueHolder, propsMap1);
                AlertProfileHandler.addAudNotification(notificationMap, alertProfileDO);
            }
            if (map.get("AlertCriteriaDetails") != null) {
                HashMap gpoPropMap = map.get("AlertCriteriaDetails");
                AlertProfileHandler.addAlertCriteria(uniqueValueHolder, gpoPropMap, alertProfileDO);
            }
            if (map.get("PrinterCriteriaDetails") != null) {
                HashMap printerPropMap = map.get("PrinterCriteriaDetails");
                PrintAlertProfileHandler.addPrintAlertCriteria(uniqueValueHolder, printerPropMap, alertProfileDO);
            }
            if (Boolean.valueOf((thresholdMap = map.get("ThresholdProfileDetails")).get("IS_THRESHOLD_NOTIFICATION").toString()).booleanValue()) {
                AlertProfileHandler.addAudThresholdNotification(AlertProfileHandler.getThresholdNotification(uniqueValueHolder, thresholdMap), alertProfileDO);
            }
            if (map.get("CallerUserName") != null) {
                HashMap selectedObjectsMap = map.get("CallerUserName");
                ArrayList domainNameList = (ArrayList)selectedObjectsMap.get("domainName");
                selectedObjectsMap.remove("domainName");
                AlertProfileHandler.addCallerUserName(selectedObjectsMap, alertProfileDO, uniqueValueHolder, 1L, (String)domainNameList.get(0));
            }
            if (map.get("BusinessHourAlert") != null) {
                AlertProfileHandler.addBusinessHourAlert(map.get("BusinessHourAlert"), alertProfileDO, uniqueValueHolder);
            }
            if (map.get("filterDetails") != null) {
                AlertProfileHandler.addCriteriaRow(alertProfileDO, (LinkedHashMap)map.get("filterDetails"));
            }
            CommonUtil.getPersistence(new boolean[0]).add(alertProfileDO);
            if (notificationTableRow != null) {
                NotificationAPI.getInstance().addNotificationInMap(notificationTableRow);
            }
            AlertProfileHandler.setIsProfileAdded();
            MonitorManager.getInstance().getMonitors(null);
            AlertProfileAPI.getInstance().addAlertProfileRowInMap(row);
            status = true;
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public static HashMap<String, Boolean> getBusinessAlertDetails(Object alertProfileId) {
        HashMap<String, Boolean> BusinessHourMap = new HashMap<String, Boolean>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), alertProfileId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertProfile", criteria);
            if (dataObject != null) {
                Row row = dataObject.getRow("AUDAlertProfile");
                int included = (Integer)row.get("IS_BUSINESS_HOUR_ENABLED");
                if (included > 1) {
                    BusinessHourMap.put("included", true);
                } else if (included == 1) {
                    BusinessHourMap.put("included", false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BusinessHourMap;
    }

    public static HashMap getAlertDetails(Object alertProfileId) {
        HashMap selectedObjectsMap2 = new HashMap();
        try {
            HashMap userNameMap = new HashMap();
            ArrayList objList = new ArrayList();
            ArrayList userList = new ArrayList();
            ArrayList groupList = new ArrayList();
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertUserCriteria", (String)"ALERTPROFILE_ID"), alertProfileId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertUserCriteria", criteria);
            Iterator iterator = dataObject.getRows("AUDAlertUserCriteria");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String guid = (String)row.get("OBJECT_GUID");
                String className = (String)row.get("OBJECT_CLASS");
                String DomainName = (String)row.get("DOMAIN_NAME");
                Row dirObjectRow = DirectoryObjectAPI.getInstance().getObjectRow(DomainName, guid, className);
                if (dirObjectRow == null) continue;
                HashMap<String, Object> objectMap = new HashMap<String, Object>();
                objectMap.put("OBJECT_GUID", guid);
                objectMap.put("NAME", dirObjectRow.get("NAME"));
                objectMap.put("username_id", (Long)row.get("USERNAME_ID"));
                objectMap.put("domain_name", (String)row.get("DOMAIN_NAME"));
                objectMap.put("object_class", (String)row.get("OBJECT_CLASS"));
                if (className.equalsIgnoreCase("User")) {
                    userList.add(objectMap);
                    continue;
                }
                groupList.add(objectMap);
            }
            if (userList.size() > 0) {
                selectedObjectsMap2.put("user", userList);
            }
            if (groupList.size() > 0) {
                selectedObjectsMap2.put("group", groupList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return selectedObjectsMap2;
    }

    public static final ArrayList<Long> getCategoryList(ArrayList<Long> monitorIdList) {
        ArrayList<Long> categoryIdList = new ArrayList<Long>();
        try {
            Long[] objectArray = monitorIdList.toArray(new Long[monitorIdList.size()]);
            Long categoryId = 0L;
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)objectArray, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", criteria);
            for (Long object : monitorIdList) {
                Criteria idCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)object, 0);
                DataObject dataObject1 = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", idCriteria);
                Iterator iterator = dataObject1.getRows("AUDMonitor");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    categoryId = (Long)row.get("CATEGORY_ID");
                }
                categoryIdList.add(categoryId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return categoryIdList;
    }

    public static String getDomainName(Long monitorId) {
        String domainName = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", criteria);
            Row row = dataObject.getRow("AUDMonitor");
            domainName = (String)row.get("DOMAIN_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static final void setIsProfileAdded(ArrayList<Long> monitorIdList, boolean isProfileAdded) {
        try {
            Long[] objectArray = monitorIdList.toArray(new Long[monitorIdList.size()]);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)objectArray, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", criteria);
            for (Long object : monitorIdList) {
                Criteria idCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)object, 0);
                Row row = dataObject.getRow("AUDMonitor", idCriteria);
                row.set("IS_PROFILE_ADDED", (Object)isProfileAdded);
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void setIsProfileAdded() {
        try {
            ArrayList<Long> monitorList = new ArrayList<Long>();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertMonitorMap", (Row)null);
            Iterator iterator = dataObject.getRows("AUDAlertMonitorMap");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long monitorId = (Long)row.get("MONITOR_ID");
                if (monitorList.contains(monitorId)) continue;
                monitorList.add(monitorId);
            }
            DataObject monitorDO = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", (Row)null);
            Iterator iterator2 = monitorDO.getRows("AUDMonitor");
            while (iterator2.hasNext()) {
                Row row = (Row)iterator2.next();
                Long monitorId = (Long)row.get("MONITOR_ID");
                if (monitorList.contains(monitorId)) {
                    row.set("IS_PROFILE_ADDED", (Object)true);
                } else {
                    row.set("IS_PROFILE_ADDED", (Object)false);
                }
                monitorDO.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(monitorDO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void addAlertMonitorMap(Object alertProfileId, ArrayList<Long> monitorIdList, DataObject alertProfileDO) {
        try {
            for (Long object : monitorIdList) {
                Row alertMonitorMapRow = new Row("AUDAlertMonitorMap");
                alertMonitorMapRow.set("ALERT_PROFILE_ID", alertProfileId);
                alertMonitorMapRow.set("MONITOR_ID", (Object)object);
                alertProfileDO.addRow(alertMonitorMapRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void scheduleUserNameAlerts() {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            HashMap userNameMap1;
            int i;
            Table table = Table.getTable((String)"AUDAlertUserCriteria");
            ArrayList userNameList = new ArrayList();
            ArrayList groupNameList = new ArrayList();
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertUserCriteria", (String)"ALERTPROFILE_ID"), null, 1);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertUserCriteria", (String)"*"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                String guid = (String)dataSet.getValue("OBJECT_GUID");
                String className = (String)dataSet.getValue("OBJECT_CLASS");
                String DomainName = (String)dataSet.getValue("DOMAIN_NAME");
                Row dirObjectRow = DirectoryObjectAPI.getInstance().getObjectRow(DomainName, guid, className);
                if (dirObjectRow == null) continue;
                HashMap<String, Object> objectMap = new HashMap<String, Object>();
                objectMap.put("OBJECT_GUID", guid);
                objectMap.put("NAME", dirObjectRow.get("NAME"));
                objectMap.put("username_id", (Long)dataSet.getValue("USERNAME_ID"));
                objectMap.put("domain_name", (String)dataSet.getValue("DOMAIN_NAME"));
                objectMap.put("object_class", (String)dataSet.getValue("OBJECT_CLASS"));
                if (className.equalsIgnoreCase("User")) {
                    userNameList.add(objectMap);
                    continue;
                }
                groupNameList.add(objectMap);
            }
            DataObject alertProfileDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (i = 0; i < userNameList.size(); ++i) {
                userNameMap1 = (HashMap)userNameList.get(i);
                AlertProfileHandler.scheduleUserNameMapAlerts(userNameMap1, alertProfileDO);
            }
            for (i = 0; i < groupNameList.size(); ++i) {
                userNameMap1 = (HashMap)groupNameList.get(i);
                AlertProfileHandler.scheduleUserNameMapAlerts(userNameMap1, alertProfileDO);
            }
            CommonUtil.getPersistence(new boolean[0]).add(alertProfileDO);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static final void scheduleUserNameMapAlerts(HashMap userNameMap, DataObject alertProfileDO) {
        try {
            AlertProfileHandler.deleteCallerUserNameNotification(userNameMap.get("username_id"), "AUDCallerUserNameMap");
            ArrayList<Row> rowList = AlertProfileHandler.getCriteriaResult((String)userNameMap.get("domain_name"), userNameMap.get("username_id"), (String)userNameMap.get("OBJECT_GUID"), (String)userNameMap.get("object_class"), 1L, (String)userNameMap.get("NAME"));
            for (Row row : rowList) {
                alertProfileDO.addRow(row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void addCallerUserName(HashMap userNameMap, DataObject alertProfileDO, Object alertProfileId, Long categoryId, String domainName) {
        try {
            Set objectClasses = userNameMap.keySet();
            for (String objectClass : objectClasses) {
                ArrayList objectsList = (ArrayList)userNameMap.get(objectClass);
                for (Object object : objectsList) {
                    HashMap objectMap = (HashMap)object;
                    String guid = (String)objectMap.get("OBJECT_GUID");
                    Row CallerUserNameRow = new Row("AUDAlertUserCriteria");
                    CallerUserNameRow.set("ALERTPROFILE_ID", alertProfileId);
                    UniqueValueHolder criteriaId = (UniqueValueHolder)CallerUserNameRow.get("USERNAME_ID");
                    CallerUserNameRow.set("USERNAME_ID", (Object)criteriaId);
                    CallerUserNameRow.set("OBJECT_GUID", (Object)guid);
                    CallerUserNameRow.set("DOMAIN_NAME", (Object)domainName);
                    CallerUserNameRow.set("OBJECT_CLASS", (Object)objectClass);
                    ArrayList<Row> rowList = AlertProfileHandler.getCriteriaResult(domainName, criteriaId, guid, objectClass, categoryId, (String)objectMap.get("NAME"));
                    for (Row row : rowList) {
                        alertProfileDO.addRow(row);
                    }
                    alertProfileDO.addRow(CallerUserNameRow);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void addAudNotification(HashMap<String, Object> notificationMap, DataObject alertProfileDO) {
        try {
            notificationTableRow = new Row("AUDNotification");
            Set<String> keySet = notificationMap.keySet();
            for (String object : keySet) {
                notificationTableRow.set(object, notificationMap.get(object));
            }
            alertProfileDO.addRow(notificationTableRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void addAudThresholdNotification(HashMap<String, Object> thresholdMap, DataObject alertProfileDO) {
        try {
            Row thresholdRow = new Row("AUDAlertThresold");
            Set<String> keySet = thresholdMap.keySet();
            for (String object : keySet) {
                thresholdRow.set(object, thresholdMap.get(object));
            }
            alertProfileDO.addRow(thresholdRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void addCriteriaRow(DataObject alertProfileDO, LinkedHashMap<Integer, HashMap> criteriaMap) throws Exception {
        Row alertProfRow = alertProfileDO.getFirstRow("AUDAlertProfile");
        AlertProfileHandler.addCriteriaRow(alertProfRow.get("ALERT_PROFILE_ID"), alertProfileDO, criteriaMap);
    }

    public static final void addCriteriaRow(Object alertProfileId, DataObject alertProfileDO, LinkedHashMap<Integer, HashMap> criteriaMap) {
        try {
            Set<Integer> keys = criteriaMap.keySet();
            int priorityId = 1;
            for (Integer obj : keys) {
                HashMap detailsMap = criteriaMap.get(obj);
                Row row = ReportUtil.formRow("AUDAlertProfileFilterMapping", new String[]{"ALERT_PROFILE_ID", "COLUMN_ID", "RELATIONAL_OPERATOR", "LOGICAL_OPERATOR", "PRIORITY_ID"}, new Object[]{alertProfileId, Long.parseLong((String)detailsMap.get("columnField")), Long.parseLong((String)detailsMap.get("relOper")), detailsMap.get("logicalOper"), priorityId});
                String objectClass = (String)detailsMap.get("objectClass");
                if (objectClass == null || "".equalsIgnoreCase(objectClass)) {
                    row.set("VALUE", detailsMap.get("names"));
                } else {
                    row.set("VALUE", (Object)(objectClass + ";;;" + detailsMap.get("objectGuidStr")));
                }
                alertProfileDO.addRow(row);
                ++priorityId;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void addBusinessHourAlert(HashMap businessAlertMap, DataObject alertProfileDO, Object apId) {
        try {
            Row BusinessAlertRow = alertProfileDO.getRow("AUDAlertProfile");
            int businessHourValue = 0;
            if (businessAlertMap != null) {
                businessHourValue = businessAlertMap.get("included") != null ? 2 : 1;
            }
            BusinessAlertRow.set("IS_BUSINESS_HOUR_ENABLED", (Object)businessHourValue);
            alertProfileDO.updateRow(BusinessAlertRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Row> getCriteriaResult(String domainName, Object criteriaId, String guid, String objectClass, Object categoryId, String userNames) {
        ArrayList<Row> rowList = new ArrayList<Row>();
        try {
            ObjectClass resultObject = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId).getResultObjectClass();
            String resultObjectClass = resultObject.getObjectClass();
            ArrayList criteiaResultObjectList = DirectoryObjectAPI.getInstance().getChildObjects(domainName, objectClass, resultObjectClass, guid);
            if (!objectClass.equalsIgnoreCase("user")) {
                for (Object object2 : criteiaResultObjectList) {
                    HashMap hashMap = (HashMap)object2;
                    Row monitorCriteriaResultRow = new Row("AUDCallerUserNameMap");
                    monitorCriteriaResultRow.set("USERNAME_ID", criteriaId);
                    monitorCriteriaResultRow.set("CRITERIA_OBJECT", hashMap.get("SAM_ACCOUNT_NAME"));
                    rowList.add(monitorCriteriaResultRow);
                }
            } else {
                Row monitorCriteriaResultRow = new Row("AUDCallerUserNameMap");
                monitorCriteriaResultRow.set("USERNAME_ID", criteriaId);
                monitorCriteriaResultRow.set("CRITERIA_OBJECT", (Object)AlertProfileHandler.getSamAccountName(domainName, userNames));
                rowList.add(monitorCriteriaResultRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowList;
    }

    public static String getSamAccountName(String domainName, String userName) {
        Row row = null;
        try {
            row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, userName, "NAME", "user");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row == null ? userName : (String)row.get("SAM_ACCOUNT_NAME");
    }

    public static final boolean deleteAlertMonitorMap(Object alertProfileId) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertMonitorMap", (String)"ALERT_PROFILE_ID"), alertProfileId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDAlertMonitorMap");
            tablesList.add("AUDMonitor");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, criteria);
            Iterator iterator = dataObject.getRows("AUDMonitor");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("IS_PROFILE_ADDED", (Object)false);
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            CommonUtil.getPersistenceLite().delete(criteria);
            MonitorManager.getInstance().getMonitors(null);
            status = true;
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public static final boolean deleteCallerUserNameNotification(Object alertProfileId, String tableName) {
        boolean deletestatus = true;
        try {
            Criteria CallerUserNameCriteria1 = new Criteria(Column.getColumn((String)tableName, (String)"USERNAME_ID"), alertProfileId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, CallerUserNameCriteria1);
            if (dataObject != null) {
                CommonUtil.getPersistenceLite().delete(CallerUserNameCriteria1);
            }
        }
        catch (Exception e) {
            deletestatus = false;
            e.printStackTrace();
        }
        return deletestatus;
    }

    public static final boolean deleteThresholdNotification(Object alertProfileId) {
        boolean deletestatus = true;
        try {
            Criteria thresholdCriteria = new Criteria(Column.getColumn((String)"AUDAlertThresold", (String)"ALERTPROFILE_ID"), alertProfileId, 0);
            CommonUtil.getPersistenceLite().delete(thresholdCriteria);
        }
        catch (Exception e) {
            deletestatus = false;
            e.printStackTrace();
        }
        return deletestatus;
    }

    public static final boolean deleteBusinessNotification(Object alertProfileId) {
        boolean deletestatus = true;
        try {
            Criteria BusinessAlertCriteria = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), alertProfileId, 0);
            if (BusinessAlertCriteria != null) {
                CommonUtil.getPersistenceLite().delete(BusinessAlertCriteria);
            }
        }
        catch (Exception e) {
            deletestatus = false;
            e.printStackTrace();
        }
        return deletestatus;
    }

    public static final boolean deleteAlertNotification(Object notificationId) {
        boolean deletestatus = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDNotification", (String)"NOTIFICATIONID"), notificationId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            deletestatus = false;
            e.printStackTrace();
        }
        return deletestatus;
    }

    public static final boolean updateAlertProfileByOptions(Long[] alertProfileId, String action, String values) {
        String isMailNotification;
        if (values.contains(",isMailNotification=true")) {
            isMailNotification = "true";
            values = values.replace(",isMailNotification=true", "");
        } else {
            isMailNotification = "false";
            values = values.replace(",isMailNotification=false", "");
        }
        boolean status = false;
        try {
            if (action.equals("mailCheck")) {
                int i;
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 8);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertNotificationMap", criteria);
                if (dataObject.isEmpty()) {
                    for (i = 0; i < alertProfileId.length; ++i) {
                        Row row = new Row("AUDAlertNotificationMap");
                        row.set("ALERTPROFILE_ID", (Object)alertProfileId[i]);
                        dataObject.addRow(row);
                        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                    }
                } else {
                    for (i = 0; i < alertProfileId.length; ++i) {
                        Criteria criteria1 = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId[i], 0);
                        Row row = dataObject.getRow("AUDAlertNotificationMap", criteria1);
                        if (row == null) {
                            row = new Row("AUDAlertNotificationMap");
                            row.set("ALERTPROFILE_ID", (Object)alertProfileId[i]);
                            dataObject.addRow(row);
                        }
                        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                    }
                }
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 8);
                DataObject dataObject1 = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertProfile", criteria2);
                Iterator itr1 = dataObject1.getRows("AUDAlertProfile");
                HashMap<String, Object> propsMap = new HashMap<String, Object>();
                boolean i2 = false;
                while (itr1.hasNext()) {
                    Row alertProfileRow = (Row)itr1.next();
                    alertProfileRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
                    propsMap.put("ALERT_PROFILE_NAME", RB.getString(String.valueOf(alertProfileRow.get("ALERT_PROFILE_NAME"))));
                    propsMap.put("ALERT_PROFILE_DESCRIPTION", alertProfileRow.get("ALERT_PROFILE_DESCRIPTION"));
                    propsMap.put("ALERT_MESSAGE", alertProfileRow.get("ALERT_MESSAGE"));
                    propsMap.put("SEVERITY", alertProfileRow.get("SEVERITY"));
                    propsMap.put("MODIFICATION_TIME", alertProfileRow.get("MODIFICATION_TIME"));
                    propsMap.put("CRITERIA_PATTERN", alertProfileRow.get("CRITERIA_PATTERN") != null ? alertProfileRow.get("CRITERIA_PATTERN") : "-");
                    dataObject1.updateRow(alertProfileRow);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObject1);
                    AlertProfileAPI.getInstance().updateAlertProfileRowInMap((Long)alertProfileRow.get("ALERT_PROFILE_ID"), propsMap);
                }
                Long notificationId = 0L;
                HashMap<String, Object> notificationMap = null;
                DataObject alertNotificationDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Iterator itr = dataObject.getRows("AUDAlertNotificationMap");
                while (itr.hasNext()) {
                    Row notificationRow = (Row)itr.next();
                    HashMap<String, Object> propsMap1 = new HashMap<String, Object>();
                    propsMap1.put("IS_MAIL_NOTIFICATION", isMailNotification);
                    propsMap1.put("TO_ADDRESS", values);
                    Criteria criteriaforMail = new Criteria(Column.getColumn((String)"AUDNotification", (String)"NOTIFICATIONID"), notificationRow.get("NOTIFICATION_ID"), 0);
                    DataObject dataObjectforMail = CommonUtil.getPersistence(new boolean[0]).get("AUDNotification", criteriaforMail);
                    Row r = dataObjectforMail.getRow("AUDNotification");
                    if (r != null) {
                        propsMap1.put("MAIL_SUBJECT", (String)r.get("MAIL_SUBJECT"));
                        propsMap1.put("BODY_CONTENT_TYPE", (String)r.get("BODY_CONTENT_TYPE"));
                        propsMap1.put("ALERT_MSG_NEEDED", (Boolean)r.get("ALERT_MSG_NEEDED"));
                        propsMap1.put("EVT_DETAILS_NEEDED", (Boolean)r.get("EVT_DETAILS_NEEDED"));
                    } else {
                        propsMap1.put("MAIL_SUBJECT", "");
                        propsMap1.put("BODY_CONTENT_TYPE", "html");
                        propsMap1.put("ALERT_MSG_NEEDED", true);
                        propsMap1.put("EVT_DETAILS_NEEDED", true);
                    }
                    Criteria criterianew = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), notificationRow.get("ALERTPROFILE_ID"), 0);
                    notificationId = (Long)notificationRow.get("NOTIFICATION_ID");
                    if (isMailNotification.equals("false")) {
                        if (!AlertProfileHandler.deleteAlertNotification(notificationId)) continue;
                        CommonUtil.getPersistenceLite().delete(criterianew);
                        NotificationAPI.getInstance().updateNotificationMap(notificationId, propsMap1);
                        AlertProfileAPI.getInstance().updateAlertProfileRowInMap(Long.valueOf(String.valueOf(notificationRow.get("ALERTPROFILE_ID"))), propsMap1);
                        continue;
                    }
                    if (!AlertProfileHandler.deleteAlertNotification(notificationId)) continue;
                    notificationMap = AlertProfileHandler.getNotification(notificationId, propsMap1);
                    AlertProfileHandler.addAudNotification(notificationMap, alertNotificationDO);
                    CommonUtil.getPersistence(new boolean[0]).update(alertNotificationDO);
                    NotificationAPI.getInstance().updateNotificationMap(notificationId, propsMap1);
                }
                CommonUtil.getPersistence(new boolean[0]).update(alertNotificationDO);
                status = true;
            } else if (action.equals("Disable") || action.equals("Enable")) {
                boolean b = AlertProfileAPI.getInstance().enableDisableAlertProfile(alertProfileId, action);
                status = true;
            } else if (action.equals("Delete") && AlertProfileHandler.deleteNotificationAndMap(alertProfileId)) {
                status = AlertProfileHandler.deleteAlertProfile(alertProfileId);
            }
            MonitorManager.getInstance().updateAlertProfileInMonitorMap(alertProfileId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static final boolean updateAlertProfile(Object alertProfileId, HashMap<String, HashMap> map, ArrayList<Long> monitorIdList) {
        boolean status = false;
        try {
            Row row = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertProfile", new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), alertProfileId, 0)).getRow("AUDAlertProfile");
            Row DomaineNamerow = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertMonitorMap", new Criteria(Column.getColumn((String)"AUDAlertMonitorMap", (String)"ALERT_PROFILE_ID"), alertProfileId, 0)).getRow("AUDAlertMonitorMap");
            String domainName = map.get("AlertCriteriaDetails") != null ? "" : (map.get("PrinterCriteriaDetails") != null ? "" : AlertProfileHandler.getDomainName((Long)DomaineNamerow.get("MONITOR_ID")));
            Long creationTime = (Long)row.get("CREATION_TIME");
            DataObject alertMonitorDO = null;
            if (AlertProfileHandler.deleteAlertMonitorMap(alertProfileId)) {
                alertMonitorDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                AlertProfileHandler.addAlertMonitorMap(alertProfileId, monitorIdList, alertMonitorDO);
            }
            DataObject alertProfileDO = null;
            if (map.get("AlertCriteriaDetails") != null) {
                HashMap gpoPropMap = map.get("AlertCriteriaDetails");
                if (AlertProfileHandler.deleteAlertCriteria(alertProfileId)) {
                    alertProfileDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    AlertProfileHandler.addAlertCriteria(alertProfileId, gpoPropMap, alertProfileDO);
                }
                domainName = (String)gpoPropMap.get("DOMAIN_NAME");
            }
            if (map.get("PrinterCriteriaDetails") != null && map.get("PrinterCriteriaDetails").size() > 0) {
                alertProfileDO = PrintAlertProfileHandler.updatePrintAlertProfile(alertProfileId, map.get("PrinterCriteriaDetails"), domainName);
            }
            HashMap propsMap = map.get("AlertProfileDetails");
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row alertProfileRow = new Row("AUDAlertProfile");
            Set keySet = propsMap.keySet();
            alertProfileRow.set("ALERT_PROFILE_ID", alertProfileId);
            alertProfileRow.set("CREATION_TIME", (Object)creationTime);
            for (String string : keySet) {
                alertProfileRow.set(string, propsMap.get(string));
            }
            HashMap businessAlertMap = map.get("BusinessHourMap");
            int businessHourValue = 0;
            if (businessAlertMap != null) {
                businessHourValue = businessAlertMap.get("included") != null ? 2 : 1;
            }
            alertProfileRow.set("IS_BUSINESS_HOUR_ENABLED", (Object)businessHourValue);
            dataObj.addRow(alertProfileRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            HashMap thresholdMap = map.get("ThresholdProfileDetails");
            DataObject thresholdNotificationDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            HashMap selectedObjectsMap = map.get("callerUserName");
            Criteria thresholdCriteria = new Criteria(Column.getColumn((String)"AUDAlertThresold", (String)"ALERTPROFILE_ID"), alertProfileId, 0);
            DataObject thresholdDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertThresold", thresholdCriteria);
            if ((HashMap)selectedObjectsMap.get("selectedObjectsMap") != null) {
                Criteria CallerUserNameCriteria1 = new Criteria(Column.getColumn((String)"AUDAlertUserCriteria", (String)"ALERTPROFILE_ID"), alertProfileId, 0);
                DataObject callerUserProfileDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                AlertProfileHandler.addCallerUserName((HashMap)selectedObjectsMap.get("selectedObjectsMap"), callerUserProfileDO, alertProfileId, 1L, domainName);
                CommonUtil.getPersistence(new boolean[0]).add(callerUserProfileDO);
            }
            if (thresholdMap != null) {
                if (!thresholdDataObject.isEmpty()) {
                    if (Boolean.valueOf(thresholdMap.get("IS_THRESHOLD_NOTIFICATION").toString()).booleanValue() && AlertProfileHandler.deleteThresholdNotification(alertProfileId)) {
                        AlertProfileHandler.addAudThresholdNotification(AlertProfileHandler.getThresholdNotification(alertProfileId, thresholdMap), thresholdNotificationDO);
                        CommonUtil.getPersistence(new boolean[0]).add(thresholdNotificationDO);
                    } else {
                        AlertProfileHandler.deleteThresholdNotification(alertProfileId);
                    }
                } else if (Boolean.valueOf(thresholdMap.get("IS_THRESHOLD_NOTIFICATION").toString()).booleanValue()) {
                    AlertProfileHandler.addAudThresholdNotification(AlertProfileHandler.getThresholdNotification(alertProfileId, thresholdMap), thresholdNotificationDO);
                    CommonUtil.getPersistence(new boolean[0]).add(thresholdNotificationDO);
                }
            }
            HashMap propsMap1 = map.get("NotificationProfileDetails");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), alertProfileId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertNotificationMap", criteria);
            Long notificationId = 0L;
            DataObject alertNotificationDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            HashMap<String, Object> notificationMap = null;
            if (!dataObject.isEmpty()) {
                Iterator itr = dataObject.getRows("AUDAlertNotificationMap");
                while (itr.hasNext()) {
                    Row notificationRow = (Row)itr.next();
                    notificationId = (Long)notificationRow.get("NOTIFICATION_ID");
                    propsMap1.remove("alertProfileId");
                }
                if (Boolean.valueOf(propsMap1.get("IS_MAIL_NOTIFICATION").toString()).booleanValue()) {
                    if (AlertProfileHandler.deleteAlertNotification(notificationId)) {
                        notificationMap = AlertProfileHandler.getNotification(notificationId, propsMap1);
                        AlertProfileHandler.addAudNotification(notificationMap, alertNotificationDO);
                    }
                } else if (AlertProfileHandler.deleteAlertNotification(notificationId)) {
                    CommonUtil.getPersistenceLite().delete(criteria);
                }
            } else if (Boolean.valueOf(propsMap1.get("IS_MAIL_NOTIFICATION").toString()).booleanValue()) {
                Row row1 = new Row("AUDAlertNotificationMap");
                row1.set("ALERTPROFILE_ID", alertProfileId);
                UniqueValueHolder uniqueValueHolder = (UniqueValueHolder)row1.get("NOTIFICATION_ID");
                notificationMap = AlertProfileHandler.getNotification(uniqueValueHolder, propsMap1);
                AlertProfileHandler.addAudNotification(notificationMap, alertNotificationDO);
                alertNotificationDO.addRow(row1);
            }
            if (alertMonitorDO != null) {
                CommonUtil.getPersistence(new boolean[0]).add(alertMonitorDO);
                AlertProfileHandler.setIsProfileAdded();
            }
            if (map.get("filterDetails") != null) {
                logger.log(Level.INFO, "Going to delete Alert Filter");
                CommonUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"AUDAlertProfileFilterMapping", (String)"ALERT_PROFILE_ID"), alertProfileId, 0));
                DataObject alertFilterDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                AlertProfileHandler.addCriteriaRow(alertProfileId, alertFilterDO, (LinkedHashMap)map.get("filterDetails"));
                CommonUtil.getPersistence(new boolean[0]).add(alertFilterDO);
                propsMap.put("filterDetails", AlertProfileAPI.getInstance().getFilterDetails(alertFilterDO));
            }
            MonitorManager.getInstance().getMonitors(null);
            if (alertProfileDO != null) {
                CommonUtil.getPersistence(new boolean[0]).add(alertProfileDO);
            }
            if (!alertNotificationDO.isEmpty()) {
                CommonUtil.getPersistence(new boolean[0]).add(alertNotificationDO);
                Row notificationRow = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertNotificationMap", new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), alertProfileId, 0)).getRow("AUDAlertNotificationMap");
                notificationId = (Long)notificationRow.get("NOTIFICATION_ID");
            }
            AlertProfileAPI.getInstance().updateAlertProfileRowInMap((Long)alertProfileId, propsMap);
            NotificationAPI.getInstance().updateNotificationMap(notificationId, propsMap1);
            status = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static final HashMap<String, Object> getNotification(Object notificationId, HashMap<String, Object> propsMap) {
        HashMap<String, Object> notificationMap = new HashMap<String, Object>();
        try {
            notificationMap.put("NOTIFICATIONID", notificationId);
            notificationMap.put("NOTIFICATION_TYPE", "E-Mail");
            notificationMap.put("TO_ADDRESS", propsMap.get("TO_ADDRESS"));
            notificationMap.put("MAIL_SUBJECT", propsMap.get("MAIL_SUBJECT"));
            notificationMap.put("BODY_CONTENT_TYPE", propsMap.get("BODY_CONTENT_TYPE") == null ? "html" : propsMap.get("BODY_CONTENT_TYPE"));
            notificationMap.put("ALERT_MSG_NEEDED", propsMap.get("ALERT_MSG_NEEDED") == null ? Boolean.valueOf(true) : propsMap.get("ALERT_MSG_NEEDED"));
            notificationMap.put("EVT_DETAILS_NEEDED", propsMap.get("EVT_DETAILS_NEEDED") == null ? Boolean.valueOf(true) : propsMap.get("EVT_DETAILS_NEEDED"));
            notificationMap.put("ADDNL_MAIL_ADDRESSES", propsMap.get("ADDNL_MAIL_ADDRESSES"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notificationMap;
    }

    public static final HashMap<String, Object> getThresholdNotification(Object alertProfileId, HashMap<String, Object> propsMap) {
        HashMap<String, Object> thresholdMap = new HashMap<String, Object>();
        try {
            thresholdMap.put("ALERTPROFILE_ID", alertProfileId);
            thresholdMap.put("TIME_INTERVAL", propsMap.get("TIME_INTERVAL"));
            thresholdMap.put("THRES_COUNT", propsMap.get("THRES_COUNT"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thresholdMap;
    }

    public static final boolean deleteNotificationAndMap(Long[] alertProfileId) {
        boolean deletestatus = false;
        ArrayList<Long> notificationIdList = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertNotificationMap", criteria);
            Long notificationId = 0L;
            if (!dataObject.isEmpty()) {
                Iterator itr = dataObject.getRows("AUDAlertNotificationMap");
                while (itr.hasNext()) {
                    Row notificationRow = (Row)itr.next();
                    notificationId = (Long)notificationRow.get("NOTIFICATION_ID");
                    notificationIdList.add(notificationId);
                }
                deletestatus = true;
                CommonUtil.getPersistenceLite().delete(criteria);
                AlertProfileAPI.getInstance().deleteAlertProfileRowInMap(notificationId);
                NotificationAPI.getInstance().deleteNotificationInMap(notificationIdList);
            } else {
                deletestatus = true;
            }
        }
        catch (Exception e) {
            deletestatus = false;
            e.printStackTrace();
        }
        return deletestatus;
    }

    public static final boolean copyAlertProfile(Long alertProfileId, String alertProfileName) {
        boolean status = false;
        try {
            DataObject dataObject = AlertProfileHandler.getAlertProfileDO(alertProfileId);
            if (dataObject != null && !dataObject.isEmpty()) {
                DataObject toBeAddedAlertProfileDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row alertProfileRow = dataObject.getRow("AUDAlertProfile");
                Row toBeAddedAlertProfileRow = new Row("AUDAlertProfile");
                toBeAddedAlertProfileRow.set("ALERT_PROFILE_NAME", (Object)alertProfileName);
                toBeAddedAlertProfileRow.set("PROFILE_TYPE", alertProfileRow.get("PROFILE_TYPE"));
                toBeAddedAlertProfileRow.set("ALERT_MESSAGE", alertProfileRow.get("ALERT_MESSAGE"));
                toBeAddedAlertProfileRow.set("SEVERITY", alertProfileRow.get("SEVERITY"));
                toBeAddedAlertProfileDO.addRow(toBeAddedAlertProfileRow);
                UniqueValueHolder alertProfileIdHolder = (UniqueValueHolder)toBeAddedAlertProfileRow.get("ALERT_PROFILE_ID");
                Iterator iterator = dataObject.getRows("AUDAlertMonitorMap");
                while (iterator.hasNext()) {
                    Row alertMonitorRow = (Row)iterator.next();
                    Row toBeAddedAlertMonitorRow = new Row("AUDAlertMonitorMap");
                    toBeAddedAlertMonitorRow.set("ALERT_PROFILE_ID", (Object)alertProfileIdHolder);
                    toBeAddedAlertMonitorRow.set("MONITOR_ID", alertMonitorRow.get("MONITOR_ID"));
                    toBeAddedAlertProfileDO.addRow(toBeAddedAlertMonitorRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(toBeAddedAlertProfileDO);
                status = true;
                MonitorManager.getInstance().getMonitors(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static final boolean deleteAlertProfile(Long[] alertProfileId) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
            AlertProfileHandler.setIsProfileAdded();
            status = AlertProfileHandler.deleteAlerts(alertProfileId);
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public static final boolean deleteAlerts(Long[] alertProfileId) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlert", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
            status = true;
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public static final DataObject getAlertProfileDO(Long alertProfileId) {
        DataObject alertProfileDO = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDAlertProfile");
            tablesList.add("AUDAlertMonitorMap");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDAlertMonitorMap");
            alertProfileDO = CommonUtil.getPersistence(new boolean[0]).get(tablesList, leftJoinList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertProfileDO;
    }

    public static final HashMap<String, Object> getAlertProfile(Long alertProfileId) {
        HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
        try {
            DataObject alertProfileDO = AlertProfileHandler.getAlertProfileDO(alertProfileId);
            Row alertProfileRow = alertProfileDO.getRow("AUDAlertProfile");
            List ColumnsList = alertProfileRow.getColumns();
            for (String string : ColumnsList) {
                if (string.equalsIgnoreCase("ALERT_PROFILE_DESCRIPTION") || string.equals("ALERT_PROFILE_NAME")) {
                    alertProfileMap.put(string, RB.getString((String)alertProfileRow.get(string)));
                    continue;
                }
                alertProfileMap.put(string, alertProfileRow.get(string));
            }
            ArrayList<Long> monitorList = new ArrayList<Long>();
            Iterator iterator = alertProfileDO.getRows("AUDAlertMonitorMap");
            while (iterator.hasNext()) {
                Row alertMonitorRow = (Row)iterator.next();
                monitorList.add((Long)alertMonitorRow.get("MONITOR_ID"));
            }
            alertProfileMap.put("monitorList", monitorList);
            alertProfileMap.put("thresholdDetails", AlertProfileHandler.getThresHoldNotification(alertProfileId));
            alertProfileMap.put("UserNameAlert", AlertProfileHandler.getAlertDetails(alertProfileId));
            alertProfileMap.put("businessHourDetails", AlertProfileHandler.getBusinessAlertDetails(alertProfileId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertProfileMap;
    }

    public static final HashMap<String, Object> getAlertNotification(Long alertProfileId) {
        HashMap<String, Object> notificationMap = new HashMap<String, Object>();
        String toAddress = "";
        try {
            DataObject alertNotificationDO = AlertProfileHandler.getNotificationDO(alertProfileId);
            Iterator itr = alertNotificationDO.getRows("AUDNotification");
            while (itr.hasNext()) {
                Row notificationRow = (Row)itr.next();
                notificationMap.put("toAddress", (String)notificationRow.get("TO_ADDRESS"));
                notificationMap.put("MAIL_SUBJECT", (String)notificationRow.get("MAIL_SUBJECT"));
                notificationMap.put("BODY_CONTENT_TYPE", (String)notificationRow.get("BODY_CONTENT_TYPE"));
                notificationMap.put("ALERT_MSG_NEEDED", (Boolean)notificationRow.get("ALERT_MSG_NEEDED"));
                notificationMap.put("EVT_DETAILS_NEEDED", (Boolean)notificationRow.get("EVT_DETAILS_NEEDED"));
                notificationMap.put("ADDNL_MAIL_ADDRESSES", (String)notificationRow.get("ADDNL_MAIL_ADDRESSES"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notificationMap;
    }

    public static final HashMap<String, Integer> getThresHoldNotification(Long alertProfileId) {
        HashMap<String, Integer> thresholdMap = new HashMap<String, Integer>();
        int thresholdInterval = 0;
        try {
            DataObject thresholdNotificationDO = AlertProfileHandler.getThresholdDO(alertProfileId);
            Iterator itr = thresholdNotificationDO.getRows("AUDAlertThresold");
            while (itr.hasNext()) {
                Row thresholdRow = (Row)itr.next();
                thresholdInterval = (Integer)thresholdRow.get("TIME_INTERVAL");
                int thresholdCount = (Integer)thresholdRow.get("THRES_COUNT");
                thresholdMap.put("thresholdInterval", thresholdInterval);
                thresholdMap.put("thresholdCount", thresholdCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thresholdMap;
    }

    public static final DataObject getThresholdDO(Long alertProfileId) {
        DataObject alertNotificationDO = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertThresold", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDAlertThresold");
            alertNotificationDO = CommonUtil.getPersistence(new boolean[0]).get(tablesList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertNotificationDO;
    }

    public static final DataObject getNotificationDO(Long alertProfileId) {
        DataObject alertNotificationDO = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertNotificationMap", (String)"ALERTPROFILE_ID"), (Object)alertProfileId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDAlertNotificationMap");
            tablesList.add("AUDNotification");
            alertNotificationDO = CommonUtil.getPersistence(new boolean[0]).get(tablesList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertNotificationDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ArrayList<HashMap<String, String>> getAlertVariables() {
        Statement stmt = null;
        Connection con = null;
        ResultSet resultSet = null;
        ArrayList<HashMap<String, String>> variableList = new ArrayList<HashMap<String, String>>();
        try {
            String query = "SELECT DISPLAYNAME,COLUMNALIAS FROM AUDColumnConfiguration GROUP BY DISPLAYNAME,COLUMNALIAS";
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            resultSet = QueryUtil.executeQuery("Alert Variables", stmt, query);
            while (resultSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("columnAlias", resultSet.getString("COLUMNALIAS"));
                map.put("displayName", RB.getString(resultSet.getString("DISPLAYNAME")));
                variableList.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exp) {
                stmt = null;
                exp.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception ex) {
                con = null;
                ex.printStackTrace();
            }
        }
        return variableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final JSONArray getAlertVariables2(ArrayList<Long> reportProfileIds, String objectClass) {
        Statement stmt = null;
        Connection con = null;
        ResultSet resultSet = null;
        JSONArray variableList = new JSONArray();
        try {
            String categoryId = AlertProfileHandler.getCategoryIdsFromMonitor(reportProfileIds);
            if (!"".equals(categoryId)) {
                String query = "SELECT COLUMN_DISPLAY_NAME,ELEMENT_ID,COLUMN_NAME,COLUMN_DATA_TYPE,MIN(COLUMN_ID) as COLUMN_ID,EXPECTED_OBJECT_CLASS FROM AUDReportColumns WHERE CATEGORY_ID IN (" + categoryId + ")";
                if (objectClass != null) {
                    query = query + "AND EXPECTED_OBJECT_CLASS IN ('" + objectClass + "')";
                }
                query = query + "AND COLUMN_NAME NOT IN ('TIME_GENERATED') GROUP BY COLUMN_DISPLAY_NAME,COLUMN_NAME,COLUMN_DATA_TYPE,ELEMENT_ID,EXPECTED_OBJECT_CLASS";
                con = RelationalAPI.getInstance().getConnection();
                stmt = con.createStatement();
                resultSet = QueryUtil.executeQuery("Alert Variables", stmt, query);
                while (resultSet.next()) {
                    JSONObject map = new JSONObject();
                    map.put("value", (Object)resultSet.getString("COLUMN_NAME"));
                    map.put("name", (Object)RB.getString(resultSet.getString("COLUMN_DISPLAY_NAME")));
                    map.put("COLUMN_ID", resultSet.getLong("COLUMN_ID"));
                    map.put("ELEMENT_ID", resultSet.getLong("ELEMENT_ID"));
                    map.put("COLUMN_DATA_TYPE", resultSet.getLong("COLUMN_DATA_TYPE"));
                    map.put("EXPECTED_OBJECT_CLASS", (Object)resultSet.getString("EXPECTED_OBJECT_CLASS"));
                    variableList.put((Object)map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exp) {
                stmt = null;
                exp.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception ex) {
                con = null;
                ex.printStackTrace();
            }
        }
        return variableList;
    }

    public static final void addAlertCriteria(Object alertProfileId, HashMap gpoPropMap, DataObject alertProfileDO) {
        try {
            ArrayList objectGuidList = (ArrayList)gpoPropMap.get("GPO_GUIDS");
            String objectClass = (String)gpoPropMap.get("OBJECT_CLASS");
            String domainName = (String)gpoPropMap.get("DOMAIN_NAME");
            for (String object : objectGuidList) {
                Row alertCritRow = new Row("AUDAlertCriteria");
                alertCritRow.set("ALERT_PROFILE_ID", alertProfileId);
                alertCritRow.set("OBJECT_GUID", (Object)object);
                alertCritRow.set("OBJECT_CLASS", (Object)objectClass);
                alertCritRow.set("DOMAIN_NAME", (Object)domainName);
                alertProfileDO.addRow(alertCritRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final boolean deleteAlertCriteria(Object alertProfileId) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertCriteria", (String)"ALERT_PROFILE_ID"), alertProfileId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            status = true;
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    private static String getCategoryIdsFromMonitor(ArrayList<Long> reportProfileIds) throws Exception {
        StringBuilder sb = new StringBuilder();
        Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)reportProfileIds.toArray(), 8);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", crit);
        int i = 0;
        Iterator iter = dObj.getRows("AUDMonitor");
        while (iter.hasNext()) {
            if (i != 0) {
                sb.append(",");
            }
            Row row = (Row)iter.next();
            sb.append(Long.toString((Long)row.get("CATEGORY_ID")));
            ++i;
        }
        return sb.toString();
    }
}

