/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.auditing.server.EventManager;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfile;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.AudColumnConfig;
import com.adventnet.sym.adsm.auditing.server.alert.FaultManager;
import com.adventnet.sym.adsm.auditing.server.monitor.Monitor;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlertProfileManager
extends Observable
implements Observer {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static AlertProfileManager alertProfileManager = null;
    private static Vector<Row> inQ = new Vector();
    private static HashMap<String, Map<Long, Long>> eventUniqueCountMap = new HashMap();
    private static Map<String, HashMap<Integer, Map<Long, Long>>> deletedUniqueMap = new ConcurrentHashMap<String, HashMap<Integer, Map<Long, Long>>>();
    private static HashMap mailPropMap = new HashMap();
    private static HashMap<String, Row[]> rowVectorArray = new HashMap();
    private static HashMap<String, HashMap> mailMap = new HashMap();
    private static Logger logger = Logger.getLogger("ReportLogger");

    private AlertProfileManager() {
        try {
            AlertProfileAPI.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Action().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertProfileManager getInstance() {
        if (alertProfileManager != null) return alertProfileManager;
        Class<AlertProfileManager> clazz = AlertProfileManager.class;
        synchronized (AlertProfileManager.class) {
            if (alertProfileManager != null) return alertProfileManager;
            alertProfileManager = new AlertProfileManager();
            EventManager.getInstance().register(alertProfileManager);
            // ** MonitorExit[var0] (shouldn't be in output)
            return alertProfileManager;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        ArrayList eventRowList = (ArrayList)object;
        this.addEventRow(eventRowList);
    }

    public void register(Observer observer) {
        this.addObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventRow(Vector eventVector) {
        Vector<Row> vector = inQ;
        synchronized (vector) {
            inQ.addAll(eventVector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventRow(ArrayList<Row> eventRowList) {
        Vector<Row> vector = inQ;
        synchronized (vector) {
            for (Row eventRow : eventRowList) {
                try {
                    if (eventRow.getTableName().contains("ACL") || eventRow.getTableName().equalsIgnoreCase("AUDUserLastLogonInfo")) continue;
                    Long monitorId = (Long)eventRow.get("MONITOR_ID");
                    Monitor monitor = MonitorManager.getInstance().getMonitor(monitorId);
                    if (monitor == null || !monitor.isAlertProfileEnabled()) continue;
                    inQ.addElement(eventRow);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean canAlert(String alertMessage, Row eventRow, AlertProfile alertProfile, Boolean isFilterSucceed) {
        int thresHoldCount = 1;
        boolean canSendAlertTemp = false;
        boolean canGo = true;
        boolean canStart = true;
        Map<Long, Long> thresUniqueListMap = eventUniqueCountMap.get(alertMessage);
        ArrayList<Long> eventTimeList = new ArrayList<Long>(thresUniqueListMap.values());
        ArrayList<Long> uniqueIdArrayList = new ArrayList<Long>(thresUniqueListMap.keySet());
        boolean sendThresHold = false;
        int i = 0;
        int start = 0;
        int m = 0;
        for (m = 0; m < eventTimeList.size() && canGo; ++m) {
            thresHoldCount = 1;
            for (i = 1 + m; i < eventTimeList.size(); ++i) {
                Long difference = eventTimeList.get(i) - eventTimeList.get(m);
                if (difference < 0L) {
                    difference = difference * -1L;
                }
                if (eventTimeList.get(m) - eventTimeList.get(i) <= (long)alertProfile.getThresholdInterval() && difference <= (long)alertProfile.getThresholdInterval() && isFilterSucceed.booleanValue()) {
                    ++thresHoldCount;
                    if (canStart) {
                        start = i - 1;
                        canStart = false;
                    }
                }
                if (thresHoldCount <= alertProfile.getThresholdCount() || canSendAlertTemp) continue;
                sendThresHold = true;
                canSendAlertTemp = true;
                int hashIndex = 0;
                TreeMap deletedUniqueTemp = (Integer)eventRow.get("EVENT_NUMBER") > 4000 ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
                HashMap<Integer, Map<Long, Long>> deletedArrayMap = deletedUniqueMap.get(alertMessage);
                for (int k = start; k <= i; ++k) {
                    deletedUniqueTemp.put(uniqueIdArrayList.get(k), eventTimeList.get(k));
                }
                Row[] rows = null;
                if (deletedUniqueMap.get(alertMessage) != null) {
                    rows = rowVectorArray.get(alertMessage);
                    hashIndex = 1;
                } else {
                    deletedArrayMap = new HashMap();
                    eventUniqueCountMap.remove(alertMessage);
                    rows = new Row[2];
                }
                rows[hashIndex] = eventRow;
                deletedArrayMap.put(hashIndex, deletedUniqueTemp);
                rowVectorArray.put(alertMessage, rows);
                deletedUniqueMap.put(alertMessage, deletedArrayMap);
                eventTimeList.subList(start, i + 1).clear();
                uniqueIdArrayList.subList(start, i + 1).clear();
                canGo = false;
                this.sendThresHoldAlertsForDisplay(alertProfile, eventRow, alertMessage);
                break;
            }
            canStart = true;
        }
        if (!sendThresHold) {
            thresUniqueListMap = (Integer)eventRow.get("EVENT_NUMBER") > 4000 ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
            for (i = 0; i < eventTimeList.size(); ++i) {
                thresUniqueListMap.put(uniqueIdArrayList.get(i), eventTimeList.get(i));
            }
            eventUniqueCountMap.put(alertMessage, thresUniqueListMap);
        }
        return canSendAlertTemp;
    }

    public void sendThresHoldAlertsForDisplay(AlertProfile alertProfile, Row eventRow, String alertMessage) {
        try {
            HashMap newMailPropMap;
            Vector<Row> alertRowVector = new Vector<Row>();
            Vector<HashMap> mailPropVector = new Vector<HashMap>();
            HashMap<Integer, Map<Long, Long>> deletedTempMap = deletedUniqueMap.get(alertMessage);
            Map<Long, Long> eventUniqueMap = deletedTempMap.get(0);
            ArrayList<Long> deletedArrayListTemp = new ArrayList<Long>(eventUniqueMap.values());
            ArrayList<Long> uniqueArrayListTemp = new ArrayList<Long>(eventUniqueMap.keySet());
            Long first = deletedArrayListTemp.get(0);
            Long last = deletedArrayListTemp.get(deletedArrayListTemp.size() - 1);
            Long temp = 0L;
            if (last < first) {
                temp = first;
                first = last;
                last = temp;
            }
            HashMap alertProfileMap = mailMap.get(alertMessage);
            String thresholdMailMessage = RB.getString("adap.Threshold.MailMessage1") + uniqueArrayListTemp.size() + " " + RB.getString("adap.Threshold.MailMessage2") + TimeUtil.formatDate(first * 60000L) + " " + RB.getString("adap.Threshold.MailMessage3") + TimeUtil.formatDate(last * 60000L);
            String domain = eventRow.getColumns().contains("DOMAIN") ? (String)eventRow.get("DOMAIN") : (String)eventRow.get("CALLER_USER_DOMAIN");
            Row rowToSend = this.getAlertRow(eventRow, alertProfileMap, domain, 0);
            alertRowVector.add(rowToSend);
            FaultManager.addAlertRows(alertRowVector);
            this.setThresholdData(rowToSend, alertProfile.getThresholdInterval(), uniqueArrayListTemp);
            if (alertProfile.getIsMailEnabled() && !(newMailPropMap = this.checkDuplicateAlerts(eventRow, alertProfileMap, thresholdMailMessage)).isEmpty()) {
                mailPropVector.add(newMailPropMap);
            }
            this.setChanged();
            this.notifyObservers(mailPropVector);
            rowVectorArray.remove(alertMessage);
            mailMap.remove(alertMessage);
            deletedUniqueMap.remove(alertMessage);
            eventUniqueCountMap.remove(alertMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkThresHold(String alertMessage, Long timeGenerated, Long unique, Row eventRow, AlertProfile alertProfile, Boolean isFilterSucceed) {
        TreeMap thresUniqueListMap = eventUniqueCountMap.get(alertMessage) == null ? ((Integer)eventRow.get("EVENT_NUMBER") > 4000 ? new TreeMap(Collections.reverseOrder()) : new TreeMap()) : eventUniqueCountMap.get(alertMessage);
        thresUniqueListMap.put(unique, timeGenerated / 60L);
        eventUniqueCountMap.put(alertMessage, thresUniqueListMap);
        return this.canAlert(alertMessage, eventRow, alertProfile, isFilterSucceed);
    }

    public boolean checkBusinessHours(AlertProfile alertProfile, Long timeGenerated) {
        boolean businessHourAlert = true;
        try {
            int businessValue = alertProfile.getIsBusinessHourEnabled();
            if (businessValue > 0) {
                Date time = new Date(timeGenerated * 1000L);
                HashMap<String, String> businessAlertValues = BusinessServerSettings.getBusinessHourSettings();
                int temp = time.getHours();
                boolean condition = true;
                ArrayList days = new ArrayList();
                String fromTimeString = businessAlertValues.get("FromTime");
                if (!fromTimeString.equalsIgnoreCase("")) {
                    int fromTime = Integer.parseInt(businessAlertValues.get("FromTime"));
                    int toTime = Integer.parseInt(businessAlertValues.get("ToTime"));
                    String[] dayOfWeek = businessAlertValues.get("Days").split(",");
                    Collections.addAll(days, dayOfWeek);
                    String[] Calendardays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
                    if (fromTime > 0) {
                        if (businessValue == 2) {
                            condition = temp >= fromTime && temp <= toTime - 1 && days.contains(Calendardays[time.getDay()]);
                        } else {
                            boolean bl = condition = temp < fromTime || temp > toTime - 1 || !days.contains(Calendardays[time.getDay()]);
                        }
                        if (!condition) {
                            businessHourAlert = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            businessHourAlert = false;
            ex.printStackTrace();
        }
        return businessHourAlert;
    }

    public void processAlertProfiles(Row eventRow, ArrayList<HashMap<String, Object>> alertProfileList, String domainName) {
        Vector<HashMap> mailPropVector = new Vector<HashMap>();
        boolean callerUserAlert = true;
        boolean businessHourAlert = true;
        boolean thresHoldAlert = false;
        boolean isFilter = true;
        try {
            for (HashMap<String, Object> alertProfileMap : alertProfileList) {
                Vector<Row> alertRowVector = new Vector<Row>();
                AlertProfile alertProfile = AlertProfileAPI.getInstance().getAlertProfile(Long.valueOf(alertProfileMap.get("ALERT_PROFILE_ID").toString()));
                DataAccess.generateValues((Row)eventRow);
                Long unique = (Long)eventRow.get("UNIQUE_ID");
                Long timeGenerated = Long.valueOf(eventRow.get("TIME_GENERATED").toString());
                if (alertProfile.hasCallerUserName()) {
                    String userName = eventRow.getColumns().contains("CALLER_USER_NAME") && eventRow.get("CALLER_USER_NAME") != null && !((String)eventRow.get("CALLER_USER_NAME")).equalsIgnoreCase("-") ? (String)eventRow.get("CALLER_USER_NAME") : (eventRow.getColumns().contains("USERNAME") && eventRow.get("USERNAME") != null ? (String)eventRow.get("USERNAME") : (eventRow.getColumns().contains("CLIENT_USER_NAME") ? (String)eventRow.get("CLIENT_USER_NAME") : null));
                    callerUserAlert = userName == null ? false : alertProfile.getCallerUserNameValue().contains(userName.toLowerCase());
                }
                businessHourAlert = this.checkBusinessHours(alertProfile, timeGenerated);
                isFilter = this.checkFilterDetails(eventRow, alertProfile);
                thresHoldAlert = alertProfile.getIsThresholdEnabled();
                String format = (String)alertProfileMap.get("ALERT_MESSAGE");
                if (thresHoldAlert && callerUserAlert && businessHourAlert) {
                    String userName = eventRow.getColumns().contains("USERNAME") ? (String)eventRow.get("USERNAME") : (eventRow.getColumns().contains("CALLER_USER_NAME") ? (String)eventRow.get("CALLER_USER_NAME") : (String)eventRow.get("CLIENT_USER_NAME"));
                    String alertMessage = alertProfile.getId().toString() + (String)eventRow.get("SOURCE") + userName;
                    mailMap.put(alertMessage, alertProfileMap);
                    this.checkThresHold(alertMessage, timeGenerated, unique, eventRow, alertProfile, isFilter);
                }
                if (thresHoldAlert || !callerUserAlert || !businessHourAlert || !isFilter) continue;
                alertRowVector.add(this.getAlertRow(eventRow, alertProfileMap, domainName, 0));
                if (alertProfile.getIsMailEnabled() && alertProfile.getThresholdCount() == 0) {
                    HashMap newMailPropMap = this.checkDuplicateAlerts(eventRow, alertProfileMap, "");
                    if (!newMailPropMap.isEmpty()) {
                        mailPropVector.add(newMailPropMap);
                    }
                    FaultManager.addAlertRows(alertRowVector);
                    continue;
                }
                if (alertProfile.getThresholdCount() != 0) continue;
                FaultManager.addAlertRows(alertRowVector);
            }
            if (mailPropVector.size() > 0) {
                this.setChanged();
                this.notifyObservers(mailPropVector);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap checkDuplicateAlerts(Row eventRow, HashMap<String, Object> alertProfileMap, String thresMessage) {
        HashMap newMailPropMap = new HashMap();
        try {
            String format = (String)alertProfileMap.get("ALERT_MESSAGE");
            String alertMessage = FormatUtil.getFormatMessage(eventRow, format);
            if (mailPropMap.get(alertMessage) == null) {
                mailPropMap.put(alertMessage, Long.valueOf(eventRow.get("TIME_GENERATED").toString()));
                newMailPropMap = this.getMailPropMap(eventRow, alertProfileMap, thresMessage);
                newMailPropMap.put("EVENT_ROW", eventRow);
                return newMailPropMap;
            }
            long oldCreationTime = Long.valueOf(mailPropMap.get(alertMessage).toString());
            long newCreationTime = Long.valueOf(eventRow.get("TIME_GENERATED").toString());
            mailPropMap.put(alertMessage, newCreationTime);
            newMailPropMap = this.getMailPropMap(eventRow, alertProfileMap, thresMessage);
            newMailPropMap.put("EVENT_ROW", eventRow);
            return newMailPropMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return newMailPropMap;
        }
    }

    public HashMap getMailPropMap(Row eventRow, HashMap alertProfileMap, String thresMessage) {
        HashMap<String, Object> newMailPropMap = new HashMap<String, Object>();
        HashMap eventDetailsMap1 = null;
        try {
            Long monitorId = (Long)eventRow.get("MONITOR_ID");
            Monitor monitor = MonitorManager.getInstance().getMonitor(monitorId);
            Long reportId = monitor.getAuditReportId();
            newMailPropMap.put("ALERT_PROFILE_ID", (Long)alertProfileMap.get("ALERT_PROFILE_ID"));
            String format = (String)alertProfileMap.get("ALERT_MESSAGE");
            newMailPropMap.put("ALERT_MESSAGE", FormatUtil.getFormatMessage(eventRow, format));
            newMailPropMap.put("SEVERITY", alertProfileMap.get("SEVERITY"));
            if (thresMessage.length() > 0) {
                newMailPropMap.put("THRESDETAILS", thresMessage);
            }
            if (reportId != null) {
                HashMap eventDetailsMap;
                Long cvId = AUDCustomViewAPI.getInstance().getReportCVIdInMap(reportId);
                if (cvId != null && (eventDetailsMap = AudColumnConfig.getInstance().getColumnAliasDisplayName(cvId)) != null) {
                    Set keySet = eventDetailsMap.keySet();
                    eventDetailsMap1 = new HashMap();
                    for (String key : keySet) {
                        if (eventRow.get(key) != null) {
                            if (key.equals("TIME_GENERATED") || key.equals("CREATION_TIME")) {
                                Long ctMST = (Long)eventRow.get(key);
                                String time = TimeUtil.formatDate(ctMST * 1000L);
                                eventDetailsMap1.put(eventDetailsMap.get(key), time);
                                continue;
                            }
                            eventDetailsMap1.put(eventDetailsMap.get(key), eventRow.get(key));
                            continue;
                        }
                        eventDetailsMap1.put(eventDetailsMap.get(key), "-");
                    }
                }
                newMailPropMap.put("Mail_PROP_MAP", eventDetailsMap1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newMailPropMap;
    }

    public void setThresholdData(Row eventRow, int timeInterval, ArrayList<Long> uniqueIdArrayList) {
        try {
            Long alertId = (Long)eventRow.get("ALERT_ID");
            Long monitorId = (Long)eventRow.get("MONITOR_ID");
            for (int i = 0; i < uniqueIdArrayList.size(); ++i) {
                WritableDataObject d = new WritableDataObject();
                Row r = new Row("AUDAlertThresholdMap");
                r.set("ALERT_ID", (Object)alertId);
                r.set("MONITOR_ID", (Object)monitorId);
                r.set("UNIQUE_ID", (Object)uniqueIdArrayList.get(i));
                r.set("TIME_INTERVAL", (Object)timeInterval);
                d.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add((DataObject)d);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Boolean checkFilterDetails(Row eventRow, AlertProfile alertProfile) {
        Boolean isFilter = true;
        try {
            LinkedHashMap<Integer, HashMap<String, Object>> filterDetails = alertProfile.getFilterDetails();
            if (filterDetails.size() > 0) {
                Set<Integer> strValue = filterDetails.keySet();
                Boolean[] statusMap = new Boolean[filterDetails.size()];
                String filterPattern = alertProfile.getFilterPattern();
                for (Integer priorityId : strValue) {
                    Boolean status;
                    HashMap<String, Object> filterMap = filterDetails.get(priorityId);
                    String columnName = (String)filterMap.get("COLUMN_NAME");
                    Long relOp = (Long)filterMap.get("RELATIONAL_OPERATOR");
                    String logicalOperator = (String)filterMap.get("LOGICAL_OPERATOR");
                    int columnDataType = (Integer)filterMap.get("COLUMN_DATA_TYPE");
                    statusMap[priorityId.intValue() - 1] = status = this.checkEventDetails(eventRow.get(columnName), filterMap.get("VALUE"), relOp, columnDataType);
                }
                isFilter = this.checkStatus(filterPattern, statusMap);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, ex.getMessage());
        }
        return isFilter;
    }

    private Boolean checkStatus(String filterPattern, Boolean[] statusMap) throws Exception {
        filterPattern = filterPattern.replace("(", " ( ").replace(")", " ) ").trim();
        Boolean isFilter = true;
        isFilter = statusMap.length > 1 ? Boolean.valueOf(ReportUtil.checkFilter(filterPattern, statusMap)) : statusMap[0];
        return isFilter;
    }

    private Boolean checkEventDetails(Object colValue, Object filterValue, Long relOp, int columnDataType) throws Exception {
        Boolean status = false;
        String[] filValues = filterValue.toString().split(",");
        for (int i = 0; i < filValues.length; ++i) {
            String temp = filValues[i].toString().trim();
            status = columnDataType == 1001 || columnDataType == 1005 ? Boolean.valueOf(ReportUtil.compareStringValues(colValue, temp, relOp.intValue())) : Boolean.valueOf(ReportUtil.compareNumericValues(colValue, temp, relOp.intValue()));
            if (status.booleanValue()) break;
        }
        return status;
    }

    public Row getAlertRow(Row eventRow, HashMap<String, Object> alertProfileMap, String domainName, int alertType) {
        Boolean gpo = false;
        Boolean printer = false;
        Row alertRow = new Row("AUDAlert");
        try {
            if (alertType != 0) {
                gpo = alertType == 1;
                printer = gpo == false;
            }
            printer = alertType != 0 ? alertType == 2 : false;
            String format = RB.getString((String)alertProfileMap.get("ALERT_MESSAGE"));
            Long monitorId = 0L;
            if (!gpo.booleanValue() && !printer.booleanValue()) {
                monitorId = (Long)eventRow.get("MONITOR_ID");
            }
            if (printer.booleanValue()) {
                monitorId = 0L;
                alertRow.set("ALERT_MESSAGE", (Object)(" The document " + (String)eventRow.get("FILE_NAME") + " was printed by  " + (String)eventRow.get("USERNAME")));
            } else {
                alertRow.set("ALERT_MESSAGE", (Object)FormatUtil.getFormatMessage(eventRow, format));
            }
            alertRow.set("UNIQUE_ID", eventRow.get("UNIQUE_ID"));
            alertRow.set("MONITOR_ID", (Object)monitorId);
            alertRow.set("ALERT_PROFILE_ID", (Object)((Long)alertProfileMap.get("ALERT_PROFILE_ID")));
            alertRow.set("SEVERITY", alertProfileMap.get("SEVERITY"));
            alertRow.set("PREVIOUS_SEVERITY", alertProfileMap.get("SEVERITY"));
            alertRow.set("CREATION_TIME", eventRow.get("TIME_GENERATED"));
            alertRow.set("MODIFIED_TIME", eventRow.get("TIME_GENERATED"));
            alertRow.set("SOURCE", printer == false ? eventRow.get("SOURCE") : eventRow.get("SERVERNAME"));
            alertRow.set("DOMAIN_NAME", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Vector<Row> inQCopy = null;
        Vector<Row> vector = inQ;
        synchronized (vector) {
            inQCopy = inQ;
            inQ = new Vector();
        }
        try {
            if (inQCopy.size() > 0) {
                for (Row eventRow : inQCopy) {
                    Long monitorId = (Long)eventRow.get("MONITOR_ID");
                    Monitor monitor = MonitorManager.getInstance().getMonitor(monitorId);
                    if (monitor == null) continue;
                    ArrayList<HashMap<String, Object>> alertProfileList = monitor.getAlertProfiles();
                    this.processAlertProfiles(eventRow, alertProfileList, monitor.getDomainName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        @Override
        public void run() {
            try {
                while (!this.shutDown) {
                    this.checkAndProcess();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void checkAndProcess() {
            this.waitForUpdate(300L);
            AlertProfileManager.this.process();
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

