/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Iterator;

public class AudColumnConfig {
    private static AudColumnConfig audColumnConfig = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private HashMap cvIdcolumnaliasDisplayNameMap = null;

    private AudColumnConfig() {
        try {
            if (this.cvIdcolumnaliasDisplayNameMap == null) {
                this.getColumnAliasDisplayNames();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudColumnConfig getInstance() {
        if (audColumnConfig != null) return audColumnConfig;
        Class<AudColumnConfig> clazz = AudColumnConfig.class;
        synchronized (AudColumnConfig.class) {
            if (audColumnConfig != null) return audColumnConfig;
            audColumnConfig = new AudColumnConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return audColumnConfig;
        }
    }

    public void getColumnAliasDisplayNames() {
        try {
            this.cvIdcolumnaliasDisplayNameMap = new HashMap();
            Table reportCvMapTable = Table.getTable((String)"AUDReportCVMapping");
            Table monitorMapTable = Table.getTable((String)"AUDMonitorReportMap");
            SelectQueryImpl sq = new SelectQueryImpl(reportCvMapTable);
            Join monitorReportMapJoin = new Join(reportCvMapTable, monitorMapTable, new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            sq.addJoin(monitorReportMapJoin);
            sq.addSelectColumn(Column.getColumn((String)"AUDReportCVMapping", (String)"*"));
            DataObject reportCvMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator reportCvMapIterator = reportCvMapDataObject.getRows("AUDReportCVMapping");
            while (reportCvMapIterator.hasNext()) {
                Row reportCvMapRow = (Row)reportCvMapIterator.next();
                Long cvId = (Long)reportCvMapRow.get("CV_ID");
                this.cvIdcolumnaliasDisplayNameMap.put(cvId, this.getCloumAliasDisplayName(cvId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getColumnAliasDisplayName(Long cvId) {
        try {
            if (this.cvIdcolumnaliasDisplayNameMap == null) {
                this.getColumnAliasDisplayNames();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (HashMap)this.cvIdcolumnaliasDisplayNameMap.get(cvId);
    }

    public void addColDispNameInMap(Long reportId) {
        try {
            if (this.cvIdcolumnaliasDisplayNameMap != null) {
                Long cvId = this.getCvId(reportId);
                this.cvIdcolumnaliasDisplayNameMap.put(cvId, this.getCloumAliasDisplayName(cvId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteColDispNameInMap(Long monitorId) {
        try {
            if (this.cvIdcolumnaliasDisplayNameMap != null) {
                Long reportId = AUDCustomViewAPI.getInstance().getReportId(monitorId);
                Long cvId = this.getCvId(reportId);
                this.cvIdcolumnaliasDisplayNameMap.remove(cvId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getCvId(Long reportId) {
        Long cvId = 0L;
        try {
            Table reportCvMapTable = Table.getTable((String)"AUDReportCVMapping");
            Table monitorReportMapTable = Table.getTable((String)"AUDMonitorReportMap");
            SelectQueryImpl sq = new SelectQueryImpl(reportCvMapTable);
            Join monitorReportMapJoin = new Join(reportCvMapTable, monitorReportMapTable, new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitorReportMap", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            sq.addJoin(monitorReportMapJoin);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AUDReportCVMapping", (String)"*"));
            DataObject reportCvMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator reportCvMapIterator = reportCvMapDataObject.getRows("AUDReportCVMapping");
            while (reportCvMapIterator.hasNext()) {
                Row r = (Row)reportCvMapIterator.next();
                cvId = (Long)r.get("CV_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cvId;
    }

    public HashMap getCloumAliasDisplayName(Long cvId) {
        HashMap<String, String> columnAliasDisplayNameMap = new HashMap<String, String>();
        try {
            Table columnConfigTable = Table.getTable((String)"AUDColumnConfiguration");
            SelectQueryImpl sq = new SelectQueryImpl(columnConfigTable);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMN_CONF_ID"));
            sq.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNALIAS"));
            sq.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"DISPLAYNAME"));
            DataObject reportCvMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator columnCongIterator = reportCvMapDataObject.getRows("AUDColumnConfiguration");
            while (columnCongIterator.hasNext()) {
                Row r = (Row)columnCongIterator.next();
                columnAliasDisplayNameMap.put((String)r.get("COLUMNALIAS"), rb.getString((String)r.get("DISPLAYNAME")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnAliasDisplayNameMap;
    }
}

