/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;

public class GPOAlertProfileAPI {
    private static final Logger LOGGER = Logger.getLogger(GPOAlertProfileAPI.class.getName());
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static String[] nameGuidArray = new String[]{"{31B2F340-016D-11D2-945F-00C04FB984F9}", "{6AC1786C-016F-11D2-945F-00C04fB984F9}"};
    private static String[] alertNameArray = new String[]{RB.getString("adap.GPOAlertProfileAPI.Default_Domain_Policy_Modified"), RB.getString("adap.GPOAlertProfileAPI.Default_Domain_Controllers_Policy_Modified")};

    public static Boolean isGPOAlertProfile(Long alertProfileId) {
        Boolean b = false;
        try {
            DataObject dobj = GPOAlertProfileAPI.getAlertCriteriaDO(alertProfileId);
            if (dobj != null && !dobj.isEmpty()) {
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static DataObject getAlertCriteriaDO(Long alertProfileId) {
        DataObject alertCriteriaDataObject = null;
        try {
            Table alertCriteriaTable = Table.getTable((String)"AUDAlertCriteria");
            SelectQueryImpl sq = new SelectQueryImpl(alertCriteriaTable);
            if (alertProfileId != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertCriteria", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0);
                sq.setCriteria(crit);
            }
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertCriteria", (String)"*"));
            alertCriteriaDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertCriteriaDataObject;
    }

    private static ArrayList getAlertProfGPOGUIDList(Long alertProfileId) {
        ArrayList gpoGuidList = new ArrayList();
        try {
            DataObject dataObject = GPOAlertProfileAPI.getAlertCriteriaDO(alertProfileId);
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDAlertCriteria");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String objectGuid = (String)row.get("OBJECT_GUID");
                    String objectClass = (String)row.get("OBJECT_CLASS");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("OBJECT_GUID", objectGuid);
                    map.put("OBJECT_CLASS", objectClass);
                    gpoGuidList.add(map);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoGuidList;
    }

    public static HashMap<String, String> getGPONameGuidMap(Long alertProfileId) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList list = GPOAlertProfileAPI.getAlertProfGPOGUIDList(alertProfileId);
            String objectGuid = "";
            String objectClass = "";
            if (list.size() == 1) {
                HashMap gpoGuidMap = (HashMap)list.get(0);
                objectGuid = (String)gpoGuidMap.get("OBJECT_GUID");
                objectClass = (String)gpoGuidMap.get("OBJECT_CLASS");
                if (objectClass.equalsIgnoreCase("domainDNS")) {
                    map.put("OBJECT_GUID", "allobjects");
                    map.put("OBJECT_NAME", "allobjects");
                } else {
                    map.put("OBJECT_GUID", objectGuid);
                    map.put("OBJECT_NAME", GPODetailsAPI.getInstance().getGPOName(objectGuid.toLowerCase()));
                }
            } else {
                String objectName = "";
                for (HashMap gpoGuidMap : list) {
                    if (objectName.equals("")) {
                        objectGuid = (String)gpoGuidMap.get("OBJECT_GUID");
                        objectName = GPODetailsAPI.getInstance().getGPOName(((String)gpoGuidMap.get("OBJECT_GUID")).toLowerCase());
                        continue;
                    }
                    objectGuid = objectGuid + "," + (String)gpoGuidMap.get("OBJECT_GUID");
                    objectName = objectName + "," + GPODetailsAPI.getInstance().getGPOName(((String)gpoGuidMap.get("OBJECT_GUID")).toLowerCase());
                }
                map.put("OBJECT_GUID", objectGuid);
                map.put("OBJECT_NAME", objectName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static HashMap getGPONameGuidMap2(Long alertProfileId) {
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        try {
            ArrayList list = GPOAlertProfileAPI.getAlertProfGPOGUIDList(alertProfileId);
            String objectGuid = "";
            String objectClass = "";
            JSONArray chosenNameList = new JSONArray();
            JSONArray chosenIDList = new JSONArray();
            if (list.size() == 1) {
                HashMap gpoGuidMap = (HashMap)list.get(0);
                objectGuid = (String)gpoGuidMap.get("OBJECT_GUID");
                objectClass = (String)gpoGuidMap.get("OBJECT_CLASS");
                if (objectClass.equalsIgnoreCase("domainDNS")) {
                    chosenNameList.put((Object)"[All Objects]");
                    chosenIDList.put((Object)"allobjects");
                } else {
                    chosenNameList.put((Object)GPODetailsAPI.getInstance().getGPOName(((String)gpoGuidMap.get("OBJECT_GUID")).toLowerCase()));
                    chosenIDList.put(gpoGuidMap.get("OBJECT_GUID"));
                }
            } else {
                String objectName = "";
                for (HashMap gpoGuidMap : list) {
                    chosenNameList.put((Object)GPODetailsAPI.getInstance().getGPOName(((String)gpoGuidMap.get("OBJECT_GUID")).toLowerCase()));
                    chosenIDList.put(gpoGuidMap.get("OBJECT_GUID"));
                }
            }
            map.put("chosenNameList", chosenNameList);
            map.put("chosenIDList", chosenIDList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static DataObject getJoinDO() {
        DataObject dataObject = null;
        try {
            Table table = Table.getTable((String)"AUDAlertCriteria");
            Table domainTable = Table.getTable((String)"ADSMDomainGeneralDetails");
            Table gpoTable = Table.getTable((String)"ADSMGPODetails");
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Join alertCriteriaDomainJoin = new Join(table, domainTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Join domainGPOJoin = new Join(domainTable, gpoTable, new String[]{"NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            sq.addJoin(alertCriteriaDomainJoin);
            sq.addJoin(domainGPOJoin);
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertCriteria", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"*"));
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObject;
    }

    public static DataObject getGPOAlertProfileDO(HashMap<String, String> map) {
        DataObject dataObject = null;
        try {
            Table table = Table.getTable((String)"AUDAlertProfile");
            Table criteriaTable = Table.getTable((String)"AUDAlertCriteria");
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Join alertProfileCriteriaJoin = new Join(table, criteriaTable, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 2);
            sq.addJoin(alertProfileCriteriaJoin);
            if (map != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_NAME"), (Object)map.get("ALERT_PROFILE_NAME"), 0);
                Criteria alertCritCriteria = crit.and(new Criteria(Column.getColumn((String)"AUDAlertCriteria", (String)"DOMAIN_NAME"), (Object)map.get("DOMAIN_NAME"), 0));
                sq.setCriteria(crit);
                sq.setCriteria(alertCritCriteria);
            }
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertCriteria", (String)"*"));
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObject;
    }

    public static HashMap alertGPOSettingsmap(String gpoGuids, String domainName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ArrayList<String> guidList = new ArrayList<String>();
            String[] gpoGuidsArray = gpoGuids.split(",");
            long len = gpoGuidsArray.length;
            String objectClass = "groupPolicyContainer";
            if (len == 1L) {
                if (gpoGuidsArray[0].equalsIgnoreCase("allobjects")) {
                    String domainGuid = DomainDetailsAPI.getDomainObjectGuid(domainName);
                    guidList.add(domainGuid);
                    objectClass = "domainDNS";
                } else {
                    guidList.add(gpoGuidsArray[0]);
                }
            } else {
                int i = 0;
                while ((long)i < len) {
                    guidList.add(gpoGuidsArray[i]);
                    ++i;
                }
            }
            map.put("guidList", guidList);
            map.put("objectClass", objectClass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static void CreateDefaultAlertProfile(String domainName) {
        try {
            DataObject alertDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertProfile", (Criteria)null);
            DataObject alertCritDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertCriteria", (Criteria)null);
            int i = 0;
            HashMap map = GPODetailsAPI.getInstance().getGPOObjectGUIDMap(domainName);
            for (String nameGuid : nameGuidArray) {
                HashMap<String, String> argMap = new HashMap<String, String>();
                argMap.put("ALERT_PROFILE_NAME", alertNameArray[i]);
                argMap.put("DOMAIN_NAME", domainName);
                DataObject dataObj = GPOAlertProfileAPI.getGPOAlertProfileDO(argMap);
                if (!dataObj.isEmpty() || map == null) continue;
                String objectGuid = (String)map.get(nameGuid.toLowerCase());
                LOGGER.log(Level.INFO, "GPO guid in GPOAlertProfileAPI :. " + objectGuid);
                if (objectGuid == null) continue;
                Row alertProfileRow = new Row("AUDAlertProfile");
                alertProfileRow.set("ALERT_PROFILE_NAME", (Object)alertNameArray[i]);
                alertProfileRow.set("ALERT_PROFILE_DESCRIPTION", (Object)alertNameArray[i]);
                alertProfileRow.set("ALERT_MESSAGE", (Object)RB.getString("adap.GPOAlertProfileAPI.GPO_AlertProfile_Message"));
                alertProfileRow.set("SEVERITY", (Object)3);
                alertProfileRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
                alertProfileRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
                DataAccess.generateValues((Row)alertProfileRow);
                Row alertCritRow = new Row("AUDAlertCriteria");
                alertCritRow.set("ALERT_PROFILE_ID", alertProfileRow.get("ALERT_PROFILE_ID"));
                alertCritRow.set("OBJECT_GUID", (Object)objectGuid);
                alertCritRow.set("OBJECT_CLASS", (Object)"groupPolicyContainer");
                alertCritRow.set("DOMAIN_NAME", (Object)domainName);
                alertDataObject.addRow(alertProfileRow);
                alertCritDataObject.addRow(alertCritRow);
                ++i;
            }
            if (i > 0) {
                CommonUtil.getPersistence(new boolean[0]).update(alertDataObject);
                CommonUtil.getPersistence(new boolean[0]).update(alertCritDataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

