/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileManager;
import com.adventnet.sym.adsm.auditing.server.alert.FaultManager;
import com.adventnet.sym.adsm.auditing.server.alert.GPOAlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.notification.AlertNotificationManager;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;

public class GPOAlertProfileListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static GPOAlertProfileListener gpoAlertProfileListener = null;
    public Queue<Row> gpoQueue = null;
    public HashMap<Long, HashMap<String, Object>> gpoAlertProfileMap = null;
    public HashMap<Long, ArrayList> alertGPOMap = null;
    public HashMap<String, String> gpoDomainObjectsMap = null;
    public Action action = null;
    public String columnName = "OBJECT_CLASS";
    static final String[] COLUMNNAMES = new String[]{"UNIQUE_ID", "SETTINGS_ADDED", "SETTINGS_MODIFIED", "SETTINGS_REMOVED"};

    private GPOAlertProfileListener() {
        try {
            this.gpoQueue = new LinkedList<Row>();
            HashMap gpoAlertPropMap = new HashMap();
            this.alertGPOMap = new HashMap();
            this.gpoDomainObjectsMap = new HashMap();
            this.gpoAlertProfileMap = new HashMap();
            this.setGPOAlertProfileRowInMap();
            this.setAlertGPOMap();
            this.setGPODomainObjectMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPOAlertProfileListener getInstance() {
        Class<GPOAlertProfileListener> clazz = GPOAlertProfileListener.class;
        synchronized (GPOAlertProfileListener.class) {
            if (gpoAlertProfileListener == null) {
                gpoAlertProfileListener = new GPOAlertProfileListener();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gpoAlertProfileListener;
        }
    }

    private void setGPOAlertProfileRowInMap() {
        try {
            DataObject dataObject = GPOAlertProfileAPI.getGPOAlertProfileDO(null);
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDAlertProfile");
                while (iterator.hasNext()) {
                    HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
                    Row alertProfileRow = (Row)iterator.next();
                    Long alertProfileId = (Long)alertProfileRow.get("ALERT_PROFILE_ID");
                    List columnList = alertProfileRow.getColumns();
                    for (String columnName : columnList) {
                        alertProfileMap.put(columnName, alertProfileRow.get(columnName));
                    }
                    this.gpoAlertProfileMap.put(alertProfileId, alertProfileMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setAlertGPOMap() {
        try {
            DataObject dataObject = GPOAlertProfileAPI.getAlertCriteriaDO(null);
            ArrayList objectList = null;
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDAlertCriteria");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long alertProfileId = (Long)row.get("ALERT_PROFILE_ID");
                    String objectGuid = (String)row.get("OBJECT_GUID");
                    objectList = this.alertGPOMap.get(alertProfileId) == null ? new ArrayList() : this.alertGPOMap.get(alertProfileId);
                    objectList.add(objectGuid.toLowerCase());
                    this.alertGPOMap.put(alertProfileId, objectList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setGPODomainObjectMap() {
        try {
            DataObject dataObject = GPOAlertProfileAPI.getJoinDO();
            Iterator iterator = dataObject.getRows("ADSMDomainGeneralDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String domainName = (String)row.get("NAME");
                String objectGuid = (String)row.get("OBJECT_GUID");
                if (domainName == null) continue;
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                Iterator gpoIterator = dataObject.getRows("ADSMGPODetails", crit);
                while (gpoIterator.hasNext()) {
                    Row gpoRow = (Row)gpoIterator.next();
                    String gpoObjectGuid = (String)gpoRow.get("OBJECT_GUID");
                    this.gpoDomainObjectsMap.put(gpoObjectGuid.toLowerCase(), objectGuid.toLowerCase());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getGPODomainObjectGuid(String gpoGuid) {
        String objectGuid = null;
        try {
            if (this.gpoDomainObjectsMap == null) {
                this.setGPODomainObjectMap();
            }
            objectGuid = this.gpoDomainObjectsMap.get(gpoGuid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objectGuid;
    }

    public HashMap<String, Object> getAlertProfileMap(Long alertProfileId) {
        HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
        try {
            if (this.gpoAlertProfileMap == null) {
                this.setGPOAlertProfileRowInMap();
            }
            alertProfileMap = this.gpoAlertProfileMap.get(alertProfileId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertProfileMap;
    }

    public void refreshGPOAlertMaps() {
        try {
            this.gpoAlertProfileMap = new HashMap();
            this.alertGPOMap = new HashMap();
            this.gpoDomainObjectsMap = new HashMap();
            this.setGPOAlertProfileRowInMap();
            this.setAlertGPOMap();
            this.setGPODomainObjectMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void addInQueue(Row auditInfoRow) {
        try {
            this.gpoQueue.add(auditInfoRow);
            Action action = new Action(this.gpoQueue);
            action.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void process(Row alertProfileRow) {
        try {
            if (alertProfileRow != null) {
                Vector<Row> alertRowVector = new Vector<Row>();
                String gpoGUID = (String)alertProfileRow.get("OBJECT_GUID");
                String domainGUID = this.getGPODomainObjectGuid(gpoGUID.toLowerCase());
                ArrayList<String> guidList = new ArrayList<String>();
                guidList.add(gpoGUID.toLowerCase());
                if (domainGUID != null) {
                    guidList.add(domainGUID.toLowerCase());
                }
                ArrayList<Long> alertProfileIdList = this.checkCriteria(guidList);
                for (Long alertProfileId : alertProfileIdList) {
                    String domainName = (String)alertProfileRow.get("DOMAIN_NAME");
                    HashMap<String, Object> alertProfileMap = this.getAlertProfileMap(alertProfileId);
                    if (alertProfileIdList.indexOf(alertProfileId) == 0) {
                        String gpoName = (String)alertProfileRow.get("OBJECT_GUID");
                        gpoName = GPODetailsAPI.getInstance().getGPOName(gpoName.toLowerCase());
                        alertProfileRow.set("OBJECT_GUID", (Object)gpoName);
                    }
                    Row row = AlertProfileManager.getInstance().getAlertRow(alertProfileRow, alertProfileMap, domainName, 1);
                    alertRowVector.add(row);
                    Vector notificationVector = new Vector();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ALERT_PROFILE_ID", alertProfileId);
                    for (String columnName : COLUMNNAMES) {
                        map.put(columnName, alertProfileRow.get(columnName));
                    }
                    map.put("ALERT_MESSAGE", row.get("ALERT_MESSAGE"));
                    map.put("SEVERITY", row.get("SEVERITY"));
                    map.put("IS_GPO", true);
                    map.put("EVENT_ROW", alertProfileRow);
                    notificationVector.add(map);
                    AlertNotificationManager.getInstance().addAlertRowVector(notificationVector);
                }
                if (!alertRowVector.isEmpty()) {
                    FaultManager.addAlertRows(alertRowVector);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ArrayList<Long> checkCriteria(ArrayList<String> guidList) {
        ArrayList<Long> alertProfileIdList = new ArrayList<Long>();
        try {
            if (this.alertGPOMap == null) {
                this.setAlertGPOMap();
            }
            for (String guid : guidList) {
                Set<Long> keySet = this.alertGPOMap.keySet();
                for (Long alertProfileId : keySet) {
                    ArrayList list = this.alertGPOMap.get(alertProfileId);
                    if (!list.contains(guid)) continue;
                    alertProfileIdList.add(alertProfileId);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertProfileIdList;
    }

    public void CreateDefaultAlertProfile(String domainName) {
        try {
            AlertCreation alertCreation = new AlertCreation(domainName);
            alertCreation.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;
        Queue<Row> queue = null;

        public Action() {
        }

        public Action(Queue<Row> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                if (this.queue.size() > 0) {
                    for (int i = 0; i < this.queue.size(); ++i) {
                        Row row = this.queue.remove();
                        GPOAlertProfileListener.this.process(row);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AlertCreation
    extends Thread {
        private boolean shutDown = false;
        String domainName = null;

        public AlertCreation(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public void run() {
            try {
                GPOAlertProfileAPI.CreateDefaultAlertProfile(this.domainName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

