/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;

public class PrintAlertProfileAPI {
    public static DataObject getAlertCriteriaDO(Long alertProfileId) {
        DataObject alertCriteriaDataObject = null;
        try {
            Table table = Table.getTable((String)"AUDAlertProfile");
            Table alertCriteriaTable = Table.getTable((String)"AUDPrinterAlertCriteria");
            SelectQueryImpl sq = new SelectQueryImpl(alertCriteriaTable);
            Join alertProfileCriteriaJoin = new Join(alertCriteriaTable, table, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 2);
            sq.addJoin(alertProfileCriteriaJoin);
            Criteria finalCriteria = null;
            if (alertProfileId != null) {
                finalCriteria = new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0);
            }
            Criteria audAlertProf = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"IS_ENABLED"), (Object)true, 0);
            finalCriteria = finalCriteria != null ? finalCriteria.and(audAlertProf) : audAlertProf;
            sq.setCriteria(finalCriteria);
            sq.addSelectColumn(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"*"));
            alertCriteriaDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertCriteriaDataObject;
    }

    public static Boolean isPrinterAlertProfile(Long alertProfileId) {
        Boolean b = false;
        try {
            DataObject dobj = PrintAlertProfileAPI.getAlertCriteriaDO(alertProfileId);
            if (dobj != null && !dobj.isEmpty()) {
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static boolean checkProfileExists(String hostComputer) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"PRINTER_NAME"), (Object)"ALL", 0);
            Criteria alertCritCriteria = crit.and(new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"PRINT_SERVER"), (Object)hostComputer, 0));
            DataObject alertDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDPrinterAlertCriteria", alertCritCriteria.and(crit));
            if (alertDataObject.isEmpty()) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void CreateDefaultAlertProfile(String domainName, String hostComputer, String printerName) {
        try {
            DataObject alertDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertProfile", (Criteria)null);
            DataObject alertCritDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDPrinterAlertCriteria", (Criteria)null);
            boolean i = false;
            HashMap<String, String> argMap = new HashMap<String, String>();
            String alertMessage = printerName != null ? printerName : hostComputer + " Server";
            argMap.put("ALERT_PROFILE_NAME", "Recently Printed Documents in " + alertMessage);
            argMap.put("DOMAIN_NAME", domainName);
            DataObject dataObj = PrintAlertProfileAPI.getGPOAlertProfileDO(argMap);
            if (dataObj.isEmpty() && PrintAlertProfileAPI.checkProfileExists(hostComputer)) {
                Row alertProfileRow = new Row("AUDAlertProfile");
                alertProfileRow.set("ALERT_PROFILE_NAME", (Object)("Recently Printed Documents in " + alertMessage));
                alertProfileRow.set("ALERT_PROFILE_DESCRIPTION", (Object)("Recently Printed Documents in " + alertMessage));
                alertProfileRow.set("ALERT_MESSAGE", (Object)("Recently Printed Documents in " + alertMessage));
                alertProfileRow.set("SEVERITY", (Object)2);
                alertProfileRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
                alertProfileRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
                DataAccess.generateValues((Row)alertProfileRow);
                Row alertCritRow = new Row("AUDPrinterAlertCriteria");
                alertCritRow.set("ALERT_PROFILE_ID", alertProfileRow.get("ALERT_PROFILE_ID"));
                alertCritRow.set("PRINTER_NAME", (Object)(printerName != null ? printerName : "ALL"));
                alertCritRow.set("PRINT_SERVER", (Object)hostComputer);
                alertCritRow.set("DOMAIN_NAME", (Object)domainName);
                alertDataObject.addRow(alertProfileRow);
                alertCritDataObject.addRow(alertCritRow);
                CommonUtil.getPersistence(new boolean[0]).update(alertDataObject);
                CommonUtil.getPersistence(new boolean[0]).update(alertCritDataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap<String, String> getPrinterNameMap(Long alertProfileId) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList list = PrintAlertProfileAPI.getAlertProfPrintersList(alertProfileId);
            String printerName = "";
            if (list.size() == 1) {
                HashMap printerMap = (HashMap)list.get(0);
                printerName = (String)printerMap.get("PRINTER_NAME");
                printerName = printerName.replace("\\", "\\\\");
                map.put("PRINTER_NAME", printerName);
            } else {
                for (HashMap printerMap : list) {
                    String printerNameTemp = ((String)printerMap.get("PRINTER_NAME")).replace("\\", "\\\\");
                    if (printerName.equals("")) {
                        printerName = printerNameTemp;
                        continue;
                    }
                    printerName = printerName + "," + printerNameTemp;
                }
                map.put("PRINTER_NAME", printerName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static HashMap getPrinterNameMap2(Long alertProfileId) {
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        try {
            ArrayList list = PrintAlertProfileAPI.getAlertProfPrintersList(alertProfileId);
            JSONArray chosenNameList = new JSONArray();
            JSONArray chosenIDList = new JSONArray();
            for (HashMap printerMap : list) {
                String printerNameTemp = (String)printerMap.get("PRINTER_NAME");
                if (printerNameTemp.equals("allobjects")) {
                    chosenNameList.put((Object)"[All Objects]");
                    chosenIDList.put((Object)printerNameTemp);
                    continue;
                }
                chosenNameList.put((Object)printerNameTemp);
                chosenIDList.put((Object)printerNameTemp);
            }
            map.put("chosenNameList", chosenNameList);
            map.put("chosenIDList", chosenIDList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    private static ArrayList getAlertProfPrintersList(Long alertProfileId) {
        ArrayList printerList = new ArrayList();
        try {
            DataObject dataObject = PrintAlertProfileAPI.getAlertCriteriaDO(alertProfileId);
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDPrinterAlertCriteria");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String printerName = (String)row.get("PRINTER_NAME");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("PRINTER_NAME", printerName);
                    printerList.add(map);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return printerList;
    }

    public static DataObject getGPOAlertProfileDO(HashMap<String, String> map) {
        DataObject dataObject = null;
        Criteria finalCriteria = null;
        try {
            Table table = Table.getTable((String)"AUDAlertProfile");
            Table criteriaTable = Table.getTable((String)"AUDPrinterAlertCriteria");
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Join alertProfileCriteriaJoin = new Join(table, criteriaTable, new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 2);
            sq.addJoin(alertProfileCriteriaJoin);
            if (map != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_NAME"), (Object)map.get("ALERT_PROFILE_NAME"), 0);
                Criteria alertCritCriteria = crit.and(new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"DOMAIN_NAME"), (Object)map.get("DOMAIN_NAME"), 0));
                finalCriteria = crit.and(new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"DOMAIN_NAME"), (Object)map.get("DOMAIN_NAME"), 0));
            }
            finalCriteria = finalCriteria != null ? finalCriteria.and(new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"IS_ENABLED"), (Object)true, 0)) : new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"IS_ENABLED"), (Object)true, 0);
            sq.setCriteria(finalCriteria);
            sq.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"*"));
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObject;
    }
}

