/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileManager;
import com.adventnet.sym.adsm.auditing.server.alert.FaultManager;
import com.adventnet.sym.adsm.auditing.server.alert.PrintAlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.notification.AlertNotificationManager;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;

public class PrintAlertProfileListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static PrintAlertProfileListener printAlertProfileListener = null;
    public Queue<Row> printerQueue = null;
    public HashMap<Long, HashMap<String, Object>> printAlertProfileMap = null;
    public HashMap<Long, HashMap<String, ArrayList<String>>> alertPrinterMap = null;
    public Action action = null;
    static final String[] COLUMNNAMES = new String[]{"USERNAME", "FILE_NAME", "PRINTER_NAME", "PAGES", "DOMAIN_NAME", "COPIES", "DOC_SIZE", "SERVERNAME"};

    private PrintAlertProfileListener() {
        try {
            this.printerQueue = new LinkedList<Row>();
            this.alertPrinterMap = new HashMap();
            this.printAlertProfileMap = new HashMap();
            this.setPrintAlertProfileRowInMap();
            this.setAlertPrinterMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void refreshAlertProfileMaps() {
        try {
            this.alertPrinterMap = new HashMap();
            this.printAlertProfileMap = new HashMap();
            this.setPrintAlertProfileRowInMap();
            this.setAlertPrinterMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintAlertProfileListener getInstance() {
        Class<PrintAlertProfileListener> clazz = PrintAlertProfileListener.class;
        synchronized (PrintAlertProfileListener.class) {
            if (printAlertProfileListener == null) {
                printAlertProfileListener = new PrintAlertProfileListener();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return printAlertProfileListener;
        }
    }

    private void setPrintAlertProfileRowInMap() {
        try {
            DataObject dataObject = PrintAlertProfileAPI.getGPOAlertProfileDO(null);
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDAlertProfile");
                while (iterator.hasNext()) {
                    HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
                    Row alertProfileRow = (Row)iterator.next();
                    Long alertProfileId = (Long)alertProfileRow.get("ALERT_PROFILE_ID");
                    List columnList = alertProfileRow.getColumns();
                    for (String columnName : columnList) {
                        alertProfileMap.put(columnName, alertProfileRow.get(columnName));
                    }
                    this.printAlertProfileMap.put(alertProfileId, alertProfileMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setAlertPrinterMap() {
        try {
            DataObject dataObject = PrintAlertProfileAPI.getAlertCriteriaDO(null);
            if (dataObject != null && !dataObject.isEmpty()) {
                HashMap<Object, Object> serverPrinterListMap = null;
                Iterator iterator = dataObject.getRows("AUDPrinterAlertCriteria");
                while (iterator.hasNext()) {
                    ArrayList serverList = new ArrayList();
                    ArrayList PrinterList = new ArrayList();
                    Row row = (Row)iterator.next();
                    Long alertProfileId = (Long)row.get("ALERT_PROFILE_ID");
                    String servername = (String)row.get("PRINT_SERVER");
                    String printername = PrintHandler.escapeRevert((String)row.get("PRINTER_NAME"));
                    printername = printername.replace("\\\\", "");
                    if (this.alertPrinterMap.get(alertProfileId) == null) {
                        serverPrinterListMap = new HashMap();
                    } else {
                        serverPrinterListMap = this.alertPrinterMap.get(alertProfileId);
                        serverList = (ArrayList)serverPrinterListMap.get("servername");
                        PrinterList = (ArrayList)serverPrinterListMap.get("printername");
                    }
                    serverList.add(servername);
                    PrinterList.add(printername);
                    serverPrinterListMap.put("servername", serverList);
                    serverPrinterListMap.put("printername", PrinterList);
                    this.alertPrinterMap.put(alertProfileId, serverPrinterListMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap<String, Object> getAlertProfileMap(Long alertProfileId) {
        HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
        try {
            if (this.printAlertProfileMap == null) {
                this.setPrintAlertProfileRowInMap();
            }
            alertProfileMap = this.printAlertProfileMap.get(alertProfileId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertProfileMap;
    }

    public synchronized void addInQueue(Row auditInfoRow) {
        try {
            this.printerQueue.add(auditInfoRow);
            Action action = new Action(this.printerQueue);
            action.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void process(Row alertProfileRow) {
        try {
            if (alertProfileRow != null) {
                Vector<Row> alertRowVector = new Vector<Row>();
                String serverName = (String)alertProfileRow.get("SERVERNAME");
                String printerName = (String)alertProfileRow.get("PRINTER_NAME");
                ArrayList<Long> alertProfileIdList = this.checkCriteria(printerName);
                for (Long alertProfileId : alertProfileIdList) {
                    String domainName = (String)alertProfileRow.get("DOMAIN_NAME");
                    HashMap<String, Object> alertProfileMap = this.getAlertProfileMap(alertProfileId);
                    Row row = AlertProfileManager.getInstance().getAlertRow(alertProfileRow, alertProfileMap, domainName, 2);
                    alertRowVector.add(row);
                    Vector<HashMap> notificationVector = new Vector<HashMap>();
                    HashMap map = new HashMap();
                    notificationVector.add(this.getPrinterMailPropMap(alertProfileMap, alertProfileRow));
                    AlertNotificationManager.getInstance().addAlertRowVector(notificationVector);
                }
                if (!alertRowVector.isEmpty()) {
                    FaultManager.addAlertRows(alertRowVector);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private HashMap getPrinterMailPropMap(HashMap alertProfileMap, Row alertProfileRow) {
        HashMap<String, Object> newMailPropMap = new HashMap<String, Object>();
        try {
            newMailPropMap.put("ALERT_PROFILE_ID", (Long)alertProfileMap.get("ALERT_PROFILE_ID"));
            String format = (String)alertProfileMap.get("ALERT_MESSAGE");
            newMailPropMap.put("ALERT_MESSAGE", FormatUtil.getFormatMessage(alertProfileRow, format));
            newMailPropMap.put("SEVERITY", alertProfileMap.get("SEVERITY"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String columnName : COLUMNNAMES) {
                map.put(columnName, alertProfileRow.get(columnName));
            }
            Long ctMST = (Long)alertProfileRow.get("TIME_GENERATED");
            String time = TimeUtil.formatDate(ctMST * 1000L);
            map.put("TIME_GENERATED", time);
            newMailPropMap.put("Mail_PROP_MAP", map);
            newMailPropMap.put("EVENT_ROW", alertProfileRow);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newMailPropMap;
    }

    private ArrayList<Long> checkCriteria(String printerName) {
        ArrayList<Long> alertProfileIdList = new ArrayList<Long>();
        try {
            if (this.alertPrinterMap == null) {
                this.setAlertPrinterMap();
            }
            Set<Long> keySet = this.alertPrinterMap.keySet();
            for (Long alertProfileId : keySet) {
                boolean canAlert = true;
                HashMap<String, ArrayList<String>> tempPrintServerMap = this.alertPrinterMap.get(alertProfileId);
                ArrayList<String> listPrinter = tempPrintServerMap.get("printername");
                if (!listPrinter.contains("all") && !listPrinter.contains("allobjects")) {
                    canAlert = listPrinter.contains(printerName);
                }
                if (!canAlert) continue;
                alertProfileIdList.add(alertProfileId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertProfileIdList;
    }

    class Action
    extends Thread {
        private boolean shutDown = false;
        Queue<Row> queue = null;

        public Action() {
        }

        public Action(Queue<Row> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                if (this.queue.size() > 0) {
                    for (int i = 0; i < this.queue.size(); ++i) {
                        Row row = this.queue.remove();
                        PrintAlertProfileListener.this.process(row);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

