/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert.notification;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfile;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileManager;
import com.adventnet.sym.adsm.auditing.server.alert.notification.Notification;
import com.adventnet.sym.adsm.auditing.server.alert.notification.NotificationAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPSettingsHandler;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class AlertNotificationManager
implements Observer {
    private static AlertNotificationManager alertNotificationManager = null;
    private static Vector inQ = new Vector();

    private AlertNotificationManager() {
        try {
            NotificationAPI.getInstance().getNotifications();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Action().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertNotificationManager getInstance() {
        if (alertNotificationManager != null) return alertNotificationManager;
        Class<AlertNotificationManager> clazz = AlertNotificationManager.class;
        synchronized (AlertNotificationManager.class) {
            if (alertNotificationManager != null) return alertNotificationManager;
            alertNotificationManager = new AlertNotificationManager();
            AlertProfileManager.getInstance().register(alertNotificationManager);
            // ** MonitorExit[var0] (shouldn't be in output)
            return alertNotificationManager;
        }
    }

    @Override
    public void update(Observable observable, Object alertVector) {
        try {
            Vector alertRowVector = (Vector)alertVector;
            this.addAlertRowVector(alertRowVector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlertRowVector(Vector alertRowVector) {
        Vector vector = inQ;
        synchronized (vector) {
            inQ.addAll(alertRowVector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Vector inQCopy = null;
        Vector mailInQ = new Vector();
        Vector vector = inQ;
        synchronized (vector) {
            inQCopy = inQ;
            inQ = new Vector();
        }
        try {
            if (inQCopy.size() > 0) {
                for (Object object : inQCopy) {
                    HashMap map = (HashMap)object;
                    AlertProfile alertProfile = AlertProfileAPI.getInstance().getAlertProfile(Long.valueOf(map.get("ALERT_PROFILE_ID").toString()));
                    if (!alertProfile.getIsMailEnabled()) continue;
                    ArrayList<Long> notificationIdList = alertProfile.getNotificationIdList();
                    for (int i = 0; i < notificationIdList.size(); ++i) {
                        String subject;
                        String addnMailId;
                        HashMap<String, Object> mailProperties = new HashMap<String, Object>();
                        Long notificationId = notificationIdList.get(i);
                        Notification notification = NotificationAPI.getInstance().getNotification(notificationId);
                        ArrayList<String> toAddress = AlertProfileAPI.getAlertMailToAddress(notification.getToAddress(), (Row)map.get("EVENT_ROW"));
                        String bodyContentType = notification.getBodyContentType();
                        Boolean isAlertMsgNeeded = notification.getAlertMsgNeeded();
                        Boolean isEvtDetailsNeeded = notification.getEvtDetailsNeeded();
                        String addnMailAddr = notification.getAddnMailAddress();
                        if (addnMailAddr != null && !"".equals(addnMailAddr) && (addnMailId = AlertProfileAPI.getMailIdsFromName(addnMailAddr, (Row)map.get("EVENT_ROW"))) != null && !"-".equals(addnMailId)) {
                            toAddress.add(addnMailId);
                        }
                        subject = (subject = notification.getMailSubject()) != null && !subject.trim().equals("") ? FormatUtil.getFormatMessage((Row)map.get("EVENT_ROW"), subject) : alertProfile.getName();
                        Boolean isGPOAlert = (Boolean)map.get("IS_GPO");
                        if (isGPOAlert == null) {
                            isGPOAlert = false;
                        }
                        String message = "";
                        if (isGPOAlert != null && isGPOAlert.booleanValue()) {
                            String columnName = "UNIQUE_ID";
                            Long uniqueId = (Long)map.get(columnName);
                            HashMap<String, ArrayList> settingsMap = GPSettingsHandler.getSettingsChangeRow(columnName, uniqueId.toString());
                            message = NotificationAPI.getInstance().getGPOSettingsMessage(settingsMap, map);
                        } else {
                            message = NotificationAPI.getInstance().getAlertMessage(map, bodyContentType, isAlertMsgNeeded, isEvtDetailsNeeded);
                        }
                        mailProperties.put("subject", subject);
                        mailProperties.put("message", message);
                        mailProperties.put("toAddress", toAddress.toArray(new String[toAddress.size()]));
                        mailProperties.put("isGPOAlert", isGPOAlert);
                        if (!isGPOAlert.booleanValue()) {
                            mailProperties.put("contentType", bodyContentType);
                        }
                        mailInQ.add(mailProperties);
                    }
                }
                SendMailAPI.getInstance().addSendMailInQue(mailInQ);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        @Override
        public void run() {
            try {
                while (!this.shutDown) {
                    this.checkAndProcess();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void checkAndProcess() {
            this.waitForUpdate(300L);
            AlertNotificationManager.this.process();
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

