/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.alert.notification;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.notification.Notification;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class NotificationAPI {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static NotificationAPI notificationAPI = null;
    private HashMap notificationsMap = null;
    private static int count = 0;

    private NotificationAPI() {
        try {
            if (this.notificationsMap == null) {
                this.getNotifications();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotificationAPI getInstance() {
        if (notificationAPI != null) return notificationAPI;
        Class<NotificationAPI> clazz = NotificationAPI.class;
        synchronized (NotificationAPI.class) {
            if (notificationAPI != null) return notificationAPI;
            notificationAPI = new NotificationAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return notificationAPI;
        }
    }

    public void getNotifications() throws DataAccessException {
        try {
            Table alertNotificationTable = Table.getTable((String)"AUDNotification");
            SelectQueryImpl sq = new SelectQueryImpl(alertNotificationTable);
            sq.addSelectColumn(Column.getColumn((String)"AUDNotification", (String)"*"));
            DataObject notificationDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator notificationIterator = notificationDataObject.getRows("AUDNotification");
            while (notificationIterator.hasNext()) {
                Row notificationRow = (Row)notificationIterator.next();
                Long notificationId = (Long)notificationRow.get("NOTIFICATIONID");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("NOTIFICATION_TYPE", (String)notificationRow.get("NOTIFICATION_TYPE"));
                map.put("TO_ADDRESS", (String)notificationRow.get("TO_ADDRESS"));
                map.put("MAIL_SUBJECT", (String)notificationRow.get("MAIL_SUBJECT"));
                map.put("BODY_CONTENT_TYPE", (String)notificationRow.get("BODY_CONTENT_TYPE"));
                map.put("ALERT_MSG_NEEDED", (Boolean)notificationRow.get("ALERT_MSG_NEEDED"));
                map.put("EVT_DETAILS_NEEDED", (Boolean)notificationRow.get("EVT_DETAILS_NEEDED"));
                map.put("ADDNL_MAIL_ADDRESSES", (String)notificationRow.get("ADDNL_MAIL_ADDRESSES"));
                Notification notification = new Notification(notificationId, map);
                if (this.notificationsMap == null) {
                    this.notificationsMap = new HashMap();
                }
                this.notificationsMap.put(notificationId, notification);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Notification getNotification(Long notificationId) throws DataAccessException {
        if (this.notificationsMap == null) {
            this.getNotifications();
        }
        return (Notification)this.notificationsMap.get(notificationId);
    }

    public void addNotificationInMap(Row notificationRow) {
        try {
            if (this.notificationsMap == null) {
                this.notificationsMap = new HashMap();
            }
            Long notificationId = (Long)notificationRow.get("NOTIFICATIONID");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("NOTIFICATION_TYPE", (String)notificationRow.get("NOTIFICATION_TYPE"));
            map.put("TO_ADDRESS", (String)notificationRow.get("TO_ADDRESS"));
            map.put("MAIL_SUBJECT", (String)notificationRow.get("MAIL_SUBJECT"));
            map.put("BODY_CONTENT_TYPE", (String)notificationRow.get("BODY_CONTENT_TYPE"));
            map.put("ALERT_MSG_NEEDED", (Boolean)notificationRow.get("ALERT_MSG_NEEDED"));
            map.put("EVT_DETAILS_NEEDED", (Boolean)notificationRow.get("EVT_DETAILS_NEEDED"));
            map.put("ADDNL_MAIL_ADDRESSES", (String)notificationRow.get("ADDNL_MAIL_ADDRESSES"));
            Notification notification = new Notification(notificationId, map);
            this.notificationsMap.put(notificationId, notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteNotificationInMap(ArrayList notificationIdList) {
        try {
            if (this.notificationsMap != null) {
                for (int i = 0; i < notificationIdList.size(); ++i) {
                    this.notificationsMap.remove((Long)notificationIdList.get(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateNotificationMap(Long notificationId, HashMap notificationMap) {
        try {
            if (this.notificationsMap != null) {
                if (Boolean.valueOf(notificationMap.get("IS_MAIL_NOTIFICATION").toString()).booleanValue()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("NOTIFICATION_TYPE", "E-Mail");
                    map.put("TO_ADDRESS", (String)notificationMap.get("TO_ADDRESS"));
                    map.put("MAIL_SUBJECT", (String)notificationMap.get("MAIL_SUBJECT"));
                    map.put("BODY_CONTENT_TYPE", (String)notificationMap.get("BODY_CONTENT_TYPE"));
                    map.put("ALERT_MSG_NEEDED", (Boolean)notificationMap.get("ALERT_MSG_NEEDED"));
                    map.put("EVT_DETAILS_NEEDED", (Boolean)notificationMap.get("EVT_DETAILS_NEEDED"));
                    map.put("ADDNL_MAIL_ADDRESSES", (String)notificationMap.get("ADDNL_MAIL_ADDRESSES"));
                    Notification notification = new Notification(notificationId, map);
                    this.notificationsMap.put(notificationId, notification);
                    Notification notification1 = (Notification)this.notificationsMap.get(notificationId);
                } else {
                    this.notificationsMap.remove(notificationId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAlertMessage(HashMap mailPropMap, String bodyContent, Boolean isAlertMsgNeeded, Boolean isEvtDetailsNeeded) {
        String message = "";
        try {
            boolean isContentTypePlain = SendMailAPI.getInstance().getIsContentTypePlain();
            String alertMessage = (String)mailPropMap.get("ALERT_MESSAGE");
            Object severityOb = mailPropMap.get("SEVERITY");
            String severityStr = this.getSeverity(severityOb);
            String imageName = "";
            String thresMessage = "";
            if (!bodyContent.equalsIgnoreCase("text")) {
                String alertMessageTab = "<table width = \"70%\" align =\"center\" cellpadding=\"2\" cellspacing=\"3\" Style=\"border:1px dashed #FF0000;\"><tr><td><table width = \"100%\" align = \"center\" cellpadding=\"2\" cellspacing=\"3\" Style=\"border:1px solid #FF0000;\"><tr><td width=\"15%\" align=\"right\"><span style = \"color:#000000;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\" >" + rb.getString("adap.AUDColumnConfiguration.displayname.Alert_Message") + ":</span></td><td><span style = \"font-family: Verdana,Arial,Helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">" + alertMessage + "</span></td></tr><tr><td width=\"15%\" align=\"right\"><span style = \"color:#000000;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\">" + rb.getString("adap.AUDColumnConfiguration.displayname.Severity") + ":</span></td><td><span style = \"font-family: Verdana,Arial,Helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">" + severityStr + "</span></td></tr>";
                if (mailPropMap.get("THRESDETAILS") != null) {
                    thresMessage = (String)mailPropMap.get("THRESDETAILS");
                    alertMessageTab = alertMessageTab + "<tr><td width=\"15%\" align=\"right\"><span style = \"color:#000000;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\">Note: </span></td><td><span style = \"font-family: Verdana,Arial,Helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">" + thresMessage + "</span></td></tr></table></td></tr> </table>";
                } else {
                    alertMessageTab = alertMessageTab + "</table></td></tr></table>";
                }
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append("<html><head><meta content=\"text/plain; charset=UTF-8\" http-equiv=\"Content-Type\"><style type=\"text/css\">.style1 {font-family: Arial, Helvetica, sans-serif;\tfont-size: 12px;} .rowtable2 {font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:normal;text-decoration:none;} .adminselected1 {background-color:#BABDFF;background-position:right top;color:#000000;font-size:10px;font-weight:bold;height:26px;}</style><span class=\"style1\"></head>&nbsp;&nbsp;<body>");
                if (isAlertMsgNeeded.booleanValue()) {
                    messageBuffer.append(alertMessageTab);
                }
                if (isEvtDetailsNeeded.booleanValue()) {
                    messageBuffer.append("<br><br><table width=\"70%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#E8E8E8\"> <tr colspan = 2 height = 24 bgcolor = \"#efefef\"><td ><span style = \"color:#000000;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\" >");
                    messageBuffer.append(rb.getString("adap.NotificationAPI.Event_Details"));
                    messageBuffer.append("</span></td></tr>");
                    HashMap eventDetailsMap = (HashMap)mailPropMap.get("Mail_PROP_MAP");
                    Set keySet = eventDetailsMap.keySet();
                    messageBuffer.append(" ");
                    int k = 0;
                    for (String key : keySet) {
                        Object obj = eventDetailsMap.get(key);
                        if (k % 2 == 0) {
                            messageBuffer.append("<tr style =\"font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;background-color: #FFFFFF;border-bottom: 1px solid #E8E8E8;height: 25px;\"><td width=\"100\"><span style = \"color:#000000;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\" >");
                            messageBuffer.append(key);
                            messageBuffer.append("</span></td><td width = \"150\"> <span style = \"font-family: Verdana,Arial,Helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">&nbsp;&nbsp;");
                            messageBuffer.append(obj);
                            messageBuffer.append("</td></tr>");
                        } else {
                            messageBuffer.append("<tr style =\"font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;background-color: #F9F9F9;border-bottom: 1px solid #E8E8E8;border-right:1px solid #E8E8E8;height: 25px;\"><td width=\"100\"><span style = \"color:#000000;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\" >");
                            messageBuffer.append(key);
                            messageBuffer.append("</span></td><td width = \"150\"> <span style = \"font-family: Verdana,Arial,Helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">&nbsp;&nbsp;");
                            messageBuffer.append(obj);
                            messageBuffer.append("</td></tr>");
                        }
                        ++k;
                    }
                    messageBuffer.append("</table>");
                }
                messageBuffer.append("</body></html>");
                message = messageBuffer.toString();
            } else {
                String alertMessageTab = "\n" + rb.getString("adap.AUDColumnConfiguration.displayname.Alert_Message") + "\t:\t" + alertMessage + "\n" + rb.getString("adap.AUDColumnConfiguration.displayname.Severity") + "\t:\t" + severityStr + "\n";
                StringBuffer messageBuffer = new StringBuffer();
                if (isAlertMsgNeeded.booleanValue()) {
                    messageBuffer.append("\n");
                    messageBuffer.append(alertMessageTab);
                }
                if (isEvtDetailsNeeded.booleanValue()) {
                    messageBuffer.append("\n");
                    messageBuffer.append(rb.getString("adap.NotificationAPI.Event_Details"));
                    messageBuffer.append("\n");
                    HashMap eventDetailsMap = (HashMap)mailPropMap.get("Mail_PROP_MAP");
                    Set keySet = eventDetailsMap.keySet();
                    messageBuffer.append(" ");
                    for (String key : keySet) {
                        Object obj = eventDetailsMap.get(key);
                        messageBuffer.append("");
                        messageBuffer.append(key);
                        messageBuffer.append("\t:\t");
                        messageBuffer.append(obj);
                        messageBuffer.append("\n");
                    }
                    messageBuffer.append("\n");
                }
                message = messageBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public String getGPOSettingsMapUI(HashMap settingsMap, String uniqueIdString, Boolean alert) {
        String message = "";
        try {
            StringBuffer messageBuffer = new StringBuffer();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            String[] setColNames = new String[]{"CHANGE_TYPE_TEXT", "SETTING_NAME", "SETTING_OLD_VALUE", "SETTING_NEW_VALUE"};
            String[] setColDispNames = new String[]{rb.getString("adap.AUDRuleVariables.variable_name.Change_Type"), rb.getString("adap.AUDReportColumns.column_display_name.Policy"), rb.getString("adap.AUDColumnConfiguration.displayname.Old_Value"), rb.getString("adap.AUDColumnConfiguration.displayname.New_value")};
            String[] commColNames = new String[]{"COMMENT_OLD_VALUE", "COMMENT_NEW_VALUE"};
            String[] commColDispNames = new String[]{rb.getString("adap.AUDColumnConfiguration.displayname.Comment_Old_value"), rb.getString("adap.AUDColumnConfiguration.displayname.Comment_New_Value")};
            Set keySet = settingsMap.keySet();
            int keyCount = 0;
            int len = settingsMap.size();
            for (Object object : keySet) {
                String displayStyle = "display:none";
                String imgString = "images/collapsed.gif";
                if (keyCount == 0) {
                    displayStyle = "display:block";
                    imgString = "images/expanded.gif";
                }
                if (alert.booleanValue()) {
                    displayStyle = "display:block";
                }
                messageBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\"  style=\"margin-top:1px\">");
                messageBuffer.append("<tr><td>");
                messageBuffer.append("<table width=\"100%\"  cellspacing=\"0\" cellpadding=\"0\" style=\"border : 1px solid #cccccc;background-color: #e3e3e3;padding:4px;\" align=\"center\">");
                messageBuffer.append("<tbody>");
                if (alert.booleanValue()) {
                    messageBuffer.append("<tr><td><span style=\"color: #444444;font-family: Verdana,Arial,Helvetica,sans-serif;font-size: 10px;font-weight: bold; text-decoration: none;padding-left:5px;\">" + object + "</span></td></tr>");
                } else {
                    messageBuffer.append("<tr  style=\"cursor:hand;cursor:pointer\" onclick=\"toggleDetailsDiv('POLICY_PATH_" + uniqueIdString + "_" + keyCount + "')\"><td><a style=\"color: #444444;font-family: Verdana,Arial,Helvetica,sans-serif;font-size: 10px;font-weight: bold; text-decoration: none;\" href=\"javascript:void(0);\"><img id=\"POLICY_PATH_" + uniqueIdString + "_" + keyCount + "_ANCHOR\" src=\"" + imgString + "\" border=\"0\"/><span style=\"padding-left:5px;\">" + object + "</span></a></td></tr>");
                }
                messageBuffer.append("<tr><td>");
                messageBuffer.append("<div id=\"POLICY_PATH_" + uniqueIdString + "_" + keyCount + "\" style=\"" + displayStyle + "\">");
                messageBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\">");
                messageBuffer.append("<tbody>");
                messageBuffer.append("<tr>");
                messageBuffer.append("<td valign=\"top\">");
                messageBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\"  style=\"margin-top:1px\">");
                messageBuffer.append("<tbody>");
                messageBuffer.append("<tr>");
                messageBuffer.append("<td>");
                messageBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">");
                messageBuffer.append("<tbody>");
                messageBuffer.append("<tr>");
                messageBuffer.append("<td valign=\"top\" bgcolor=\"#ffffff\">");
                messageBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" border=\"0\" align=\"center\">");
                ArrayList settingsList = (ArrayList)settingsMap.get(object);
                boolean isAdmTemplate = false;
                if (!settingsList.isEmpty()) {
                    HashMap detailMap = (HashMap)settingsList.get(0);
                    isAdmTemplate = (Boolean)detailMap.get("IS_ADM_TEMPLATE");
                }
                int cc = setColNames.length;
                if (isAdmTemplate) {
                    cc += commColNames.length;
                }
                int cw = 100 / cc;
                messageBuffer.append("<tr style=\"background: transparent url(/images/inner-heading-bg.gif);height:29px\">");
                for (String colName : setColDispNames) {
                    messageBuffer.append("<td width=\"" + cw + "%\" style=\"color: #666666;font-family: Verdana,Arial,Helvetica,sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;\">" + colName + "</td>");
                }
                if (isAdmTemplate) {
                    for (String colName : commColDispNames) {
                        messageBuffer.append("<td width=\"" + cw + "%\" style=\"color: #666666;font-family: Verdana,Arial,Helvetica,sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;\">" + colName + "</td>");
                    }
                }
                messageBuffer.append("</tr>");
                for (int i = 0; i < settingsList.size(); ++i) {
                    ClobImpl clobObj;
                    Object obj;
                    String value;
                    messageBuffer.append("<tr style=\"font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;background-color: #FFFFFF;border-bottom: 1px solid #E8E8E8;height: 25px;\">");
                    HashMap detailValueMap = (HashMap)settingsList.get(i);
                    String cellClass = "font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 11px;color: #000000;text-decoration: none;";
                    for (String colName : setColNames) {
                        value = "-";
                        if (colName.equalsIgnoreCase("CHANGE_TYPE_TEXT")) {
                            Integer changeType = (Integer)detailValueMap.get("CHANGE_TYPE");
                            cellClass = NotificationAPI.getChangeTypeStyle(changeType);
                        } else {
                            cellClass = "font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 11px;color: #000000;text-decoration: none;";
                        }
                        if (detailValueMap.get(colName) != null) {
                            obj = detailValueMap.get(colName);
                            if (obj.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
                                clobObj = (ClobImpl)obj;
                                value = clobObj.getSubString(1L, (int)clobObj.length());
                            } else {
                                value = obj.toString();
                            }
                        }
                        messageBuffer.append("<td  style=\"border-bottom:1px solid #f9f9f9;\"> <span style=\"" + cellClass + "\">" + value + "</span></td>");
                    }
                    if (isAdmTemplate) {
                        for (String colName : commColNames) {
                            value = "-";
                            if (detailValueMap.get(colName) != null) {
                                obj = detailValueMap.get(colName);
                                if (obj.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
                                    clobObj = (ClobImpl)obj;
                                    value = clobObj.getSubString(1L, (int)clobObj.length());
                                } else {
                                    value = obj.toString();
                                }
                            }
                            messageBuffer.append("<td  style=\"border-bottom:1px solid #f9f9f9;\"> <span style=\"font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;color: #000000;text-decoration: none;\">" + value + "</span></td>");
                        }
                    }
                    messageBuffer.append("</tr>");
                }
                messageBuffer.append("</table>");
                messageBuffer.append("</td></tr>");
                messageBuffer.append("</tbody>");
                messageBuffer.append("</table>");
                messageBuffer.append("</td>");
                messageBuffer.append("</tr>");
                messageBuffer.append("</tbody>");
                messageBuffer.append("</table>");
                messageBuffer.append("</td>");
                messageBuffer.append("</tr>");
                messageBuffer.append("</tbody>");
                messageBuffer.append("</table>");
                messageBuffer.append("</div>");
                messageBuffer.append("</td>");
                messageBuffer.append("</tr>");
                messageBuffer.append("</tbody>");
                messageBuffer.append("</table>");
                messageBuffer.append("</td>");
                messageBuffer.append("</tr>");
                messageBuffer.append("</table>");
                ++keyCount;
            }
            message = messageBuffer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message;
    }

    public String getChangesCountTableUI(HashMap map) {
        String table = "";
        try {
            table = "<table width=\"11%\" align=\"right\"><tbody><tr><td><span style=\"" + NotificationAPI.getChangeTypeStyle(1) + "\">Added :" + map.get("SETTINGS_ADDED") + "</span></td></tr><tr><td><span style=\"" + NotificationAPI.getChangeTypeStyle(3) + "\"> Removed :" + map.get("SETTINGS_REMOVED") + "</span></td></tr><tr><td> <span style=\"" + NotificationAPI.getChangeTypeStyle(2) + "\"> Modified :" + map.get("SETTINGS_MODIFIED") + "</span></td></tr></tbody></table>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return table;
    }

    public static String getChangeTypeStyle(Integer changeType) {
        String cellClass = "";
        try {
            if (changeType == 1) {
                cellClass = "font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: bold;color:#04B404;text-decoration: none;";
            } else if (changeType == 3) {
                cellClass = "font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: bold;color: #FF0000;text-decoration: none;";
            } else if (changeType == 2) {
                cellClass = "font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: bold;color: #000000;text-decoration: none;";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cellClass;
    }

    public String getGPOSettingsMessage(HashMap settingsMap, HashMap map) {
        String message = "";
        try {
            StringBuffer messageBuffer = new StringBuffer();
            String messageUI = this.getAlertMessageUI(map);
            String settingsMapUI = this.getGPOSettingsMapUI(settingsMap, "1", true);
            String countTableUI = this.getChangesCountTableUI(map);
            messageBuffer.append(messageUI);
            messageBuffer.append("<br>");
            messageBuffer.append(countTableUI);
            messageBuffer.append("<br>");
            messageBuffer.append("<br>");
            messageBuffer.append("&nbsp;");
            messageBuffer.append(settingsMapUI);
            message = messageBuffer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message;
    }

    public String getAlertMessageUI(HashMap map) {
        String message = "";
        try {
            StringBuffer messageBuffer = new StringBuffer();
            messageBuffer.append("<table width=\"100%\" cellspacing=\"3\" cellpadding=\"2\" align=\"center\" style=\"border:1px dashed #ff0000;\">");
            messageBuffer.append("<tbody><tr><td>");
            messageBuffer.append("<table width=\"100%\" cellspacing=\"3\" cellpadding=\"2\" align=\"center\" style=\"border:1px solid #ff0000;\">");
            messageBuffer.append("<tbody>");
            messageBuffer.append("<tr><td width=\"15%\" align=\"right\">");
            messageBuffer.append("<span style=\"color:#000000;font-family:verdana,arial,helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\">");
            messageBuffer.append("Alert Message:");
            messageBuffer.append("</span>");
            messageBuffer.append("</td><td>");
            messageBuffer.append("<span style=\"font-family: verdana,arial,helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">");
            messageBuffer.append((String)map.get("ALERT_MESSAGE"));
            messageBuffer.append("</span>");
            messageBuffer.append("</td></tr>");
            messageBuffer.append("<tr><td width=\"15%\" align=\"right\">");
            messageBuffer.append("<span style=\"color:#000000;font-family:verdana,arial,helvetica,sans-serif;font-size:10px;font-weight:bold;text-decoration:none;\">");
            messageBuffer.append("Severity:");
            messageBuffer.append("</span>");
            messageBuffer.append("</td><td>");
            messageBuffer.append("<span style=\"font-family: verdana,arial,helvetica,sans-serif;font-size:11px;color:#000000;text-decoration:none;\">");
            messageBuffer.append(this.getSeverity(map.get("SEVERITY")));
            messageBuffer.append("</span>");
            messageBuffer.append("</td></tr>");
            messageBuffer.append("</tbody>");
            messageBuffer.append("</table>");
            messageBuffer.append("</td></tr>");
            messageBuffer.append("</tbody>");
            messageBuffer.append("</table>");
            message = messageBuffer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message;
    }

    public String getSeverity(Object severityOb) {
        String severityStr = "";
        try {
            if (severityOb != null) {
                int severityId = Integer.parseInt(severityOb.toString());
                if (severityId == 0) {
                    severityStr = rb.getString("adap.NotificationAPI.Clear");
                }
                if (severityId == 1) {
                    severityStr = rb.getString("adap.NotificationAPI.Attention");
                }
                if (severityId == 2) {
                    severityStr = rb.getString("adap.NotificationAPI.Trouble");
                }
                if (severityId == 3) {
                    severityStr = rb.getString("adap.NotificationAPI.Critical");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return severityStr;
    }
}

