/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.archive;

import com.adventnet.sym.adsm.auditing.server.archive.DataArchiver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveFile {
    private static final Logger LOGGER = Logger.getLogger(ArchiveFile.class.getName());
    private String fileName = null;
    private BufferedWriter writer = null;
    private Long fileCreationTime = 0L;

    public ArchiveFile(String domainController) {
        String dateString = null;
        try {
            String dcDirName = DataArchiver.getBaseArchiveDirectory() + File.separator + domainController;
            File dcDir = new File(dcDirName);
            if (!dcDir.exists()) {
                dcDir.mkdirs();
            }
            SimpleDateFormat format = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
            dateString = format.format(new Date());
            this.fileName = dcDir.getAbsolutePath() + File.separator + dateString;
            this.writer = new BufferedWriter(new FileWriter(this.fileName));
            this.fileCreationTime = System.currentTimeMillis();
            LOGGER.log(Level.INFO, " New Archive File Opened for Writing =={0}", this.fileName);
        }
        catch (Exception ee) {
            LOGGER.log(Level.WARNING, "Exception while creating file for host =={0}:: on{1}", new Object[]{domainController, dateString});
            ee.printStackTrace();
        }
    }

    public void writeInFile(Vector recordList) {
        try {
            for (Hashtable eventTable : recordList) {
                this.writer.write(eventTable.toString());
                this.writer.newLine();
            }
            this.writer.flush();
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exeption while writing file {0}", this.fileName);
            ee.printStackTrace();
        }
    }

    private void createFolder(String domainName, String domainController) {
        String dir = ".." + File.separator + "archive" + File.separator + domainName + File.separator + domainController;
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void reopen() {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.fileName));
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exeption while reopening file {0}", this.fileName);
            ee.printStackTrace();
        }
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exeption while closing file {0}", this.fileName);
            ee.printStackTrace();
        }
    }

    public Long getFileCreationTime() {
        return this.fileCreationTime;
    }

    public void setFileCreationTime(Long fileCreationTime) {
        this.fileCreationTime = fileCreationTime;
    }
}

