/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.archive;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFile;
import com.adventnet.sym.adsm.auditing.server.archive.DataArchiver;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class ArchiveFileAPI {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static ArchiveFileAPI archiveFileAPI = null;
    private Hashtable archiveFileMap = new Hashtable();
    private ArrayList dcList = new ArrayList();
    private Hashtable zipCreationTimeMap = new Hashtable();
    private static final String ARCHIVE_CONFIG_TABLE = "AUDArchiveConfig";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArchiveFileAPI getInstance() {
        if (archiveFileAPI != null) return archiveFileAPI;
        Class<ArchiveFileAPI> clazz = ArchiveFileAPI.class;
        synchronized (ArchiveFileAPI.class) {
            if (archiveFileAPI != null) return archiveFileAPI;
            archiveFileAPI = new ArchiveFileAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return archiveFileAPI;
        }
    }

    private ArchiveFileAPI() {
        this.getZipCreationTimeMap();
    }

    public ArchiveFile getArchiveFile(String domainController) {
        ArchiveFile file = (ArchiveFile)this.archiveFileMap.get(domainController);
        if (file == null) {
            if (!this.dcList.contains(domainController)) {
                this.dcList.add(domainController);
            }
            file = new ArchiveFile(domainController);
            this.archiveFileMap.put(domainController, file);
        }
        return file;
    }

    public ArrayList getDcList() {
        return this.dcList;
    }

    public void removeFileFromMap(String domainController) {
        this.archiveFileMap.remove(domainController);
    }

    public void enableArchiving(boolean enable) {
        for (ArchiveFile file : this.archiveFileMap.values()) {
            if (enable) {
                file.reopen();
                continue;
            }
            file.close();
        }
        DataArchiver.getInstance().setNeedToArchive(enable);
    }

    public Row getArchiveConfig() {
        Row row = null;
        try {
            DataObject archiveDataObject = CommonUtil.getPersistence(new boolean[0]).get(ARCHIVE_CONFIG_TABLE, (Row)null);
            if (archiveDataObject.size(ARCHIVE_CONFIG_TABLE) > 0) {
                row = archiveDataObject.getRow(ARCHIVE_CONFIG_TABLE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    public void addOrUpdateArchiveConfig(HashMap archiveConfigMap) {
        try {
            DataObject archiveDataObject = CommonUtil.getPersistence(new boolean[0]).get(ARCHIVE_CONFIG_TABLE, (Row)null);
            if (archiveDataObject.size(ARCHIVE_CONFIG_TABLE) > 0) {
                Row row = this.getArchiveConfig();
                CommonUtil.getRowObject(row, archiveConfigMap);
                archiveDataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(archiveDataObject);
                this.updateDataArchiver(archiveConfigMap);
            } else {
                Row row = new Row(ARCHIVE_CONFIG_TABLE);
                CommonUtil.getRowObject(row, archiveConfigMap);
                archiveDataObject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(archiveDataObject);
                this.updateDataArchiver(archiveConfigMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDataArchiver(HashMap archiveConfigMap) {
        if (archiveConfigMap.get("FILE_CREATION_INTERVAL") != null) {
            DataArchiver.getInstance().setArchiveFileCreationTime((Long)archiveConfigMap.get("FILE_CREATION_INTERVAL"));
        }
        if (archiveConfigMap.get("ZIP_CREATION_INTERVAL") != null) {
            DataArchiver.getInstance().setArchiveZipCreationTime((Long)archiveConfigMap.get("ZIP_CREATION_INTERVAL"));
        }
        if (archiveConfigMap.get("BASE_ARCHIVE_DIRECTORY") != null) {
            for (ArchiveFile file : this.archiveFileMap.values()) {
                file.close();
            }
            String path = (String)archiveConfigMap.get("BASE_ARCHIVE_DIRECTORY");
            if (path.lastIndexOf(File.separator) != path.length() - 1) {
                path = path + File.separator;
            }
            DataArchiver.getInstance();
            DataArchiver.setBaseArchiveDirectory(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getZipCreationTimeMap() {
        Connection connection = null;
        Statement statement = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            String selectQuery = "SELECT SOURCE, MAX(CREATION_TIME) as MAX_TIME FROM AUDARCHIVEDFILES GROUP BY SOURCE";
            ResultSet resultSet = QueryUtil.executeQuery("Get Start End Values", statement, selectQuery);
            while (resultSet.next()) {
                this.zipCreationTimeMap.put(resultSet.getString("SOURCE"), resultSet.getLong("MAX_TIME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public Long getZipCreationTime(String domainController) {
        Long zipCreationTime = 0L;
        if (this.zipCreationTimeMap.get(domainController) != null) {
            zipCreationTime = (Long)this.zipCreationTimeMap.get(domainController);
        }
        return zipCreationTime;
    }

    public void setZipCreationTime(String domainController, Long zipCreationTime) {
        this.zipCreationTimeMap.put(domainController, zipCreationTime);
    }

    public String checkArchiveFolderPermission(String archivePath) {
        String message = null;
        try {
            File file = new File(archivePath + File.separator + "Test.txt");
            if (file.createNewFile()) {
                message = "Success";
                file.delete();
            } else {
                message = rb.getString("adap.ArchiveFileAPI.Unable_to_write_to_given_directory_kindly_change_to_necessary_permissions");
            }
        }
        catch (Exception ex) {
            message = rb.getString("adap.ArchiveFileAPI.Unable_to_write_to_given_directory_kindly_change_to_necessary_permissions") + "." + ex.getMessage() + ".";
            ex.printStackTrace();
        }
        return message;
    }
}

