/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.archive;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveLogonData {
    private static final Logger logger = Logger.getLogger(ArchiveLogonData.class.getName());
    public static long daysToBackup = 0L;
    private String META_TABLE = "AUDMetaTable";

    public List getDumpTables() throws DataAccessException {
        ArrayList<String> l = new ArrayList<String>();
        long currentTime = System.currentTimeMillis();
        long previousTime = daysToBackup * 24L * 60L * 60L * 1000L;
        long filterTimeStamp = currentTime - previousTime;
        logger.log(Level.INFO, "Filter Time Stamp -> " + filterTimeStamp);
        Criteria c = new Criteria(Column.getColumn((String)this.META_TABLE, (String)"END_TIME"), (Object)filterTimeStamp, 7);
        Criteria tblName = new Criteria(Column.getColumn((String)this.META_TABLE, (String)"LOOKUP_TABLENAME"), (Object)"AUDLogonInfo_", 12);
        Criteria tot = c.and(tblName);
        DataObject metaTable = CommonUtil.getPersistence(new boolean[0]).get(this.META_TABLE, tot);
        Iterator ie = metaTable.getRows(this.META_TABLE);
        while (ie.hasNext()) {
            Row r = (Row)ie.next();
            String lookupTableName = (String)r.get("LOOKUP_TABLENAME");
            l.add(lookupTableName);
        }
        logger.log(Level.INFO, "Tables List -> " + ((Object)l).toString());
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpLogonData() throws DataAccessException, SQLException, Exception {
        List tblDelList = this.getDumpTables();
        if (tblDelList.size() < 1) {
            logger.log(Level.INFO, "No logon tables to cleanup.");
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            for (int i = 0; i < tblDelList.size(); ++i) {
                String sql = "DROP TABLE " + tblDelList.get(i);
                String updateMetaTable = "DELETE FROM AUDMetaTable WHERE LOOKUP_TABLENAME = '" + tblDelList.get(i) + "'";
                logger.log(Level.INFO, "Dropping Logon table " + tblDelList.get(i));
                QueryUtil.executeUpdate("Dropping extra Logon data", statement, sql);
                QueryUtil.executeUpdate("Update Meta table", statement, updateMetaTable);
            }
            logger.log(Level.INFO, "Finished dropping logon tables, count : " + tblDelList.size());
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    public void setDaysToKeepData(long days) {
        daysToBackup = days;
    }

    public void testMethod() {
    }
}

