/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.archive;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFile;
import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFileAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DataArchiver
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DataArchiver.class.getName());
    private final Integer waitObject = new Integer(0);
    private boolean shutdown = false;
    private Hashtable eventMap = new Hashtable();
    private int fileDay = 0;
    private int fileMonth = 0;
    private int fileYear = 0;
    private static String BASE_ARCHIVE_DIRECTORY = null;
    public TreeSet sort = null;
    private static boolean needToArchive = false;
    private static long waitTime = 500L;
    private static int noOfEvents = 500;
    private static long archiveFileCreationTime = 86400000L;
    private static long archiveZipCreationTime = 172800000L;
    private static int archiveBufferSize = 8192;
    private static DataArchiver dataArchiver = null;

    public static String getBaseArchiveDirectory() {
        return BASE_ARCHIVE_DIRECTORY;
    }

    public static void setBaseArchiveDirectory(String baseArchiveDirectory) {
        BASE_ARCHIVE_DIRECTORY = baseArchiveDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataArchiver getInstance() {
        if (dataArchiver != null) return dataArchiver;
        Class<DataArchiver> clazz = DataArchiver.class;
        synchronized (DataArchiver.class) {
            if (dataArchiver != null) return dataArchiver;
            dataArchiver = new DataArchiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataArchiver;
        }
    }

    private DataArchiver() {
        super("DATA ARCHIVER");
        if (needToArchive) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.log(Level.FINER, " DATA ARCHIVER SUCCESSFULLY STARTED =========>>>>>>>>");
        while (!this.shutdown) {
            this.storeEvent();
            Integer n = this.waitObject;
            synchronized (n) {
                try {
                    this.waitObject.wait(waitTime);
                    LOGGER.log(Level.FINER, " DATA ARCHIVER RESUMES FROM SLEEP===========");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveEvent(Hashtable eventTable) {
        if (!needToArchive) {
            return;
        }
        String domainController = (String)eventTable.get("DomainController");
        Vector<Hashtable> eventList = null;
        Serializable serializable = this.eventMap;
        synchronized (serializable) {
            eventList = (Vector<Hashtable>)this.eventMap.get(domainController);
            if (eventList == null) {
                eventList = new Vector<Hashtable>();
            }
            eventList.add(eventTable);
            this.eventMap.put(domainController, eventList);
        }
        if (eventList.size() >= noOfEvents) {
            serializable = this.waitObject;
            synchronized (serializable) {
                this.waitObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEvent() {
        if (!needToArchive) {
            return;
        }
        Hashtable tempRecordMap = null;
        Hashtable hashtable = this.eventMap;
        synchronized (hashtable) {
            tempRecordMap = this.eventMap;
            this.eventMap = new Hashtable();
        }
        for (Map.Entry entry : tempRecordMap.entrySet()) {
            String domainController = (String)entry.getKey();
            Vector records = (Vector)entry.getValue();
            ArchiveFile file = ArchiveFileAPI.getInstance().getArchiveFile(domainController);
            file.writeInFile(records);
            this.checkForFileCreation(domainController);
        }
    }

    private void checkForFileCreation(String domainController) {
        ArchiveFile file = ArchiveFileAPI.getInstance().getArchiveFile(domainController);
        Long lastFileCreatedTime = file.getFileCreationTime();
        long fileDiff = System.currentTimeMillis() - lastFileCreatedTime;
        if (fileDiff > archiveFileCreationTime) {
            this.closeFiles(domainController);
        }
        this.checkForZipFileCreation(domainController);
    }

    private boolean checkForZipFileCreation(String domainController) {
        Long lastZipFileCreatedTime = ArchiveFileAPI.getInstance().getZipCreationTime(domainController);
        long zipDiff = System.currentTimeMillis() - lastZipFileCreatedTime;
        if (zipDiff > archiveZipCreationTime) {
            this.closeFiles(domainController);
            String directoryName = BASE_ARCHIVE_DIRECTORY + domainController;
            try {
                String zipFileName = this.createZipFile(directoryName, domainController);
                if (zipFileName == null) {
                    LOGGER.log(Level.INFO, "Unable to create zip for =={0}", directoryName);
                }
                if (zipFileName != null) {
                    this.updateDatabase(new File(zipFileName), domainController);
                }
            }
            catch (Exception ee) {
                LOGGER.log(Level.WARNING, "Exception while searching file =={0}", directoryName);
                ee.printStackTrace();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createZipFile(String directoryName, String dcName) {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        ArrayList<Long> arr = new ArrayList<Long>(files.length);
        SimpleDateFormat format = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
        String dateString = format.format(new Date());
        String zipFileName = directory.getAbsolutePath() + "_" + dateString + ".zip";
        FileOutputStream dest = null;
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        try {
            dest = new FileOutputStream(zipFileName);
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[archiveBufferSize];
            for (int i = 0; i < files.length; ++i) {
                int count;
                String filename = files[i].getName();
                arr.add(i, new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss").parse(filename).getTime());
                LOGGER.log(Level.INFO, "ADDING  {0} To zip {1}", new Object[]{filename, zipFileName});
                FileInputStream fi = new FileInputStream(files[i]);
                origin = new BufferedInputStream(fi, archiveBufferSize);
                ZipEntry entry = new ZipEntry(filename);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, archiveBufferSize)) != -1) {
                    out.write(data, 0, count);
                }
                fi.close();
                origin.close();
            }
            this.sort = new TreeSet(arr);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, " Exception while creating Zip file {0}", zipFileName);
            e.printStackTrace();
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out != null) {
                    out.close();
                }
                if (dest != null) {
                    dest.close();
                }
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
                directory.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return zipFileName;
    }

    private void closeFiles(String domainController) {
        ArchiveFile file = ArchiveFileAPI.getInstance().getArchiveFile(domainController);
        file.close();
        ArchiveFileAPI.getInstance().removeFileFromMap(domainController);
    }

    public void disableArchiving() {
        ArchiveFileAPI.getInstance().enableArchiving(false);
    }

    public void enableArchiving() {
        ArchiveFileAPI.getInstance().enableArchiving(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInstantZipFile() {
        Integer n = this.waitObject;
        synchronized (n) {
            this.waitObject.notify();
        }
    }

    private void updateDatabase(File zipFile, String domainController) {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("AUDArchivedFiles");
            row.set("SOURCE", (Object)domainController);
            row.set("CREATION_TIME", (Object)System.currentTimeMillis());
            row.set("FILE_NAME", (Object)zipFile.getAbsolutePath());
            row.set("FILE_SIZE", (Object)zipFile.length());
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            ArchiveFileAPI.getInstance().setZipCreationTime(domainController, (Long)row.get("CREATION_TIME"));
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " EXCEPTION WHILE Archiving File in database ========={0} Source =={1}", new Object[]{zipFile.toString(), domainController});
            ee.printStackTrace();
        }
    }

    public boolean isNeedToArchive() {
        return needToArchive;
    }

    public void setNeedToArchive(boolean needToArchive) {
        DataArchiver.needToArchive = needToArchive;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public long getArchiveFileCreationTime() {
        return archiveFileCreationTime;
    }

    public void setArchiveFileCreationTime(long archiveFileCreationTime) {
        DataArchiver.archiveFileCreationTime = archiveFileCreationTime;
    }

    public long getArchiveZipCreationTime() {
        return archiveZipCreationTime;
    }

    public void setArchiveZipCreationTime(long archiveZipCreationTime) {
        DataArchiver.archiveZipCreationTime = archiveZipCreationTime;
    }

    static {
        Row archiveConfigRow = ArchiveFileAPI.getInstance().getArchiveConfig();
        if (archiveConfigRow == null) {
            String dirName = System.getProperty("server.home");
            BASE_ARCHIVE_DIRECTORY = dirName + File.separator + "archive" + File.separator;
            File baseArchiveDir = new File(BASE_ARCHIVE_DIRECTORY);
            if (!baseArchiveDir.exists()) {
                baseArchiveDir.mkdirs();
            }
            try {
                BASE_ARCHIVE_DIRECTORY = baseArchiveDir.getCanonicalPath() + File.separator;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, Object> archiveConfigMap = new HashMap<String, Object>();
            archiveConfigMap.put("BASE_ARCHIVE_DIRECTORY", BASE_ARCHIVE_DIRECTORY);
            archiveConfigMap.put("FILE_CREATION_INTERVAL", archiveFileCreationTime);
            archiveConfigMap.put("ZIP_CREATION_INTERVAL", archiveZipCreationTime);
            archiveConfigMap.put("ENABLE_ARCHIVING", false);
            ArchiveFileAPI.getInstance().addOrUpdateArchiveConfig(archiveConfigMap);
        } else {
            BASE_ARCHIVE_DIRECTORY = (String)archiveConfigRow.get("BASE_ARCHIVE_DIRECTORY") + File.separator;
            archiveFileCreationTime = (Long)archiveConfigRow.get("FILE_CREATION_INTERVAL");
            archiveZipCreationTime = (Long)archiveConfigRow.get("ZIP_CREATION_INTERVAL");
            needToArchive = (Boolean)archiveConfigRow.get("ENABLE_ARCHIVING");
        }
        LOGGER.log(Level.INFO, " BASE ARCHIVE DIRECTORY IS ==={0}", BASE_ARCHIVE_DIRECTORY);
    }
}

