/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.mfw.BackupDB;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.sym.adsm.auditing.server.backupdata.BackupEventTables;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADAPBackupDB
extends BackupDB {
    private static final Logger logger = Logger.getLogger(ADAPBackupDB.class.getName());
    private static String dbServerName = null;

    private static void backupEventTables(String backupDir) throws Exception {
        Date today = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd-HHmm");
        String datenewformat = formatter.format(today);
        String path = backupDir + File.separator + "EventData" + File.separator + datenewformat;
        File file = new File(path);
        file.mkdirs();
        dbServerName = ChangeDBServer.getActiveDB();
        for (String tableName : BackupEventTables.tables) {
            ArrayList metatableNameList = BackupEventTables.getTableList(tableName);
            logger.log(Level.INFO, "Meta Tables List : " + metatableNameList);
            if (metatableNameList.isEmpty()) continue;
            for (Object object : metatableNameList) {
                String metaTableName = (String)object;
                try {
                    ADAPBackupDB.dumpTable(metaTableName, path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void dumpTable(String table, String path) throws Exception {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        System.out.println("Dumping table+ " + table);
        try {
            connection = RelationalAPI.getInstance().getConnection();
            String fileName = path + File.separator + table + ".csv";
            fileName = fileName.replace("\\", "\\\\");
            String query = null;
            if (dbServerName.equalsIgnoreCase("mysql")) {
                query = "SELECT * INTO OUTFILE \"" + fileName + "\" " + "FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n' FROM " + table;
                preparedStatement = connection.prepareStatement(query);
                resultSet = preparedStatement.executeQuery();
            } else if (dbServerName.equalsIgnoreCase("postgres")) {
                ArrayList<String> dumpCMD = new ArrayList<String>();
                String dbDumpPath = System.getProperty("db.home") + "/bin/pg_dump.exe";
                File file = new File(path);
                dumpCMD.add(dbDumpPath);
                dumpCMD.add("-Upostgres");
                String url = ChangeDBServer.getPropertyValue("url");
                String temp = "" + url.substring(url.indexOf("localhost:") + 10, url.length());
                String port = temp.substring(0, temp.indexOf("/"));
                dumpCMD.add("--port=" + port);
                dumpCMD.add("--host=127.0.0.1");
                dumpCMD.add("-t");
                dumpCMD.add(table);
                dumpCMD.add("-f");
                dumpCMD.add(file.getCanonicalPath() + File.separator + table + ".sql");
                dumpCMD.add("adap");
                String[] commandToExecute = dumpCMD.toArray(new String[dumpCMD.size()]);
                Process process = Runtime.getRuntime().exec(commandToExecute);
                String errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
                if (errorStream != null) {
                    logger.log(Level.SEVERE, errorStream);
                    throw new Exception("Error occured while backup " + table + " table :: ErrorStream message ::: " + errorStream);
                }
            }
            String filename23 = BackupEventTables.createZipFile(path, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static void main(String[] args) {
        String backupDir = args[0];
        String backupFile = null;
        if (args.length > 1) {
            backupFile = args[1];
        }
        logger.log(Level.INFO, "Backup Directory :: " + backupDir);
        logger.log(Level.INFO, "Backup File Name :: " + backupFile);
        try {
            ADAPBackupDB.backupDB((String)backupDir, (String)backupFile, (int)2, (boolean)false);
            ConsoleOut.println((String)"Backing up Event Data......");
            ADAPBackupDB.backupEventTables(backupDir);
            ConsoleOut.println((String)"Event Data backed up Successfully.");
            System.exit(0);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while BackingUp DB. ", e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

