/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.backupdata.BackupEventTables;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADAPRestoreDB {
    private static final Logger logger = Logger.getLogger(ADAPRestoreDB.class.getName());

    private static void restoreEventDB(String backupDir) throws Exception {
        for (String tableName : BackupEventTables.tables) {
            ArrayList fileList = ADAPRestoreDB.getBackupTables(tableName, backupDir);
            for (Object object : fileList) {
                HashMap hashMap = (HashMap)object;
                RestoreUtil.recreateTable(hashMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getBackupTables(String tableName, String backupDir) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList fileList = new ArrayList();
        try {
            String query = "SELECT LOOKUP_TABLENAME FROM AUDMetaTable where LOOKUP_TABLENAME LIKE '" + tableName + "_1%'";
            logger.log(Level.INFO, "query is :" + query);
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Backup meta tables :", statement, query);
            while (resultSet.next()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String lookupTableName = resultSet.getString("LOOKUP_TABLENAME");
                hashMap.put("TABLE_NAME", tableName);
                hashMap.put("LOOKUP_TABLENAME", lookupTableName);
                hashMap.put("BASE_DB_BACKUP_DIRECTORY", backupDir);
                hashMap.put("FILE_NAME", lookupTableName + ".zip");
                fileList.add(hashMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileList;
    }

    public static void main(String[] args) {
        String src = args[0];
        try {
            ADAPRestoreDB.restoreEventDB(src);
            System.exit(0);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while Restoring DB. ", e);
            System.exit(1);
        }
    }
}

