/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.archive.DataArchiver;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.MssqlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Backup {
    private static int attempt = 1;
    private boolean dbhealthstatus = true;
    private String dbserver = "mysql";
    private String backupDir = null;
    private String backupFileName = null;
    private String separator = File.separator;
    private BufferedWriter outWriter = null;
    private static int archiveBufferSize = 8192;
    public static Backup backUp = null;
    private static Logger logger = Logger.getLogger(Backup.class.getName());
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static Integer success = 1;
    public static Integer failure = 2;
    public static Integer retry = 3;

    public static Backup getInstance() {
        if (backUp == null) {
            backUp = new Backup();
        }
        return backUp;
    }

    private static String format(String colData) {
        StringBuffer buffer = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(colData);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\'') {
                buffer.append("''");
            } else if (character == '\\') {
                buffer.append("\\\\");
            } else if (character == '\r') {
                buffer.append("\\r");
            } else if (character == '\n') {
                buffer.append("\\n");
            } else if (character != '\u0000') {
                buffer.append(character);
            }
            character = iterator.next();
        }
        return buffer.toString();
    }

    private static boolean isTextColumn(String columnType) {
        boolean flag = false;
        if ("varchar".equalsIgnoreCase(columnType) || "nvarchar".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("char".equalsIgnoreCase(columnType) || "nchar".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("text".equalsIgnoreCase(columnType) || "ntext".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("datetime".equalsIgnoreCase(columnType) || "timestamp".equalsIgnoreCase(columnType)) {
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean dumpTable(String table) throws Exception {
        logger.info("Into dumpTable, dumping + " + table);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        Boolean b = false;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            this.backupDir = Backup.getBackupDir();
            String fileName = this.backupDir + this.separator + table + ".csv";
            String dbServerName = CommonUtil.getDBServerName();
            if (dbServerName.equalsIgnoreCase("mysql")) {
                fileName = fileName.replace("\\", "\\\\");
            }
            if (dbServerName.equalsIgnoreCase("mssql")) {
                MssqlUtil.getInstance();
                query = MssqlUtil.getBackupQuery(table, fileName);
                Backup.executeCommand(query);
            } else if (dbServerName.equalsIgnoreCase("mysql")) {
                query = "SELECT * INTO OUTFILE \"" + fileName + "\" " + "FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n' FROM " + table;
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
            } else if (dbServerName.equalsIgnoreCase("postgres")) {
                query = "COPY " + table + " TO '" + fileName + "' NULL AS ''";
                stmt = conn.prepareStatement(query);
                stmt.execute();
            }
            b = true;
            if (!dbServerName.equalsIgnoreCase("mssql")) {
                logger.fine("Backingup meta Table, Query is :" + query);
            }
        }
        catch (Exception e) {
            b = false;
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        if (b.booleanValue()) {
            String filename23 = Backup.createZipFile(this.backupDir, table);
        }
        return b;
    }

    public static Integer executeCommand(String command) throws Exception {
        Integer val = failure;
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        boolean b = true;
        while ((line = bufReader.readLine()) != null) {
            if (line.trim().equalsIgnoreCase(rb.getString("adap.common.bcp_0_rows_copied").toUpperCase())) {
                val = retry;
            } else if (line.toUpperCase().contains(rb.getString("adap.common.bcp_rows_copied").toUpperCase())) {
                val = success;
            }
            logger.log(Level.INFO, "BCP Return line in Backup java " + line);
        }
        bufReader.close();
        p.waitFor();
        if (val == failure) {
            throw new Exception(rb.getString("adap.common.bcp_backup"));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getMetaData(String table_name) {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = conn.prepareStatement("SELECT TABLE_ID FROM TableDetails where TABLE_NAME = '" + table_name + "'");
            rs = stmt.executeQuery();
            if (rs.next()) {
                stmt = conn.prepareStatement("SELECT COLUMN_NAME, MAX_SIZE FROM ColumnDetails where TABLE_ID = '" + rs.getString(1) + "'");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hash.put(rs.getString(1), rs.getString(2));
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        return hash;
    }

    public static String getBackupDir() {
        String baseDataBacUpDir = "";
        try {
            baseDataBacUpDir = DataArchiver.getBaseArchiveDirectory();
            baseDataBacUpDir = baseDataBacUpDir + "tableBackup" + File.separator;
            File baseDir = new File(baseDataBacUpDir);
            baseDataBacUpDir = baseDir.getCanonicalPath() + File.separator;
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Backup Directory is " + baseDataBacUpDir);
        return baseDataBacUpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createZipFile(String directoryName, String fileName) throws Exception {
        String zipFileName = "";
        BufferedInputStream origin = null;
        FileOutputStream dest = null;
        ZipOutputStream out = null;
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        try {
            zipFileName = directory.getAbsolutePath() + File.separator + fileName + ".zip";
            dest = new FileOutputStream(zipFileName);
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[archiveBufferSize];
            for (int i = 0; i < files.length; ++i) {
                int count;
                String fileToZip = files[i].getName();
                if (!fileToZip.contains(fileName + ".csv")) continue;
                FileInputStream fi = new FileInputStream(files[i]);
                origin = new BufferedInputStream(fi, archiveBufferSize);
                ZipEntry entry = new ZipEntry(fileToZip);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, archiveBufferSize)) != -1) {
                    out.write(data, 0, count);
                }
                fi.close();
                origin.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out != null) {
                    out.close();
                }
                if (dest != null) {
                    dest.close();
                }
                for (int i = 0; i < files.length; ++i) {
                    String filename1 = files[i].getName();
                    if (!filename1.contains(fileName + ".csv")) continue;
                    files[i].delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileName;
    }
}

