/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BackupEventTables {
    private static int archiveBufferSize = 8192;
    private static String dirName = null;
    private static String dbServerName = null;
    public static String[] tables = new String[]{"AUDLogonInfo", "AUDAccountCreation", "AUDUserMgmt", "AUDGroupMgmt", "AUDComputerMgmt", "AUDPolicyChange", "AUDOUMgmt", "AUDGPOMgmt", "AUDLogonLogoffInfo", "AUDFileAuditInfo", "AUDComputerAuditInfo", "AUDNPSAuditInfo", "AUDFileIntegrityMonitor", "AUDDNSAuditInfo", "AUDADOAuditInfo", "AUDADFSLogonLogoffInfo"};

    public static void backupTables(String tableName) {
        try {
            ArrayList metatableNameList = BackupEventTables.getTableList(tableName);
            System.out.println("Meta Tables List : " + metatableNameList);
            if (!metatableNameList.isEmpty()) {
                BackupEventTables.dumpTable(metatableNameList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void backupTables_New(String tableName) {
        try {
            ArrayList metatableNameList = BackupEventTables.getTableList(tableName);
            System.out.println("Table Name : " + tableName);
            System.out.println("Tables count : " + metatableNameList.size());
            if (!metatableNameList.isEmpty()) {
                for (int i = 0; i < metatableNameList.size(); ++i) {
                    String metaTableName = (String)metatableNameList.get(i);
                    System.out.println("Backing up table : " + i);
                    BackupEventTables.dumpTable(metaTableName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean dumpTable(ArrayList metaTableNameList) {
        try {
            for (int i = 0; i < metaTableNameList.size(); ++i) {
                boolean b = true;
                String metaTableName = (String)metaTableNameList.get(i);
                try {
                    BackupEventTables.dumpTable(metaTableName);
                }
                catch (Exception e) {
                    b = false;
                    e.printStackTrace();
                }
                if (!b) continue;
                BackupEventTables.backUpmetaTableRow(metaTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void dumpTable(String table) throws Exception {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        System.out.println("Dumping table+ " + table);
        try {
            connection = RelationalAPI.getInstance().getConnection();
            String fileName = dirName + File.separator + table + ".csv";
            fileName = fileName.replace("\\", "\\\\");
            String query = null;
            if (dbServerName.equalsIgnoreCase("mysql")) {
                query = "SELECT * INTO OUTFILE \"" + fileName + "\" " + "FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n' FROM " + table;
            } else if (dbServerName.equalsIgnoreCase("postgres")) {
                query = "COPY " + table + " TO " + fileName + " NULL AS ''";
            }
            System.out.println("Query -> " + query);
            preparedStatement = connection.prepareStatement(query);
            resultSet = preparedStatement.executeQuery();
            String filename23 = BackupEventTables.createZipFile(dirName, table);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createZipFile(String directoryName, String fileName) throws Exception {
        String zipFileName = "";
        BufferedInputStream origin = null;
        FileOutputStream dest = null;
        ZipOutputStream out = null;
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        try {
            zipFileName = directory.getAbsolutePath() + File.separator + fileName + ".zip";
            dest = new FileOutputStream(zipFileName);
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[archiveBufferSize];
            for (int i = 0; i < files.length; ++i) {
                int count;
                String fileToZip = files[i].getName();
                if (!fileToZip.contains(fileName + ".csv") && !fileToZip.contains(fileName + ".sql")) continue;
                FileInputStream fi = new FileInputStream(files[i]);
                origin = new BufferedInputStream(fi, archiveBufferSize);
                ZipEntry entry = new ZipEntry(fileToZip);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, archiveBufferSize)) != -1) {
                    out.write(data, 0, count);
                }
                fi.close();
                origin.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out != null) {
                    out.close();
                }
                if (dest != null) {
                    dest.close();
                }
                for (int i = 0; i < files.length; ++i) {
                    String filename1 = files[i].getName();
                    if (!filename1.contains(fileName + ".csv") && !filename1.contains(fileName + ".sql")) continue;
                    files[i].delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTableList(String tableName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            String query = "SELECT * FROM AUDMetaTable where LOOKUP_TABLENAME like '" + tableName + "_1%'";
            System.out.println("query is :" + query);
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting meta tables :", statement, query);
            while (resultSet.next()) {
                tableList.add(resultSet.getString("LOOKUP_TABLENAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTableList_New(String tableName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            String query = "SHOW TABLES LIKE '" + tableName + "_%'";
            System.out.println("query is :" + query);
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting meta tables :", statement, query);
            while (resultSet.next()) {
                tableList.add(resultSet.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean backUpmetaTableRow(String metaTableName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Statement preparedStatement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            String criteria = "WHERE LOOKUP_TABLENAME='" + metaTableName + "'";
            String query = "SELECT * from AUDMetaTable " + criteria;
            preparedStatement = connection.prepareStatement("INSERT INTO AUDBackUpMetaTable(TABLE_NAME, START_TIME, END_TIME, START_INDEX, END_INDEX, LOOKUP_TABLENAME, FILE_NAME, BASE_DB_BACKUP_DIRECTORY, IS_REGENERATE_DATA) VALUES (?,?,?,?,?,?,?,?,?)");
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Meta Entry :", statement, query);
            while (resultSet.next()) {
                preparedStatement.setString(1, resultSet.getString("TABLE_NAME"));
                preparedStatement.setLong(2, resultSet.getLong("START_TIME"));
                preparedStatement.setLong(3, resultSet.getLong("END_TIME"));
                preparedStatement.setLong(4, resultSet.getLong("START_INDEX"));
                preparedStatement.setLong(5, resultSet.getLong("END_INDEX"));
                preparedStatement.setString(6, resultSet.getString("LOOKUP_TABLENAME"));
                preparedStatement.setString(7, resultSet.getString("LOOKUP_TABLENAME") + ".zip");
                preparedStatement.setString(8, dirName);
                preparedStatement.setBoolean(9, false);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            String deleteMetaEntryQuery = "DELETE FROM AUDMetaTable " + criteria;
            QueryUtil.executeSingleQuery("DELETE META TABLE ENTRY ", deleteMetaEntryQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            for (String string : tables) {
                BackupEventTables.backupTables(string);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        try {
            String confFileDir = System.getProperty("server.home") + "/conf/";
            try {
                PersistenceInitializer.initializeDB((String)confFileDir);
            }
            catch (Exception ex) {
                ConsoleOut.println((String)ex.getMessage());
            }
            dirName = System.getProperty("server.home");
            dirName = dirName + File.separator + "EventBackup" + File.separator;
            if (!new File(dirName).exists()) {
                new File(dirName).mkdirs();
            }
            dbServerName = ChangeDBServer.getActiveDB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

