/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestoreArchivedEventTable {
    public String doAction = "";
    public static boolean isAlive = false;
    public static boolean spaceException = false;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private Logger logger = Logger.getLogger(RestoreArchivedEventTable.class.getName());
    public static Properties categories = new Properties();
    private static RestoreArchivedEventTable restoreArchivedEventTable = null;
    public Queue<String> loadDataTable = null;
    public Action action = null;

    private RestoreArchivedEventTable() {
        try {
            this.loadDataTable = new LinkedList<String>();
            this.action = new Action();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error while load event table");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestoreArchivedEventTable getInstance() {
        if (restoreArchivedEventTable != null) return restoreArchivedEventTable;
        Class<RestoreArchivedEventTable> clazz = RestoreArchivedEventTable.class;
        synchronized (RestoreArchivedEventTable.class) {
            restoreArchivedEventTable = new RestoreArchivedEventTable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return restoreArchivedEventTable;
        }
    }

    public static void setStatusUnload() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"STATUS"), null, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDBackUpMetaTable", crit);
            Iterator iterator = dObj.getRows("AUDBackUpMetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("STATUS", (Object)rb.getString("adap.RestoreArchivedEventTable.Unloaded"));
                dObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getDumpEventTableSettings(String sortColumn, String sortOrder, Integer fromIndex, Integer range, Integer count, String searchCategory, String loadType, boolean isEmber) {
        RestoreArchivedEventTable.setStatusUnload();
        ArrayList dumpTableList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        boolean search = true;
        try {
            Criteria crit;
            boolean isAsc = true;
            if (sortOrder != null && (sortOrder.equals("DSC") || sortOrder.equals("DESC"))) {
                isAsc = false;
            }
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
            Join AudBackUpMetaEventCategoriesJoin = new Join("AUDBackUpMetaTable", "AUDBackupDataConfig", new String[]{"TABLE_NAME"}, new String[]{"TABLE_NAME"}, 2);
            selectQuery.addJoin(AudBackUpMetaEventCategoriesJoin);
            if (!loadType.equals("All") && !searchCategory.equals("All")) {
                crit = null;
                crit = searchCategory.equalsIgnoreCase(rb.getString("adap.AdminController.Import_Log_File")) ? new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"IMPORT_TABLE"), (Object)true, 0) : new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"), (Object)categories.getProperty(searchCategory), 0);
                Criteria crit1 = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"STATUS"), (Object)loadType, 0);
                selectQuery.setCriteria(crit.and(crit1));
            } else {
                if (!searchCategory.equals("All")) {
                    crit = null;
                    crit = searchCategory.equalsIgnoreCase(rb.getString("adap.AdminController.Import_Log_File")) ? new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"IMPORT_TABLE"), (Object)true, 0) : new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"), (Object)categories.getProperty(searchCategory), 0);
                    selectQuery.setCriteria(crit);
                }
                if (!loadType.equals("All")) {
                    Criteria crit1 = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"STATUS"), (Object)loadType, 0);
                    selectQuery.setCriteria(crit1);
                }
            }
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)"*"));
            Integer innerTopVal = fromIndex - 1 + range;
            if (count > 0 && count < innerTopVal) {
                range = count % range;
            }
            if (fromIndex != null && range != null && sortColumn != null) {
                selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)sortColumn), isAsc));
                selectQuery.setRange(new Range(fromIndex.intValue(), range.intValue()));
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                HashMap<String, Object> backupMetatableMap = new HashMap<String, Object>();
                String action = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                boolean b = Boolean.valueOf(dataSet.getValue("IS_REGENERATE_DATA").toString());
                if (b) {
                    action = rb.getString("adap.RestoreArchivedEventTable.Loaded");
                }
                String categoryName = rb.getString((String)dataSet.getValue("CATEGORY_DISPLAY_NAME"));
                String zipFileName = (String)dataSet.getValue("FILE_NAME");
                long startTime = Long.valueOf(dataSet.getValue("START_TIME").toString());
                long endTime = new Long(dataSet.getValue("END_TIME").toString());
                String startTimeStr = TimeUtil.formatDate(startTime * 1000L);
                String endTimeStr = TimeUtil.formatDate(endTime * 1000L);
                String status = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                SelectQueryImpl selectQuery1 = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
                Criteria crit2 = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"FILE_NAME"), (Object)zipFileName, 0);
                DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDBackUpMetaTable", crit2);
                Row row = dObj.getRow("AUDBackUpMetaTable");
                if (dataSet.getValue("STATUS") != null) {
                    status = (String)dataSet.getValue("STATUS");
                    if (!status.contains("Exception")) {
                        status = (String)dataSet.getValue("STATUS");
                        if (status.equals("Loading") && !isAlive) {
                            status = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                            row.set("STATUS", (Object)status);
                        }
                    } else {
                        String[] ExceptionData = status.split("at");
                        if (ExceptionData[0].contains("STACKTRACE")) {
                            String[] Exception1 = ExceptionData[0].split("STACKTRACE");
                            status = Exception1[1];
                        } else {
                            status = ExceptionData[0];
                        }
                    }
                } else {
                    row.set("STATUS", (Object)status);
                }
                dObj.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dObj);
                backupMetatableMap.put("ACTION", action);
                backupMetatableMap.put("CATEGORYNAME", categoryName);
                backupMetatableMap.put("FILENAME", zipFileName);
                if (isEmber) {
                    backupMetatableMap.put("START_TIME", startTime);
                    backupMetatableMap.put("END_TIME", endTime);
                } else {
                    backupMetatableMap.put("FROM", startTimeStr);
                    backupMetatableMap.put("TO", endTimeStr);
                }
                backupMetatableMap.put("STATUS", status);
                dumpTableList.add(backupMetatableMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return dumpTableList;
    }

    public static int getDataBaseSize() {
        int size = 0;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
            Join AudBackUpMetaEventCategoriesJoin = new Join("AUDBackUpMetaTable", "AUDBackupDataConfig", new String[]{"TABLE_NAME"}, new String[]{"TABLE_NAME"}, 2);
            selectQuery.addJoin(AudBackUpMetaEventCategoriesJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)"*"));
            DataObject dataAvailable = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            size = dataAvailable.size("AUDBackUpMetaTable");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int getBackupMetatableCount(String categoryName, String loadType) {
        int count = 0;
        try {
            Criteria crit;
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
            Join AudBackUpMetaEventCategoriesJoin = new Join("AUDBackUpMetaTable", "AUDBackupDataConfig", new String[]{"TABLE_NAME"}, new String[]{"TABLE_NAME"}, 2);
            selectQuery.addJoin(AudBackUpMetaEventCategoriesJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)"*"));
            DataObject dataAvailable = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!loadType.equals("All") && !categoryName.equals("All")) {
                crit = null;
                crit = categoryName.equalsIgnoreCase(rb.getString("adap.AdminController.Import_Log_File")) ? new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"IMPORT_TABLE"), (Object)true, 0) : new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"), (Object)categories.getProperty(categoryName), 0);
                Criteria crit1 = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"STATUS"), (Object)loadType, 0);
                selectQuery.setCriteria(crit.and(crit1));
            } else {
                if (!categoryName.equals("All")) {
                    crit = null;
                    crit = categoryName.equalsIgnoreCase(rb.getString("adap.AdminController.Import_Log_File")) ? new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"IMPORT_TABLE"), (Object)true, 0) : new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"), (Object)categories.getProperty(categoryName), 0);
                    selectQuery.setCriteria(crit);
                }
                if (!loadType.equals("All")) {
                    Criteria crit1 = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"STATUS"), (Object)loadType, 0);
                    selectQuery.setCriteria(crit1);
                }
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (dataObject != null) {
                count = dataObject.size("AUDBackUpMetaTable");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public void addToQueue(String eventZipFileName, String doAction) {
        try {
            this.doAction = doAction;
            String[] loadFileName = eventZipFileName.split(",");
            String message = rb.getString("adap.RestoreArchivedEventTable.Loading");
            for (int i = 0; i < loadFileName.length; ++i) {
                if (this.loadDataTable.contains(loadFileName[i])) continue;
                ArrayList loadTableDetails = this.getDumpEventTableSettings(loadFileName[i]);
                for (Object object : loadTableDetails) {
                    HashMap hashMap = (HashMap)object;
                    String lookupTableName = (String)hashMap.get("LOOKUP_TABLENAME");
                    RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
                }
                this.loadDataTable.add(loadFileName[i]);
            }
            this.logger.log(Level.INFO, "loadDataTable size: " + this.loadDataTable.size());
            this.logger.log(Level.INFO, "action Thread Status: " + this.action.isAlive());
            if (!this.action.isAlive()) {
                this.logger.log(Level.INFO, "Thread is Alive");
                this.action = new Action();
                this.action.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String zipFileName) {
        String lookupTableName;
        String message;
        block11: {
            String fileName = null;
            message = null;
            lookupTableName = null;
            boolean canLoad = true;
            boolean canUnLoad = true;
            try {
                if (this.doAction.equals("load")) {
                    canUnLoad = false;
                } else if (this.doAction.equals("unload")) {
                    canLoad = false;
                }
                if (zipFileName == null) break block11;
                fileName = zipFileName;
                message = rb.getString("adap.RestoreArchivedEventTable.Loading");
                ArrayList loadTableDetails = this.getDumpEventTableSettings(fileName);
                for (Object object : loadTableDetails) {
                    boolean reCreate;
                    HashMap hashMap = (HashMap)object;
                    boolean isRegenerate = (Boolean)hashMap.get("IS_REGENERATE_DATA");
                    lookupTableName = (String)hashMap.get("LOOKUP_TABLENAME");
                    RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
                    if (canUnLoad) {
                        message = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                        RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
                    }
                    if (isRegenerate && canUnLoad) {
                        this.deleteFromDB(hashMap);
                        message = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                        RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
                        continue;
                    }
                    if (!canLoad) continue;
                    if (!this.isTableExists(lookupTableName).booleanValue() && (reCreate = RestoreUtil.recreateTable(hashMap))) {
                        boolean action = true;
                        long dumpTime = System.currentTimeMillis() / 1000L;
                        RestoreArchivedEventTable.updateBackupTableAction(action, lookupTableName, dumpTime);
                    }
                    message = rb.getString("adap.RestoreArchivedEventTable.Loaded");
                    RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
                }
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    message = ex.getMessage();
                }
                catch (Throwable throwable) {
                    RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
                    throw throwable;
                }
                RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
            }
        }
        RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, lookupTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isTableExists(String tableName) {
        Boolean isTableExists = true;
        String query = "SELECT COUNT(UNIQUE_ID) FROM " + tableName;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            this.logger.log(Level.INFO, "For checking the Table is available in DB, Table Name is : " + tableName);
            statement.execute(query);
            this.logger.log(Level.INFO, "Table already exists : " + tableName);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Table doesn't Exist : " + tableName);
            this.logger.log(Level.INFO, e.getMessage());
            isTableExists = false;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isTableExists;
    }

    public void deleteFromDB(HashMap hashMap) {
        try {
            if (!hashMap.isEmpty()) {
                String deleteTableName = (String)hashMap.get("LOOKUP_TABLENAME");
                String fileName = (String)hashMap.get("FILE_NAME");
                System.out.println("deleteTableName : " + deleteTableName);
                String dropTableQR = "DROP TABLE  " + deleteTableName;
                QueryUtil.executeSingleQuery("DROP BACKUP TABLE", dropTableQR);
                boolean action = false;
                long dumpTime = 0L;
                RestoreArchivedEventTable.updateBackupTableAction(action, deleteTableName, dumpTime);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updateDumpEventTableLogMessage(String message, String fileName) {
        try {
            if (message == null) {
                message = rb.getString("adap.RestoreArchivedEventTable.Loaded");
            }
            String backupMetaTableName = "AUDBackUpMetaTable";
            Criteria crit = new Criteria(Column.getColumn((String)backupMetaTableName, (String)"LOOKUP_TABLENAME"), (Object)fileName, 0);
            DataObject bmDO = CommonUtil.getPersistence(new boolean[0]).get(backupMetaTableName, crit);
            Iterator ie = bmDO.getRows(backupMetaTableName);
            if (ie.hasNext()) {
                Row row = (Row)ie.next();
                row.set("STATUS", (Object)message);
                bmDO.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(bmDO);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updateBackupTableAction(boolean action, String fileName, long dumpTime) {
        try {
            isAlive = true;
            System.out.println("dump Time in updateBackupTableAction :::" + dumpTime);
            String backupMetaTableName = "AUDBackUpMetaTable";
            Criteria crit = new Criteria(Column.getColumn((String)backupMetaTableName, (String)"LOOKUP_TABLENAME"), (Object)fileName, 0);
            DataObject bmDO = CommonUtil.getPersistence(new boolean[0]).get(backupMetaTableName, crit);
            Iterator ie = bmDO.getRows(backupMetaTableName);
            if (ie.hasNext()) {
                Row row = (Row)ie.next();
                row.set("IS_REGENERATE_DATA", (Object)action);
                row.set("DUMP_TIME", (Object)dumpTime);
                bmDO.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(bmDO);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList getDumpEventTableSettings(String loadTableName) {
        ArrayList loadTableDtails = new ArrayList();
        try {
            String tableName = "AUDBackUpMetaTable";
            if (loadTableName != null) {
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"FILE_NAME"), (Object)loadTableName, 0);
                selectQuery.setCriteria(crit);
                selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
                Iterator iterator = obj.getRows(tableName);
                while (iterator.hasNext()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Row row = (Row)iterator.next();
                    String lookupTableName = (String)row.get("LOOKUP_TABLENAME");
                    String orgTableName = (String)row.get("TABLE_NAME");
                    String fileName = (String)row.get("FILE_NAME");
                    String baseDBBackupDirectory = (String)row.get("BASE_DB_BACKUP_DIRECTORY");
                    boolean isRegenerateData = (Boolean)row.get("IS_REGENERATE_DATA");
                    map.put("LOOKUP_TABLENAME", lookupTableName);
                    map.put("FILE_NAME", fileName);
                    map.put("TABLE_NAME", orgTableName);
                    map.put("BASE_DB_BACKUP_DIRECTORY", baseDBBackupDirectory);
                    map.put("IS_REGENERATE_DATA", isRegenerateData);
                    loadTableDtails.add(map);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return loadTableDtails;
    }

    public static void deleteFromDB() {
        try {
            ArrayList tableList = RestoreArchivedEventTable.getDeleteTableList();
            System.out.println("Schedule tableName List :" + tableList);
            if (!tableList.isEmpty()) {
                for (Object object : tableList) {
                    String tableName = (String)object;
                    boolean b = RestoreArchivedEventTable.deleteTable(tableName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean deleteTable(String tableName) {
        boolean b = true;
        try {
            if (tableName != null) {
                String dropTableQR = "DROP TABLE  " + tableName;
                QueryUtil.executeSingleQuery("DROP BACKUP TABLE", dropTableQR);
                boolean action = false;
                long dumpTime = 0L;
                String message = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                RestoreArchivedEventTable.updateDumpEventTableLogMessage(message, tableName);
                RestoreArchivedEventTable.updateBackupTableAction(action, tableName, dumpTime);
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        return b;
    }

    public static ArrayList getDeleteTableList() {
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            long day = 2L;
            Long TIME_PERIOD = day * 86400L;
            Long FROM = System.currentTimeMillis() / 1000L - TIME_PERIOD;
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"IS_REGENERATE_DATA"), (Object)true, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"DUMP_TIME"), (Object)0, 5));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDBackUpMetaTable", (String)"DUMP_TIME"), (Object)FROM, 7));
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackUpMetaTable", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("AUDBackUpMetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String tableName = (String)row.get("LOOKUP_TABLENAME");
                tableList.add(tableName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tableList;
    }

    static {
        String[] s = new String[]{"adap.AUDCategories.category_name.File_Audit", "adap.AUDReportCategories.name.Server_Audit_Reports", "adap.AUDCategories.category_name.Account_Logon", "adap.AUDCategories.category_name.Group_Modification", "adap.AUDCategories.category_name.Local_Logon-Logoff", "adap.AUDCategories.category_name.OU_Management", "adap.AUDCategories.category_name.User_Modification", "adap.AUDCategories.category_name.Account_Creation_", "adap.AUDCategories.category_name.Computer_Modification", "adap.AUDCategories.category_name.GPO_Management", "adap.AUDBackupDataConfig.Network_Policy_Server", "adap.AUDCategories.category_name.Domain_Policy_Changes", "adap.AUDBackupDataConfig.Advanced_AD_Auditing", "adap.AUDBackupDataConfig.DNS_Server_Auditing", "adap.AUDCategories.category_name.File_Integrity", "adap.AUDBackupDataConfig.Print_Server_Auditing"};
        for (int i = 0; i < s.length; ++i) {
            categories.setProperty(rb.getString(s[i]), s[i]);
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        @Override
        public void run() {
            try {
                while (RestoreArchivedEventTable.this.loadDataTable.size() > 0) {
                    for (int i = 0; i < RestoreArchivedEventTable.this.loadDataTable.size(); ++i) {
                        String zipFileName = RestoreArchivedEventTable.this.loadDataTable.remove();
                        RestoreArchivedEventTable.this.logger.log(Level.INFO, "Removing zip file : " + zipFileName);
                        RestoreArchivedEventTable.this.process(zipFileName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void checkAndProcess() {
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

