/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class RestoreEventTables {
    private static String[] tables = new String[]{"AUDLogonInfo", "AUDAccountCreation", "AUDUserMgmt", "AUDGroupMgmt", "AUDComputerMgmt", "AUDPolicyChange", "AUDOUMgmt", "AUDGPOMgmt", "AUDLogonLogoffInfo", "AUDNPSAuditInfo", "AUDComputerAuditInfo", "AUDFileIntegrityMonitor"};
    private static HashMap createTableCache = new HashMap();

    public static void main(String[] args) {
        try {
            for (String string : tables) {
                RestoreEventTables.restoreTables(string);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreTables(String tableName) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            ArrayList fileList = RestoreEventTables.getBackupTables(tableName);
            for (Object object : fileList) {
                HashMap hashMap = (HashMap)object;
                RestoreUtil.recreateTable(hashMap);
                RestoreEventTables.addMetaTableEntries(hashMap, connection);
                RestoreEventTables.deleteBackupMetaTableEntries(hashMap, statement);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMetaTableEntries(HashMap hashMap, Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO audmetatable (TABLE_NAME, START_TIME, END_TIME, START_INDEX, END_INDEX, LOOKUP_TABLENAME, STATUS) VALUES (?,?,?,?,?,?,? )");
            preparedStatement.setString(1, (String)hashMap.get("TABLE_NAME"));
            preparedStatement.setLong(2, (Long)hashMap.get("START_TIME"));
            preparedStatement.setLong(3, (Long)hashMap.get("END_TIME"));
            preparedStatement.setLong(4, (Long)hashMap.get("START_INDEX"));
            preparedStatement.setLong(5, (Long)hashMap.get("END_INDEX"));
            preparedStatement.setString(6, (String)hashMap.get("LOOKUP_TABLENAME"));
            preparedStatement.setString(7, "SUCCESS");
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void deleteBackupMetaTableEntries(HashMap hashMap, Statement statement) throws Exception {
        String tableName = (String)hashMap.get("TABLE_NAME");
        String lookupTableName = (String)hashMap.get("LOOKUP_TABLENAME");
        String deleteQuery = "SELECT * FROM AUDBackUpMetaTable WHERE TABLE_NAME='" + tableName + "' AND LOOKUP_TABLENAME='" + lookupTableName + "'";
        System.out.println("Deleting Backup Meta Table Entry : " + deleteQuery);
        QueryUtil.executeUpdate("Deleting Backup Meta Table Entry", statement, deleteQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getBackupTables(String tableName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList fileList = new ArrayList();
        try {
            String query = "SELECT * FROM AUDBackUpMetaTable where TABLE_NAME = '" + tableName + "' AND BASE_DB_BACKUP_DIRECTORY like '%EventBackup%'";
            System.out.println("query is :" + query);
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Backup meta tables :", statement, query);
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("TABLE_NAME", resultSet.getString("TABLE_NAME"));
                hashMap.put("START_TIME", resultSet.getLong("START_TIME"));
                hashMap.put("END_TIME", resultSet.getLong("END_TIME"));
                hashMap.put("START_INDEX", resultSet.getLong("START_INDEX"));
                hashMap.put("END_INDEX", resultSet.getLong("END_INDEX"));
                hashMap.put("LOOKUP_TABLENAME", resultSet.getString("LOOKUP_TABLENAME"));
                hashMap.put("FILE_NAME", resultSet.getString("FILE_NAME"));
                hashMap.put("BASE_DB_BACKUP_DIRECTORY", resultSet.getString("BASE_DB_BACKUP_DIRECTORY"));
                fileList.add(hashMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return fileList;
    }

    static {
        try {
            String confFileDir = System.getProperty("server.home") + "/conf/";
            PersistenceInitializer.initializeDB((String)confFileDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

