/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.backupdata.Backup;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreArchivedEventTable;
import com.adventnet.sym.adsm.common.server.mysql.tools.RestoreBackup;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.MssqlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileSystemUtils;

public class RestoreUtil {
    static final int BUFFER = 2048;
    private static Logger logger = Logger.getLogger(Backup.class.getName());

    public static boolean loadData(HashMap hashMap, Statement statement) throws Exception {
        boolean loadData = true;
        String lookupTableName = "";
        try {
            String loadDataQuery;
            String dbServerName = CommonUtil.getDBServerName();
            String dirName = (String)hashMap.get("BASE_DB_BACKUP_DIRECTORY");
            String fileName = (String)hashMap.get("FILE_NAME");
            lookupTableName = (String)hashMap.get("LOOKUP_TABLENAME");
            RestoreUtil.unZip(dirName + File.separator + fileName, dirName);
            String csvName = fileName.replaceAll("zip", "csv");
            csvName = dirName + File.separator + csvName;
            if (dbServerName.equalsIgnoreCase("mysql")) {
                csvName = csvName.replaceAll("\\\\", "\\\\\\\\");
            }
            File file1 = new File(csvName);
            if (RestoreUtil.isFreeSpaceAvailable()) {
                RestoreArchivedEventTable.spaceException = false;
                loadDataQuery = null;
                if (dbServerName.equalsIgnoreCase("mssql")) {
                    RestoreUtil.executeCommand(lookupTableName, csvName, false);
                } else if (dbServerName.equalsIgnoreCase("mysql")) {
                    loadDataQuery = "load data local infile '" + csvName + "' into table " + lookupTableName + " fields terminated by ',' OPTIONALLY ENCLOSED BY '\"' lines terminated by '\n'";
                    QueryUtil.executeUpdate("Loading Data from csv", statement, loadDataQuery);
                } else if (dbServerName.equalsIgnoreCase("postgres")) {
                    loadDataQuery = "COPY " + lookupTableName + " FROM '" + csvName + "' NULL AS '' ENCODING 'UTF8'";
                    QueryUtil.executeUpdate("Loading Data From csv ", statement, loadDataQuery);
                }
            } else {
                loadData = false;
                file1.delete();
                RestoreArchivedEventTable.spaceException = true;
                throw new Exception("Not Enough Space To Load");
            }
            logger.info("Loading Data : " + loadDataQuery);
            loadData = true;
            File file = new File(csvName);
            file.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            loadData = false;
            try {
                if (!lookupTableName.equals("")) {
                    logger.info("LoadData Failed. So Dropping Table : " + lookupTableName);
                    QueryUtil.executeQuery("drop table " + lookupTableName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new Exception(ex.getMessage());
        }
        return loadData;
    }

    public static boolean recreateTable(HashMap hashMap) throws Exception {
        Connection connection = null;
        Statement statement = null;
        boolean reCreate = true;
        try {
            String tableName = (String)hashMap.get("TABLE_NAME");
            String lookupTableName = (String)hashMap.get("LOOKUP_TABLENAME");
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            RestoreBackup restoreBackup = new RestoreBackup();
            String createSyntax = restoreBackup.constructQuery(lookupTableName, tableName);
            logger.log(Level.INFO, "createSyntax is " + createSyntax);
            if (createSyntax != null && !"".equals(createSyntax)) {
                QueryUtil.executeUpdate("Recreating Table", statement, createSyntax);
                reCreate = RestoreUtil.loadData(hashMap, statement);
            } else {
                logger.log(Level.INFO, "Am going to dump table");
                reCreate = RestoreUtil.dumpPSQLData(hashMap, statement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            reCreate = false;
            throw new Exception(e.getMessage());
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                throw new Exception(se.getMessage());
            }
        }
        return reCreate;
    }

    private static boolean dumpPSQLData(HashMap hashMap, Statement statement) {
        boolean dumpStatus = true;
        try {
            String dirName = (String)hashMap.get("BASE_DB_BACKUP_DIRECTORY");
            String fileName = (String)hashMap.get("FILE_NAME");
            String lookupTableName = (String)hashMap.get("LOOKUP_TABLENAME");
            RestoreUtil.unZip(dirName + File.separator + fileName, dirName);
            String name = fileName.replaceAll("zip", "sql");
            name = dirName + File.separator + name;
            name = name.replaceAll("\\\\", "\\\\\\\\");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(RestoreUtil.buildString(System.getProperty("db.home"), File.separator, "bin", File.separator, "psql.exe"));
            cmdList.add("-Upostgres");
            cmdList.add("--port=33307");
            cmdList.add("--host=127.0.0.1");
            cmdList.add("-c");
            cmdList.add(RestoreUtil.buildString("\\i '", name, "'"));
            cmdList.add("adap");
            String[] commandToExecute = cmdList.toArray(new String[cmdList.size()]);
            Process process = Runtime.getRuntime().exec(commandToExecute);
            String errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
            if (errorStream != null) {
                logger.log(Level.SEVERE, errorStream);
                throw new Exception("Error occured while Restoring " + lookupTableName + " table :: ErrorStream message ::: " + errorStream);
            }
            File file = new File(name);
            file.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            dumpStatus = false;
        }
        return dumpStatus;
    }

    private static String buildString(String ... args) {
        StringBuilder buffer = new StringBuilder();
        for (String str : args) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTable(String checkTableName) {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        boolean returnVal = false;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String dbServerName = CommonUtil.getDBServerName();
            String sqlQuery = null;
            if (dbServerName.equalsIgnoreCase("mssql")) {
                sqlQuery = "sp_columns " + checkTableName;
            } else if (dbServerName.equalsIgnoreCase("mysql")) {
                sqlQuery = "SHOW TABLES LIKE '" + checkTableName + "'";
            } else if (dbServerName.equalsIgnoreCase("postgres")) {
                sqlQuery = "SELECT TABLENAME FROM PG_TABLES WHERE TABLENAME ILIKE '" + checkTableName + "'";
            }
            resultSet = QueryUtil.executeQuery("Shows  tables", statement, sqlQuery);
            if (resultSet != null) {
                while (resultSet.next()) {
                    returnVal = true;
                    String tableNames = resultSet.getString(1);
                }
            }
        }
        catch (Exception ex) {
            returnVal = false;
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exp) {
                resultSet = null;
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(String src, String dst) {
        FilterOutputStream dest = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            dest = null;
            fis = new FileInputStream(src);
            zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                System.out.println("Extracting: " + entry);
                byte[] data = new byte[2048];
                String destname = dst + File.separator + entry.getName();
                FileOutputStream fos = new FileOutputStream(destname);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    ((BufferedOutputStream)dest).write(data, 0, count);
                }
                ((BufferedOutputStream)dest).flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dest != null) {
                    dest.close();
                }
                zis.close();
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(String src, String dst, Vector vect) {
        FilterOutputStream dest = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            ZipEntry entry;
            dest = null;
            fis = new FileInputStream(src);
            zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                System.out.println("Extracting: " + entry);
                byte[] data = new byte[2048];
                String destname = dst + File.separator + entry.getName();
                vect.add(destname);
                fos = new FileOutputStream(destname);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    ((BufferedOutputStream)dest).write(data, 0, count);
                }
                ((BufferedOutputStream)dest).flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dest.close();
                zis.close();
                fis.close();
                fos.close();
            }
            catch (Exception e) {}
        }
    }

    private static boolean isFreeSpaceAvailable() {
        boolean status = true;
        try {
            double freeDiskSpace = FileSystemUtils.freeSpaceKb((String)System.getProperty("server.dir"));
            if (freeDiskSpace < 1363148.0) {
                status = false;
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception while getting freeSpaceKb ");
        }
        return status;
    }

    public static void executeCommand(String lookupTableName, String csvName, Boolean utf8) throws Exception {
        MssqlUtil.getInstance();
        String loadDataQuery = MssqlUtil.getLoadQuery(lookupTableName, csvName, utf8);
        Integer val = Backup.executeCommand(loadDataQuery);
        if (val == Backup.retry) {
            val = Backup.executeCommand(loadDataQuery);
        }
    }
}

