/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.backupdata.metatable;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogFileUtil;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.mysql.tools.ConnectionUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MetaTableUtil {
    private RelationalAPI relationalAPI = null;
    private static MetaTableUtil metaTableUtil = null;
    private static ArrayList<String> metaTableList = new ArrayList();
    private static String dbName = CommonUtil.getDBServerName();

    private MetaTableUtil() {
        try {
            this.relationalAPI = RelationalAPI.getInstance();
            metaTableList = MetaTableUtil.getTableNameList("LOOKUP_TABLENAME", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetaTableUtil getInstance() {
        if (metaTableUtil != null) return metaTableUtil;
        Class<MetaTableUtil> clazz = MetaTableUtil.class;
        synchronized (MetaTableUtil.class) {
            metaTableUtil = new MetaTableUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return metaTableUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryInMetaTable() {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.relationalAPI.getConnection();
            statement = connection.createStatement();
            HashMap map = this.getMissedTableList();
            Set keySet = map.keySet();
            for (Object object : keySet) {
                ArrayList list = (ArrayList)map.get(object);
                for (String newTableName : list) {
                    String tableName = object.toString();
                    if (newTableName.contains("_0_")) {
                        tableName = object + "_0";
                    }
                    MetaTableHandler.addMetaTableRow(tableName, newTableName, statement);
                }
            }
            String scheduleIdUVH = "Schedule:schedule_id:UVH@5002";
            Long scheduleId = DBObjectUtil.getUVHValues("Schedule", scheduleIdUVH);
            ImportLogFileUtil.getInstance().changeAdminStatus(scheduleId, 4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMissedTableList() {
        Connection con = null;
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        try {
            if (dbName != null && dbName.equalsIgnoreCase("mssql")) {
                con = ConnectionUtil.getConnection(dbName);
                List list = ConnectionUtil.getTableList();
                ArrayList<String> tableNameList = MetaTableUtil.getTableNameList("TABLE_NAME", false);
                for (String name : tableNameList) {
                    for (Object tableName : list) {
                        if (!tableName.toString().contains(name) || !this.isEntryMissedTable(tableName.toString()) || name.equalsIgnoreCase(tableName.toString()) || tableName.toString().equalsIgnoreCase(name + "_0")) continue;
                        ArrayList<String> nameList = (ArrayList<String>)map.get(name);
                        if (nameList == null) {
                            nameList = new ArrayList<String>();
                        }
                        nameList.add(tableName.toString());
                        map.put(name, nameList);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return map;
    }

    public boolean isEntryMissedTable(String tableName) {
        boolean b = true;
        try {
            if (metaTableList.contains(tableName)) {
                b = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static ArrayList<String> getTableNameList(String columnName, Boolean b) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Criteria criteria = null;
            if (b != null) {
                criteria = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"IMPORT_TABLE"), (Object)b, 0);
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMetaTable", criteria);
            Iterator rowIterator = dataObject.getRows("AUDMetaTable");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                String tableName = row.get(columnName).toString();
                if (tableName.equalsIgnoreCase("AUDAlert") || list.contains(tableName)) continue;
                list.add(tableName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }
}

