/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultAccountMgmtListener;
import com.adventnet.sym.adsm.auditing.server.util.ExchangeCallerUserNameUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.Hashtable;

public final class AccountCreationListener
extends DefaultAccountMgmtListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();

    @Override
    public Object getColumnValue(String columnName, Object value) {
        Object customizedValue = null;
        if (columnName.equalsIgnoreCase("GROUP_TYPE")) {
            Integer valueInt = (Integer)value;
            customizedValue = this.getGroupType(valueInt);
        } else if (columnName.equalsIgnoreCase("GROUP_SCOPE")) {
            Integer valueInt = (Integer)value;
            customizedValue = this.getGroupScope(valueInt);
        } else if (columnName.equalsIgnoreCase("OBJECT_CLASS")) {
            Integer valueInt = (Integer)value;
            if (valueInt == 624 || valueInt == 4720) {
                customizedValue = RB.getString("adap.AUDSQLQuery.sql_string.User");
            } else if (valueInt == 645 || valueInt == 4741) {
                customizedValue = RB.getString("adap.AUDSQLQuery.sql_string.Computer");
            } else if (valueInt == 631 || valueInt == 635 || valueInt == 648 || valueInt == 653 || valueInt == 658 || valueInt == 663 || valueInt == 4727 || valueInt == 4731 || valueInt == 4744 || valueInt == 4749 || valueInt == 4754 || valueInt == 4759) {
                customizedValue = RB.getString("adap.AUDSQLQuery.sql_string.Group");
            }
        } else {
            customizedValue = super.getColumnValue(columnName, value);
        }
        return customizedValue;
    }

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            String objClass = "user";
            if (eventNumber == 624 || eventNumber == 4720) {
                objClass = "user";
            } else if (eventNumber == 645 || eventNumber == 4741) {
                objClass = "computer";
            } else if (eventNumber == 631 || eventNumber == 635 || eventNumber == 648 || eventNumber == 653 || eventNumber == 658 || eventNumber == 663 || eventNumber == 4727 || eventNumber == 4731 || eventNumber == 4744 || eventNumber == 4749 || eventNumber == 4754 || eventNumber == 4759) {
                objClass = "group";
            }
            row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objClass));
            if (!objClass.equals("computer")) {
                ExchangeCallerUserNameUtil.getInstance().updateExchangeInfoInEventRow(row, eventTbl);
            }
        }
        return row;
    }
}

