/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultAccountMgmtListener;
import com.adventnet.sym.adsm.auditing.server.category.FormatMessageUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.util.UserAttributeUtil;
import java.util.ArrayList;
import java.util.Hashtable;

public final class ComputerMgmtListener
extends DefaultAccountMgmtListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            String dcName = (String)row.get("SOURCE");
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            rowList = new ArrayList<Row>();
            String compMgmtText = this.computerMgmtType(row, eventNumber, eventTbl);
            row.set("COMP_MGMT_TYPE", (Object)compMgmtText);
            rowList.add(row);
            if (eventNumber.equals(566) || eventNumber.equals(5139) || eventNumber.equals(5136)) {
                String formatMessage;
                Integer isArchive;
                String objectName = (String)row.get("ACCOUNT_NAME");
                Row row1 = FormatMessageUtil.getObjectRow(domainName, objectName, "computer", dcName, isArchive = (Integer)eventTbl.get("IsArchiveEvent"));
                if (row1 != null) {
                    String sIdString = (String)row1.get("SID_STRING");
                    sIdString = new StringBuffer().append("%{").append(sIdString).append("}").toString();
                    row.set("ACCOUNT_SID", (Object)sIdString);
                    row.set("ACCOUNT_NAME", (Object)((String)row1.get("NAME")));
                }
                if ((formatMessage = FormatMessageUtil.setFormatMessage(domainName, row, eventTbl, RB.getString("adap.ADMPObjects.display_text.Computer"))) != null) {
                    formatMessage = new StringBuffer().append(formatMessage).append(RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{compMgmtText})).toString();
                }
                row.set("FORMAT_MESSAGE", (Object)formatMessage);
                String attributeString = row.get("ATTRIBUTES_TEXT") != null ? SchemaAPI.getInstance().getAttributeCommonName((String)row.get("ATTRIBUTES_TEXT")) : null;
                row.set("ATTRIBUTES_TEXT", (Object)attributeString);
                if (attributeString != null) {
                    Long attribCategoryId = SchemaAPI.getInstance().getAttributeCategoryId(attributeString);
                    if (attributeString.equalsIgnoreCase("NT-Security-Descriptor") || attributeString.equalsIgnoreCase("WRITE_DAC")) {
                        attribCategoryId = 3L;
                    }
                    row.set("ATTRIBUTE_CATEGORY_ID", (Object)attribCategoryId);
                }
                if (eventNumber.equals(5136)) {
                    row.set("REMARKS", (Object)RB.getString("adap.AUDSQLQuery.sql_string.Computer_Modified"));
                    if (eventTbl.get("ATTRIBUTES_OLD_VALUE") != null) {
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)((String)eventTbl.get("ATTRIBUTES_OLD_VALUE")));
                    }
                    if (attributeString != null) {
                        Boolean b;
                        if (attributeString.equalsIgnoreCase("User-Account-Control")) {
                            if (row.get("ATTRIBUTES_NEW_VALUE") != null) {
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)UserAttributeUtil.getUserFlagString((String)row.get("ATTRIBUTES_NEW_VALUE")));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)UserAttributeUtil.getUserFlagString((String)row.get("ATTRIBUTES_OLD_VALUE")));
                            }
                        } else if (attributeString.equalsIgnoreCase("User-Parameters")) {
                            row.set("ATTRIBUTES_NEW_VALUE", (Object)"");
                            row.set("ATTRIBUTES_OLD_VALUE", (Object)"");
                        } else if (attributeString.equalsIgnoreCase("NT-Security-Descriptor")) {
                            UserAttributeUtil.setACLChanges(rowList, domainName, "NT-Security-Descriptor");
                        } else if (attributeString.equalsIgnoreCase("msRASSavedFramedIPAddress") || attributeString.equalsIgnoreCase("msRADIUSFramedIPAddress")) {
                            if (row.get("ATTRIBUTES_NEW_VALUE") != null) {
                                Long ipAddress = Long.valueOf(row.get("ATTRIBUTES_NEW_VALUE").toString());
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)UserAttributeUtil.getIPAddress(ipAddress));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null) {
                                Long oldIpAddress = Long.valueOf(row.get("ATTRIBUTES_OLD_VALUE").toString());
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)UserAttributeUtil.getIPAddress(oldIpAddress));
                            }
                        }
                        if (!attributeString.equalsIgnoreCase("NT-Security-Descriptor") && row.get("ATTRIBUTES_NEW_VALUE") != null && row.get("ATTRIBUTES_NEW_VALUE") != "") {
                            formatMessage = new StringBuffer().append(formatMessage).append(", ").append(RB.handleGetObject("adap.DefaultAccountMgmtListener.values", new String[]{(String)row.get("ATTRIBUTES_NEW_VALUE")})).toString();
                            row.set("FORMAT_MESSAGE", (Object)formatMessage);
                        }
                        if (!attributeString.equalsIgnoreCase("NT-Security-Descriptor")) {
                            if (row.get("ATTRIBUTES_OLD_VALUE") == null) {
                                row.set("REMARKS", (Object)"Computer Attribute Added");
                            } else if (row.get("ATTRIBUTES_NEW_VALUE") == null || row.get("ATTRIBUTES_NEW_VALUE").equals("") && !attributeString.equalsIgnoreCase("NT-Security-Descriptor")) {
                                row.set("REMARKS", (Object)"Computer Attribute Removed");
                            }
                        }
                        if ((b = this.compareAttributesValue(row)).booleanValue()) {
                            rowList = null;
                        }
                    }
                } else {
                    String remarks = FormatMessageUtil.getRemarksMsg(eventTbl, "Computer", row);
                    if (attributeString != null) {
                        remarks = RB.getString("adap.AUDSQLQuery.sql_string.Computer_Modified");
                    }
                    row.set("REMARKS", (Object)remarks);
                }
            } else {
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            }
        }
        return rowList;
    }
}

