/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.category.DSAListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DHCPUtil;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateUtil;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttibuteConstants;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSObjectQueue;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSUpdateUtil;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class DNSListener
extends DSAListener {
    @Override
    protected Row setDSAEventRow(String domainName, Row row) {
        Row dnsRow = super.setDSAEventRow(domainName, row);
        String accessMask = dnsRow.get("ACCESS_MASK").toString();
        String objectClass = row.get("OBJECT_CLASS").toString();
        if (accessMask.equalsIgnoreCase("0x1")) {
            dnsRow.set("DNS_MGMT_TYPE", (Object)1);
            dnsRow.set("ADDITIONAL_INFO2_TEXT", (Object)ObjectUpdateUtil.getRDN((String)dnsRow.get("ADDITIONAL_INFO")));
            if (objectClass.equalsIgnoreCase("e0fa1e8c-9b45-11d0-afdd-00c04fd930c9")) {
                HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)dnsRow.get("SOURCE"), (String)dnsRow.get("ADDITIONAL_INFO"), "distinguishedName", (byte)1);
                dnsRow.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                dnsRow.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
            }
        } else if (accessMask.equalsIgnoreCase("0x10000")) {
            dnsRow.set("DNS_MGMT_TYPE", (Object)10);
            if (objectClass.equalsIgnoreCase("e0fa1e8c-9b45-11d0-afdd-00c04fd930c9")) {
                HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)dnsRow.get("SOURCE"), (String)dnsRow.get("ADDITIONAL_INFO"), "distinguishedName", (byte)0);
                dnsRow.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                dnsRow.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
            }
        } else if (accessMask.equalsIgnoreCase("0x40000")) {
            dnsRow.set("DNS_MGMT_TYPE", (Object)3);
            if (objectClass.equalsIgnoreCase("e0fa1e8c-9b45-11d0-afdd-00c04fd930c9")) {
                String objectName = dnsRow.get("OBJECT_NAME").toString();
                String objectGuid = objectName.substring(objectName.indexOf("{") + 1, objectName.lastIndexOf("}"));
                HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)dnsRow.get("SOURCE"), objectGuid, "objectGUID", (byte)1);
                dnsRow.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                dnsRow.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
            }
        } else if (accessMask.equalsIgnoreCase("0x20") && dnsRow.get("ATTRIBUTES_TEXT") != null) {
            HashMap<String, Object> propertiesFromNative;
            String attributeText = dnsRow.get("ATTRIBUTES_TEXT").toString();
            String objectName = dnsRow.get("OBJECT_NAME").toString();
            String objectClassTxt = objectClass.equalsIgnoreCase("e0fa1e8c-9b45-11d0-afdd-00c04fd930c9") ? "dnsNode" : "dnsZone";
            String objectGuid = objectName.substring(objectName.indexOf("{") + 1, objectName.lastIndexOf("}"));
            Properties properties = DNSUpdateUtil.getDNSObject(domainName, (String)dnsRow.get("SOURCE"), objectGuid, objectClassTxt, "objectGUID");
            if (attributeText.contains("dNSTombstoned") || attributeText.contains("DNS-Tombstoned")) {
                boolean dnsTombstoned;
                String dnsTombstonedString = (String)((ArrayList)properties.get("dNSTombstoned")).get(0);
                boolean bl = dnsTombstoned = dnsTombstonedString.equals("1");
                if (dnsTombstoned) {
                    int dnsMgmtType = 14;
                    String clientUserName = (String)dnsRow.get("CLIENT_USER_NAME");
                    if (clientUserName.indexOf("$") > 0) {
                        clientUserName = clientUserName.substring(0, clientUserName.lastIndexOf("$"));
                        dnsMgmtType = DHCPUtil.getInstance().isDNSServer(clientUserName, (String)dnsRow.get("CLIENT_DOMAIN")) ? 11 : (DHCPUtil.getInstance().isDHCPServer(clientUserName, (String)dnsRow.get("CLIENT_DOMAIN")) ? 12 : 13);
                    } else if (clientUserName.equalsIgnoreCase("SYSTEM")) {
                        dnsMgmtType = 11;
                    }
                    dnsRow.set("DNS_MGMT_TYPE", (Object)dnsMgmtType);
                    return dnsRow;
                }
            }
            if (attributeText.contains("dnsRecord") || attributeText.contains("Dns-Record")) {
                dnsRow.set("DNS_MGMT_TYPE", (Object)2);
                propertiesFromNative = DNSUpdateUtil.getDNSObjectProperties(properties, domainName, "dnsNode");
                ArrayList dnsRecordListFromNative = (ArrayList)propertiesFromNative.get("DNS_RECORD_TABLE_VALUES");
                HashMap<String, Object> propertiesFromDB = DNSUpdateUtil.getDNSObjectFromDB(objectName.substring(1), "OBJECT_GUID");
                ArrayList dnsRecordListFromDB = (ArrayList)propertiesFromDB.get("DNS_RECORD_TABLE_VALUES");
                boolean b = this.compareDNSNodeValues(dnsRow, dnsRecordListFromDB, dnsRecordListFromNative);
                if (properties != null) {
                    properties.put("domainName", domainName);
                    properties.put("objectClass", "dnsNode");
                    DNSObjectQueue.getInstance().addToQueue(properties);
                }
                if (!b) {
                    return null;
                }
            } else if (attributeText.equalsIgnoreCase("dnsProperty") || attributeText.equalsIgnoreCase("Dns-Property")) {
                propertiesFromNative = DNSUpdateUtil.getDNSObjectProperties(properties, domainName, objectClassTxt);
                HashMap<String, Object> propertiesFromDB = DNSUpdateUtil.getDNSObjectFromDB(objectGuid, "OBJECT_GUID");
                if (objectClass.equalsIgnoreCase("e0fa1e8c-9b45-11d0-afdd-00c04fd930c9")) {
                    dnsRow.set("HOST_TYPE", propertiesFromNative.get("HOST_TYPE"));
                    dnsRow.set("HOST_TYPE_STRING", propertiesFromNative.get("HOST_TYPE_STRING"));
                }
                dnsRow.set("ATTRIBUTES_NEW_VALUE", propertiesFromNative.get("DNS_PROPERTY") != null ? propertiesFromNative.get("DNS_PROPERTY") : "-");
                dnsRow.set("ATTRIBUTES_OLD_VALUE", propertiesFromDB.get("DNS_PROPERTY") != null ? propertiesFromDB.get("DNS_PROPERTY") : "-");
                if (properties != null) {
                    properties.put("domainName", domainName);
                    properties.put("objectClass", objectClassTxt);
                    DNSObjectQueue.getInstance().addToQueue(properties);
                }
            } else if (!this.compareAttributesValue(dnsRow).booleanValue() && objectClass.equalsIgnoreCase("e0fa1e8c-9b45-11d0-afdd-00c04fd930c9")) {
                HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)dnsRow.get("SOURCE"), objectGuid, "OBJECT_GUID", (byte)1);
                dnsRow.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                dnsRow.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
            } else {
                dnsRow = null;
            }
        }
        return dnsRow;
    }

    @Override
    protected Row setDSAFormatMessage(Row row) {
        Integer dnsMgmtType = row.get("DNS_MGMT_TYPE") != null ? (Integer)row.get("DNS_MGMT_TYPE") : 0;
        String formatMessage = "";
        String modifiedAttributesText = "";
        try {
            String objClass = (String)row.get("OBJECT_CLASS");
            objClass = objClass.replace("%{", "");
            objClass = objClass.replace("}", "");
            SchemaClass schemaClass = SCHEMA_API.getSchemaClass(objClass);
            if (schemaClass != null) {
                ObjectClass objectClass = DIRECTORY_OBJECT_API.getObjectClass(schemaClass.getLdapDisplayName());
                String objectClassDisplayName = objectClass == null ? schemaClass.getCommonName() : objectClass.getDisplayText();
                formatMessage = new StringBuffer().append(formatMessage).append(objectClassDisplayName).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dnsMgmtType.equals(1)) {
            formatMessage = new StringBuffer().append(formatMessage).append(" (").append((String)row.get("HOST_TYPE_STRING")).append(") ").append(" '").append(row.get("ADDITIONAL_INFO")).append("'").append(RB.handleGetObject("adap.DSAListener._was_created_by")).toString();
            formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        } else if (dnsMgmtType > 9) {
            formatMessage = new StringBuffer().append(formatMessage).append(" '").append(row.get("OBJECT_NAME_TEXT")).append("'").append(RB.handleGetObject("adap.DSAListener._was_deleted_by")).toString();
            formatMessage = formatMessage + RB.getString("adap.DSAListener.Deletion_by");
            String clientUserName = (String)row.get("CLIENT_USER_NAME");
            formatMessage = dnsMgmtType.equals(11) ? formatMessage + " " + RB.getString("adap.DSAListener.DNS_server_Scavenging") : (dnsMgmtType.equals(12) ? formatMessage + " " + RB.getString("adap.DSAListener.DHCP_server") : (dnsMgmtType.equals(13) ? formatMessage + " " + RB.getString("adap.DSAListener.Client_Workstation") : formatMessage + " " + RB.getString("adap.DSAListener.User")));
        } else if (dnsMgmtType.equals(3)) {
            formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "'";
            formatMessage = RB.handleGetObject("adap.DSAListener.Permission_of_formatMessage", new String[]{formatMessage});
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
            formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        } else if (dnsMgmtType.equals(2)) {
            formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "'";
            String modifiedAttributes = (String)row.get("ATTRIBUTES");
            modifiedAttributesText = modifiedAttributes != null ? (String)row.get("ATTRIBUTES_TEXT") : "-";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
            formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        }
        if (!modifiedAttributesText.equalsIgnoreCase("")) {
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{modifiedAttributesText});
        }
        row.set("FORMAT_MESSAGE", (Object)formatMessage);
        return row;
    }

    @Override
    protected boolean setDSCEventRow(String domainName, int eventCode, ArrayList<Row> rowList, Hashtable<String, Object> eventTbl) {
        boolean b = super.setDSCEventRow(domainName, eventCode, rowList, eventTbl);
        Row row = rowList.get(0);
        Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
        String objectClass = row.get("OBJECT_CLASS_TEXT").toString();
        if (eventNumber.equals(5137)) {
            row.set("DNS_MGMT_TYPE", (Object)1);
            if (objectClass.equalsIgnoreCase("dnsNode")) {
                HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)row.get("SOURCE"), (String)row.get("ADDITIONAL_INFO"), "distinguishedName", (byte)1);
                row.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                row.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
            }
        } else if (eventNumber.equals(5141)) {
            row.set("DNS_MGMT_TYPE", (Object)10);
            if (objectClass.equalsIgnoreCase("dnsNode")) {
                HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)row.get("SOURCE"), (String)row.get("ADDITIONAL_INFO"), "distinguishedName", (byte)0);
                row.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                row.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
            }
        } else if (eventNumber.equals(5136)) {
            String attributeText = row.get("ATTRIBUTES_TEXT").toString();
            if (attributeText.equalsIgnoreCase("dNSTombstoned") || attributeText.equalsIgnoreCase("DNS-Tombstoned")) {
                String attributeNewValue = (String)row.get("ATTRIBUTES_NEW_VALUE");
                String attributeOldValue = (String)row.get("ATTRIBUTES_OLD_VALUE");
                if (attributeOldValue != null && attributeNewValue.equalsIgnoreCase(attributeOldValue) || attributeNewValue.equalsIgnoreCase("false")) {
                    return false;
                }
                if (attributeNewValue.equalsIgnoreCase("true")) {
                    int dnsMgmtType = 14;
                    String clientUserName = (String)row.get("CLIENT_USER_NAME");
                    if (clientUserName.indexOf("$") > 0) {
                        clientUserName = clientUserName.substring(0, clientUserName.lastIndexOf("$"));
                        dnsMgmtType = DHCPUtil.getInstance().isDNSServer(clientUserName, (String)row.get("CLIENT_DOMAIN")) ? 11 : (DHCPUtil.getInstance().isDHCPServer(clientUserName, (String)row.get("CLIENT_DOMAIN")) ? 12 : 13);
                    } else if (clientUserName.equalsIgnoreCase("SYSTEM")) {
                        dnsMgmtType = 11;
                    }
                    row.set("DNS_MGMT_TYPE", (Object)dnsMgmtType);
                    b = true;
                }
            } else if (attributeText.equalsIgnoreCase("NT-Security-Descriptor")) {
                row.set("DNS_MGMT_TYPE", (Object)3);
                if (objectClass.equalsIgnoreCase("dnsNode")) {
                    HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)row.get("SOURCE"), (String)row.get("ADDITIONAL_INFO"), "distinguishedName", (byte)1);
                    row.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                    row.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
                }
                b = true;
            } else if (attributeText.equalsIgnoreCase("dnsRecord") || attributeText.equalsIgnoreCase("Dns-Record")) {
                b = true;
                String additionalInfo = row.get("ADDITIONAL_INFO").toString();
                row.set("DNS_MGMT_TYPE", (Object)2);
                Properties properties = DNSUpdateUtil.getDNSObject(domainName, (String)row.get("SOURCE"), additionalInfo, "dnsNode", "distinguishedName");
                HashMap<String, Object> propertiesFromNative = DNSUpdateUtil.getDNSObjectProperties(properties, domainName, "dnsNode");
                ArrayList dnsRecordListFromNative = (ArrayList)propertiesFromNative.get("DNS_RECORD_TABLE_VALUES");
                HashMap<String, Object> propertiesFromDB = DNSUpdateUtil.getDNSObjectFromDB((String)row.get("ADDITIONAL_INFO"), "distinguishedName");
                ArrayList dnsRecordListFromDB = (ArrayList)propertiesFromDB.get("DNS_RECORD_TABLE_VALUES");
                b = this.compareDNSNodeValues(row, dnsRecordListFromDB, dnsRecordListFromNative);
                if (properties != null) {
                    properties.put("domainName", domainName);
                    properties.put("objectClass", "dnsNode");
                    DNSObjectQueue.getInstance().addToQueue(properties);
                }
            } else if (attributeText.equalsIgnoreCase("dnsProperty") || attributeText.equalsIgnoreCase("Dns-Property")) {
                Properties properties = DNSUpdateUtil.getDNSObject(domainName, (String)row.get("SOURCE"), row.get("ADDITIONAL_INFO").toString(), objectClass, "distinguishedName");
                HashMap<String, Object> propertiesFromNative = DNSUpdateUtil.getDNSObjectProperties(properties, domainName, objectClass);
                HashMap<String, Object> propertiesFromDB = DNSUpdateUtil.getDNSObjectFromDB((String)row.get("ADDITIONAL_INFO"), "distinguishedName");
                if (objectClass.equalsIgnoreCase("dnsNode")) {
                    row.set("HOST_TYPE", propertiesFromNative.get("HOST_TYPE"));
                    row.set("HOST_TYPE_STRING", propertiesFromNative.get("HOST_TYPE_STRING"));
                }
                row.set("ATTRIBUTES_NEW_VALUE", propertiesFromNative.get("DNS_PROPERTY") != null ? propertiesFromNative.get("DNS_PROPERTY") : "-");
                row.set("ATTRIBUTES_OLD_VALUE", propertiesFromDB.get("DNS_PROPERTY") != null ? propertiesFromDB.get("DNS_PROPERTY") : "-");
                if (properties != null) {
                    properties.put("domainName", domainName);
                    properties.put("objectClass", objectClass);
                    DNSObjectQueue.getInstance().addToQueue(properties);
                }
                b = true;
            } else if (!this.compareAttributesValue(row).booleanValue()) {
                if (objectClass.equalsIgnoreCase("dnsNode")) {
                    HashMap<String, Object> hashtable = DNSUpdateUtil.getDNSHostType(domainName, (String)row.get("SOURCE"), (String)row.get("ADDITIONAL_INFO"), "distinguishedName", (byte)1);
                    row.set("HOST_TYPE", hashtable.get("HOST_TYPE"));
                    row.set("HOST_TYPE_STRING", hashtable.get("HOST_TYPE_STRING"));
                }
                b = true;
            } else {
                b = false;
            }
        }
        return b;
    }

    private boolean compareDNSNodeValues(Row row, ArrayList<HashMap<String, Object>> dnsRecordListFromDB, ArrayList<HashMap<String, Object>> dnsRecordListFromNative) {
        dnsRecordListFromDB = dnsRecordListFromDB == null ? new ArrayList<HashMap<String, Object>>() : dnsRecordListFromDB;
        dnsRecordListFromNative = dnsRecordListFromNative == null ? new ArrayList() : dnsRecordListFromNative;
        HashMap<String, Object> newValueMap = new HashMap<String, Object>();
        HashMap<String, Object> oldValueMap = new HashMap<String, Object>();
        if (dnsRecordListFromNative.size() <= 1 && dnsRecordListFromDB.size() <= 1) {
            HashMap nativeRecordMap = dnsRecordListFromNative.size() == 1 ? (HashMap)dnsRecordListFromNative.get(0) : new HashMap();
            HashMap<String, Object> dbRecordMap = dnsRecordListFromDB.size() == 1 ? dnsRecordListFromDB.get(0) : new HashMap();
            this.compareHashMap(nativeRecordMap, dbRecordMap, newValueMap, oldValueMap);
            row.set("HOST_TYPE", nativeRecordMap.get("HOST_TYPE") != null ? nativeRecordMap.get("HOST_TYPE") : dbRecordMap.get("HOST_TYPE"));
            row.set("HOST_TYPE_STRING", nativeRecordMap.get("HOST_TYPE_STRING") != null ? nativeRecordMap.get("HOST_TYPE_STRING") : dbRecordMap.get("HOST_TYPE_STRING"));
        } else {
            for (HashMap nativeRecordMap : dnsRecordListFromNative) {
                HashMap<String, Object> dbRecordMap = this.getKeyMap(nativeRecordMap, dnsRecordListFromDB);
                if (dbRecordMap.isEmpty()) continue;
                this.compareHashMap(nativeRecordMap, dbRecordMap, newValueMap, oldValueMap);
                if (newValueMap.isEmpty()) continue;
                row.set("HOST_TYPE", nativeRecordMap.get("HOST_TYPE") != null ? nativeRecordMap.get("HOST_TYPE") : dbRecordMap.get("HOST_TYPE"));
                row.set("HOST_TYPE_STRING", nativeRecordMap.get("HOST_TYPE_STRING") != null ? nativeRecordMap.get("HOST_TYPE_STRING") : dbRecordMap.get("HOST_TYPE_STRING"));
                break;
            }
        }
        row.set("ATTRIBUTES_NEW_VALUE", (Object)(newValueMap.isEmpty() ? "-" : newValueMap.toString()));
        row.set("ATTRIBUTES_OLD_VALUE", (Object)(oldValueMap.isEmpty() ? "-" : oldValueMap.toString()));
        return !newValueMap.isEmpty() || !oldValueMap.isEmpty();
    }

    private void compareHashMap(HashMap<String, Object> nativeRecordMap, HashMap<String, Object> dbRecordMap, HashMap<String, Object> newValueMap, HashMap<String, Object> oldValueMap) {
        for (String keyFromNativeMap : nativeRecordMap.keySet()) {
            if (!DNSAttibuteConstants.isEditableProperty(keyFromNativeMap)) continue;
            if (dbRecordMap.containsKey(keyFromNativeMap)) {
                if (dbRecordMap.get(keyFromNativeMap).equals(nativeRecordMap.get(keyFromNativeMap)) || !DNSAttibuteConstants.isEditableProperty(keyFromNativeMap)) continue;
                newValueMap.put(DNSAttibuteConstants.getDNSRecordDisplayProperty(keyFromNativeMap), nativeRecordMap.get(keyFromNativeMap));
                oldValueMap.put(DNSAttibuteConstants.getDNSRecordDisplayProperty(keyFromNativeMap), dbRecordMap.get(keyFromNativeMap));
                continue;
            }
            newValueMap.put(DNSAttibuteConstants.getDNSRecordDisplayProperty(keyFromNativeMap), nativeRecordMap.get(keyFromNativeMap));
        }
    }

    private HashMap<String, Object> getKeyMap(HashMap<String, Object> hashMap, ArrayList<HashMap<String, Object>> dnsRecordList) {
        int hostType = (Integer)hashMap.get("HOST_TYPE");
        String keyColumn = DNSAttibuteConstants.getKeyColumn(hostType);
        Object keyValue = hashMap.get(keyColumn);
        for (HashMap<String, Object> hashMap2 : dnsRecordList) {
            int hostType2 = (Integer)hashMap2.get("HOST_TYPE");
            String keyColumn2 = DNSAttibuteConstants.getKeyColumn(hostType2);
            Object keyValue2 = hashMap2.get(keyColumn2);
            if (hostType != hostType2 || !keyValue.equals(keyValue2)) continue;
            return hashMap2;
        }
        return new HashMap<String, Object>();
    }

    @Override
    protected void setDSCFormatMessage(int eventCode, Row row, Hashtable<String, Object> eventTbl) {
        String formatMessage = "";
        String schemaClass = RB.getString((String)row.get("OBJECT_CLASS_TEXT"));
        formatMessage = formatMessage + schemaClass;
        if (eventCode == 5137) {
            formatMessage = formatMessage + " (" + (String)row.get("HOST_TYPE_STRING") + ") ";
            formatMessage = formatMessage + " '" + ObjectUpdateUtil.getRDN((String)row.get("ADDITIONAL_INFO")) + "'";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_created_by");
            formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        } else if (eventCode == 5141) {
            formatMessage = formatMessage + " (" + (String)row.get("HOST_TYPE_STRING") + ") ";
            formatMessage = formatMessage + " '" + ObjectUpdateUtil.getRDN((String)row.get("ADDITIONAL_INFO")) + "' ";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.was_deleted_from_AD_by");
            formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        } else if (eventCode == 5139) {
            formatMessage = formatMessage + " (" + (String)row.get("HOST_TYPE_STRING") + ") ";
            formatMessage = formatMessage + " '" + ObjectUpdateUtil.getRDN((String)row.get("ADDITIONAL_INFO")) + "'";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.was_moved_to_StringeventTblgetObject_Old", new String[]{(String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Old_DN"))});
            formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        } else if (eventCode == 5136) {
            formatMessage = formatMessage + " (" + (String)row.get("HOST_TYPE_STRING") + ") ";
            formatMessage = formatMessage + " '" + ObjectUpdateUtil.getRDN((String)row.get("ADDITIONAL_INFO")) + "'";
            String attributesText = row.get("ATTRIBUTES_TEXT") != null ? row.get("ATTRIBUTES_TEXT").toString() : null;
            Integer dnsMgmtType = (Integer)row.get("DNS_MGMT_TYPE");
            if (dnsMgmtType > 9) {
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_deleted_by");
                formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
                formatMessage = formatMessage + RB.getString("adap.DSAListener.Deletion_by");
                String clientUserName = (String)row.get("CLIENT_USER_NAME");
                formatMessage = dnsMgmtType.equals(11) ? formatMessage + " " + RB.getString("adap.DSAListener.DNS_server_Scavenging") : (dnsMgmtType.equals(12) ? formatMessage + " " + RB.getString("adap.DSAListener.DHCP_server") : (dnsMgmtType.equals(13) ? formatMessage + " " + RB.getString("adap.DSAListener.Client_Workstation") : formatMessage + " " + RB.getString("adap.DSAListener.User")));
            } else if (dnsMgmtType.equals(3)) {
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
                formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Modified_Properties__rowgetATTRIBUTES_TEXT", new String[]{(String)row.get("ATTRIBUTES_TEXT")});
            } else {
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
                formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{(String)row.get("ATTRIBUTES_TEXT")});
                formatMessage = formatMessage + ". ";
                formatMessage = formatMessage + RB.handleGetObject("adap.DefaultAccountMgmtListener.value", new String[]{(String)row.get("ATTRIBUTES_NEW_VALUE")});
            }
        }
        row.set("FORMAT_MESSAGE", (Object)formatMessage);
    }
}

