/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.util.ExchangeCallerUserNameUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateUtil;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.common.server.util.UserAttributeUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.regex.Pattern;

public class DSAListener
extends DefaultCategoryListener {
    protected static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    protected static final SchemaAPI SCHEMA_API = SchemaAPI.getInstance();
    protected static final DirectoryObjectAPI DIRECTORY_OBJECT_API = DirectoryObjectAPI.getInstance();
    private static final String[] SCHEMA_GUIDS = new String[]{"bf967a8f-0de6-11d0-a285-00aa003049e2", "bf967a83-0de6-11d0-a285-00aa003049e2", "bf967a80-0de6-11d0-a285-00aa003049e2", "5a8b3261-c38d-11d1-bbc9-0080c76670c0", "52ab8671-5709-11d1-a9c6-0000f80367c1"};

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            rowList = new ArrayList<Row>();
            Integer eventCode = (Integer)row.get("EVENT_NUMBER");
            if (eventCode == 566 || eventCode == 4662) {
                if ((row = this.setDSAEventRow(domainName, row)) != null) {
                    row = this.setDSAFormatMessage(row);
                    rowList.add(row);
                }
            } else {
                rowList.add(row);
                if (!this.setDSCEventRow(domainName, eventCode, rowList, eventTbl)) {
                    return null;
                }
                this.setDSCFormatMessage(eventCode, row, eventTbl);
            }
            ExchangeCallerUserNameUtil.getInstance().updateExchangeInfoInEventRow(row, eventTbl);
        }
        return rowList;
    }

    public boolean isSchemaObject(String guid) {
        boolean isSchemaObject = false;
        for (String string : SCHEMA_GUIDS) {
            if (!string.equalsIgnoreCase(guid)) continue;
            isSchemaObject = true;
            break;
        }
        return isSchemaObject;
    }

    protected Row setDSAEventRow(String domainName, Row row) {
        String accesses;
        String additionalInfo2;
        row.set("REMARKS", (Object)new StringBuffer().append(row.get("ACCESSES")).append(" : ").append(RB.getString((String)row.get("OBJECT_CLASS_TEXT"))).toString());
        String objectType = (String)row.get("OBJECT_TYPE");
        objectType = objectType.replace("%{", "");
        objectType = objectType.replace("}", "");
        if (this.isSchemaObject(objectType)) {
            row.set("OBJECT_CATEGORY_TYPE", (Object)2);
            row.set("ROOT_DOMAIN_NAMING_CONTEXT", (Object)DomainDetailsAPI.getRootDomainNamingContext(domainName));
        }
        String dcName = (String)row.get("SOURCE");
        SchemaClass schemaClass = SCHEMA_API.getSchemaClass(objectType);
        String objectName = (String)row.get("OBJECT_NAME");
        objectName = objectName.substring(1);
        String objectClass = (String)row.get("OBJECT_CLASS");
        int isConfigClass = SchemaAPI.getInstance().isConfigurationClass(objectType.toLowerCase());
        int isConfigChildClass = SchemaAPI.getInstance().isConfigurationClass(objectClass.toLowerCase());
        if (isConfigClass >= 0 || isConfigChildClass >= 0) {
            row.set("OBJECT_CATEGORY_TYPE", (Object)3);
            row.set("ROOT_DOMAIN_NAMING_CONTEXT", (Object)DomainDetailsAPI.getRootDomainNamingContext(domainName));
            row.set("CONFIG_SUB_CATEGORY", (Object)(isConfigClass >= 0 ? isConfigClass : isConfigChildClass));
        }
        String accessMask = (String)row.get("ACCESS_MASK");
        if (schemaClass != null) {
            String ldapName = schemaClass.getLdapDisplayName();
            row.set("OBJECT_TYPE_TEXT", (Object)schemaClass.getCommonDisplayName());
            row.set("OBJECT_CLASS_TEXT", (Object)schemaClass.getCommonDisplayName());
            try {
                Properties properties;
                if (accessMask.equalsIgnoreCase("0x10000") && this.checkObjectPresent(objectName, domainName, dcName)) {
                    row = null;
                    return row;
                }
                String objectNameText = objectName;
                String objectLocationText = objectName;
                Row row2 = DIRECTORY_OBJECT_API.getObjectRow(domainName, objectName, "OBJECT_GUID", ldapName, dcName);
                if (row2 != null) {
                    objectLocationText = (String)row2.get("CANONICAL_NAME");
                    objectNameText = (String)row2.get("NAME");
                } else if (!(ldapName.equalsIgnoreCase("user") || ldapName.equalsIgnoreCase("computer") || ldapName.equalsIgnoreCase("group") || (properties = ObjectUpdateUtil.getObjectFromGuid(domainName, objectName, dcName)) == null)) {
                    objectNameText = ldapName.equalsIgnoreCase("dnsZone") || ldapName.equalsIgnoreCase("dnsNode") || ldapName.equalsIgnoreCase("dns-Zone") || ldapName.equalsIgnoreCase("dns-Node") || ldapName.equalsIgnoreCase("DNS Zone") || ldapName.equalsIgnoreCase("DNS Node") ? ((ArrayList)properties.get("dc")).get(0).toString().replace("\n", " ") : ((ArrayList)properties.get("cn")).get(0).toString().replace("\n", " ");
                    objectLocationText = ((ArrayList)properties.get("canonicalName")).get(0).toString().replace("\n", " ");
                    String objectDN = ((ArrayList)properties.get("distinguishedName")).get(0).toString().replace("\n", " ");
                    if (Pattern.matches(".*cn=configuration,dc=.*", objectDN.toLowerCase()) && !Pattern.matches(".*cn=schema,cn=configuration,dc=.*", objectDN.toLowerCase())) {
                        row.set("OBJECT_CATEGORY_TYPE", (Object)3);
                        row.set("ROOT_DOMAIN_NAMING_CONTEXT", (Object)DomainDetailsAPI.getRootDomainNamingContext(domainName));
                    }
                }
                row.set("OBJECT_NAME_TEXT", (Object)objectNameText);
                row.set("OBJECT_LOCATION_TEXT", (Object)objectLocationText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((additionalInfo2 = (String)row.get("ADDITIONAL_INFO2")) != null && !additionalInfo2.equalsIgnoreCase("") && objectType.equalsIgnoreCase(objectClass) && accessMask.equalsIgnoreCase("0x1")) {
            additionalInfo2 = additionalInfo2.substring(1);
            String objClass = (String)row.get("OBJECT_CLASS");
            String objClassTxt = (String)row.get("OBJECT_CLASS_TEXT");
            objClass = objClass.replace("%{", "");
            objClass = objClass.replace("}", "");
            SchemaClass schemaClass2 = SCHEMA_API.getSchemaClass(objClass);
            String objectNameText = additionalInfo2;
            String objectLocationText = additionalInfo2;
            if (schemaClass2 != null) {
                try {
                    Properties properties;
                    Row row2 = DIRECTORY_OBJECT_API.getObjectRow(domainName, additionalInfo2, "OBJECT_GUID", schemaClass2.getLdapDisplayName(), dcName);
                    if (row2 != null) {
                        row.set("ADDITIONAL_INFO2_TEXT", row2.get("NAME"));
                    } else if (!(objClassTxt.equalsIgnoreCase("user") && objClassTxt.equalsIgnoreCase("group") && objClassTxt.equalsIgnoreCase("computer") || (properties = ObjectUpdateUtil.getObjectFromGuid(domainName, additionalInfo2, dcName)) == null)) {
                        objectNameText = objClassTxt.equalsIgnoreCase("dnsZone") || objClassTxt.equalsIgnoreCase("dnsNode") || objClassTxt.equalsIgnoreCase("dns-Zone") || objClassTxt.equalsIgnoreCase("dns-Node") || objClassTxt.equalsIgnoreCase("DNS Zone") || objClassTxt.equalsIgnoreCase("DNS Node") ? ((ArrayList)properties.get("dc")).get(0).toString().replace("\n", " ") : ((ArrayList)properties.get("cn")).get(0).toString().replace("\n", " ");
                        objectLocationText = ((ArrayList)properties.get("canonicalName")).get(0).toString().replace("\n", " ");
                        String objectDN = ((ArrayList)properties.get("distinguishedName")).get(0).toString().replace("\n", " ");
                        if (Pattern.matches(".*cn=configuration,dc=.*", objectDN.toLowerCase()) && !Pattern.matches(".*cn=schema,cn=configuration,dc=.*", objectDN.toLowerCase())) {
                            row.set("OBJECT_CATEGORY_TYPE", (Object)3);
                            row.set("ROOT_DOMAIN_NAMING_CONTEXT", (Object)DomainDetailsAPI.getRootDomainNamingContext(domainName));
                        }
                    }
                    row.set("OBJECT_NAME_TEXT", (Object)objectNameText);
                    row.set("OBJECT_LOCATION_TEXT", (Object)objectLocationText);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String string = accesses = row.get("ACCESSES") != null ? (String)row.get("ACCESSES") : null;
        if (accesses.equalsIgnoreCase("WRITE_DAC")) {
            row.set("ATTRIBUTE_CATEGORY_ID", (Object)3L);
        }
        return row;
    }

    protected Row setDSAFormatMessage(Row row) {
        String accessMask = (String)row.get("ACCESS_MASK");
        String formatMessage = "";
        String modifiedAttributesText = "";
        String readAttributesText = "";
        try {
            String objClass = (String)row.get("OBJECT_CLASS");
            objClass = objClass.replace("%{", "");
            objClass = objClass.replace("}", "");
            SchemaClass schemaClass = SCHEMA_API.getSchemaClass(objClass);
            if (schemaClass != null) {
                ObjectClass objectClass = DIRECTORY_OBJECT_API.getObjectClass(schemaClass.getLdapDisplayName());
                String objectClassDisplayName = objectClass == null ? schemaClass.getCommonName() : objectClass.getDisplayText();
                formatMessage = new StringBuffer().append(formatMessage).append(objectClassDisplayName).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (accessMask.equalsIgnoreCase("0x1")) {
            formatMessage = new StringBuffer().append(formatMessage).append(" '").append(row.get("ADDITIONAL_INFO")).append("'").append(RB.handleGetObject("adap.DSAListener._was_created_by")).toString();
        } else if (accessMask.equalsIgnoreCase("0x10000")) {
            formatMessage = new StringBuffer().append(formatMessage).append(" '").append(row.get("OBJECT_NAME_TEXT")).append("'").append(RB.handleGetObject("adap.DSAListener._was_deleted_by")).toString();
        } else if (accessMask.equalsIgnoreCase("0x40000")) {
            formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "'";
            formatMessage = RB.handleGetObject("adap.DSAListener.Permission_of_formatMessage", new String[]{formatMessage});
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
        } else if (accessMask.equalsIgnoreCase("0x100")) {
            if (row.get("ATTRIBUTES") != null && ((String)row.get("ATTRIBUTES_TEXT")).contains("ms-Mcs-AdmPwd")) {
                formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "' ";
                formatMessage = RB.handleGetObject("adap.DSAListener.Password_of_formatMessage", new String[]{formatMessage});
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_read_by");
            }
        } else if (accessMask.equalsIgnoreCase("0x10")) {
            formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "' ";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_read_by");
            if (row.get("ATTRIBUTES") != null) {
                readAttributesText = (String)row.get("ATTRIBUTES_TEXT");
            }
        } else if (accessMask.equalsIgnoreCase("0x20")) {
            formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "'";
            String modifiedAttributes = (String)row.get("ATTRIBUTES");
            if (modifiedAttributes != null) {
                if (modifiedAttributes.contains("bf967a0e-0de6-11d0-a285-00aa003049e2")) {
                    String additionalInfo = (String)row.get("ADDITIONAL_INFO");
                    String additionalInfo2 = (String)row.get("ADDITIONAL_INFO2");
                    if (additionalInfo != null && !additionalInfo.equalsIgnoreCase("") && additionalInfo2 != null && !additionalInfo2.equalsIgnoreCase("")) {
                        formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_moved_to_additionalInfo", new String[]{additionalInfo});
                    } else if (additionalInfo == null || additionalInfo.equalsIgnoreCase("")) {
                        formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_renamed_to_additionalInfo", new String[]{additionalInfo});
                    }
                } else {
                    formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
                    modifiedAttributesText = (String)row.get("ATTRIBUTES_TEXT");
                }
            } else {
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
                modifiedAttributesText = "-";
            }
        }
        formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        if (!modifiedAttributesText.equalsIgnoreCase("")) {
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{modifiedAttributesText});
        }
        if (!readAttributesText.equalsIgnoreCase("")) {
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Read_Properties__readAttributesText", new String[]{readAttributesText});
        }
        row.set("FORMAT_MESSAGE", (Object)formatMessage);
        return row;
    }

    public boolean checkObjectPresent(String objectName, String domainName, String dcName) {
        boolean objectPresent = false;
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("objectGUID");
        attributeList.add("distinguishedName");
        objectName = objectName.substring(objectName.indexOf("{") + 1, objectName.lastIndexOf("}"));
        try {
            Properties properties = ADHandler.getObjectFromGUID(domainName, 1L, objectName, attributeList, dcName);
            if (properties != null) {
                objectPresent = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectPresent;
    }

    protected boolean setDSCEventRow(String domainName, int eventCode, ArrayList<Row> rowList, Hashtable<String, Object> eventTbl) {
        String additionalInfo;
        Row row = rowList.get(0);
        String dcName = (String)row.get("SOURCE");
        this.setAccessMask(eventCode, row);
        row.set("REMARKS", (Object)(row.get("ACCESSES") + " : " + RB.getString((String)row.get("OBJECT_CLASS_TEXT"))));
        if (eventCode == 5136) {
            String attributeOldVal = (String)eventTbl.get("ATTRIBUTES_OLD_VALUE");
            if (attributeOldVal != null) {
                row.set("ATTRIBUTES_OLD_VALUE", (Object)attributeOldVal);
            }
            String attributeTxt = row.get("ATTRIBUTES_TEXT") != null ? SchemaAPI.getInstance().getAttributeCommonName((String)row.get("ATTRIBUTES_TEXT")) : null;
            row.set("ATTRIBUTES_TEXT", (Object)attributeTxt);
            if (attributeTxt != null) {
                Object oldValue;
                Object newValue;
                if (attributeTxt.equalsIgnoreCase("GP-Link")) {
                    String oldGPONames;
                    String newGPONames = (String)row.get("ATTRIBUTES_NEW_VALUE");
                    if (newGPONames != null) {
                        newGPONames = this.getGPOLinks(newGPONames);
                        row.set("ATTRIBUTES_NEW_VALUE", (Object)newGPONames);
                    }
                    if (eventTbl.get("ATTRIBUTES_OLD_VALUE") != null && (oldGPONames = (String)row.get("ATTRIBUTES_OLD_VALUE")) != null) {
                        oldGPONames = this.getGPOLinks(oldGPONames);
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)oldGPONames);
                    }
                } else if (attributeTxt.equalsIgnoreCase("GP-Options")) {
                    String oldGPOptions;
                    String newGPOptions = (String)row.get("ATTRIBUTES_NEW_VALUE");
                    if (newGPOptions != null) {
                        row.set("ATTRIBUTES_NEW_VALUE", (Object)this.getGPOptions(newGPOptions));
                    }
                    if (eventTbl.get("ATTRIBUTES_OLD_VALUE") != null && (oldGPOptions = (String)row.get("ATTRIBUTES_OLD_VALUE")) != null) {
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)this.getGPOptions(oldGPOptions));
                    }
                } else if (attributeTxt.equalsIgnoreCase("Flags")) {
                    newValue = Integer.valueOf((String)row.get("ATTRIBUTES_NEW_VALUE"));
                    row.set("ATTRIBUTES_NEW_VALUE", (Object)this.setFlags((Integer)newValue));
                    if (row.get("ATTRIBUTES_OLD_VALUE") != null) {
                        oldValue = Integer.valueOf((String)row.get("ATTRIBUTES_OLD_VALUE"));
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)this.setFlags((Integer)oldValue));
                        if (((Integer)oldValue).equals(newValue)) {
                            return false;
                        }
                    }
                } else if (attributeTxt.equalsIgnoreCase("NT-Security-Descriptor")) {
                    try {
                        row.set("ATTRIBUTE_CATEGORY_ID", (Object)3L);
                        UserAttributeUtil.setACLChanges(rowList, domainName, "NT-Security-Descriptor");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (attributeTxt.equalsIgnoreCase("ms-DS-Maximum-Password-Age") || attributeTxt.equalsIgnoreCase("ms-DS-Minimum-Password-Age") || attributeTxt.equalsIgnoreCase("ms-DS-Lockout-Observation-Window") || attributeTxt.equalsIgnoreCase("ms-DS-Lockout-Duration")) {
                    newValue = (String)row.get("ATTRIBUTES_NEW_VALUE");
                    if (newValue != null && !((String)newValue).equalsIgnoreCase("-")) {
                        row.set("ATTRIBUTES_NEW_VALUE", (Object)TimeUtil.getPSODuration((String)newValue));
                    }
                    if ((oldValue = (String)row.get("ATTRIBUTES_OLD_VALUE")) != null && !((String)oldValue).equalsIgnoreCase("-")) {
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)TimeUtil.getPSODuration((String)oldValue));
                    }
                }
            }
        }
        String additionalInfo2 = (String)row.get("ADDITIONAL_INFO2");
        String objClassTxt = (String)row.get("OBJECT_CLASS_TEXT");
        if (additionalInfo2 != null && !additionalInfo2.equalsIgnoreCase("")) {
            String objClass = RB.getString((String)row.get("OBJECT_CLASS_TEXT"));
            if (objClass != null) {
                try {
                    String rdnString;
                    if (objClassTxt.equalsIgnoreCase("user") || objClassTxt.equalsIgnoreCase("groupPolicyContainer")) {
                        Row row2 = DIRECTORY_OBJECT_API.getObjectRow(domainName, additionalInfo2, "OBJECT_GUID", objClass, dcName);
                        if (row2 != null) {
                            row.set("ADDITIONAL_INFO2_TEXT", row2.get("NAME"));
                        }
                    } else if (row.get("ADDITIONAL_INFO") != null && (rdnString = ObjectUpdateUtil.getRDN((String)row.get("ADDITIONAL_INFO"))) != null) {
                        row.set("ADDITIONAL_INFO2_TEXT", (Object)rdnString);
                        row.set("OBJECT_NAME_TEXT", (Object)rdnString);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            row.set("ADDITIONAL_INFO2", (Object)("%" + additionalInfo2));
        }
        row.set("OBJECT_TYPE_TEXT", row.get("OBJECT_CLASS_TEXT"));
        String objectType = RB.getString((String)row.get("OBJECT_CLASS_TEXT"));
        String objectName = (String)row.get("OBJECT_NAME");
        if (objectName != null) {
            try {
                if (objClassTxt.equalsIgnoreCase("user") || objClassTxt.equalsIgnoreCase("groupPolicyContainer")) {
                    Row row2 = DIRECTORY_OBJECT_API.getObjectRow(domainName, objectName, objectType);
                    if (row2 != null) {
                        row.set("OBJECT_LOCATION_TEXT", row2.get("CANONICAL_NAME"));
                        row.set("OBJECT_NAME_TEXT", row2.get("NAME"));
                    }
                } else if (row.get("ADDITIONAL_INFO") != null) {
                    String rdnString = ObjectUpdateUtil.getRDN((String)row.get("ADDITIONAL_INFO"));
                    if (rdnString != null) {
                        row.set("OBJECT_NAME_TEXT", (Object)rdnString);
                        String canonicalName = UserAttributeUtil.getCanonicalName((String)row.get("ADDITIONAL_INFO"));
                        if (canonicalName == null) {
                            canonicalName = objectName;
                        }
                        row.set("OBJECT_LOCATION_TEXT", (Object)canonicalName);
                    } else {
                        row.set("OBJECT_NAME_TEXT", (Object)objectName);
                        row.set("OBJECT_LOCATION_TEXT", (Object)objectName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            row.set("OBJECT_NAME", (Object)("%" + objectName));
        }
        if ((additionalInfo = (String)row.get("ADDITIONAL_INFO")) != null && Pattern.matches(".*cn=configuration,dc=.*", additionalInfo = additionalInfo.toLowerCase()) && row.getTableName().equalsIgnoreCase("AUDADOAuditInfo")) {
            row.set("OBJECT_CATEGORY_TYPE", (Object)3);
            row.set("ROOT_DOMAIN_NAMING_CONTEXT", (Object)DomainDetailsAPI.getRootDomainNamingContext(domainName));
            row.set("CONFIG_SUB_CATEGORY", (Object)SchemaAPI.getInstance().isConfigurationClass(row.get("OBJECT_CLASS_TEXT").toString(), "ldapDisplayName"));
        }
        return true;
    }

    private String getGPOptions(String options) {
        if (options.equalsIgnoreCase("1")) {
            return RB.handleGetObject("adap.DSAListener.Block_GPO_Inheritance", new String[]{RB.getString("adap.common.text.filter_link.enabled")});
        }
        if (options.equalsIgnoreCase("0")) {
            return RB.handleGetObject("adap.DSAListener.Block_GPO_Inheritance", new String[]{RB.getString("adap.common.text.filter_link.disabled")});
        }
        return "-";
    }

    private void setAccessMask(int eventCode, Row row) {
        if (eventCode == 5137) {
            row.set("ACCESS_MASK", (Object)"0x1");
            row.set("ACCESSES", RB.handleGetObject("adap.DSAListener.Create_Child"));
        } else if (eventCode == 5139 || eventCode == 5136) {
            row.set("ACCESS_MASK", (Object)"0x20");
            row.set("ACCESSES", RB.handleGetObject("adap.DSAListener.Write_Property"));
        } else if (eventCode == 5141) {
            row.set("ACCESS_MASK", (Object)"0x10000");
            row.set("ACCESSES", RB.handleGetObject("adap.DSAListener.DELETE"));
        }
    }

    protected void setDSCFormatMessage(int eventCode, Row row, Hashtable<String, Object> eventTbl) {
        String formatMessage = "";
        String schemaClass = RB.getString((String)row.get("OBJECT_CLASS_TEXT"));
        if (schemaClass != null) {
            String displayText;
            ObjectClass objectClass = DIRECTORY_OBJECT_API.getObjectClass(schemaClass);
            displayText = objectClass != null ? (displayText = objectClass.getDisplayText()) : schemaClass;
            formatMessage = formatMessage + displayText;
        }
        if (eventCode == 5137) {
            formatMessage = formatMessage + " '" + (String)row.get("ADDITIONAL_INFO") + "'";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_created_by");
        } else if (eventCode == 5141) {
            formatMessage = formatMessage + " '" + (String)row.get("ADDITIONAL_INFO") + "'";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.was_deleted_by");
        } else if (eventCode == 5139) {
            formatMessage = formatMessage + " '" + (String)row.get("ADDITIONAL_INFO") + "'";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.was_moved_to_StringeventTblgetObject_Old", new String[]{(String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Old_DN"))});
        } else if (eventCode == 5136) {
            formatMessage = formatMessage + " '" + (String)row.get("OBJECT_NAME_TEXT") + "'";
            formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener._was_modified_by");
        }
        formatMessage = formatMessage + "'" + (String)row.get("CLIENT_DOMAIN") + "\\" + (String)row.get("CLIENT_USER_NAME") + "'. ";
        if (eventCode == 5136) {
            if (row.get("ATTRIBUTES_TEXT") != null && row.get("ATTRIBUTES_TEXT").equals("NT-Security-Descriptor")) {
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Modified_Properties__rowgetATTRIBUTES_TEXT", new String[]{(String)row.get("ATTRIBUTES_TEXT")});
            } else {
                formatMessage = formatMessage + RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{(String)row.get("ATTRIBUTES_TEXT")});
                formatMessage = formatMessage + ". ";
                formatMessage = formatMessage + RB.handleGetObject("adap.DefaultAccountMgmtListener.value", new String[]{(String)row.get("ATTRIBUTES_NEW_VALUE")});
            }
        }
        row.set("FORMAT_MESSAGE", (Object)formatMessage);
    }

    public String setFlags(Integer val) {
        String flag = "-";
        try {
            if (val == 0) {
                flag = RB.handleGetObject("adap.DSAListener.Flags", new String[]{RB.getString("adap.DSAListener.Computer_Configuration_Enabled"), RB.getString("adap.DSAListener.User_Configuration_Enabled")});
            } else if (val == 1) {
                flag = RB.handleGetObject("adap.DSAListener.Flags", new String[]{RB.getString("adap.DSAListener.Computer_Configuration_Enabled"), RB.getString("adap.DSAListener.User_Configuration_Disabled")});
            } else if (val == 2) {
                flag = RB.handleGetObject("adap.DSAListener.Flags", new String[]{RB.getString("adap.DSAListener.Computer_Configuration_Disabled"), RB.getString("adap.DSAListener.User_Configuration_Enabled")});
            } else if (val == 3) {
                flag = RB.handleGetObject("adap.DSAListener.Flags", new String[]{RB.getString("adap.DSAListener.Computer_Configuration_Disabled"), RB.getString("adap.DSAListener.User_Configuration_Disabled")});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return flag;
    }

    public String getGPOLinks(String ldapString) {
        StringBuilder gpoLink = new StringBuilder("");
        try {
            ldapString = ldapString.trim();
            if (ldapString != null && !ldapString.equals("")) {
                String[] gpoLdapString = ldapString.split("\\]");
                for (int i = 0; i < gpoLdapString.length; ++i) {
                    String[] gpoSettings = gpoLdapString[i].split("\\;");
                    if (gpoSettings.length <= 0) continue;
                    String gpoName = GPOUtil.getName(gpoLdapString[i]);
                    if (gpoSettings.length > 1) {
                        String valStr = gpoSettings[1];
                        Long val = Long.valueOf(valStr);
                        if (val == 0L) {
                            gpoLink.append(gpoName);
                            gpoLink.append("(");
                            gpoLink.append(RB.getString("adap.DSAListener.Link_Enabled"));
                            gpoLink.append(")");
                        } else if (val == 1L) {
                            gpoLink.append(gpoName);
                        } else if (val == 2L) {
                            gpoLink.append(gpoName);
                            gpoLink.append("(");
                            gpoLink.append(RB.getString("adap.DSAListener.Enforced"));
                            gpoLink.append(",");
                            gpoLink.append(RB.getString("adap.DSAListener.Link_Enabled"));
                            gpoLink.append(")");
                        } else if (val == 3L) {
                            gpoLink.append(gpoName);
                            gpoLink.append("(");
                            gpoLink.append(RB.getString("adap.DSAListener.Enforced"));
                            gpoLink.append(")");
                        }
                    }
                    if (i == gpoLdapString.length - 1) {
                        gpoLink.append(".");
                        continue;
                    }
                    gpoLink.append(",");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoLink.toString();
    }
}

