/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import com.adventnet.sym.adsm.auditing.server.category.FormatMessageUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.schema.Attribute;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DefaultAccountMgmtListener
extends DefaultCategoryListener {
    protected static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();
    private static final SchemaAPI SCHEMA_API = SchemaAPI.getInstance();
    private static final ADAPObjectCacheAPI ADAP_OBJECT_CACHE_API = ADAPObjectCacheAPI.getInstance();
    protected static final String[] GROUP_TYPE = new String[]{"-2147483646", "-2147483640", "-2147483644", "4", "8", "2"};
    protected static final String[] GROUP_SCOPE_STRINGS = new String[]{RB.getString("adap.DefaultAccountMgmtListener.Global"), RB.getString("adap.DefaultAccountMgmtListener.Universal"), RB.getString("adap.DefaultAccountMgmtListener.Domain_Local"), RB.getString("adap.DefaultAccountMgmtListener.Domain_Local"), RB.getString("adap.DefaultAccountMgmtListener.Universal"), RB.getString("adap.DefaultAccountMgmtListener.Global")};
    protected static final String[] GROUP_TYPE_STRINGS = new String[]{RB.getString("adap.DefaultAccountMgmtListener.Security"), RB.getString("adap.DefaultAccountMgmtListener.Security"), RB.getString("adap.DefaultAccountMgmtListener.Security"), RB.getString("adap.DefaultAccountMgmtListener.Distribution"), RB.getString("adap.DefaultAccountMgmtListener.Distribution"), RB.getString("adap.DefaultAccountMgmtListener.Distribution")};
    protected static final String[] USER_PARAM_TXT = new String[]{"CtxShadow", "CtxWFProfilePath", "CtxWFHomeDirDrive", "CtxWFHomeDir", "CtxCfgFlags1", "CtxInitialProgram", "CtxWorkDirectory", "CtxMaxDisconnectionTime", "CtxMaxConnectionTime", "CtxMaxIdleTime"};
    protected static final String[] USER_PARAM_STR_0 = new String[]{RB.getString("adap.DefaultAccountMgmtListener.Remote_control"), RB.getString("adap.DefaultAccountMgmtListener.Remote_Desktop_Profile"), RB.getString("adap.DefaultAccountMgmtListener.Remote_Desktop_Profile"), RB.getString("adap.DefaultAccountMgmtListener.Remote_Desktop_Profile"), RB.getString("adap.DefaultAccountMgmtListener.CtxCfgFlags1"), RB.getString("adap.DefaultAccountMgmtListener.Environment"), RB.getString("adap.DefaultAccountMgmtListener.Environment"), RB.getString("adap.DefaultAccountMgmtListener.Sessions"), RB.getString("adap.DefaultAccountMgmtListener.Sessions"), RB.getString("adap.DefaultAccountMgmtListener.Sessions")};
    protected static final String[] USER_PARAM_STR_1 = new String[]{RB.getString("adap.DefaultAccountMgmtListener.Enable_Remote_control"), RB.getString("adap.UserMgmtListener.Profile_Path"), RB.getString("adap.DefaultAccountMgmtListener.Home_Directory_Drive"), RB.getString("adap.ComputerMgmtListener.Home_Directory"), RB.getString("adap.DefaultAccountMgmtListener.CtxCfgFlags1"), RB.getString("adap.DefaultAccountMgmtListener.Program_file_name"), RB.getString("adap.DefaultAccountMgmtListener.Start_in"), RB.getString("adap.ADSMAttributeDetails.attrib_disp_name.End_Disconnected_Sessions"), RB.getString("adap.ADSMAttributeDetails.attrib_disp_name.Active_Session_Limit"), RB.getString("adap.ADSMAttributeDetails.attrib_disp_name.Idle_Session_Limit")};
    protected static final String[] USER_ATTRIB_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "DISPLAY_NAME", "USER_PRINCIPAL_NAME", "HOME_DIRECTORY", "HOME_DRIVE", "SCRIPT_PATH", "PROFILE_PATH", "LOGON_TO", "PWD_LAST_SET", "ACCOUNT_EXPIRY_DATE", "PRIMARY_GROUP_ID", "ALLOWED_TO_DELEGATE_TO", "USER_ACCOUNT_CONTROL", "USER_PARAMETERS", "SID_HISTORY", "LOGON_HOURS"};
    protected static final String[] USER_ATTRIBS = new String[]{RB.getString("adap.ComputerMgmtListener.Sam_Account_Name"), RB.getString("adap.ComputerMgmtListener.Display_Name"), RB.getString("adap.ComputerMgmtListener.User_Principal_Name"), RB.getString("adap.ComputerMgmtListener.Home_Directory"), RB.getString("adap.ComputerMgmtListener.Home_Drive"), RB.getString("adap.ComputerMgmtListener.Script_Path"), RB.getString("adap.UserMgmtListener.Profile_Path"), RB.getString("adap.ComputerMgmtListener.User_Workstations"), RB.getString("adap.ComputerMgmtListener.Password_Last_Set"), RB.getString("adap.ComputerMgmtListener.Account_Expires"), RB.getString("adap.ComputerMgmtListener.Primary_Group_ID"), RB.getString("adap.ComputerMgmtListener.AllowedToDelegateTo"), RB.getString("adap.ComputerMgmtListener.User_Account_Control"), RB.getString("adap.ComputerMgmtListener.User_Parameters"), RB.getString("adap.ComputerMgmtListener.Sid_History"), RB.getString("adap.ComputerMgmtListener.Logon_Hours")};
    protected static final String[] COMP_ATTRIB_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "DISPLAY_NAME", "USER_PRINCIPAL_NAME", "HOME_DIRECTORY", "HOME_DRIVE", "SCRIPT_PATH", "PROFILE_PATH", "LOGON_TO", "PWD_LAST_SET", "ACCOUNT_EXPIRY_DATE", "PRIMARY_GROUP_ID", "ALLOWED_TO_DELEGATE_TO", "USER_ACCOUNT_CONTROL", "USER_PARAMETERS", "SID_HISTORY", "LOGON_HOURS", "DNS_HOST_NAME", "SERVICE_PRINCIPAL_NAME"};
    protected static final String[] COMP_ATTRIBS = new String[]{RB.getString("adap.ComputerMgmtListener.Sam_Account_Name"), RB.getString("adap.ComputerMgmtListener.Display_Name"), RB.getString("adap.ComputerMgmtListener.User_Principal_Name"), RB.getString("adap.ComputerMgmtListener.Home_Directory"), RB.getString("adap.ComputerMgmtListener.Home_Drive"), RB.getString("adap.ComputerMgmtListener.Script_Path"), RB.getString("adap.ComputerMgmtListener.Profile_Path"), RB.getString("adap.ComputerMgmtListener.User_Workstations"), RB.getString("adap.ComputerMgmtListener.Password_Last_Set"), RB.getString("adap.ComputerMgmtListener.Account_Expires"), RB.getString("adap.ComputerMgmtListener.Primary_Group_ID"), RB.getString("adap.ComputerMgmtListener.AllowedToDelegateTo"), RB.getString("adap.ComputerMgmtListener.User_Account_Control"), RB.getString("adap.ComputerMgmtListener.User_Parameters"), RB.getString("adap.ComputerMgmtListener.Sid_History"), RB.getString("adap.ComputerMgmtListener.Logon_Hours"), RB.getString("adap.ComputerMgmtListener.DNS_Host_Name"), RB.getString("adap.ComputerMgmtListener.Service_Principal_Names")};

    @Override
    public Object getColumnValue(String columnName, Object value) {
        Object customizedValue = null;
        if (columnName.equalsIgnoreCase("GROUP_TYPE")) {
            Integer valueInt = (Integer)value;
            customizedValue = this.getGroupType(valueInt);
        } else if (columnName.equalsIgnoreCase("GROUP_SCOPE")) {
            Integer valueInt = (Integer)value;
            customizedValue = this.getGroupScope(valueInt);
        } else if (columnName.equalsIgnoreCase("OBJECT_CLASS")) {
            Integer valueInt = (Integer)value;
            if (valueInt == 624 || valueInt == 4720) {
                customizedValue = "user";
            } else if (valueInt == 645 || valueInt == 4741) {
                customizedValue = "computer";
            } else if (valueInt == 631 || valueInt == 635 || valueInt == 648 || valueInt == 653 || valueInt == 658 || valueInt == 663 || valueInt == 4727 || valueInt == 4731 || valueInt == 4744 || valueInt == 4749 || valueInt == 4754 || valueInt == 4759) {
                customizedValue = "group";
            }
        } else {
            customizedValue = super.getColumnValue(columnName, value);
        }
        return customizedValue;
    }

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = this.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            rowList = new ArrayList<Row>();
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            String accountSID;
            String dcName = (String)row.get("SOURCE");
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            String accountName = (String)row.get("ACCOUNT_NAME");
            if (!(eventNumber == 566 && eventNumber == 5139 && eventNumber == 5137 || (accountSID = (String)row.get("ACCOUNT_SID")) == null || accountSID.startsWith("%{"))) {
                accountSID = new StringBuffer().append("%{").append(accountSID).append("}").toString();
                row.set("ACCOUNT_SID", (Object)accountSID);
            }
            if (eventNumber.equals(566) || eventNumber.equals(5139)) {
                Integer isArchive = (Integer)eventTbl.get("IsArchiveEvent");
                Row objectRow = FormatMessageUtil.getObjectRow(domainName, accountName, objectClass, dcName, isArchive);
                if (objectRow != null) {
                    String sidString = (String)objectRow.get("SID_STRING");
                    sidString = new StringBuffer().append("%{").append(sidString).append("}").toString();
                    row.set("ACCOUNT_SID", (Object)sidString);
                    if (objectClass.equalsIgnoreCase("user")) {
                        row.set("ACCOUNT_NAME", (Object)((String)objectRow.get("SAM_ACCOUNT_NAME")));
                        String mgmtTypeAndRemarks = this.getUserMgmtText(row, eventNumber, eventTbl);
                        row.set("USER_MGMT_TYPE", (Object)mgmtTypeAndRemarks);
                        ArrayList attributeList = (ArrayList)eventTbl.get("Attributes");
                        if (attributeList != null && (attributeList.contains("bf967a0e-0de6-11d0-a285-00aa003049e2") || attributeList.contains("bf96793f-0de6-11d0-a285-00aa003049e2"))) {
                            row.set("REMARKS", (Object)mgmtTypeAndRemarks);
                        } else {
                            row.set("REMARKS", (Object)RB.getString("adap.UserMgmtListener.User_Modified"));
                        }
                    } else {
                        String remarks = FormatMessageUtil.getRemarksMsg(eventTbl, objectClass, row);
                        row.set("ACCOUNT_NAME", (Object)((String)objectRow.get("NAME")));
                        row.set("REMARKS", (Object)remarks);
                    }
                    row.set("FORMAT_MESSAGE", (Object)FormatMessageUtil.setFormatMessage(domainName, row, eventTbl, objectClass));
                }
            } else {
                List columnList = row.getColumns();
                if (columnList.contains("ACCOUNT_NAME") && (accountName == null || accountName.equalsIgnoreCase("") || accountName.equalsIgnoreCase("-"))) {
                    row.set("ACCOUNT_NAME", (Object)this.getUserName(domainName, row));
                }
                if (columnList.contains("USER_MGMT_TYPE")) {
                    row.set("USER_MGMT_TYPE", (Object)this.getUserMgmtText(row, eventNumber, eventTbl));
                }
                if (columnList.contains("MEMBER_NAME")) {
                    String memberName = (String)row.get("MEMBER_NAME");
                    String memberSid = null;
                    if (columnList.contains("MEMBER_SID") && (memberSid = (String)row.get("MEMBER_SID")) != null && memberSid.indexOf("{") != -1) {
                        memberSid = memberSid.substring(memberSid.indexOf("{") + 1, memberSid.indexOf("}"));
                    }
                    if (memberName == null || memberName.equalsIgnoreCase("") || memberName.equalsIgnoreCase("-")) {
                        row.set("MEMBER_NAME", (Object)this.getMemberName(domainName, row));
                    } else if (memberSid != null && memberName.toLowerCase().contains("foreignsecurityprincipal") && memberName.contains(memberSid)) {
                        String name = this.getMemberName(domainName, row);
                        if (!name.equalsIgnoreCase("-")) {
                            memberName = memberName.replaceAll(memberSid, name);
                        }
                        row.set("MEMBER_NAME", (Object)memberName);
                    }
                }
                if (columnList.contains("COMP_MGMT_TYPE")) {
                    String compMgmtText = this.computerMgmtType(row, eventNumber, eventTbl);
                    row.set("COMP_MGMT_TYPE", (Object)compMgmtText);
                }
                if (eventNumber == 4723) {
                    row.set("REMARKS", (Object)RB.getString("adap.UserMgmtListener.Change_Password_Attempt"));
                } else if (eventNumber == 4724) {
                    row.set("REMARKS", (Object)RB.getString("adap.UserMgmtListener.User_Account_password_set"));
                } else if (eventNumber == 624 || eventNumber == 4720) {
                    objectClass = "user";
                } else if (eventNumber == 645 || eventNumber == 4741) {
                    objectClass = "computer";
                } else if (eventNumber == 631 || eventNumber == 635 || eventNumber == 648 || eventNumber == 653 || eventNumber == 658 || eventNumber == 663 || eventNumber == 4727 || eventNumber == 4731 || eventNumber == 4744 || eventNumber == 4749 || eventNumber == 4754 || eventNumber == 4759) {
                    objectClass = "group";
                } else if (eventNumber.equals(636) || eventNumber.equals(637) || eventNumber.equals(4732) || eventNumber.equals(4733)) {
                    row.set("ACCOUNT_DOMAIN", (Object)domainName);
                }
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            }
        }
        return row;
    }

    protected String getGroupType(Integer eventNumber) {
        String groupType = "-";
        if (eventNumber == 641 || eventNumber >= 631 && eventNumber <= 639 || eventNumber >= 658 && eventNumber <= 662 || eventNumber == 4737 || eventNumber >= 4727 && eventNumber <= 4735 || eventNumber >= 4754 && eventNumber <= 4758) {
            groupType = RB.getString("adap.DefaultAccountMgmtListener.Security");
        } else if (eventNumber >= 648 && eventNumber <= 657 || eventNumber >= 663 && eventNumber <= 667 || eventNumber >= 4744 && eventNumber <= 4753 || eventNumber >= 4759 && eventNumber <= 4763) {
            groupType = RB.getString("adap.DefaultAccountMgmtListener.Distribution");
        }
        return groupType;
    }

    protected String getGroupScope(Integer eventNumber) {
        String groupScope = "-";
        if (eventNumber >= 635 && eventNumber <= 639 || eventNumber >= 648 && eventNumber <= 652 || eventNumber >= 4731 && eventNumber <= 4735 || eventNumber >= 4744 && eventNumber <= 4748) {
            groupScope = RB.getString("adap.DefaultAccountMgmtListener.Domain_Local");
        } else if (eventNumber == 641 || eventNumber >= 631 && eventNumber <= 634 || eventNumber >= 653 && eventNumber <= 657 || eventNumber == 4737 || eventNumber >= 4727 && eventNumber <= 4730 || eventNumber >= 4749 && eventNumber <= 4753) {
            groupScope = RB.getString("adap.DefaultAccountMgmtListener.Global");
        } else if (eventNumber >= 658 && eventNumber <= 667 || eventNumber >= 4754 && eventNumber <= 4763) {
            groupScope = RB.getString("adap.DefaultAccountMgmtListener.Universal");
        }
        return groupScope;
    }

    protected String computerMgmtType(Row row, Integer eventNumber, Hashtable<String, Object> eventTbl) {
        String compMgmtText = "-";
        String accessMask = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Access_Mask"));
        if (eventNumber.equals(646) || eventNumber.equals(4742)) {
            compMgmtText = "";
            for (int i = 0; i < COMP_ATTRIB_COLUMNS.length; ++i) {
                String attributeValue = (String)row.get(COMP_ATTRIB_COLUMNS[i]);
                if (attributeValue == null || attributeValue.equalsIgnoreCase("-")) continue;
                if (!compMgmtText.equalsIgnoreCase("")) {
                    compMgmtText = new StringBuffer().append(compMgmtText).append(", ").toString();
                }
                compMgmtText = new StringBuffer().append(compMgmtText).append(COMP_ATTRIBS[i]).toString();
            }
            if (compMgmtText.equalsIgnoreCase("")) {
                compMgmtText = "-";
            }
        } else if (eventNumber.equals(645) || eventNumber.equals(4741)) {
            compMgmtText = RB.getString("adap.ComputerMgmtListener.Computer_Account_Created");
        } else if (eventNumber.equals(647) || eventNumber.equals(4743)) {
            compMgmtText = RB.getString("adap.ComputerMgmtListener.Computer_Account_Deleted");
        } else if (eventNumber.equals(626) || eventNumber.equals(4722)) {
            compMgmtText = RB.getString("adap.ComputerMgmtListener.Computer_Account_Enabled");
        } else if (eventNumber.equals(629) || eventNumber.equals(4725)) {
            compMgmtText = RB.getString("adap.ComputerMgmtListener.Computer_Account_Disabled");
        } else if (eventNumber.equals(566)) {
            ArrayList attributeList = (ArrayList)eventTbl.get("Attributes");
            if (attributeList != null) {
                compMgmtText = "";
                for (String string : attributeList) {
                    if (!compMgmtText.equalsIgnoreCase("")) {
                        compMgmtText = new StringBuffer().append(compMgmtText).append(", ").toString();
                    }
                    Attribute attribute = SCHEMA_API.getAttribute(string);
                    compMgmtText = new StringBuffer().append(compMgmtText).append(attribute.getLdapDisplayName()).toString();
                }
            } else if (accessMask.equalsIgnoreCase("0x40000")) {
                String accesses;
                System.out.println("computer event Table : " + eventTbl);
                compMgmtText = accesses = (String)eventTbl.get("Accesses");
            }
            row.set("ATTRIBUTES_TEXT", (Object)compMgmtText);
        } else if (eventNumber.equals(5136)) {
            compMgmtText = (String)row.get("ATTRIBUTES_TEXT");
        }
        return compMgmtText;
    }

    protected String getUserName(String domainName, Row row) {
        String userName = (String)row.get("ACCOUNT_SID");
        try {
            String userSid = (String)row.get("ACCOUNT_SID");
            if (userSid != null && userSid.indexOf("{") > 0) {
                userSid = userSid.substring(userSid.indexOf("{") + 1, userSid.indexOf("}"));
            }
            userName = ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, userSid, "SAM_ACCOUNT_NAME", "user");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userName;
    }

    protected String getUserMgmtText(Row row, Integer eventNumber, Hashtable<String, Object> eventTbl) {
        String userMgmtType = "-";
        if (eventNumber.equals(626) || eventNumber.equals(4722)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.Account_Enabled");
        } else if (eventNumber.equals(629) || eventNumber.equals(4725)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.Account_Disabled");
        } else if (eventNumber.equals(644) || eventNumber.equals(4740)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.Account_Locked");
        } else if (eventNumber.equals(671) || eventNumber.equals(4767)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.Account_Unlocked");
        } else if (eventNumber.equals(627) || eventNumber.equals(4723)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.Change_Password_Attempt");
        } else if (eventNumber.equals(628) || eventNumber.equals(4724)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.User_password_set");
        } else if (eventNumber.equals(630) || eventNumber.equals(4726)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.User_Deleted");
        } else if (eventNumber.equals(642) || eventNumber.equals(4738)) {
            userMgmtType = "";
            List columnList = row.getColumns();
            for (int i = 0; i < USER_ATTRIB_COLUMNS.length; ++i) {
                String attributeValue;
                if (!columnList.contains(USER_ATTRIB_COLUMNS[i]) || (attributeValue = (String)row.get(USER_ATTRIB_COLUMNS[i])) == null || attributeValue.equalsIgnoreCase("-")) continue;
                if (!userMgmtType.equalsIgnoreCase("")) {
                    userMgmtType = new StringBuffer().append(userMgmtType).append(", ").toString();
                }
                userMgmtType = new StringBuffer().append(userMgmtType).append(USER_ATTRIBS[i]).toString();
            }
            if (userMgmtType.equalsIgnoreCase("")) {
                userMgmtType = "-";
            }
        } else if (eventNumber.equals(566)) {
            String accessMask = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Access_Mask"));
            String additionalInf2 = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Additional_Info2"));
            ArrayList attributeList = (ArrayList)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Attributes"));
            if (attributeList != null) {
                if (attributeList.contains("bf967a0e-0de6-11d0-a285-00aa003049e2") || attributeList.contains("bf96793f-0de6-11d0-a285-00aa003049e2")) {
                    if (accessMask.equalsIgnoreCase("0x20") && (additionalInf2 != null || !additionalInf2.equalsIgnoreCase(""))) {
                        userMgmtType = RB.getString("adap.UserMgmtListener.User_Moved");
                    }
                    if (accessMask.equalsIgnoreCase("0x20") && (additionalInf2 == null || additionalInf2.equalsIgnoreCase(""))) {
                        userMgmtType = RB.getString("adap.UserMgmtListener.User_Renamed");
                    }
                } else {
                    userMgmtType = "";
                    for (String string : attributeList) {
                        if (!userMgmtType.equalsIgnoreCase("")) {
                            userMgmtType = new StringBuffer().append(userMgmtType).append(", ").toString();
                        }
                        Attribute attribute = SCHEMA_API.getAttribute(string);
                        userMgmtType = new StringBuffer().append(userMgmtType).append(attribute.getLdapDisplayName()).toString();
                    }
                }
            } else if (accessMask.equalsIgnoreCase("0x40000")) {
                String accesses;
                userMgmtType = accesses = (String)eventTbl.get("Accesses");
            }
            row.set("ATTRIBUTES_TEXT", (Object)userMgmtType);
        } else if (eventNumber.equals(5139)) {
            userMgmtType = RB.getString("adap.UserMgmtListener.User_Moved");
        } else if (eventNumber.equals(5136)) {
            userMgmtType = (String)row.get("ATTRIBUTES_TEXT");
        }
        return userMgmtType;
    }

    protected String getMemberName(String domainName, Row row) {
        String memberName = "-";
        try {
            List columnList = row.getColumns();
            if (columnList.contains("MEMBER_SID")) {
                String memberSid = (String)row.get("MEMBER_SID");
                if (memberSid == null) {
                    return memberName;
                }
                if (memberSid.indexOf("{") != -1) {
                    memberSid = memberSid.substring(memberSid.indexOf("{") + 1, memberSid.indexOf("}"));
                }
                memberName = ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, memberSid, "DISTINGUISHED_NAME", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memberName;
    }

    protected String getGroupMgmtType(Row row, Integer eventNumber, Hashtable<String, Object> eventTbl) {
        String groupMgmtText = "-";
        String accessMask = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Access_Mask"));
        if (eventNumber.equals(566)) {
            ArrayList attributeList = (ArrayList)eventTbl.get("Attributes");
            if (attributeList != null) {
                groupMgmtText = "";
                for (String string : attributeList) {
                    if (!groupMgmtText.equalsIgnoreCase("")) {
                        groupMgmtText = new StringBuffer().append(groupMgmtText).append(", ").toString();
                    }
                    Attribute attribute = SCHEMA_API.getAttribute(string);
                    groupMgmtText = new StringBuffer().append(groupMgmtText).append(attribute.getLdapDisplayName()).toString();
                }
            } else if (accessMask.equalsIgnoreCase("0x40000")) {
                String accesses;
                System.out.println("gorup event Table : " + eventTbl);
                groupMgmtText = accesses = (String)eventTbl.get("Accesses");
            }
            row.set("ATTRIBUTES_TEXT", (Object)groupMgmtText);
        } else if (eventNumber.equals(5136)) {
            groupMgmtText = (String)row.get("ATTRIBUTES_TEXT");
        }
        return groupMgmtText;
    }
}

