/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventVariablesAPI;
import com.adventnet.sym.adsm.auditing.server.LastLogonUpdateQueue;
import com.adventnet.sym.adsm.auditing.server.category.EventCategoryListener;
import com.adventnet.sym.adsm.auditing.server.monitor.RuleVariable;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultCategoryListener
implements EventCategoryListener {
    protected static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final EventVariablesAPI EVENT_VARIABLES_API = EventVariablesAPI.getInstance();

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = this.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            rowList = new ArrayList<Row>();
            rowList.add(row);
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            if ((eventNumber == 4768 || eventNumber == 672) && (Integer)row.get("EVENT_TYPE") == 8) {
                LastLogonUpdateQueue.getInstance().addOrUpdateRow(row);
            }
        }
        return rowList;
    }

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        HashMap eventColumnMap = EVENT_VARIABLES_API.getEventVarMapping((Integer)eventTbl.get("EventCode"), categoryId);
        Row retRow = null;
        if (eventColumnMap != null && !eventColumnMap.isEmpty()) {
            Set tableSet = eventColumnMap.keySet();
            for (String tableName : tableSet) {
                ArrayList columnMapList = (ArrayList)eventColumnMap.get(tableName);
                if (eventTbl.get("IsArchiveEvent") != null) {
                    tableName = tableName + "_0";
                }
                retRow = new Row(tableName);
                this.setEventRow(columnMapList, eventTbl, retRow);
                retRow.set("MONITOR_ID", (Object)monitorId);
            }
        }
        return retRow;
    }

    public void setEventRow(ArrayList<HashMap<String, Object>> columnMapList, Hashtable<String, Object> eventTbl, Row retRow) throws DataAccessException, NullPointerException {
        for (HashMap<String, Object> columnMap : columnMapList) {
            String code;
            Object customizedValue;
            String columnName = (String)columnMap.get("COLUMN_NAME");
            Long variableId = (Long)columnMap.get("VARIABLE_ID");
            RuleVariable ruleVariable = EVENT_VARIABLES_API.getVariable(variableId);
            String variableName = ruleVariable.getName();
            Object value = eventTbl.get(variableName);
            String tableName = retRow.getTableName();
            if (ruleVariable.isMultiValued()) {
                List valueList = (List)value;
                if (valueList == null) continue;
                customizedValue = "";
                for (String object2 : valueList) {
                    if (!((String)customizedValue).equalsIgnoreCase("")) {
                        customizedValue = (String)customizedValue + ",";
                    }
                    customizedValue = (String)customizedValue + object2;
                    retRow.set(columnName, customizedValue);
                }
                continue;
            }
            if ((tableName.equalsIgnoreCase("AUDFileAuditInfo") || tableName.equalsIgnoreCase("AUDFileAuditInfo_0") || tableName.equalsIgnoreCase("AUDFileIntegrityMonitor")) && columnName.equalsIgnoreCase("ACCESS_MASK")) {
                Long accessMask = 0L;
                try {
                    Integer eventNumber = (Integer)eventTbl.get("EventCode");
                    accessMask = eventNumber == 4670 || eventNumber == 4907 ? Long.valueOf(40000L) : Long.valueOf(value == null || value.toString().equals("") ? 0L : Long.decode(value.toString()));
                }
                catch (Exception e) {
                    EVENT_LOGGER.log(Level.WARNING, new StringBuffer().append("Exception while Decoding Access Mask :").append(e.getMessage()).toString());
                }
                retRow.set(columnName, (Object)accessMask);
                continue;
            }
            if ((tableName.equalsIgnoreCase("AUDGroupMgmt") || tableName.equalsIgnoreCase("AUDOUMgmt")) && columnName.equalsIgnoreCase("ACCESS_MASK")) {
                retRow.set(columnName, value);
                if (!value.equals("0x40000")) continue;
                retRow.set("ATTRIBUTES_TEXT", eventTbl.get("Accesses"));
                retRow.set("ATTRIBUTE_CATEGORY_ID", (Object)3L);
                continue;
            }
            Integer eventNumber = (Integer)eventTbl.get("EventCode");
            if (columnName.equalsIgnoreCase("EVENT_TYPE_TEXT") && eventNumber > 199 && eventNumber < 306 && ((code = (String)eventTbl.get("Error Code")) != null || eventNumber == 203)) {
                value = "16";
                retRow.set("EVENT_TYPE", value);
            }
            customizedValue = this.getColumnValue(columnName, value);
            retRow.set(columnName, customizedValue);
        }
    }

    public Object getColumnValue(String columnName, Object value) {
        Object customizedValue = null;
        if (columnName.equalsIgnoreCase("EVENT_TYPE_TEXT")) {
            if (value.toString().equals("8")) {
                customizedValue = RB.handleGetObject("adap.DefaultCategoryListener.Success");
            } else if (value.toString().equals("16")) {
                customizedValue = RB.handleGetObject("adap.DefaultCategoryListener.Failure");
            }
        } else {
            customizedValue = columnName.equalsIgnoreCase("TIME_GENERATED") ? Long.valueOf(Integer.valueOf(value.toString()).intValue()) : value;
        }
        return customizedValue;
    }

    protected Boolean compareAttributesValue(Row row) {
        boolean b = false;
        try {
            Object newValue = row.get("ATTRIBUTES_NEW_VALUE");
            Object oldValue = row.get("ATTRIBUTES_OLD_VALUE");
            if (newValue != null && oldValue != null && newValue.equals(oldValue)) {
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }
}

